/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.cli;

import com.j_spaces.cli.CommandException;
import com.j_spaces.cli.ICommand;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.BasicTypeInfo;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.obf.ba;
import com.j_spaces.obf.mn;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CleanSpace
implements ICommand {
    private String a;
    private String b;
    private static final String c = "h";
    private static final String d = "t";
    private static Logger e = Logger.getLogger("com.gigaspaces.admin");

    public CleanSpace() {
    }

    public CleanSpace(String string, String string2) {
        this.a = string;
        this.b = string2;
    }

    public void usage(PrintWriter printWriter) {
        System.out.println("\n*****************************************************\n");
        System.out.println("Usage: com.j_spaces.cli.CleanSpace [container name] [space name]");
        System.out.println(" options:");
        System.out.println(" -h    prints help");
        System.out.println(" -l    lookup service hostname");
        System.out.println(" -r    RMI registry hostname");
        System.out.println(" -g    lookup groups");
        System.out.println(" -t    class template");
        System.out.println(" Usage example with Lookup: com.j_spaces.cli.CleanSpace [container name] [space name] -l lookuphost -g group1 group2 or \nUsage example with RMI registry: com.j_spaces.cli.CleanSpace [container name] [space name] -r rmiRegistryHost -t className");
        System.out.println("\n*****************************************************\n");
    }

    public void execute(Map map, PrintWriter printWriter) throws CommandException {
        if (map.containsKey(c)) {
            this.usage(printWriter);
            return;
        }
        try {
            String string = ba.a(this.a, this.b, map);
            IJSpace iJSpace = (IJSpace)SpaceFinder.find(string);
            if (iJSpace == null) {
                System.out.println(this.b + " space is not found.");
                System.exit(-1);
            }
            System.out.println("Started to clean <" + this.b + "> space in <" + this.a + "> container...");
            if (map.containsKey(d)) {
                ExternalEntry externalEntry = this.a((String)map.get(d), iJSpace);
                iJSpace.clear(externalEntry, null);
            } else {
                iJSpace.clean();
            }
            System.out.println("The <" + this.b + "> space cleaned successfully.");
        }
        catch (Exception exception) {
            throw new CommandException(CleanSpace.a(exception).toString());
        }
    }

    private static StringWriter a(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter;
    }

    private ExternalEntry a(String string, IJSpace iJSpace) throws RemoteException {
        ExternalEntry externalEntry = null;
        if (string != null && string.trim().length() > 0) {
            BasicTypeInfo basicTypeInfo = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClassTypeInfo(string);
            String[] stringArray = basicTypeInfo.getFieldsNames();
            externalEntry = new ExternalEntry(string, new Object[stringArray.length]);
            externalEntry.m_FieldsNames = stringArray;
            externalEntry.m_FieldsTypes = basicTypeInfo.getFieldsTypes();
        }
        return externalEntry;
    }

    public static void main(String[] stringArray) {
        mn mn2 = new mn("h,l,g,r,t");
        try {
            if (stringArray.length < 2) {
                CleanSpace cleanSpace = new CleanSpace();
                cleanSpace.usage(new PrintWriter(System.out));
            } else {
                CleanSpace cleanSpace = new CleanSpace(stringArray[0], stringArray[1]);
                cleanSpace.execute(mn2.a(stringArray), new PrintWriter(System.out));
            }
        }
        catch (CommandException commandException) {
            e.log(Level.SEVERE, commandException.toString(), commandException);
        }
        System.exit(0);
    }
}

