/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.CommandException;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.gigaspaces.admin.cli.OptionHandler;
import com.gigaspaces.admin.cli.PasswordField;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.obf.ct;
import com.j_spaces.obf.hb;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserAdministrator
implements GS.OptionHandler,
Constants {
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");
    private OptionHandler b;
    public static final String OPERATION_NAME = "userAdmin";

    public UserAdministrator() {
        String[] stringArray = new String[]{"h", "help"};
        this.b = new OptionHandler(Formatter.fromArray((String[])stringArray));
    }

    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n\n");
        stringBuffer.append("The User Administrator tool provides an ability to configure all security features\n");
        stringBuffer.append("Usage: admin userAdmin schemaName [options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help       prints help\n");
        stringBuffer.append("Usage example: ");
        stringBuffer.append("\tadmin userAdmin default\n");
        stringBuffer.append("\n*****************************************************\n\n");
        return stringBuffer.toString();
    }

    public String process(String string, BufferedReader bufferedReader) {
        try {
            Map map = this.b.getOptions(string);
            if (map.containsKey("h") || map.containsKey("help")) {
                return this.getUsage();
            }
            if (string.trim().length() == 0) {
                CLIUtilities.printMissingNameMessage("Schema");
                return this.getUsage();
            }
            String string2 = string.substring(0, string.length() - 1).trim();
            if (string2.length() == 0) {
                CLIUtilities.printMissingNameMessage("Schema");
                return this.getUsage();
            }
            this.a(string2, map, bufferedReader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() != null) {
                System.out.println(illegalArgumentException.getMessage());
            } else {
                System.out.println(illegalArgumentException.toString());
            }
            System.out.println(this.getUsage());
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, exception.toString(), exception);
        }
        return "";
    }

    private void a(String string, Map map, BufferedReader bufferedReader) throws Exception {
        InputStream inputStream = ResourceLoader.findContainerSchema(string);
        if (inputStream == null) {
            String string2 = "Container schema configuration '" + string + "' does not exist.";
            System.out.println(string2);
            return;
        }
        System.out.println("Define administrator user name \nEnter name: ");
        String string3 = bufferedReader.readLine();
        if (string3 == null || string3.length() <= 0) {
            throw new CommandException("No administrator name entered");
        }
        System.out.println("Define administrator password to [" + string + "] container ");
        String string4 = PasswordField.readPassword("Enter password: \n");
        if (string4 == null || string4.length() <= 0) {
            throw new CommandException("No password entered");
        }
        if (string4.length() < 4) {
            throw new CommandException("Password is too short, minimum is 4 characters.");
        }
        String string5 = PasswordField.readPassword("Repeat password, for verification: \n");
        if (string5 == null || !string4.equals(string5)) {
            throw new CommandException("Entered passwords do not match.");
        }
        hb.a(true, string, string3, ct.a().a(string4));
        System.out.println("Administrator name and password have been set/updated successfully.");
    }
}

