/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.cli;

import com.gigaspaces.admin.cli.CLIFinder;
import com.gigaspaces.admin.cli.CLIUtilities;
import com.gigaspaces.admin.cli.Constants;
import com.gigaspaces.admin.cli.Formatter;
import com.gigaspaces.admin.cli.GS;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.IDirectSpaceProxy;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;

public abstract class AbstractSpaceCommand
implements GS.OptionHandler,
Constants {
    public String operationName;
    public static final String CANCEL_OPTION = "c";
    public static final String YES_OPTION = "y";
    public static final String NO_OPTION = "n";
    public static final Logger _logger = Logger.getLogger("com.gigaspaces.admin");
    public int searchedSpaceState;

    public Map getClusterMembersAdminSpaces(ClusterPolicy clusterPolicy) throws RemoteException, FinderException, NoSuchNameException {
        Map map = CLIFinder.getClusterMembersSpaceProxies(clusterPolicy);
        HashMap<String, IRemoteJSpaceAdmin> hashMap = new HashMap<String, IRemoteJSpaceAdmin>(map.size());
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            IJSpace iJSpace = (IJSpace)entry.getValue();
            IRemoteJSpaceAdmin iRemoteJSpaceAdmin = (IRemoteJSpaceAdmin)iJSpace.getAdmin();
            hashMap.put(string, iRemoteJSpaceAdmin);
        }
        return hashMap;
    }

    public StringBuffer getBasicUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*****************************************************\n");
        stringBuffer.append("Usage: space " + this.operationName + "[options]\n");
        stringBuffer.append("options:\n");
        stringBuffer.append("\t-h/-help    prints help\n");
        stringBuffer.append("\t-url    space url\n");
        stringBuffer.append("\t-c/-cluster    cluster operation\n");
        return stringBuffer;
    }

    public IJSpace[] getSelectedSpaceProxies(BufferedReader bufferedReader) {
        ServiceItem[] serviceItemArray = CLIFinder.findSpaceServices(this.searchedSpaceState);
        return this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
    }

    public IJSpace[] getAllClusterMembers(ClusterPolicy clusterPolicy, BufferedReader bufferedReader) {
        ServiceItem[] serviceItemArray = CLIFinder.findClusterMembers(clusterPolicy, this.searchedSpaceState);
        return this.getSelectedFromListSpaceProxies(serviceItemArray, bufferedReader);
    }

    public IJSpace[] getSelectedFromListSpaceProxies(ServiceItem[] serviceItemArray, BufferedReader bufferedReader) {
        ServiceItem[] serviceItemArray2;
        if (serviceItemArray.length == 0) {
            System.out.println("No GigaSpace instances discovered\n");
            return null;
        }
        if (bufferedReader == null) {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        if ((serviceItemArray2 = Formatter.selectItems((ServiceItem[])serviceItemArray, (String)this.a(this.operationName), (BufferedReader)bufferedReader)) == null || serviceItemArray2.length == 0) {
            return null;
        }
        int n2 = serviceItemArray2.length;
        LinkedList<IJSpace> linkedList = new LinkedList<IJSpace>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = serviceItemArray2[i2].service;
            if (!(object instanceof IJSpace)) continue;
            linkedList.add((IJSpace)object);
        }
        return linkedList.toArray(new IJSpace[linkedList.size()]);
    }

    public Object find(String string) throws RemoteException, FinderException {
        Object object = null;
        try {
            SpaceURL spaceURL = SpaceURLParser.parseURL(string);
            object = CLIFinder.find(spaceURL, this.searchedSpaceState);
        }
        catch (MalformedURLException malformedURLException) {
            CLIUtilities.printWrongServiceURLMessage(string);
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, malformedURLException.toString(), malformedURLException);
            }
        }
        catch (FinderException finderException) {
            CLIUtilities.printWrongServiceURLMessage(string);
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, finderException.toString(), finderException);
            }
            throw finderException;
        }
        return object;
    }

    private String a(String string) {
        return "Enter a comma-separated list to " + string + " or \"" + CANCEL_OPTION + "\" to cancel : ";
    }

    public ClusterPolicy getClusterPolicy(IJSpace iJSpace) throws RemoteException {
        return ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getClusterPolicy();
    }

    public ServiceItem[] getContainerSpaces(IJSpaceContainer iJSpaceContainer, String string) throws RemoteException, NoSuchNameException {
        if (string.equals("rmi:")) {
            String[] stringArray = iJSpaceContainer.getSpaceNames();
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                IJSpace iJSpace = iJSpaceContainer.getSpace(string2, false);
                if (this.searchedSpaceState >= 0 && ((IRemoteJSpaceAdmin)((Object)((IDirectSpaceProxy)iJSpace).getRemoteJSpace())).getState() != this.searchedSpaceState) continue;
                ServiceItem serviceItem = CLIFinder.createSpaceServiceItem(iJSpace, string2);
                arrayList.add(serviceItem);
            }
            return arrayList.toArray(new ServiceItem[arrayList.size()]);
        }
        if (string.equals("jini:")) {
            String string3 = iJSpaceContainer.getName();
            IJSpaceContainerAdmin iJSpaceContainerAdmin = (IJSpaceContainerAdmin)((Object)iJSpaceContainer);
            String string4 = iJSpaceContainerAdmin.getConfig().containerHostName;
            ServiceItem[] serviceItemArray = CLIFinder.findSpacesByJini(string3, null, string4, this.searchedSpaceState);
            return serviceItemArray;
        }
        return null;
    }
}

