/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.KerberosEndpointInternalsAccess;
import com.sun.jini.jeri.internal.connection.BasicConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.kerberos.KerberosServerEndpoint;
import net.jini.jeri.kerberos.KerberosUtil;
import net.jini.security.AuthenticationPermission;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public final class KerberosEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -880347439811805543L;
    private static final Logger logger = Logger.getLogger("net.jini.jeri.kerberos.client");
    private final String serverHost;
    private final int serverPort;
    private final KerberosPrincipal serverPrincipal;
    private final SocketFactory csf;
    private static final Object classLock = new Object();
    private static GSSManager gssManager;
    private static final int maxCacheSize;
    private static final int minGssContextLifetime;
    private static final int maxGssContextRetries;
    private transient KerberosUtil.SoftCache softCache;
    private transient ConnectionEndpointImpl connectionEndpoint;
    private transient ConnManager connManager;
    private transient boolean disableSocketConnect;
    private static final Map internTable;
    private static final int NO_ERROR = -1;
    private static final int UNSUPPORTABLE_CONSTRAINT_REQUIRED = 0;
    private static final int NULL_SUBJECT = 1;
    private static final int NO_CLIENT_PRINCIPAL = 2;
    private static final int UNSATISFIABLE_CONSTRAINT_REQUIRED = 3;
    private static final String[] ERROR_STRINGS;
    static /* synthetic */ Class class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl;
    static /* synthetic */ Class class$net$jini$jeri$kerberos$KerberosEndpoint;

    private KerberosEndpoint(String serverHost, int serverPort, KerberosPrincipal serverPrincipal, SocketFactory csf) {
        if (serverHost == null) {
            throw new NullPointerException("serverHost is null");
        }
        if (serverPort <= 0 || serverPort > 65535) {
            throw new IllegalArgumentException("server port number out of range 1-65535: serverPort = " + serverPort);
        }
        if (serverPrincipal == null) {
            throw new NullPointerException("serverPrincipal is null");
        }
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.serverPrincipal = serverPrincipal;
        this.csf = csf;
        logger.log(Level.FINE, "created {0}", this);
    }

    public static KerberosEndpoint getInstance(String serverHost, int serverPort, KerberosPrincipal serverPrincipal) {
        return KerberosEndpoint.intern(new KerberosEndpoint(serverHost, serverPort, serverPrincipal, null));
    }

    public static KerberosEndpoint getInstance(String serverHost, int serverPort, KerberosPrincipal serverPrincipal, SocketFactory csf) {
        return KerberosEndpoint.intern(new KerberosEndpoint(serverHost, serverPort, serverPrincipal, csf));
    }

    public String getHost() {
        return this.serverHost;
    }

    public int getPort() {
        return this.serverPort;
    }

    public KerberosPrincipal getPrincipal() {
        return this.serverPrincipal;
    }

    public SocketFactory getSocketFactory() {
        return this.csf;
    }

    public OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException("constraints cannot be null");
        }
        logger.log(Level.FINE, "newRequest requested with constraints:\n{0}", constraints);
        Subject clientSubject = (Subject)Security.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        CacheKey key = new CacheKey(clientSubject, constraints);
        RequestHandleImpl handle = (RequestHandleImpl)this.softCache.get(key);
        if (handle == null || !handle.reusable(clientSubject)) {
            handle = new RequestHandleImpl(clientSubject, constraints);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new request handle has been constructed:\n{0}", new Object[]{handle});
            }
            this.softCache.put(key, handle);
        }
        return this.connManager.newRequest(handle);
    }

    public boolean checkTrustEquivalence(Object obj) {
        return this.equals(obj);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ this.serverPrincipal.hashCode() ^ this.serverHost.hashCode() ^ this.serverPort ^ (this.csf != null ? this.csf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KerberosEndpoint)) {
            return false;
        }
        KerberosEndpoint oep = (KerberosEndpoint)obj;
        return this.serverPrincipal.equals(oep.serverPrincipal) && this.serverHost.equals(oep.serverHost) && this.serverPort == oep.serverPort && Util.sameClassAndEquals(this.csf, oep.csf);
    }

    public String toString() {
        return "KerberosEndpoint[serverHost=" + this.serverHost + " serverPort=" + this.serverPort + " serverPrincipal=" + this.serverPrincipal + (this.csf == null ? "" : "csf = " + this.csf.toString()) + "]";
    }

    private Object readResolve() {
        return KerberosEndpoint.intern(this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.serverHost == null) {
            throw new InvalidObjectException("serverHost is null");
        }
        if (this.serverPort <= 0 || this.serverPort > 65535) {
            throw new InvalidObjectException("server port number out of range 1-65535: serverPort = : " + this.serverPort);
        }
        if (this.serverPrincipal == null) {
            throw new InvalidObjectException("serverPrincipal is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KerberosEndpoint intern(KerberosEndpoint endpoint) {
        Map map = internTable;
        synchronized (map) {
            KerberosEndpoint canonical;
            WeakReference ref = (WeakReference)internTable.get(endpoint);
            if (ref != null && (canonical = (KerberosEndpoint)ref.get()) != null) {
                return canonical;
            }
            endpoint.softCache = new KerberosUtil.SoftCache(maxCacheSize);
            KerberosEndpoint kerberosEndpoint = endpoint;
            kerberosEndpoint.getClass();
            endpoint.connectionEndpoint = kerberosEndpoint.new ConnectionEndpointImpl();
            endpoint.connManager = new BasicConnManagerFactory().create(endpoint.connectionEndpoint);
            internTable.put(endpoint, new WeakReference<KerberosEndpoint>(endpoint));
            return endpoint;
        }
    }

    private void checkEndpoint(KerberosEndpoint ep) {
        if (!this.equals(ep)) {
            throw new IllegalArgumentException("endpoint mismatch, this endpoint is: " + this + ", passed in endpoint is: " + ep);
        }
    }

    private RequestHandleImpl checkRequestHandleImpl(Object h) {
        if (h == null) {
            throw new NullPointerException("Handle cannot be null");
        }
        if (!(h instanceof RequestHandleImpl)) {
            throw new IllegalArgumentException("Unexpected handle type: " + h);
        }
        RequestHandleImpl rh = (RequestHandleImpl)h;
        this.checkEndpoint(rh.getEndpoint());
        return rh;
    }

    private ConnectionImpl checkConnection(Object c) {
        if (!(c instanceof ConnectionImpl)) {
            throw new IllegalArgumentException("Expected connection type is " + ConnectionImpl.class + ", while " + c + " is passed in.");
        }
        ConnectionImpl conn = (ConnectionImpl)c;
        this.checkEndpoint(conn.getEndpoint());
        return conn;
    }

    static {
        maxCacheSize = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.maxCacheSize", 64));
        minGssContextLifetime = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.minGssContextLifetime", 30));
        maxGssContextRetries = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosEndpoint.maxGssContextRetries", 3));
        internTable = new WeakHashMap(5);
        KerberosEndpointInternals.registerDiscoveryBackDoor();
        ERROR_STRINGS = new String[]{"UNSUPPORTABLE_CONSTRAINT_REQUIRED", "NULL_SUBJECT", "NO_CLIENT_PRINCIPAL", "UNSATISFIABLE_CONSTRAINT_REQUIRED"};
    }

    private static final class CacheKey {
        private final Subject subject;
        private final InvocationConstraints constraints;

        CacheKey(Subject subject, InvocationConstraints constraints) {
            this.subject = subject;
            this.constraints = constraints;
        }

        public int hashCode() {
            return System.identityHashCode(this.subject) ^ System.identityHashCode(this.constraints);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey okey = (CacheKey)o;
            return this.subject == okey.subject && this.constraints == okey.constraints;
        }
    }

    private final class ConnectionImpl
    extends KerberosUtil.Connection
    implements Connection {
        private static final int KRB_AP_ERR_REPEAT = 34;
        private InputStream istream;
        private OutputStream ostream;

        ConnectionImpl(Socket sock, KerberosUtil.Config config) throws IOException {
            super(sock);
            this.clientPrincipal = config.clientPrincipal;
            this.doEncryption = config.encry;
            this.doDelegation = config.deleg;
            this.connectionLogger = logger;
            boolean done = false;
            try {
                Security.doPrivileged(new PrivilegedExceptionAction(this){
                    private final /* synthetic */ ConnectionImpl this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object run() throws IOException, GSSException {
                        ConnectionImpl.access$1600(this.this$1);
                        return null;
                    }
                });
                this.ostream = new KerberosUtil.ConnectionOutputStream(this);
                this.istream = new KerberosUtil.ConnectionInputStream(this);
                done = true;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "constructor", "failed to establish GSSContext for this connection with {0}.", new Object[]{config}, ex);
                }
                if (ex instanceof GSSException) {
                    IOException ioe = new IOException("Failed to establish GSS context for this connection.");
                    ioe.initCause(ex);
                    throw ioe;
                }
                throw (IOException)ex;
            }
            finally {
                if (!done) {
                    this.close();
                }
            }
        }

        public OutputStream getOutputStream() throws IOException {
            return this.ostream;
        }

        public InputStream getInputStream() throws IOException {
            return this.istream;
        }

        public SocketChannel getChannel() {
            return null;
        }

        public void populateContext(OutboundRequestHandle handle, Collection context) {
            if (handle == null) {
                throw new NullPointerException("handle is null");
            }
            if (context == null) {
                throw new NullPointerException("context is null");
            }
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle handle) {
            RequestHandleImpl rh = KerberosEndpoint.this.checkRequestHandleImpl(handle);
            return rh.unfulfilledConstraints;
        }

        public void writeRequestData(OutboundRequestHandle handle, OutputStream out) {
        }

        public IOException readResponseData(OutboundRequestHandle handle, InputStream in) {
            return null;
        }

        public String toString() {
            StringBuffer b = new StringBuffer("KerberosEndpoint.ConnectionImpl");
            b.append("[clientPrincipal=" + this.clientPrincipal);
            b.append(" serverPrincipal=" + KerberosEndpoint.this.serverPrincipal);
            b.append(" doEncryption=" + this.doEncryption);
            b.append(" doDelegation=" + this.doDelegation);
            b.append(" client=" + this.sock.getLocalAddress().getHostName());
            b.append(":" + this.sock.getLocalPort());
            b.append(" server=" + this.sock.getInetAddress().getHostName());
            b.append(":" + this.sock.getPort());
            b.append(']');
            return b.toString();
        }

        boolean satisfies(KerberosUtil.Config config) {
            return this.gssContext.getLifetime() >= minGssContextLifetime && this.clientPrincipal.equals(config.clientPrincipal) && this.doEncryption == config.encry && this.doDelegation == config.deleg;
        }

        void checkConnectPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                InetSocketAddress address = (InetSocketAddress)this.sock.getRemoteSocketAddress();
                if (address.isUnresolved()) {
                    sm.checkConnect(address.getHostName(), this.sock.getPort());
                } else {
                    sm.checkConnect(address.getAddress().getHostAddress(), this.sock.getPort());
                }
            }
        }

        boolean switchTo(KerberosUtil.Config config) {
            if (this.gssContext.getLifetime() < minGssContextLifetime) {
                return false;
            }
            if (this.clientPrincipal.equals(config.clientPrincipal) && this.doDelegation == config.deleg) {
                this.doEncryption = config.encry;
                return true;
            }
            return false;
        }

        KerberosEndpoint getEndpoint() {
            return KerberosEndpoint.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void establishContext() throws IOException, GSSException {
            Object object = classLock;
            synchronized (object) {
                if (gssManager == null) {
                    gssManager = GSSManager.getInstance();
                }
            }
            GSSName clientName = gssManager.createName(this.clientPrincipal.getName(), KerberosUtil.krb5NameType);
            GSSCredential clientCred = gssManager.createCredential(clientName, Integer.MAX_VALUE, KerberosUtil.krb5MechOid, 1);
            GSSName serverName = gssManager.createName(KerberosEndpoint.this.serverPrincipal.getName(), KerberosUtil.krb5NameType);
            block5: for (int i = maxGssContextRetries; i > 0; --i) {
                this.gssContext = gssManager.createContext(serverName, KerberosUtil.krb5MechOid, clientCred, 0);
                this.gssContext.requestMutualAuth(true);
                this.gssContext.requestInteg(true);
                this.gssContext.requestConf(true);
                this.gssContext.requestCredDeleg(this.doDelegation);
                this.gssContext.requestReplayDet(true);
                this.gssContext.requestSequenceDet(true);
                byte[] token = new byte[]{};
                try {
                    while (true) {
                        if ((token = this.gssContext.initSecContext(token, 0, token.length)) != null) {
                            this.dos.writeInt(token.length);
                            this.dos.write(token);
                            this.dos.flush();
                        }
                        if (this.gssContext.isEstablished()) break block5;
                        token = new byte[this.dis.readInt()];
                        this.dis.readFully(token);
                    }
                }
                catch (GSSException ge) {
                    if ((ge.getMessage().indexOf("34") >= 0 || ge.getMajor() == 19 || ge.getMinor() == 34 || ge.getMessage().indexOf("Request is a replay") >= 0) && i != 1) continue;
                    throw ge;
                }
            }
            if (!this.gssContext.getIntegState() || this.doEncryption && !this.gssContext.getConfState() || this.doDelegation && !this.gssContext.getCredDelegState() || !((Object)this.gssContext.getTargName()).toString().equals(KerberosEndpoint.this.serverPrincipal.getName())) {
                throw new IOException("Failed to establish gss context for connection");
            }
            logger.log(Level.FINE, "GSSContext established for {0}", this);
        }

        static /* synthetic */ void access$1600(ConnectionImpl x0) throws IOException, GSSException {
            x0.establishContext();
        }
    }

    private final class ConnectionEndpointImpl
    implements ConnectionEndpoint {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ConnectionEndpointImpl() {
        }

        public Connection connect(OutboundRequestHandle handle) throws IOException {
            RequestHandleImpl rh = KerberosEndpoint.this.checkRequestHandleImpl(handle);
            KerberosUtil.Config config = null;
            Exception exceptionCaught = null;
            try {
                List configs = rh.getConfigs();
                config = (KerberosUtil.Config)configs.get(0);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Passed in request handle is:\n{0},\nconfiguration list returned by getConfigs is:\n{1},\nin which the first one will be used.", new Object[]{rh, configs});
                }
            }
            catch (UnsupportedConstraintException e) {
                exceptionCaught = e;
            }
            catch (SecurityException e) {
                exceptionCaught = e;
            }
            if (exceptionCaught != null) {
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "connect", "failed to find a supportable connection configuration for the request", null, exceptionCaught);
                }
                if (rh.errorCode == 0) {
                    throw exceptionCaught;
                }
                UnsupportedConstraintException genericException = new UnsupportedConstraintException("Either there are conflicting or unsatisfiable constraint requirements, or the JAAS login has not been done (Subject.getSubject(AccessController.getContext()) returns null), or no appropriate Kerberos principal and corresponding TGT allowed by the requirements can be found in the current subject. " + rh.constraints);
                KerberosUtil.secureThrow(exceptionCaught, genericException);
            }
            Socket sock = !KerberosEndpoint.this.disableSocketConnect ? this.connectToHost(rh) : this.newSocket();
            ConnectionImpl c = new ConnectionImpl(sock, config);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "New connection established:\n{0}", new Object[]{c});
            }
            return c;
        }

        private Socket connectToHost(RequestHandleImpl rh) throws IOException {
            InetAddress[] addresses;
            try {
                addresses = InetAddress.getAllByName(KerberosEndpoint.this.serverHost);
            }
            catch (UnknownHostException uhe) {
                try {
                    return this.connectToSocketAddress(new InetSocketAddress(KerberosEndpoint.this.serverHost, KerberosEndpoint.this.serverPort), rh);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{KerberosEndpoint.this.serverHost + ":" + KerberosEndpoint.this.serverPort}, e);
                    }
                    throw e;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{KerberosEndpoint.this.serverHost + ":" + KerberosEndpoint.this.serverPort}, e);
                    }
                    throw e;
                }
            }
            catch (SecurityException e) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception resolving host {0}", new Object[]{KerberosEndpoint.this.serverHost}, e);
                }
                throw e;
            }
            IOException lastIOException = null;
            SecurityException lastSecurityException = null;
            for (int i = 0; i < addresses.length; ++i) {
                InetSocketAddress socketAddress = new InetSocketAddress(addresses[i], KerberosEndpoint.this.serverPort);
                try {
                    return this.connectToSocketAddress(socketAddress, rh);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl") : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastIOException = e;
                    if (!(e instanceof SocketTimeoutException)) continue;
                    break;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl") : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastSecurityException = e;
                }
            }
            if (lastIOException != null) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to {0}", new Object[]{KerberosEndpoint.this.serverHost + ":" + KerberosEndpoint.this.serverPort}, lastIOException);
                }
                throw lastIOException;
            }
            if (!$assertionsDisabled && lastSecurityException == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connectToHost", "exception connecting to {0}", new Object[]{KerberosEndpoint.this.serverHost + ":" + KerberosEndpoint.this.serverPort}, lastSecurityException);
            }
            throw lastSecurityException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Socket connectToSocketAddress(SocketAddress socketAddress, RequestHandleImpl rh) throws IOException {
            long timeout = rh.connectionAbsoluteTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                throw new SocketTimeoutException("connection timeout passed before socket.connect is called");
            }
            Socket sock = this.newSocket();
            boolean ok = false;
            try {
                if (timeout > Integer.MAX_VALUE) {
                    sock.connect(socketAddress);
                } else {
                    sock.connect(socketAddress, (int)timeout);
                }
                ok = true;
                Socket socket = sock;
                return socket;
            }
            finally {
                if (!ok) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private Socket newSocket() throws IOException {
            Socket sock;
            if (KerberosEndpoint.this.csf != null) {
                try {
                    sock = KerberosEndpoint.this.csf.createSocket();
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "newSocket", "failed to create socket using the given SocketFactory {0}", new Object[]{KerberosEndpoint.this.csf}, e);
                    }
                    throw e;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "created socket {0} using factory {1}", new Object[]{sock, KerberosEndpoint.this.csf});
                }
            } else {
                sock = new Socket();
                logger.log(Level.FINE, "created socket {0}", sock);
            }
            this.setSocketOptions(sock);
            return sock;
        }

        private void setSocketOptions(Socket sock) {
            block5: {
                block4: {
                    try {
                        sock.setTcpNoDelay(true);
                    }
                    catch (SocketException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block4;
                        KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "connect", "failed to setTcpNoDelay option for {0}", new Object[]{sock}, e);
                    }
                }
                try {
                    sock.setKeepAlive(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block5;
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "connect", "failed to setKeepAlive options for {0}", new Object[]{sock}, e);
                }
            }
        }

        public Connection connect(OutboundRequestHandle handle, Collection active, Collection idle) {
            ConnectionImpl c;
            Iterator j;
            KerberosUtil.Config config;
            List configList;
            RequestHandleImpl rh = KerberosEndpoint.this.checkRequestHandleImpl(handle);
            if (active == null) {
                throw new NullPointerException("active collection cannot be null");
            }
            if (idle == null) {
                throw new NullPointerException("idle collection cannot be null");
            }
            try {
                configList = rh.getConfigs();
            }
            catch (Exception e) {
                return null;
            }
            boolean checkedResolvePermission = false;
            Iterator i = configList.iterator();
            while (i.hasNext()) {
                config = (KerberosUtil.Config)i.next();
                j = active.iterator();
                while (j.hasNext()) {
                    c = KerberosEndpoint.this.checkConnection(j.next());
                    if (!c.satisfies(config)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "found an active connection for reusing:\n{0}\n{1}", new Object[]{c, config});
                    }
                    if (!checkedResolvePermission) {
                        try {
                            this.checkResolvePermission();
                        }
                        catch (SecurityException e) {
                            if (logger.isLoggable(Levels.FAILED)) {
                                LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connect", "exception resolving host {0}", new Object[]{KerberosEndpoint.this.serverHost}, e);
                            }
                            throw e;
                        }
                        checkedResolvePermission = true;
                    }
                    try {
                        c.checkConnectPermission();
                        return c;
                    }
                    catch (SecurityException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        LogUtil.logThrow(logger, Levels.HANDLED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl") : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connect", "access to reuse connection {0} denied", new Object[]{c.sock}, e);
                    }
                }
            }
            i = configList.iterator();
            while (i.hasNext()) {
                config = (KerberosUtil.Config)i.next();
                j = idle.iterator();
                while (j.hasNext()) {
                    c = KerberosEndpoint.this.checkConnection(j.next());
                    if (!c.switchTo(config)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "found an idle connection for reusing:\n{0}\n{1}", new Object[]{c, config});
                    }
                    if (!checkedResolvePermission) {
                        try {
                            this.checkResolvePermission();
                        }
                        catch (SecurityException e) {
                            if (logger.isLoggable(Levels.FAILED)) {
                                LogUtil.logThrow(logger, Levels.FAILED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl")) : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connect", "exception resolving host {0}", new Object[]{KerberosEndpoint.this.serverHost}, e);
                            }
                            throw e;
                        }
                        checkedResolvePermission = true;
                    }
                    try {
                        c.checkConnectPermission();
                        return c;
                    }
                    catch (SecurityException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        LogUtil.logThrow(logger, Levels.HANDLED, class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl == null ? KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint$ConnectionEndpointImpl") : class$net$jini$jeri$kerberos$KerberosEndpoint$ConnectionEndpointImpl, "connect", "access to reuse connection {0} denied", new Object[]{c.sock}, e);
                    }
                }
            }
            return null;
        }

        private void checkResolvePermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(KerberosEndpoint.this.serverHost, -1);
            }
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$kerberos$KerberosEndpoint == null ? (class$net$jini$jeri$kerberos$KerberosEndpoint = KerberosEndpoint.class$("net.jini.jeri.kerberos.KerberosEndpoint")) : class$net$jini$jeri$kerberos$KerberosEndpoint).desiredAssertionStatus();
        }
    }

    private final class RequestHandleImpl
    implements OutboundRequestHandle {
        private Subject clientSubject;
        private InvocationConstraints constraints;
        private boolean subjectReadOnly;
        private Set subjectClientPrincipals;
        private Set clientPrincipals;
        private int errorCode = -1;
        private String detailedExceptionMsg;
        private KerberosUtil.Config[] configs;
        private InvocationConstraints unfulfilledConstraints;
        long connectionAbsoluteTime;

        RequestHandleImpl(Subject clientSubject, InvocationConstraints constraints) {
            Iterator iter = constraints.requirements().iterator();
            while (iter.hasNext()) {
                InvocationConstraint c = (InvocationConstraint)iter.next();
                if (KerberosUtil.isSupportableConstraint(c)) continue;
                this.errorCode = 0;
                this.detailedExceptionMsg = "A constraint unsupportable by this endpoint has been required: " + c;
                return;
            }
            this.clientPrincipals = new HashSet();
            iter = constraints.requirements().iterator();
            while (iter.hasNext()) {
                if (KerberosUtil.collectCpCandidates((InvocationConstraint)iter.next(), this.clientPrincipals)) continue;
                this.errorCode = 0;
                this.detailedExceptionMsg = "Client principal constraint related conflicts found in the given set of constraints: " + constraints;
                return;
            }
            if (clientSubject == null) {
                this.errorCode = 1;
                this.detailedExceptionMsg = "JAAS login has not been done properly, the subject associated with the current AccessControlContext is null.";
                return;
            }
            this.clientSubject = clientSubject;
            this.constraints = constraints;
            this.subjectReadOnly = clientSubject.isReadOnly();
            this.subjectClientPrincipals = this.getClientPrincipals(clientSubject);
            if (this.subjectClientPrincipals.size() == 0) {
                this.errorCode = 2;
                this.detailedExceptionMsg = "JAAS login has not been done properly, the subject associated with the current AccessControlContext contains no KerberosPrincipal.";
                return;
            }
            if (this.clientPrincipals.size() > 0) {
                this.clientPrincipals.retainAll(this.subjectClientPrincipals);
            } else {
                this.clientPrincipals = this.subjectClientPrincipals;
            }
            boolean canDeleg = false;
            if (KerberosUtil.containsConstraint(constraints.requirements(), Delegation.YES) || KerberosUtil.containsConstraint(constraints.preferences(), Delegation.YES)) {
                canDeleg = true;
            }
            ArrayList<KerberosUtil.Config> configArr = new ArrayList<KerberosUtil.Config>();
            KerberosUtil.ConfigIter citer = new KerberosUtil.ConfigIter(this.clientPrincipals, KerberosEndpoint.this.serverPrincipal, canDeleg);
            block2: while (citer.hasNext()) {
                KerberosUtil.Config config = citer.next();
                Iterator jter = constraints.requirements().iterator();
                while (jter.hasNext()) {
                    InvocationConstraint c = (InvocationConstraint)jter.next();
                    if (KerberosUtil.isSatisfiable(config, c)) continue;
                    continue block2;
                }
                configArr.add(config);
            }
            if (configArr.size() == 0) {
                this.errorCode = 3;
                this.detailedExceptionMsg = "Constraints unsatisfiable by this endpoint with the current subject have been required: " + constraints + ", while the KerberosPrincipal set of " + "the subject is: " + this.subjectClientPrincipals;
                return;
            }
            this.configs = configArr.toArray(new KerberosUtil.Config[configArr.size()]);
            for (int i = 0; i < this.configs.length; ++i) {
                Iterator iter2 = constraints.preferences().iterator();
                while (iter2.hasNext()) {
                    InvocationConstraint c = (InvocationConstraint)iter2.next();
                    if (!KerberosUtil.isSatisfiable(this.configs[i], c)) continue;
                    ++this.configs[i].prefCount;
                }
            }
            Arrays.sort(this.configs, new Comparator(this){
                private final /* synthetic */ RequestHandleImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    KerberosUtil.Config config1 = (KerberosUtil.Config)o1;
                    KerberosUtil.Config config2 = (KerberosUtil.Config)o2;
                    return config2.prefCount - config1.prefCount;
                }
            });
            this.unfulfilledConstraints = KerberosUtil.containsConstraint(constraints.requirements(), Integrity.YES) ? KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS : (KerberosUtil.containsConstraint(constraints.preferences(), Integrity.YES) ? KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS : InvocationConstraints.EMPTY);
            this.connectionAbsoluteTime = Math.min(this.computeConnectionTimeLimit(constraints.requirements()), this.computeConnectionTimeLimit(constraints.preferences()));
        }

        public String toString() {
            StringBuffer b = new StringBuffer("KerberosEndpoint.RequestHandleImpl[\n");
            if (this.errorCode != -1) {
                b.append("errorCode=" + ERROR_STRINGS[this.errorCode]);
                b.append(" errorExceptionMsg=" + this.detailedExceptionMsg);
            } else {
                b.append("constraints=" + this.constraints);
                b.append("\nprincipalsInSubject=" + this.subjectClientPrincipals);
                b.append("\nallowedConfigs=[\n");
                if (this.configs.length > 0) {
                    b.append(this.configs[0]);
                }
                for (int i = 1; i < this.configs.length; ++i) {
                    b.append(",\n" + this.configs[i]);
                }
                b.append("],");
                b.append("\nunfulfilledConstraints=" + this.unfulfilledConstraints);
                b.append("\nconnectionAbsoluteTime=");
                if (this.connectionAbsoluteTime == Long.MAX_VALUE) {
                    b.append("NO_LIMIT");
                } else {
                    b.append(new Date(this.connectionAbsoluteTime));
                }
            }
            b.append(']');
            return b.toString();
        }

        boolean reusable(Subject subject) {
            if (subject == null || this.subjectReadOnly) {
                return true;
            }
            Set cps = this.getClientPrincipals(subject);
            return ((Object)cps).equals(this.subjectClientPrincipals);
        }

        List getConfigs() throws UnsupportedConstraintException {
            if (this.errorCode != -1) {
                throw new UnsupportedConstraintException(this.detailedExceptionMsg);
            }
            KerberosTicket[] tickets = (KerberosTicket[])AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ RequestHandleImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public Object run() {
                    return RequestHandleImpl.access$800(this.this$1);
                }
            });
            ArrayList<KerberosUtil.Config> configList = new ArrayList<KerberosUtil.Config>(this.configs.length);
            int delegYesStepsFromSuccess = 3;
            KerberosPrincipal delegYesCp = null;
            int delegNoStepsFromSuccess = 2;
            KerberosPrincipal delegNoCp = null;
            HashMap<AuthenticationPermission, Boolean> hasPermMap = new HashMap<AuthenticationPermission, Boolean>();
            for (int i = 0; i < this.configs.length; ++i) {
                block19: {
                    AuthenticationPermission perm = this.getAuthenticationPermission(this.configs[i].clientPrincipal, this.configs[i].deleg);
                    Boolean hasPerm = (Boolean)hasPermMap.get(perm);
                    if (hasPerm == null) {
                        try {
                            KerberosUtil.checkAuthPermission(perm);
                            hasPermMap.put(perm, Boolean.TRUE);
                            break block19;
                        }
                        catch (SecurityException e) {
                            hasPermMap.put(perm, Boolean.FALSE);
                            continue;
                        }
                    }
                    if (hasPerm == Boolean.FALSE) continue;
                }
                if (this.configs[i].deleg) {
                    KerberosTicket t;
                    if (delegYesStepsFromSuccess > 2) {
                        delegYesStepsFromSuccess = 2;
                        delegYesCp = this.configs[i].clientPrincipal;
                    }
                    if ((t = this.findTicket(tickets, this.configs[i].clientPrincipal)) == null) continue;
                    if (delegYesStepsFromSuccess > 1) {
                        delegYesStepsFromSuccess = 1;
                        delegYesCp = this.configs[i].clientPrincipal;
                    }
                    if (!t.isForwardable()) continue;
                    configList.add(this.configs[i]);
                    continue;
                }
                if (delegNoStepsFromSuccess > 1) {
                    delegNoStepsFromSuccess = 1;
                    delegNoCp = this.configs[i].clientPrincipal;
                }
                if (this.findTicket(tickets, this.configs[i].clientPrincipal) == null) continue;
                configList.add(this.configs[i]);
            }
            if (configList.size() == 0) {
                if (delegNoStepsFromSuccess < delegYesStepsFromSuccess) {
                    switch (delegNoStepsFromSuccess) {
                        case 1: {
                            throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext does not contain a valid TGT for " + delegNoCp.getName());
                        }
                        case 2: {
                            throw new SecurityException("Caller does not have any of the following acceptable permissions: " + hasPermMap.keySet());
                        }
                    }
                    throw new AssertionError((Object)"should not reach here");
                }
                switch (delegYesStepsFromSuccess) {
                    case 1: {
                        throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext contains a valid TGT for " + delegYesCp.getName() + ", but the TGT is not " + "forwardable.");
                    }
                    case 2: {
                        throw new UnsupportedConstraintException("JAAS login has not been done properly, the subject associated with the current AccessControlContext does not contain a valid TGT for " + delegYesCp.getName());
                    }
                }
                throw new AssertionError((Object)"should not reach here");
            }
            return configList;
        }

        KerberosEndpoint getEndpoint() {
            return KerberosEndpoint.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getClientPrincipals(Subject subj) {
            Set<Principal> cpset;
            Set<Principal> set = cpset = subj.getPrincipals();
            synchronized (set) {
                HashSet<Principal> set2 = new HashSet<Principal>(cpset.size());
                Iterator<Principal> iter = cpset.iterator();
                while (iter.hasNext()) {
                    Principal p = iter.next();
                    if (!(p instanceof KerberosPrincipal)) continue;
                    set2.add(p);
                }
                return set2;
            }
        }

        private long computeConnectionTimeLimit(Set constraints) {
            long timeLimit = Long.MAX_VALUE;
            Iterator iter = constraints.iterator();
            block0: while (iter.hasNext()) {
                Object c = iter.next();
                long constraintTimeLimit = Long.MIN_VALUE;
                if (c instanceof ConstraintAlternatives) {
                    Set alts = ((ConstraintAlternatives)c).elements();
                    Iterator jter = alts.iterator();
                    while (jter.hasNext()) {
                        Object alt = jter.next();
                        if (!(alt instanceof ConnectionAbsoluteTime)) continue block0;
                        long t = ((ConnectionAbsoluteTime)alt).getTime();
                        if (constraintTimeLimit >= t) continue;
                        constraintTimeLimit = t;
                    }
                } else {
                    if (!(c instanceof ConnectionAbsoluteTime)) continue;
                    constraintTimeLimit = ((ConnectionAbsoluteTime)c).getTime();
                }
                if (constraintTimeLimit >= timeLimit) continue;
                timeLimit = constraintTimeLimit;
            }
            return timeLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KerberosTicket[] getTickets() {
            Set<Object> creds;
            ArrayList<KerberosTicket> tlist = new ArrayList<KerberosTicket>();
            Set<Object> set = creds = this.clientSubject.getPrivateCredentials();
            synchronized (set) {
                Iterator<Object> iter = creds.iterator();
                while (iter.hasNext()) {
                    KerberosTicket ticket;
                    Object cred = iter.next();
                    if (!(cred instanceof KerberosTicket) || !(ticket = (KerberosTicket)cred).getServer().getName().startsWith("krbtgt/") || ticket.isDestroyed() || !ticket.isCurrent()) continue;
                    tlist.add(ticket);
                }
            }
            return tlist.toArray(new KerberosTicket[tlist.size()]);
        }

        private KerberosTicket findTicket(KerberosTicket[] tickets, KerberosPrincipal p) {
            String crealm = p.getRealm();
            String srealm = KerberosEndpoint.this.serverPrincipal.getRealm();
            String tgtName = "krbtgt/" + srealm + "@" + crealm;
            for (int i = 0; i < tickets.length; ++i) {
                if (!tickets[i].getClient().equals(p) || !tickets[i].getServer().getName().equals(tgtName)) continue;
                return tickets[i];
            }
            return null;
        }

        private AuthenticationPermission getAuthenticationPermission(KerberosPrincipal client, boolean deleg) {
            String act = deleg ? "delegate" : "connect";
            Set<KerberosPrincipal> locals = Collections.singleton(client);
            Set<KerberosPrincipal> peers = Collections.singleton(KerberosEndpoint.this.serverPrincipal);
            return new AuthenticationPermission(locals, peers, act);
        }

        static /* synthetic */ KerberosTicket[] access$800(RequestHandleImpl x0) {
            return x0.getTickets();
        }
    }

    private static final class KerberosEndpointInternals
    implements EndpointInternals {
        private KerberosEndpointInternals() {
        }

        static void registerDiscoveryBackDoor() {
            KerberosEndpointInternals backDoor = new KerberosEndpointInternals();
            try {
                Security.doPrivileged(new PrivilegedAction(backDoor){
                    private final /* synthetic */ KerberosEndpointInternals val$backDoor;
                    {
                        this.val$backDoor = val$backDoor;
                    }

                    public Object run() {
                        KerberosEndpointInternalsAccess.set(this.val$backDoor);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Problem registering with discovery provider", t);
            }
        }

        public void disableSocketConnect(Endpoint endpoint) {
            ((KerberosEndpoint)endpoint).disableSocketConnect = true;
        }

        public void setConnManagerFactory(Endpoint endpoint, ConnManagerFactory factory) {
            KerberosEndpoint kep = (KerberosEndpoint)endpoint;
            kep.connManager = factory.create(kep.connectionEndpoint);
        }

        public void setServerConnManager(ServerEndpoint endpoint, ServerConnManager manager) {
            KerberosServerEndpoint ksep = (KerberosServerEndpoint)endpoint;
            ksep.serverConnManager = manager;
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle handle) {
            return ((RequestHandleImpl)handle).unfulfilledConstraints;
        }
    }
}

