/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.ObjectTable;
import com.sun.jini.jeri.internal.runtime.SameClassKey;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.Unreferenced;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jini.id.Uuid;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.security.Security;

public final class BasicExportTable {
    private static final Object PENDING;
    private final ObjectTable objectTable = new ObjectTable();
    private final Object lock = new Object();
    private final Map listenPool = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry export(Remote impl, ServerEndpoint serverEndpoint, boolean allowDGC, boolean keepAlive, Uuid id) throws ExportException {
        Endpoint endpoint;
        ObjectTable.Target target;
        List bindings;
        block17: {
            bindings = null;
            target = null;
            try {
                LC listenContext = new LC();
                try {
                    endpoint = serverEndpoint.enumerateListenEndpoints(listenContext);
                }
                catch (IOException e) {
                    throw new ExportException("listen failed", e);
                }
                finally {
                    bindings = listenContext.getFinalBindings();
                }
                RequestDispatcher[] requestDispatchers = new RequestDispatcher[bindings.size()];
                for (int i = 0; i < requestDispatchers.length; ++i) {
                    requestDispatchers[i] = ((Binding)bindings.get((int)i)).requestDispatcher;
                }
                target = this.objectTable.export(impl, requestDispatchers, allowDGC, keepAlive, id);
                Object var13_14 = null;
                if (bindings == null) break block17;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (bindings != null) {
                    for (int i = 0; i < bindings.size(); ++i) {
                        Binding binding = (Binding)bindings.get(i);
                        Object object = this.lock;
                        synchronized (object) {
                            --binding.exportsInProgress;
                        }
                        if (target != null) continue;
                        binding.checkReferenced();
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < bindings.size(); ++i) {
                Binding binding = (Binding)bindings.get(i);
                Object object = this.lock;
                synchronized (object) {
                    --binding.exportsInProgress;
                }
                if (target != null) continue;
                binding.checkReferenced();
            }
        }
        return new Entry(bindings, target, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding getBinding(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
        Object object;
        SameClassKey key = new SameClassKey(listenEndpoint);
        Binding binding = null;
        Object object2 = this.lock;
        synchronized (object2) {
            Object value;
            while (true) {
                if ((value = this.listenPool.get(key)) instanceof Binding) {
                    binding = (Binding)value;
                    ++binding.exportsInProgress;
                    return binding;
                }
                if (value != PENDING) break;
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            if (!$assertionsDisabled && value != null) {
                throw new AssertionError();
            }
            this.listenPool.put(key, PENDING);
        }
        try {
            binding = new Binding(listenEndpoint);
            Object var9_8 = null;
            object = this.lock;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Object object3 = this.lock;
            synchronized (object3) {
                if (!$assertionsDisabled && this.listenPool.get(key) != PENDING) {
                    throw new AssertionError();
                }
                if (binding != null) {
                    this.listenPool.put(key, binding);
                    ++binding.exportsInProgress;
                } else {
                    this.listenPool.remove(key);
                }
                this.lock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            if (!$assertionsDisabled && this.listenPool.get(key) != PENDING) {
                throw new AssertionError();
            }
            if (binding != null) {
                this.listenPool.put(key, binding);
                ++binding.exportsInProgress;
            } else {
                this.listenPool.remove(key);
            }
            this.lock.notifyAll();
        }
        return binding;
    }

    static {
        $assertionsDisabled = !BasicExportTable.class.desiredAssertionStatus();
        PENDING = new Object();
    }

    private class Binding {
        private final ServerEndpoint.ListenEndpoint listenEndpoint;
        final RequestDispatcher requestDispatcher;
        final ServerEndpoint.ListenHandle listenHandle;
        int exportsInProgress = 0;

        Binding(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
            this.listenEndpoint = listenEndpoint;
            this.requestDispatcher = BasicExportTable.this.objectTable.createRequestDispatcher(new Unreferenced(this){
                private final /* synthetic */ Binding this$1;
                {
                    this.this$1 = this$1;
                }

                public void unreferenced() {
                    this.this$1.checkReferenced();
                }
            });
            try {
                this.listenHandle = (ServerEndpoint.ListenHandle)Security.doPrivileged(new PrivilegedExceptionAction(this, listenEndpoint){
                    private final /* synthetic */ ServerEndpoint.ListenEndpoint val$listenEndpoint;
                    private final /* synthetic */ Binding this$1;
                    {
                        this.this$1 = this$1;
                        this.val$listenEndpoint = val$listenEndpoint;
                    }

                    public Object run() throws IOException {
                        return this.val$listenEndpoint.listen(this.this$1.requestDispatcher);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkReferenced() {
            Object object = BasicExportTable.this.lock;
            synchronized (object) {
                if (this.exportsInProgress > 0 || BasicExportTable.this.objectTable.isReferenced(this.requestDispatcher)) {
                    return;
                }
                BasicExportTable.this.listenPool.remove(new SameClassKey(this.listenEndpoint));
            }
            this.listenHandle.close();
        }
    }

    private class LC
    implements ServerEndpoint.ListenContext {
        private boolean done = false;
        private final List bindings = new ArrayList();

        LC() {
        }

        public synchronized ServerEndpoint.ListenCookie addListenEndpoint(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
            if (this.done) {
                throw new IllegalStateException();
            }
            listenEndpoint.checkPermissions();
            Binding binding = BasicExportTable.this.getBinding(listenEndpoint);
            this.bindings.add(binding);
            return binding.listenHandle.getCookie();
        }

        synchronized List getFinalBindings() {
            this.done = true;
            return this.bindings;
        }
    }

    public static final class Entry {
        private final List bindings;
        private final ObjectTable.Target target;
        private final Endpoint endpoint;

        Entry(List bindings, ObjectTable.Target target, Endpoint endpoint) {
            this.bindings = bindings;
            this.target = target;
            this.endpoint = endpoint;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setInvocationDispatcher(InvocationDispatcher id) {
            this.target.setInvocationDispatcher(id);
        }

        public boolean unexport(boolean force) {
            if (!this.target.unexport(force)) {
                return false;
            }
            for (int i = 0; i < this.bindings.size(); ++i) {
                ((Binding)this.bindings.get(i)).checkReferenced();
            }
            return true;
        }
    }
}

