/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.isqlviewer.util.StringUtilities;

public final class UserPreferences {
    private static final String BACKING_STORE_AVAIL = "BackingStoreAvail";
    private Preferences prefStore = null;
    private Preferences defaults = null;

    public UserPreferences() {
        this(Preferences.userRoot(), "");
    }

    public UserPreferences(Preferences preferences) {
        this(preferences, "");
    }

    public UserPreferences(UserPreferences userPreferences) {
        this(userPreferences.toPreferences());
    }

    public UserPreferences(UserPreferences userPreferences, String string) {
        this(userPreferences.toPreferences(), string);
    }

    public UserPreferences(Preferences preferences, String string) {
        if (preferences == null) {
            preferences = Preferences.userRoot();
        }
        this.defaults = preferences;
        if (string == null) {
            string = "";
        }
        this.prefStore = preferences.node(string);
    }

    public boolean getBoolean(String string) {
        return this.prefStore.getBoolean(string, this.defaults.getBoolean(string, false));
    }

    public void putBoolean(String string, boolean bl2) {
        if (this.getBoolean(string) != bl2) {
            this.prefStore.putBoolean(string, bl2);
        }
    }

    public double getDouble(String string) {
        return this.prefStore.getDouble(string, this.defaults.getDouble(string, Double.NaN));
    }

    public void putDouble(String string, double d2) {
        this.prefStore.putDouble(string, d2);
    }

    public float getFloat(String string) {
        return this.prefStore.getFloat(string, this.defaults.getFloat(string, Float.NaN));
    }

    public void putFloat(String string, float f2) {
        if (this.getFloat(string) != f2) {
            this.prefStore.putFloat(string, f2);
        }
    }

    public long getLong(String string) {
        return this.prefStore.getLong(string, this.defaults.getLong(string, Long.MIN_VALUE));
    }

    public void putLong(String string, long l2) {
        if (this.getLong(string) != l2) {
            this.prefStore.putLong(string, l2);
        }
    }

    public int getInt(String string) {
        return this.prefStore.getInt(string, this.defaults.getInt(string, Integer.MIN_VALUE));
    }

    public void putInt(String string, int n2) {
        if (this.getInt(string) != n2) {
            this.prefStore.putInt(string, n2);
        }
    }

    public String get(String string) {
        return this.prefStore.get(string, this.defaults.get(string, ""));
    }

    public void put(String string, String string2) {
        try {
            if (!this.get(string).equals(string2)) {
                this.prefStore.put(string, string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.prefStore.put(string, string2);
        }
    }

    public void putColor(String string, Color color) {
        this.put(string, StringUtilities.getHTMLColor(color));
    }

    public Color getColor(String string) {
        return Color.decode(this.prefStore.get(string, this.defaults.get(string, "#000000")));
    }

    public void putRect(String string, Rectangle rectangle) {
        this.put(string, StringUtilities.formatRectangle(rectangle));
    }

    public Rectangle getRect(String string) {
        return StringUtilities.parseRectangle(this.prefStore.get(string, this.defaults.get(string, "0,0,0,0")));
    }

    public void putFont(String string, Font font) {
        this.put(string, StringUtilities.getFontString(font));
    }

    public Font getFont(String string) {
        Font font = StringUtilities.parseFontString(this.prefStore.get(string, this.defaults.get(string, "Default,11")));
        if (font == null) {
            font = StringUtilities.parseFontString("Default,11");
        }
        return font;
    }

    public boolean clearAll() {
        try {
            this.prefStore.clear();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public void clear(String string) {
        this.prefStore.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBackingStore() {
        try {
            boolean bl2 = this.prefStore.getBoolean(BACKING_STORE_AVAIL, false);
            this.prefStore.putBoolean(BACKING_STORE_AVAIL, !bl2);
            this.prefStore.flush();
        }
        catch (BackingStoreException backingStoreException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.prefStore.remove(BACKING_STORE_AVAIL);
        }
        return true;
    }

    public boolean containsKey(String string) {
        try {
            return Arrays.asList(this.prefStore.keys()).contains(string);
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            return this.prefStore.keys().length == 0;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public boolean flush() {
        try {
            this.prefStore.flush();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public Properties toPropertiesWithKeys(Collection collection) {
        Properties properties = new Properties(null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.get(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public boolean sync() {
        try {
            this.prefStore.sync();
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public Preferences toPreferences() {
        return this.prefStore;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.prefStore.addPreferenceChangeListener(preferenceChangeListener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.prefStore.removePreferenceChangeListener(preferenceChangeListener);
    }
}

