/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.j_spaces.core.IJSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.MetadataTreeModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JDBCTreeCellRenderer;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class TableEditor
extends JDialog
implements ResultSetViewer {
    private static final int ACTION_OK = 0;
    private static final int ACTION_ROW_ADD = 1;
    private static final int ACTION_ROW_REFRESH = 2;
    private static final int ACTION_ROW_DELETE = 3;
    private static final int ACTION_PRINT = 4;
    private static final int ACTION_SCHEMA_CHANGE = 5;
    private static TableEditor instance = null;
    private DatabaseConnection connection = null;
    private NumberFormat nf = NumberFormat.getIntegerInstance();
    private String currentStatement = null;
    private ActionInputHandler actionHandler = new ActionInputHandler(null);
    private MetadataTreeModel mdlBrowser = new MetadataTreeModel(null);
    private ResultSetTableModel mdlEditor = new ResultSetTableModel(null, null, false);
    private DefaultComboBoxModel mdlSchemas = new DefaultComboBoxModel<Object>(new Object[0]);
    private boolean supportsUpdatableResults = false;
    private int preferredType = 0;
    private JSplitPane jspSplitter = new JSplitPane(1);
    private JTree jtrBrowser = new JTree(this.mdlBrowser);
    private JTree jtrBookmark = new JTree(SystemConfig.getInstance().getBookmarks());
    private JButton btnOK = new JButton();
    private ITable tabEditor = new ITable(this.mdlEditor);
    private JToolBar toolbar = ActionToolBar.createNullInstance();
    private JComboBox jcbSchemas = new JComboBox(this.mdlSchemas);
    private JButton btnAddRow = new JButton(BasicUtilities.loadToolbarIconResource("AddRow"));
    private JButton btnRemRow = new JButton(BasicUtilities.loadToolbarIconResource("RowDelete"));
    private JButton btnRefRow = new JButton(BasicUtilities.loadToolbarIconResource("Refresh"));
    private JButton btnPrint = new JButton(BasicUtilities.loadToolbarIconResource("PrintPreview"));
    private JLabel lblScroll = new JLabel(" ");
    private JLabel lblLocatr = new JLabel(" 000/000 ");
    private JLabel lblCursor = new JLabel(" ");

    public void processGeneratedKeys(String string, ResultSet resultSet, String string2) {
    }

    public void processRowUpdates(String string, int n2, String string2) {
        String string3 = BasicUtilities.getString("TabEditor_Bad_ResultSet_Recieved");
        JOptionPane.showMessageDialog(this, string3);
    }

    public boolean supportsGeneratedKeys() {
        return false;
    }

    public boolean supportsUpdateableResultSets() {
        return true;
    }

    public void handleSQLException(ResultSet resultSet, SQLException sQLException) {
        String string = BasicUtilities.getString("Query_Failed");
        BasicUtilities.showExceptionPopup(this, sQLException, string);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                if (this.supportsUpdatableResults) break;
                String string = BasicUtilities.getString("TabEditor_Support_Warning");
                String string2 = BasicUtilities.getString("Warning");
                JOptionPane.showMessageDialog(this, string, string2, 2);
                break;
            }
            case 201: {
                this.cleanupCurrentStatement();
            }
        }
        super.processWindowEvent(windowEvent);
    }

    public void processResultSet(String string, ResultSet resultSet, String string2, int n2, IJSpace iJSpace) {
        if (JDBCUtilities.isUpdatable(resultSet)) {
            try {
                this.mdlEditor.setData(resultSet, null);
                String string3 = null;
                try {
                    string3 = resultSet.getCursorName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (string3 == null) {
                    this.lblCursor.setText(BasicUtilities.getString("TabEditor_Cursor_Txt", ""));
                } else {
                    this.lblCursor.setText(string3);
                }
                BasicUtilities.optimizeTableView(this.tabEditor);
                String string4 = null;
                switch (resultSet.getType()) {
                    case 1004: {
                        string4 = BasicUtilities.getString("TabEditor_Scroll_Insensitive");
                        break;
                    }
                    case 1005: {
                        string4 = BasicUtilities.getString("TabEditor_Scroll_Sensitive");
                        break;
                    }
                    default: {
                        string4 = BasicUtilities.getString("TabEditor_Scroll_Unknown");
                    }
                }
                this.lblScroll.setText(" " + string4 + " ");
                this.currentStatement = string;
                this.toolbar.setEnabled(true);
                if (this.mdlEditor.getTrueRowCount() >= 1) {
                    this.tabEditor.addRowSelectionInterval(0, 0);
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, BasicUtilities.getString("Query_Exception"));
            }
            SQLWarningViewer.addConnectionWarnings(this.connection.getWarnings());
        } else {
            String string5 = BasicUtilities.getString("TabEditor_Bad_ResultSet_Recieved");
            JOptionPane.showMessageDialog(this, string5);
            this.connection.disposeStatement(string);
        }
    }

    public void recieveResultsetWarnings(ResultSet resultSet, SQLWarning sQLWarning) {
        SQLWarningViewer.addResultsetWarnings(sQLWarning);
    }

    public void recieveStatementWarnings(Statement statement, SQLWarning sQLWarning) {
        SQLWarningViewer.addStatementWarnings(sQLWarning);
    }

    public void statementInitialized(String string) {
        this.mdlEditor.clearAll();
        this.toolbar.setEnabled(false);
    }

    public void handleStatementInterrupted(String string) {
    }

    public static int showDialog(MainFrame mainFrame) {
        try {
            instance = new TableEditor((Frame)mainFrame, mainFrame.getJDBCConnection());
            instance.pack();
            instance.setSize(640, 480);
            instance.setLocationRelativeTo(mainFrame);
            instance.show();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable);
            return -1;
        }
        return 0;
    }

    private TableEditor(Frame frame, DatabaseConnection databaseConnection) {
        super(frame, BasicUtilities.getString("TabEditor_Window_Title"), true);
        try {
            this.initUI();
            this.setConnection(databaseConnection);
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "TableEditor()::initUI()");
        }
        this.nf.setMinimumIntegerDigits(3);
    }

    public void setConnection(DatabaseConnection databaseConnection) {
        Object[] objectArray;
        this.connection = databaseConnection;
        try {
            objectArray = this.connection.getDatabaseInformation();
            if (objectArray.supportsResultSetType(1005)) {
                this.preferredType = 1005;
            } else if (objectArray.supportsResultSetType(1004)) {
                this.preferredType = 1004;
            }
            this.supportsUpdatableResults = objectArray.supportsResultSetConcurrency(this.preferredType, 1008);
        }
        catch (Throwable throwable) {
            this.supportsUpdatableResults = false;
        }
        this.mdlBrowser.updateConnection(databaseConnection);
        this.mdlSchemas.removeAllElements();
        if (databaseConnection != null) {
            this.mdlBrowser.setCatalog(databaseConnection.getCatalog(), true);
            objectArray = databaseConnection.getAvailableSchemas();
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.mdlSchemas.addElement(objectArray[i2]);
                }
            }
            if (this.mdlSchemas.getSize() >= 1) {
                this.jcbSchemas.setSelectedItem(databaseConnection.getSchema());
            }
        } else {
            this.mdlBrowser.setSchema(null, false);
            this.mdlBrowser.setCatalog(null, true);
        }
        this.jcbSchemas.setEnabled(this.mdlSchemas.getSize() >= 1);
    }

    public void handleActionPreformed(int n2) {
        int n3 = this.tabEditor.getSelectedRow();
        switch (n2) {
            case 0: {
                this.dispatchEvent(new WindowEvent(this, 201));
                break;
            }
            case 5: {
                String string = (String)this.mdlSchemas.getSelectedItem();
                this.mdlBrowser.setSchema(string, true);
                break;
            }
            case 4: {
                PrinterPreview.showPrintPreviewDialog(this, (Object)this.tabEditor.getModel(), "");
                break;
            }
            case 1: {
                try {
                    this.mdlEditor.createInsertRow();
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "ResultSetTableModel::createInsertRow()");
                }
                break;
            }
            case 3: {
                if (n3 < 0) break;
                this.mdlEditor.removeRow(n3);
                break;
            }
            case 2: {
                if (n3 < 0) break;
                try {
                    this.mdlEditor.refreshRow(n3);
                    break;
                }
                catch (Throwable throwable) {
                    BasicUtilities.showExceptionPopup(this, throwable, "");
                }
            }
        }
    }

    private void cleanupCurrentStatement() {
        if (this.currentStatement != null) {
            this.connection.disposeStatement(this.currentStatement);
            this.mdlEditor.disableEditing();
        }
    }

    private void initUI() {
        this.mdlBrowser.setMetadataEnabled(false);
        this.mdlBrowser.setProceduresEnabled(false);
        this.tabEditor.setSelectionMode(0);
        this.tabEditor.setSelectionToggleEnabled(false);
        this.tabEditor.addActionListener(new TableActionHandler(null));
        this.jtrBrowser.setCellRenderer(new JDBCTreeCellRenderer());
        this.jtrBrowser.addMouseListener(this.actionHandler);
        this.jtrBrowser.setRootVisible(false);
        this.jtrBookmark.setCellRenderer(new BookmarkTreeCellRenderer());
        this.jtrBookmark.addMouseListener(this.actionHandler);
        this.jtrBookmark.setRootVisible(false);
        this.lblScroll.setToolTipText(BasicUtilities.getString("TabEditor_Scroll_Tip"));
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnOK.addActionListener(this.actionHandler);
        this.btnOK.setActionCommand(Integer.toString(0));
        this.btnOK.setText(BasicUtilities.getString("Ok"));
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnAddRow.addActionListener(this.actionHandler);
        this.btnAddRow.setActionCommand(Integer.toString(1));
        this.btnAddRow.setToolTipText(BasicUtilities.getString("TabEditor_InsertRow_Tip"));
        this.btnPrint.addActionListener(this.actionHandler);
        this.btnPrint.setActionCommand(Integer.toString(4));
        this.btnPrint.setToolTipText(BasicUtilities.getString("Print"));
        this.btnRemRow.addActionListener(this.actionHandler);
        this.btnRemRow.setActionCommand(Integer.toString(3));
        this.btnRemRow.setToolTipText(BasicUtilities.getString("TabEditor_RemoveRow_Tip"));
        this.btnRefRow.addActionListener(this.actionHandler);
        this.btnRefRow.setActionCommand(Integer.toString(2));
        this.btnRefRow.setToolTipText(BasicUtilities.getString("TabEditor_UpdateRow_Tip"));
        this.toolbar.setOrientation(0);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.btnPrint);
        this.toolbar.addSeparator();
        this.toolbar.add(this.btnAddRow);
        this.toolbar.add(this.btnRemRow);
        this.toolbar.add(this.btnRefRow);
        this.toolbar.add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.toolbar, "North");
        jPanel.add((Component)new JScrollPane(this.tabEditor), "Center");
        jPanel.add((Component)this.configureTableStatusbar(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab("Bookmarks", BasicUtilities.loadIconResource("Bookmarks16"), new JScrollPane(this.jtrBookmark));
        jTabbedPane.addTab("JDBC", BasicUtilities.loadIconResource("Database16"), jPanel2);
        jPanel2.add((Component)this.jcbSchemas, "North");
        jPanel2.add(Box.createVerticalStrut(this.toolbar.getPreferredSize().height));
        jPanel2.add((Component)new JScrollPane(this.jtrBrowser), "Center");
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.btnOK);
        jToolBar.setFloatable(false);
        this.jcbSchemas.setActionCommand(Integer.toString(5));
        this.jcbSchemas.addActionListener(this.actionHandler);
        this.jcbSchemas.setMaximumRowCount(6);
        this.jtrBrowser.addTreeExpansionListener(this.actionHandler);
        this.tabEditor.getSelectionModel().addListSelectionListener(this.actionHandler);
        this.tabEditor.getTableHeader().setDefaultRenderer(new EditorHeaderRenderer(this.tabEditor));
        this.jspSplitter.setLeftComponent(jTabbedPane);
        this.jspSplitter.setRightComponent(jPanel);
        this.jspSplitter.setOneTouchExpandable(true);
        this.jspSplitter.setContinuousLayout(true);
        this.jspSplitter.setResizeWeight(0.75);
        JPanel jPanel3 = (JPanel)this.getContentPane();
        WizardPanel wizardPanel = new WizardPanel();
        wizardPanel.add(this.jspSplitter);
        wizardPanel.showCard(this.jspSplitter);
        jPanel3.add((Component)wizardPanel, "Center");
        jPanel3.add((Component)jToolBar, "South");
    }

    private void executeBookmark(SQLBookmark sQLBookmark) {
        if (sQLBookmark != null && !this.connection.isClosed()) {
            SQLBookmark sQLBookmark2 = (SQLBookmark)sQLBookmark.clone();
            String string = this.processSQLParameters(sQLBookmark2.getSQL());
            if (string == null) {
                return;
            }
            sQLBookmark2.setSQL(string);
            int n2 = this.preferredType;
            int n3 = 1008;
            if (sQLBookmark.hasParameters()) {
                try {
                    PreparedStatement preparedStatement = sQLBookmark2.toPreparedStatement(this.connection, n2, n3);
                    sQLBookmark.updateLastAcessTime();
                    sQLBookmark.updateUseCount();
                    this.connection.executeStatement(preparedStatement, sQLBookmark2.getSQL(), this);
                }
                catch (Throwable throwable) {
                    String string2 = BasicUtilities.getString("Bookmark_PrepStatement_Failed");
                    BasicUtilities.showExceptionPopup(this, throwable, string2);
                }
            } else {
                sQLBookmark.updateLastAcessTime();
                sQLBookmark.updateUseCount();
                this.connection.executeStaticRequest(sQLBookmark2.getSQL(), this, n2, n3);
            }
            sQLBookmark2 = null;
        } else {
            BasicUtilities.beep();
        }
    }

    private String processSQLParameters(String string) {
        String[] stringArray = StringUtilities.getSQLParameters(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            String string3 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("SQL_Param_Prompt", string2));
            if (string3 == null) {
                System.out.println(BasicUtilities.getString("Query_Cancelled"));
                hashMap.clear();
                hashMap = null;
                stringArray = null;
                return null;
            }
            hashMap.put(string2, string3);
        }
        String string4 = StringUtilities.applySQLParameters(hashMap, string);
        hashMap.clear();
        hashMap = null;
        stringArray = null;
        return string4;
    }

    private JComponent configureTableStatusbar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEtchedBorder();
        this.lblLocatr.setBorder(border);
        this.lblScroll.setBorder(border);
        this.lblCursor.setBorder(border);
        this.lblLocatr.setVerticalAlignment(0);
        this.lblScroll.setVerticalAlignment(0);
        this.lblCursor.setVerticalAlignment(0);
        this.lblScroll.setHorizontalAlignment(0);
        this.lblLocatr.setHorizontalAlignment(0);
        this.lblCursor.setHorizontalAlignment(0);
        Insets insets = new Insets(0, 0, 0, 0);
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)this.lblCursor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add((Component)this.lblScroll, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add(Box.createHorizontalStrut(2), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add((Component)this.lblLocatr, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return jPanel;
    }

    public static class 1 {
    }

    private class ActionInputHandler
    extends MouseInputAdapter
    implements ActionListener,
    IPCListener,
    ChangeListener,
    ListSelectionListener,
    TreeExpansionListener {
        private ActionInputHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public void receiveMessage(Object object, String string, Object object2) {
            if (string != null && string.equals("isql-service-change")) {
                TableEditor.this.setConnection((DatabaseConnection)object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(actionEvent.getActionCommand());
                }
                catch (Throwable throwable) {
                    TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                TableEditor.this.handleActionPreformed(n2);
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "ActionInputHandler::actionPerformed(ActionEvent)");
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (TableEditor.this.mdlBrowser == null) return;
            if (TableEditor.this.connection == null) {
                return;
            }
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                String string = (String)defaultMutableTreeNode.getUserObject();
                switch (defaultMutableTreeNode.getLevel()) {
                    case 2: {
                        String string2 = defaultMutableTreeNode.getParent().toString();
                        this.getTableData(string2, string);
                        return;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                BasicUtilities.HandleException(throwable, "TableEditor::valueChanged(TreeSelectionEvent)");
                return;
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getTableData(String string, String string2) {
            String string3 = TableEditor.this.connection.getCatalog();
            String string4 = (String)TableEditor.this.mdlSchemas.getSelectedItem();
            ResultSet resultSet = null;
            String string5 = string4 == null || string4.trim().length() == 0 ? "" : string4.concat(".");
            string5 = string5.concat(string2);
            String string6 = "SELECT * FROM ".concat(string5);
            int n2 = TableEditor.this.preferredType;
            int n3 = 1008;
            DatabaseMetaData databaseMetaData = TableEditor.this.connection.getDatabaseInformation();
            try {
                TableEditor.this.connection.executeStaticRequest(string6, TableEditor.this, n2, n3);
                resultSet = databaseMetaData.getPrimaryKeys(string3, string4, string2);
                List<Object> list = Arrays.asList(JDBCUtilities.getSingleColumn(resultSet, "COLUMN_NAME", null));
                TableEditor.this.mdlEditor.applyPrimaryKeys(list);
            }
            catch (Throwable throwable) {
                if (TableEditor.this.connection.getVerboseOn()) {
                    String string7 = "getTableData(" + string + ", " + string2 + ")";
                    BasicUtilities.HandleException(throwable, string7, TableEditor.this.connection.getDebugOn());
                }
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                if (!TableEditor.this.mdlBrowser.isUncachedNode(defaultMutableTreeNode)) return;
                switch (defaultMutableTreeNode.getLevel()) {
                    case 1: {
                        TableEditor.this.mdlBrowser.loadTableTypeNode(defaultMutableTreeNode, defaultMutableTreeNode.toString());
                        return;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                return;
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = TableEditor.this.nf.format(TableEditor.this.tabEditor.getSelectedRow() + 1);
            string = string.concat("/");
            string = string.concat(TableEditor.this.nf.format(TableEditor.this.mdlEditor.getTrueRowCount()));
            TableEditor.this.lblLocatr.setText(" ".concat(string).concat(" "));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getClickCount();
            if (n2 == 2) {
                if (TableEditor.this.mdlBrowser == null || TableEditor.this.connection == null) {
                    return;
                }
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Point point = mouseEvent.getPoint();
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath treePath = jTree.getPathForLocation(point.x, point.y);
                    if (treePath == null) {
                        BasicUtilities.beep();
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                        String string = (String)defaultMutableTreeNode.getUserObject();
                        switch (defaultMutableTreeNode.getLevel()) {
                            case 2: {
                                String string2 = defaultMutableTreeNode.getParent().toString();
                                TableEditor.this.cleanupCurrentStatement();
                                this.getTableData(string2, string);
                                break;
                            }
                        }
                    } else if (object instanceof SQLBookmark) {
                        TableEditor.this.cleanupCurrentStatement();
                        TableEditor.this.executeBookmark((SQLBookmark)object);
                    }
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable, "TableEditor::valueChanged(TreeSelectionEvent)");
                }
                finally {
                    TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        public /* synthetic */ ActionInputHandler(1 var2_2) {
            this();
        }
    }

    private class TableActionHandler
    implements ActionListener {
        private TableActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (actionEvent.getID()) {
                case 767: {
                    int n2 = Integer.parseInt(actionEvent.getActionCommand());
                    int n3 = actionEvent.getModifiers();
                    TableEditor.this.tabEditor.setValueAt(null, n3, n2);
                }
            }
        }

        public /* synthetic */ TableActionHandler(1 var2_2) {
            this();
        }
    }

    private class EditorHeaderRenderer
    extends SortableHeaderRenderer {
        public EditorHeaderRenderer(JTable jTable) {
            super(jTable);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (TableEditor.this.mdlEditor.isPrimaryKey((String)object)) {
                this.setIcon(BasicUtilities.loadIconResource("Key16"));
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

