/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.util.BasicUtilities;

public class JFontChoser
extends JComponent {
    private Font[] fnts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private Integer[] Sizes = new Integer[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36)};
    private JTextField txtExampleArea = new JTextField("abcdefghijk ABCDEFGHIJK");
    private DefaultListModel fontNames = new DefaultListModel();
    private DefaultListModel fontStyles = new DefaultListModel();
    private DefaultListModel fontSizes = new DefaultListModel();
    private int styleFontOffset = -1;
    private JDialog dialog = null;
    private ListSelectionHandler listSelectionHandler = new ListSelectionHandler(null);
    private JList lstFontNames = new JList(this.fontNames);
    private JList lstFontSizes = new JList(this.fontSizes);
    private JList lstFontStyle = new JList(this.fontStyles);
    private JButton btnOK = new JButton("OK");
    private JButton btnCancel = new JButton("Cancel");
    private JLabel lblPreview = new JLabel("Preview :");
    private boolean wasCancelled = true;
    private Font originalSelection = null;
    static /* synthetic */ Class class$java$awt$Frame;

    public JFontChoser() {
        this.initUI();
        this.setSelectedFont(null);
    }

    public Font getSelectedFont() {
        String string = (String)this.lstFontNames.getSelectedValue();
        Integer n2 = (Integer)this.lstFontSizes.getSelectedValue();
        if (this.styleFontOffset != -1) {
            return this.fnts[this.styleFontOffset + this.lstFontStyle.getSelectedIndex()].deriveFont(n2.floatValue());
        }
        return new Font(string, 0, n2);
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            font = new Font("Default", 0, 12);
        }
        this.originalSelection = font;
        int n2 = this.fontNames.indexOf(font.getFamily());
        if (n2 < 0) {
            n2 = 0;
        }
        String string = null;
        try {
            string = font.getName().substring(font.getFamily().length());
            if (string.length() == 0) {
                string = "Plain";
            }
        }
        catch (Exception exception) {
            string = "Plain";
        }
        try {
            this.lstFontNames.setSelectedIndex(n2);
            this.lstFontNames.ensureIndexIsVisible(n2);
            string = string.trim();
            n2 = this.fontStyles.indexOf(string);
            if (n2 < 0) {
                n2 = 0;
            }
            this.lstFontStyle.setSelectedIndex(n2);
            this.lstFontNames.ensureIndexIsVisible(n2);
            Integer n3 = new Integer(font.getSize());
            n2 = this.fontSizes.indexOf(n3);
            if (n2 < 0) {
                n2 = 0;
            }
            this.lstFontSizes.setSelectedIndex(n2);
            this.lstFontNames.ensureIndexIsVisible(n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Font showDialog(Component component, String string, Font font) {
        Frame frame;
        this.setSelectedFont(font);
        if (component instanceof Frame) {
            frame = (Frame)component;
        } else {
            Class<?> clazz = class$java$awt$Frame;
            if (clazz == null) {
                clazz = class$java$awt$Frame = new Frame[0].getClass().getComponentType();
            }
            frame = (Frame)SwingUtilities.getAncestorOfClass(clazz, component);
        }
        Frame frame2 = frame;
        this.dialog = new JDialog(frame2, string, true);
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(component);
        this.dialog.show();
        if (this.wasCancelled) {
            return this.originalSelection;
        }
        return this.getSelectedFont();
    }

    private void initUI() {
        int n2;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.fontNames.addElement(stringArray[n2]);
        }
        for (n2 = 0; n2 < this.Sizes.length; ++n2) {
            this.fontSizes.addElement(this.Sizes[n2]);
        }
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        this.lstFontNames.addListSelectionListener(this.listSelectionHandler);
        this.lstFontStyle.addListSelectionListener(this.listSelectionHandler);
        this.lstFontSizes.addListSelectionListener(this.listSelectionHandler);
        this.btnOK.addActionListener(this.listSelectionHandler);
        this.btnCancel.addActionListener(this.listSelectionHandler);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.lstFontNames);
        this.lstFontNames.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXX");
        this.add((Component)new JLabel("Font Name :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.75, 17, 1, insets, 0, 0));
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.lstFontStyle);
        this.lstFontStyle.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXXXXXXX");
        this.add((Component)new JLabel("Font Styles :"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.75, 17, 1, insets, 0, 0));
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.lstFontSizes);
        this.lstFontSizes.setPrototypeCellValue("XX");
        this.add((Component)new JLabel("Font Size :"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.75, 17, 1, insets, 0, 0));
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.txtExampleArea);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 64));
        BasicUtilities.lockComponentToPerferredSize(jScrollPane);
        this.add((Component)this.lblPreview, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.25, 17, 2, insets, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.btnOK);
        jPanel.add(this.btnCancel);
        this.add((Component)jPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 13, 2, insets, 0, 0));
    }

    private void loadStyles(String string) {
        this.fontStyles.clear();
        for (int i2 = 0; i2 < this.fnts.length; ++i2) {
            if (!this.fnts[i2].getFamily().equals(string)) continue;
            if (this.fontStyles.isEmpty()) {
                this.styleFontOffset = i2;
            }
            this.fontStyles.addElement(this.fnts[i2].getName());
        }
        if (this.fontStyles.isEmpty()) {
            this.fontStyles.addElement("Plain");
            this.styleFontOffset = -1;
        }
    }

    public static class 1 {
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    ActionListener {
        private ListSelectionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JFontChoser.this.btnOK) {
                JFontChoser.this.wasCancelled = false;
            }
            if (JFontChoser.this.dialog != null) {
                JFontChoser.this.dialog.dispose();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            Object object = listSelectionEvent.getSource();
            Font font = JFontChoser.this.txtExampleArea.getFont();
            String string = (String)JFontChoser.this.lstFontNames.getSelectedValue();
            Integer n2 = (Integer)JFontChoser.this.lstFontSizes.getSelectedValue();
            if (n2 == null) {
                n2 = (Integer)JFontChoser.this.fontSizes.get(0);
            }
            if (object == JFontChoser.this.lstFontNames) {
                JFontChoser.this.loadStyles(string);
            } else if (object == JFontChoser.this.lstFontStyle) {
                if (JFontChoser.this.styleFontOffset != -1) {
                    font = JFontChoser.this.fnts[JFontChoser.this.styleFontOffset + JFontChoser.this.lstFontStyle.getSelectedIndex()];
                    font = font.deriveFont(n2.floatValue());
                } else {
                    font = new Font(string, 0, n2);
                }
            } else if (object == JFontChoser.this.lstFontSizes) {
                font = font.deriveFont(n2.floatValue());
            }
            JFontChoser.this.txtExampleArea.setFont(font);
            JFontChoser.this.lblPreview.setText("Preview : " + font.getFontName());
        }

        public /* synthetic */ ListSelectionHandler(1 var2_2) {
            this();
        }
    }
}

