/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class JFileList
extends JPanel
implements ActionListener,
DropTargetListener {
    private DefaultListModel mdlPaths = new DefaultListModel();
    private JList lstPaths = new JList();
    private JScrollPane jspPaths = new JScrollPane(this.lstPaths);
    private JButton btnAddPath = new JButton(BasicUtilities.loadIconResource("Add16"));
    private JButton btnRemovePath = new JButton(BasicUtilities.loadIconResource("Delete16"));
    private Vector filters = new Vector();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private JToolBar jtbPathTools = new JToolBar(1);
    public boolean isPathModified = false;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JFileList() {
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            BasicUtilities.HandleException(throwable, "ServiceResourceEditor::initUI()");
        }
    }

    public void setResources(URL[] uRLArray) {
        this.mdlPaths.clear();
        this.isPathModified = false;
        if (uRLArray == null) {
            return;
        }
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            this.addURL(uRLArray[i2], false);
        }
        if (this.isPathModified) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    public URL[] getResources() {
        if (!this.mdlPaths.isEmpty()) {
            URL[] uRLArray = new URL[this.mdlPaths.size()];
            for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                try {
                    uRLArray[i2] = ((File)this.mdlPaths.get(i2)).toURL();
                    continue;
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
            }
            return uRLArray;
        }
        return new URL[0];
    }

    public File[] getFiles() {
        if (!this.mdlPaths.isEmpty()) {
            File[] fileArray = new File[this.mdlPaths.size()];
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                fileArray[i2] = (File)this.mdlPaths.get(i2);
            }
            return fileArray;
        }
        return new File[0];
    }

    public void setPathString(String string) {
        this.mdlPaths.clear();
        this.isPathModified = false;
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            this.addFile(file, false);
        }
        if (this.isPathModified) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class<?> clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = new ChangeListener[0].getClass().getComponentType();
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class<?> clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = new ChangeListener[0].getClass().getComponentType();
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public String toPathString() {
        File[] fileArray = this.getFiles();
        StringBuffer stringBuffer = new StringBuffer("");
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                stringBuffer.append(fileArray[i2].getAbsolutePath());
                stringBuffer.append(File.pathSeparator);
            }
        }
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl2 = false;
        if (object.equals(this.btnAddPath)) {
            File[] fileArray = BasicUtilities.getSystemFiles(this, 2);
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    File file = fileArray[i2];
                    if (!this.checkFile(file)) continue;
                    try {
                        this.addFile(file, false);
                        bl2 = true;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        } else if (object.equals(this.btnRemovePath)) {
            int[] nArray = this.lstPaths.getSelectedIndices();
            try {
                for (int i3 = nArray.length - 1; i3 >= 0; --i3) {
                    int n2 = nArray[i3];
                    this.mdlPaths.removeElementAt(n2);
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (!(object instanceof List)) {
                    BasicUtilities.beep();
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                List list = (List)object;
                Iterator iterator = list.iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 instanceof File) {
                        File file = (File)e2;
                        try {
                            if (!this.checkFile(file)) continue;
                            this.addFile(file, false);
                            bl2 = true;
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    BasicUtilities.beep();
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                dropTargetDropEvent.dropComplete(true);
                if (bl2) {
                    this.fireStateChanged(this.changeEvent);
                }
            }
            catch (Throwable throwable) {
                BasicUtilities.beep();
                dropTargetDropEvent.rejectDrop();
                BasicUtilities.HandleException(throwable);
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public boolean addFileFilter(FilenameFilter filenameFilter) {
        if (this.filters.add(filenameFilter)) {
            this.fireStateChanged(this.changeEvent);
            return true;
        }
        return false;
    }

    public void addFile(File file) {
        this.addFile(file, true);
    }

    public void addURL(URL uRL) {
        this.addURL(uRL, true);
    }

    public void setPath(String string) {
        this.mdlPaths.clear();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
        while (stringTokenizer.hasMoreTokens()) {
            this.addFile(new File(stringTokenizer.nextToken()));
        }
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void removeFilter(int n2) {
        try {
            this.filters.remove(n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean removeFilter(FilenameFilter filenameFilter) {
        return this.filters.remove(filenameFilter);
    }

    public void fireStateChanged(ChangeEvent changeEvent) {
        Class<?> clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = new ChangeListener[0].getClass().getComponentType();
        }
        EventListener[] eventListenerArray = this.listenerList.getListeners(clazz);
        for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
            try {
                ((ChangeListener)eventListenerArray[i2]).stateChanged(changeEvent);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean checkFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            FilenameFilter filenameFilter = (FilenameFilter)iterator.next();
            if (filenameFilter.accept(file.getParentFile(), file.getName())) continue;
            return false;
        }
        return true;
    }

    public void addURL(URL uRL, boolean bl2) {
        try {
            this.addFile(new File(uRL.getFile()), bl2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addFile(File file, boolean bl2) {
        if (this.checkFile(file)) {
            try {
                this.mdlPaths.addElement(file);
                this.isPathModified = true;
                if (bl2) {
                    this.fireStateChanged(this.changeEvent);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout(2, 2));
        this.mdlPaths = new DefaultListModel();
        this.lstPaths.setModel(this.mdlPaths);
        this.btnAddPath.addActionListener(this);
        this.btnRemovePath.addActionListener(this);
        this.jtbPathTools.setFloatable(false);
        this.jtbPathTools.add(this.btnAddPath);
        this.jtbPathTools.add(this.btnRemovePath);
        this.jspPaths.setRowHeaderView(this.jtbPathTools);
        this.btnAddPath.setToolTipText(BasicUtilities.getString("Path_Add_Tip"));
        this.btnRemovePath.setToolTipText(BasicUtilities.getString("Path_Del_Tip"));
        this.lstPaths.setToolTipText(BasicUtilities.getString("Path_List_Tip"));
        this.lstPaths.setSelectionMode(2);
        this.lstPaths.setDropTarget(new DropTarget(this.lstPaths, this));
        this.add((Component)this.jspPaths, "Center");
    }

    public void setToolTipText(String string) {
        this.lstPaths.setToolTipText(string);
    }

    public static class DirectoryFileFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            if (file == null || string == null) {
                return false;
            }
            string = string.toLowerCase();
            boolean bl2 = new File(file, string).isDirectory();
            return file.canRead() && bl2;
        }
    }

    public static class ClasspathFileFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            if (file == null || string == null) {
                return false;
            }
            string = string.toLowerCase();
            boolean bl2 = new File(file, string).isDirectory();
            return file.canRead() && (bl2 || string.endsWith(".jar") || string.endsWith(".zip"));
        }
    }
}

