/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BookmarkTreeModel
implements TreeModel {
    public static final String ROOT_PATH = "/";
    public static final char SEPERATOR = '/';
    private StringBuffer tabBuffer = new StringBuffer("");
    private Hashtable pathMap = new Hashtable();
    private transient Vector treeModelListeners;
    private boolean isModified = false;
    private final Charset UTF = Charset.forName("UTF8");

    public BookmarkTreeModel() {
        this(new SQLBookmark[0]);
    }

    public BookmarkTreeModel(SQLBookmark[] sQLBookmarkArray) {
        this.pathMap.put(ROOT_PATH, new Vector());
        for (int i2 = 0; i2 < sQLBookmarkArray.length; ++i2) {
            this.addBookmark(sQLBookmarkArray[i2], false);
        }
    }

    public static TreePath getTreePath(String string) {
        StringBuffer stringBuffer = new StringBuffer(ROOT_PATH);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ROOT_PATH, false, false);
        TreePath treePath = new TreePath(ROOT_PATH);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(ROOT_PATH) || string2.trim().length() == 0) continue;
            stringBuffer.append(string2);
            stringBuffer.append('/');
            treePath = treePath.pathByAddingChild(stringBuffer.toString());
        }
        return treePath;
    }

    public Object getRoot() {
        return ROOT_PATH;
    }

    public Object getChild(Object object, int n2) {
        if (object instanceof String) {
            Vector vector = (Vector)this.pathMap.get(object);
            return vector.get(n2);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof String) {
            Vector vector = (Vector)this.pathMap.get(object);
            return vector == null ? 0 : vector.size();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        return object instanceof SQLBookmark;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof String) {
            String string = object.toString();
            String string2 = (String)object2;
            String string3 = BookmarkTreeModel.getParentPathElement(string2).concat(string).concat(ROOT_PATH);
            this.movePath(string2, string3);
            return;
        }
        if (object2 instanceof SQLBookmark) {
            String string = object.toString();
            SQLBookmark sQLBookmark = (SQLBookmark)object2;
            if (!sQLBookmark.getName().equals(string)) {
                sQLBookmark.setName(string);
                this.setModified();
                this.fireTreeNodesChanged(new TreeModelEvent((Object)this, sQLBookmark.toTreePath()));
            }
        }
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof String) {
            Vector vector = (Vector)this.pathMap.get(object);
            return vector.indexOf(object2);
        }
        return -1;
    }

    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(treeModelListener)) {
            Vector vector = (Vector)this.treeModelListeners.clone();
            vector.removeElement(treeModelListener);
            this.treeModelListeners = vector;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        Vector vector;
        Vector vector2 = vector = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!vector.contains(treeModelListener)) {
            vector.addElement(treeModelListener);
            this.treeModelListeners = vector;
        }
    }

    public boolean isPath(String string) {
        return this.pathMap.containsKey(string);
    }

    public boolean isEmpty() {
        return this.getChildCount(ROOT_PATH) == 0;
    }

    public boolean isModified() {
        return this.isModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setModified() {
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.isModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(XMLReader xMLReader, InputStream inputStream) throws IOException, SAXException {
        xMLReader.setContentHandler(new Parser(this));
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.pathMap.clear();
            this.pathMap.put(ROOT_PATH, new Vector());
            this.isModified = false;
            xMLReader.parse(new InputSource(inputStream));
            xMLReader = null;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.UTF);
        PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, false);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.UTF.name() + "\" standalone='yes' ?>");
        printWriter.println("<isql-bookmarks>");
        String string = this.createTabdepth(1);
        Vector vector = (Vector)this.pathMap.get(ROOT_PATH);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object e2 = vector.get(i2);
            if (e2 instanceof SQLBookmark) {
                printWriter.print(string);
                SQLBookmark sQLBookmark = (SQLBookmark)e2;
                printWriter.write(this.formatBookmark(sQLBookmark, string));
                continue;
            }
            if (!(e2 instanceof String)) continue;
            this.persistFolder(printWriter, (String)e2, 1);
        }
        printWriter.println("</isql-bookmarks>");
        printWriter.flush();
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.isModified = false;
        }
    }

    public void createFolder(String string, String string2) {
        this.addFolder(string, string2, true);
    }

    public void deleteFolder(String string, String string2) {
        this.deleteFolder(string, string2, true);
    }

    public void deleteBookmark(SQLBookmark sQLBookmark) {
        this.deleteBookmark(sQLBookmark, true);
    }

    public void addBookmark(SQLBookmark sQLBookmark) {
        this.addBookmark(sQLBookmark, true);
    }

    public void refresh() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT_PATH}, null, null));
    }

    public void refresh(SQLBookmark sQLBookmark) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, sQLBookmark.toTreePath(), null, null));
    }

    public void moveBookmark(SQLBookmark sQLBookmark, String string) {
        this.moveBookmark(sQLBookmark, string.trim(), true);
    }

    public void movePath(String string, String string2) {
        this.managePath(string.trim(), string2.trim(), true, false);
    }

    public void copyPath(String string, String string2) {
        this.managePath(string.trim(), string2.trim(), true, true);
    }

    public void copyBookmark(SQLBookmark sQLBookmark, String string) {
        this.copyBookmark(sQLBookmark, string, true);
    }

    public void addFolder(String string, String string2, boolean bl2) {
        String string3 = null;
        string3 = string2.charAt(0) == '/' ? string.concat(string2.substring(1).concat(ROOT_PATH)) : string.concat(string2.concat(ROOT_PATH));
        this.ensurePath(string3);
        Vector vector = (Vector)this.pathMap.get(string);
        int n2 = Math.max(0, vector.indexOf(string3));
        if (bl2) {
            this.setModified();
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string), new int[]{n2}, null));
        }
    }

    public void addBookmark(SQLBookmark sQLBookmark, boolean bl2) {
        String string = sQLBookmark.getPath();
        this.ensurePath(string);
        Vector vector = (Vector)this.pathMap.get(string);
        String string2 = sQLBookmark.getName();
        int n2 = 0;
        while (vector.contains(sQLBookmark)) {
            sQLBookmark.setName(string2.concat(Integer.toString(n2)));
            ++n2;
        }
        if (vector.add(sQLBookmark) && bl2) {
            int[] nArray = new int[]{vector.indexOf(sQLBookmark)};
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string), nArray, null));
        }
    }

    public void deleteFolder(String string, String string2, boolean bl2) {
        Vector vector;
        int n2;
        String string3 = null;
        String string4 = null;
        if (string.endsWith(ROOT_PATH)) {
            string4 = new String(string);
            string3 = string4.concat(string2).concat(ROOT_PATH);
        } else {
            string4 = string.concat(ROOT_PATH);
            string3 = string4.concat(string2).concat(ROOT_PATH);
        }
        if (this.pathMap.containsKey(string4) && (n2 = (vector = (Vector)this.pathMap.get(string4)).indexOf(string3)) >= 0) {
            vector.remove(n2);
            if (bl2) {
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string4), new int[]{n2}, null));
            }
        }
        if (this.pathMap.containsKey(string3)) {
            vector = (Vector)this.pathMap.remove(string3);
            vector.clear();
            vector = null;
            if (bl2) {
                this.setModified();
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string3)));
            }
        }
    }

    public SQLBookmark deleteBookmark(SQLBookmark sQLBookmark, boolean bl2) {
        Vector vector;
        int n2;
        String string = sQLBookmark.getPath();
        if (this.pathMap.containsKey(string) && (n2 = (vector = (Vector)this.pathMap.get(string)).indexOf(sQLBookmark)) >= 0) {
            SQLBookmark sQLBookmark2 = (SQLBookmark)vector.remove(n2);
            this.setModified();
            if (bl2) {
                int[] nArray = new int[]{n2};
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string), nArray, null));
            }
            return sQLBookmark2;
        }
        throw new IllegalArgumentException(string);
    }

    public void moveBookmark(SQLBookmark sQLBookmark, String string, boolean bl2) {
        sQLBookmark = this.deleteBookmark(sQLBookmark, bl2);
        sQLBookmark.setPath(string);
        this.addBookmark(sQLBookmark, bl2);
    }

    public void copyBookmark(SQLBookmark sQLBookmark, String string, boolean bl2) {
        this.ensurePath(string);
        Vector vector = (Vector)this.pathMap.get(string);
        SQLBookmark sQLBookmark2 = (SQLBookmark)sQLBookmark.clone();
        sQLBookmark2.setPath(string);
        String string2 = sQLBookmark2.getName();
        int n2 = 0;
        while (vector.contains(sQLBookmark2)) {
            sQLBookmark2.setName(string2.concat(Integer.toString(n2)));
            ++n2;
        }
        if (vector.add(sQLBookmark2) && bl2) {
            int[] nArray = new int[]{vector.indexOf(sQLBookmark2)};
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string), nArray, null));
        }
    }

    public void managePath(String string, String string2, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        String string3 = BookmarkTreeModel.getLastPathElement(string);
        String string4 = BookmarkTreeModel.getParentPathElement(string);
        if (bl3) {
            string2 = string2.concat(string3).concat(Character.toString('/'));
        }
        if (string.equalsIgnoreCase(string2) || string.equalsIgnoreCase(ROOT_PATH)) {
            throw new IllegalArgumentException(string);
        }
        Vector vector = null;
        if (bl3) {
            vector = (Vector)this.pathMap.get(string);
        } else {
            object2 = (Vector)this.pathMap.get(string4);
            if (object2 != null) {
                int n2 = ((Vector)object2).indexOf(string);
                ((Vector)object2).set(n2, string2);
                if (bl2) {
                    object = new int[]{n2};
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string4), (int[])object, null));
                }
            }
            vector = (Vector)this.pathMap.remove(string);
            this.pathMap.put(string2, vector);
        }
        this.ensurePath(string2);
        object2 = vector.iterator();
        while (object2.hasNext()) {
            Object e2 = object2.next();
            if (e2 instanceof SQLBookmark) {
                object = (SQLBookmark)e2;
                if (bl3) {
                    this.copyBookmark((SQLBookmark)object, string2, false);
                    continue;
                }
                ((SQLBookmark)object).setPath(string2);
                continue;
            }
            object = BookmarkTreeModel.getLastPathElement((String)e2);
            String string5 = string.concat((String)object).concat(ROOT_PATH);
            if (bl3) {
                this.managePath(string5, string2, false, bl3);
                continue;
            }
            String string6 = string2.concat((String)object).concat(ROOT_PATH);
            this.managePath(string5, string6, false, bl3);
        }
        if (bl2) {
            if (!bl3) {
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string)));
            }
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(string2)));
        }
        this.setModified();
    }

    public void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                try {
                    treeModelListener.treeNodesChanged(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                try {
                    treeModelListener.treeNodesInserted(treeModelEvent);
                }
                catch (Throwable throwable) {
                    BasicUtilities.HandleException(throwable);
                }
            }
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                try {
                    treeModelListener.treeNodesRemoved(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                try {
                    treeModelListener.treeStructureChanged(treeModelEvent);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void ensurePath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ROOT_PATH, false, true);
        StringBuffer stringBuffer = new StringBuffer(ROOT_PATH);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringBuffer.toString();
            stringBuffer.append(string2);
            stringBuffer.append('/');
            if (this.pathMap.get(stringBuffer.toString()) != null) continue;
            this.pathMap.put(stringBuffer.toString(), new Vector());
            Vector vector = (Vector)this.pathMap.get(string3);
            try {
                vector.add(0, stringBuffer.toString());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                vector.add(stringBuffer.toString());
            }
        }
    }

    private String formatBookmark(SQLBookmark sQLBookmark, String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(Parser.TAG_BOOKMARK);
        stringBuffer.append(" ");
        stringBuffer.append(Parser.ATTR_NAME);
        stringBuffer.append("=\"");
        stringBuffer.append(StringUtilities.encodeXMLEntities(sQLBookmark.getName()));
        stringBuffer.append("\" ");
        stringBuffer.append(Parser.ATTR_BM_COUNT);
        stringBuffer.append("=\"");
        stringBuffer.append(Long.toString(sQLBookmark.getUseCount()));
        stringBuffer.append("\" ");
        stringBuffer.append(Parser.ATTR_BM_LAST);
        stringBuffer.append("=\"");
        stringBuffer.append(Long.toString(sQLBookmark.getLastAccessTime().getTime()));
        stringBuffer.append("\" ");
        stringBuffer.append(Parser.ATTR_BM_EPOCH);
        stringBuffer.append("=\"");
        stringBuffer.append(Long.toString(sQLBookmark.getCreationDate().getTime()));
        stringBuffer.append("\">");
        stringBuffer.append(System.getProperty("line.seperator", "\n"));
        if (sQLBookmark.hasParameters()) {
            object = sQLBookmark.parameterIterator();
            while (object.hasNext()) {
                SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)object.next();
                stringBuffer.append(string);
                stringBuffer.append("\t<");
                stringBuffer.append(Parser.TAG_PARAMETER);
                stringBuffer.append(" ");
                stringBuffer.append(Parser.ATTR_PARAM_TYPE);
                stringBuffer.append("=\"");
                stringBuffer.append(Integer.toString(parameter.getSQLType()));
                stringBuffer.append("\" ");
                stringBuffer.append(Parser.ATTR_PARAM_VALUE);
                stringBuffer.append("=\"");
                stringBuffer.append(StringUtilities.encodeXMLEntities(parameter.getValue()));
                stringBuffer.append("\" ");
                stringBuffer.append(Parser.ATTR_PARAM_OPTIONS);
                stringBuffer.append("=\"");
                stringBuffer.append(StringUtilities.encodeXMLEntities(parameter.getOptions()));
                stringBuffer.append("\"/>");
                stringBuffer.append(System.getProperty("line.seperator", "\n"));
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        object = new Base64Encoder(sQLBookmark.getSQL().trim());
        stringBuffer.append(StringUtilities.formatBreak(80, ((Base64Encoder)object).processString(), string.concat(" "), false));
        stringBuffer.append(System.getProperty("line.seperator", "\n"));
        stringBuffer.append(string);
        stringBuffer.append("</");
        stringBuffer.append(Parser.TAG_BOOKMARK);
        stringBuffer.append(">");
        stringBuffer.append(System.getProperty("line.seperator", "\n"));
        return stringBuffer.toString();
    }

    private void persistFolder(PrintWriter printWriter, String string, int n2) throws IOException {
        Vector vector = (Vector)this.pathMap.get(string);
        if (vector == null) {
            return;
        }
        String string2 = this.createTabdepth(n2);
        printWriter.print(string2);
        String string3 = BookmarkTreeModel.getLastPathElement(string);
        string3 = StringUtilities.encodeXMLEntities(string3);
        printWriter.print("<");
        printWriter.print(Parser.TAG_FOLDER);
        printWriter.print(" ");
        printWriter.print(Parser.ATTR_NAME);
        printWriter.print("=\"");
        printWriter.print(StringUtilities.encodeXMLEntities(string3));
        printWriter.println("\" >");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object e2 = vector.get(i2);
            if (e2 instanceof SQLBookmark) {
                printWriter.print(string2);
                SQLBookmark sQLBookmark = (SQLBookmark)e2;
                printWriter.write(this.formatBookmark(sQLBookmark, string2));
                continue;
            }
            if (!(e2 instanceof String)) continue;
            this.persistFolder(printWriter, (String)e2, n2 + 1);
        }
        printWriter.print(string2);
        printWriter.print("</");
        printWriter.print(Parser.TAG_FOLDER);
        printWriter.println(">");
    }

    private String createTabdepth(int n2) {
        this.tabBuffer.setLength(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tabBuffer.append('\t');
        }
        String string = this.tabBuffer.toString();
        this.tabBuffer.setLength(0);
        return string;
    }

    private static String getLastPathElement(String string) {
        return string.substring(string.lastIndexOf(47, string.length() - 2) + 1, string.length() - 1);
    }

    private static String getParentPathElement(String string) {
        String string2 = BookmarkTreeModel.getLastPathElement(string);
        return string.substring(0, string.lastIndexOf(string2));
    }

    private static class Parser
    extends DefaultHandler {
        private static String TAG_BOOKMARK = "bookmark";
        private static String TAG_PARAMETER = "parameter";
        private static String TAG_FOLDER = "folder";
        private static String ATTR_NAME = "name";
        private static String ATTR_BM_EPOCH = "created";
        private static String ATTR_BM_LAST = "last";
        private static String ATTR_BM_COUNT = "count";
        private static String ATTR_BM_EPOCH_OLD = "epoch";
        private static String ATTR_BM_LAST_OLD = "last_query";
        private static String ATTR_BM_COUNT_OLD = "use_count";
        private static String ATTR_PARAM_TYPE = "type";
        private static String ATTR_PARAM_VALUE = "value";
        private static String ATTR_PARAM_OPTIONS = "options";
        private StringBuffer pathBuffer = new StringBuffer("/");
        private BookmarkTreeModel model = null;
        private SQLBookmark currentBookmark = null;

        public Parser(BookmarkTreeModel bookmarkTreeModel) {
            this.model = bookmarkTreeModel;
        }

        public void characters(char[] cArray, int n2, int n3) {
            String string = new String(cArray, n2, n3).trim();
            if (this.currentBookmark != null && string.length() >= 1) {
                String string2 = this.currentBookmark.getSQL();
                this.currentBookmark.setSQL(string2.concat(string));
            }
            string = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = string3.toLowerCase().trim();
            if (string4.equals(TAG_FOLDER) && this.currentBookmark == null) {
                String string5 = this.pathBuffer.toString();
                String string6 = attributes.getValue(ATTR_NAME).trim();
                this.pathBuffer.append(string6);
                if (this.pathBuffer.charAt(this.pathBuffer.length() - 1) != '/') {
                    this.pathBuffer.append('/');
                }
                this.model.addFolder(string5, string6, false);
            } else if (string4.equals(TAG_PARAMETER) && this.currentBookmark != null) {
                SQLBookmark.Parameter parameter = new SQLBookmark.Parameter();
                parameter.setOptions(attributes.getValue(ATTR_PARAM_OPTIONS).trim());
                parameter.setValue(attributes.getValue(ATTR_PARAM_VALUE).trim());
                try {
                    String string7 = attributes.getValue(ATTR_PARAM_TYPE);
                    parameter.setSQLType(Integer.parseInt(string7.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
                this.currentBookmark.addParameter(parameter);
            } else if (string4.equals(TAG_BOOKMARK) && this.currentBookmark == null) {
                int n2;
                String string8 = "";
                long l2 = System.currentTimeMillis();
                long l3 = 0L;
                long l4 = 0L;
                try {
                    n2 = attributes.getIndex(ATTR_NAME);
                    if (n2 >= 0) {
                        string8 = attributes.getValue(n2);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    n2 = attributes.getIndex(ATTR_BM_EPOCH_OLD);
                    if (n2 >= 0) {
                        l2 = Long.parseLong(attributes.getValue(n2));
                    } else {
                        n2 = attributes.getIndex(ATTR_BM_EPOCH);
                        l2 = Long.parseLong(attributes.getValue(n2));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    int n3 = attributes.getIndex(ATTR_BM_COUNT_OLD);
                    if (n3 >= 0) {
                        l4 = Long.parseLong(attributes.getValue(n3));
                    } else {
                        n3 = attributes.getIndex(ATTR_BM_COUNT);
                        l4 = Long.parseLong(attributes.getValue(n3));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    int n4 = attributes.getIndex(ATTR_BM_LAST_OLD);
                    if (n4 >= 0) {
                        l3 = Long.parseLong(attributes.getValue(n4));
                    } else {
                        n4 = attributes.getIndex(ATTR_BM_LAST);
                        l3 = Long.parseLong(attributes.getValue(n4));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.currentBookmark = new SQLBookmark(new Date(l2), string8, "");
                this.currentBookmark.setPath(this.pathBuffer.toString());
                this.currentBookmark.setLastAccessTime(l3);
                this.currentBookmark.setUseCount(l4);
            }
        }

        public void endElement(String string, String string2, String string3) {
            String string4 = string3.toLowerCase().trim();
            if (string4.equals(TAG_FOLDER)) {
                String string5 = this.pathBuffer.toString();
                int n2 = string5.lastIndexOf(47);
                try {
                    n2 = string5.lastIndexOf(47, n2 - 1);
                    this.pathBuffer = this.pathBuffer.delete(n2 + 1, this.pathBuffer.length());
                }
                catch (Exception exception) {}
            } else if (string4.equals(TAG_BOOKMARK)) {
                Base64Decoder base64Decoder = new Base64Decoder(this.currentBookmark.getSQL());
                try {
                    String string6 = base64Decoder.processString();
                    this.currentBookmark.setSQL(string6);
                    this.model.addBookmark(this.currentBookmark, false);
                }
                catch (Base64FormatException base64FormatException) {
                    // empty catch block
                }
                this.currentBookmark = null;
            }
        }
    }
}

