/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class SQLBookmark
implements Transferable,
Cloneable,
Comparable {
    private Vector params = new Vector();
    private String path = null;
    private String sql = null;
    private String name = null;
    private long lastUsedTime = 0L;
    private long creationTime = 0L;
    private long useCount = 0L;
    private boolean favorite = false;

    public SQLBookmark(String string, String string2) {
        this(null, string, string2);
    }

    public SQLBookmark(String string) {
        this(null, string, "");
    }

    public SQLBookmark(Date date, String string) {
        this(date, string, "");
    }

    public SQLBookmark(Date date, String string, String string2) {
        this.creationTime = date == null ? System.currentTimeMillis() : date.getTime();
        this.setName(string);
        this.setSQL(string2);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{BasicUtilities.bookmarkFlavour, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return BasicUtilities.bookmarkFlavour.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (BasicUtilities.bookmarkFlavour.equals(dataFlavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getSQL();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public int compareTo(Object object) {
        if (object instanceof SQLBookmark) {
            SQLBookmark sQLBookmark = (SQLBookmark)object;
            String string = sQLBookmark.getPath().concat(sQLBookmark.getName());
            String string2 = this.getPath().concat(this.getName());
            return string2.compareToIgnoreCase(string);
        }
        return -1;
    }

    public Object clone() {
        SQLBookmark sQLBookmark = new SQLBookmark(this.getName());
        sQLBookmark.setLastAccessTime(this.lastUsedTime);
        sQLBookmark.setPath(this.path);
        sQLBookmark.setSQL(this.sql);
        Iterator iterator = this.parameterIterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            sQLBookmark.addParameter((Parameter)parameter.clone());
        }
        return sQLBookmark;
    }

    public boolean equals(Object object) {
        if (object instanceof SQLBookmark) {
            SQLBookmark sQLBookmark = (SQLBookmark)object;
            return this.compareTo(sQLBookmark) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SQLBookmark[count=\"");
        stringBuffer.append(Long.toString(this.useCount));
        stringBuffer.append("\" ");
        stringBuffer.append("last=\"");
        stringBuffer.append(Long.toString(this.lastUsedTime));
        stringBuffer.append("\" created=\"");
        stringBuffer.append(Long.toString(this.creationTime));
        stringBuffer.append("\" name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" favorite=\"");
        stringBuffer.append(Boolean.toString(this.favorite));
        stringBuffer.append("\" paramcount=\"");
        stringBuffer.append(Integer.toString(this.parameterCount()));
        stringBuffer.append("\" sql=\"");
        stringBuffer.append(this.sql);
        stringBuffer.append("\" ]");
        return stringBuffer.toString();
    }

    public String getSQL() {
        return this.sql;
    }

    public String getPath() {
        return this.path == null ? "/" : this.path;
    }

    public String getName() {
        return this.name;
    }

    public TreePath toTreePath() {
        return BookmarkTreeModel.getTreePath(this.getPath()).pathByAddingChild(this);
    }

    public void updateLastAcessTime() {
        this.lastUsedTime = System.currentTimeMillis();
    }

    public void updateUseCount() {
        ++this.useCount;
    }

    public Date getLastAccessTime() {
        return new Date(this.lastUsedTime);
    }

    public Date getCreationDate() {
        return new Date(this.creationTime);
    }

    public long getUseCount() {
        return this.useCount < 0L ? 0L : this.useCount;
    }

    public void setSQL(String string) {
        this.sql = string == null ? "" : "".concat(string);
    }

    public void setPath(String string) {
        this.path = string == null ? "/" : "".concat(string);
    }

    public void setName(String string) {
        if (string == null || string.trim().length() < 1) {
            throw new IllegalArgumentException(BasicUtilities.getString("Illegal_Bookmark_Name"));
        }
        this.name = new String(string);
    }

    public void setLastAccessTime(long l2) {
        this.lastUsedTime = l2;
    }

    public void setUseCount(long l2) {
        this.useCount = Math.max(0L, l2);
    }

    public boolean addParameter(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.add(parameter);
    }

    public boolean addAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof Parameter)) continue;
            bl2 = true;
            this.params.add(e2);
        }
        return bl2;
    }

    public void clearParameters() {
        this.params.clear();
    }

    public boolean contains(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.contains(parameter);
    }

    public Parameter getParameter(int n2) {
        if (n2 < 0 || n2 >= this.params.size()) {
            return null;
        }
        return (Parameter)this.params.get(n2);
    }

    public int indexOf(Parameter parameter) {
        if (parameter == null) {
            return -1;
        }
        return this.params.indexOf(parameter);
    }

    public boolean hasParameters() {
        return !this.params.isEmpty();
    }

    public Iterator parameterIterator() {
        return this.params.iterator();
    }

    public Parameter remove(int n2) {
        if (this.params.isEmpty() || n2 < 0 || n2 >= this.params.size()) {
            return null;
        }
        return (Parameter)this.params.remove(n2);
    }

    public boolean remove(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.remove(parameter);
    }

    public boolean removeAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        return this.params.removeAll(collection);
    }

    public Parameter set(int n2, Parameter parameter) {
        return this.params.set(n2, parameter);
    }

    public int parameterCount() {
        return this.params.size();
    }

    public PreparedStatement toPreparedStatement(DatabaseConnection databaseConnection) throws SQLException, ParseException {
        return this.toPreparedStatement(databaseConnection, 1003, 1007);
    }

    public PreparedStatement toPreparedStatement(DatabaseConnection databaseConnection, int n2, int n3) throws SQLException, ParseException {
        if (databaseConnection == null || databaseConnection.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString("Connection_Unavailable"));
        }
        PreparedStatement preparedStatement = databaseConnection.createPreparedStatement(this.getSQL(), n2, n3);
        Iterator iterator = this.parameterIterator();
        Object[] objectArray = new Object[this.params.size()];
        int[] nArray = new int[this.params.size()];
        int n4 = 0;
        while (iterator.hasNext()) {
            int n5;
            Parameter parameter = (Parameter)iterator.next();
            nArray[n4] = n5 = parameter.getSQLType();
            objectArray[n4] = StringUtilities.processString(parameter.getValue(), n5, parameter.getOptions());
            ++n4;
        }
        JDBCUtilities.configurePreparedStatement(preparedStatement, objectArray, nArray, false);
        return preparedStatement;
    }

    public static class Parameter
    implements Transferable,
    Cloneable {
        private int type = 1111;
        private String pvalue = null;
        private String options = null;

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (BasicUtilities.BOOKMARK_PARAMETER_FLAVOR.equals(dataFlavor)) {
                return this;
            }
            if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                return this.toString();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BasicUtilities.BOOKMARK_PARAMETER_FLAVOR, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return BasicUtilities.BOOKMARK_PARAMETER_FLAVOR.equals(dataFlavor);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }

        public Object clone() {
            Parameter parameter = new Parameter();
            parameter.options = this.options;
            parameter.pvalue = this.pvalue;
            parameter.type = this.type;
            return parameter;
        }

        public String getOptions() {
            return this.options;
        }

        public void setOptions(String string) {
            this.options = string == null ? "" : "".concat(string);
        }

        public String getValue() {
            return this.pvalue;
        }

        public void setValue(String string) {
            this.pvalue = string == null ? "" : string;
        }

        public int getSQLType() {
            return this.type;
        }

        public void setSQLType(int n2) {
            this.type = n2;
        }

        public Object processOptions() throws ParseException {
            return this.processOptions(this.getValue());
        }

        public Object processOptions(String string) throws ParseException {
            return StringUtilities.processString(string, this.getSQLType(), this.getOptions());
        }
    }
}

