/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Key;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;

class PersistentSet
extends Btree
implements IPersistentSet {
    PersistentSet() {
        this.type = 10;
        this.unique = true;
    }

    public boolean isEmpty() {
        return this.nElems == 0;
    }

    public boolean contains(Object object) {
        if (object instanceof IPersistent) {
            Key key = new Key((IPersistent)object);
            Iterator iterator = this.iterator(key, key, 0);
            return iterator.hasNext();
        }
        return false;
    }

    public Object[] toArray() {
        return this.toPersistentArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.toPersistentArray((IPersistent[])objectArray);
    }

    public boolean add(Object object) {
        IPersistent iPersistent = (IPersistent)object;
        return this.put(new Key(iPersistent), iPersistent);
    }

    public boolean remove(Object object) {
        IPersistent iPersistent = (IPersistent)object;
        return this.removeIfExists(new BtreeKey(this.checkKey(new Key(iPersistent)), iPersistent.getOid()));
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.add(iterator.next());
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (collection.contains(e2)) continue;
            arrayList.add(e2);
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.remove(arrayList.get(i2));
        }
        return n2 != 0;
    }

    public boolean removeAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.remove(iterator.next());
        }
        return bl2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (collection.size() != this.size()) {
            return false;
        }
        return this.containsAll(collection);
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n2 += ((IPersistent)iterator.next()).getOid();
        }
        return n2;
    }
}

