/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;

public class ByteBuffer {
    public byte[] arr = new byte[64];
    public int used;

    public final void extend(int n2) {
        if (n2 > this.arr.length) {
            int n3 = n2 > this.arr.length * 2 ? n2 : this.arr.length * 2;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.arr, 0, byArray, 0, this.used);
            this.arr = byArray;
        }
        this.used = n2;
    }

    final byte[] toArray() {
        byte[] byArray = new byte[this.used];
        System.arraycopy(this.arr, 0, byArray, 0, this.used);
        return byArray;
    }

    final int size() {
        return this.used;
    }

    int packString(int n2, String string, String string2) {
        if (string == null) {
            this.extend(n2 + 4);
            Bytes.pack4(this.arr, n2, -1);
            n2 += 4;
        } else {
            int n3 = string.length();
            if (string2 == null) {
                this.extend(n2 + 4 + 2 * n3);
                Bytes.pack4(this.arr, n2, n3);
                n2 += 4;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Bytes.pack2(this.arr, n2, (short)string.charAt(i2));
                    n2 += 2;
                }
            } else {
                try {
                    byte[] byArray = string.getBytes(string2);
                    this.extend(n2 + 4 + byArray.length);
                    Bytes.pack4(this.arr, n2, -2 - byArray.length);
                    System.arraycopy(byArray, 0, this.arr, n2 + 4, byArray.length);
                    n2 += 4 + byArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new StorageError(26);
                }
            }
        }
        return n2;
    }

    public OutputStream getOutputStream() {
        return new ByteBufferOutputStream();
    }

    ByteBuffer() {
    }

    class ByteBufferOutputStream
    extends OutputStream {
        ByteBufferOutputStream() {
        }

        public void write(int n2) {
            this.write(new byte[]{(byte)n2}, 0, 1);
        }

        public void write(byte[] byArray, int n2, int n3) {
            int n4 = ByteBuffer.this.used;
            ByteBuffer.this.extend(n4 + n3);
            System.arraycopy(byArray, n2, ByteBuffer.this.arr, n4, n3);
        }
    }
}

