/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Key;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreeKey;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;
import org.garret.perst.impl.XMLExporter;

class BtreePage {
    static final int firstKeyOffs = 4;
    static final int keySpace = 4092;
    static final int strKeySize = 8;
    static final int maxItems = 1023;

    BtreePage() {
    }

    static int getnItems(Page page) {
        return Bytes.unpack2(page.data, 0);
    }

    static int getSize(Page page) {
        return Bytes.unpack2(page.data, 2);
    }

    static int getKeyStrOid(Page page, int n2) {
        return Bytes.unpack4(page.data, 4 + n2 * 8);
    }

    static int getKeyStrSize(Page page, int n2) {
        return Bytes.unpack2(page.data, 4 + n2 * 8 + 4);
    }

    static int getKeyStrOffs(Page page, int n2) {
        return Bytes.unpack2(page.data, 4 + n2 * 8 + 6);
    }

    static int getReference(Page page, int n2) {
        return Bytes.unpack4(page.data, 4 + n2 * 4);
    }

    static void setnItems(Page page, int n2) {
        Bytes.pack2(page.data, 0, (short)n2);
    }

    static void setSize(Page page, int n2) {
        Bytes.pack2(page.data, 2, (short)n2);
    }

    static void setKeyStrOid(Page page, int n2, int n3) {
        Bytes.pack4(page.data, 4 + n2 * 8, n3);
    }

    static void setKeyStrSize(Page page, int n2, int n3) {
        Bytes.pack2(page.data, 4 + n2 * 8 + 4, (short)n3);
    }

    static void setKeyStrOffs(Page page, int n2, int n3) {
        Bytes.pack2(page.data, 4 + n2 * 8 + 6, (short)n3);
    }

    static void setKeyStrChars(Page page, int n2, char[] cArray) {
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Bytes.pack2(page.data, 4 + n2, (short)cArray[i2]);
            n2 += 2;
        }
    }

    static void setKeyBytes(Page page, int n2, byte[] byArray) {
        System.arraycopy(byArray, 0, page.data, 4 + n2, byArray.length);
    }

    static void setReference(Page page, int n2, int n3) {
        Bytes.pack4(page.data, 4 + n2 * 4, n3);
    }

    static final int compare(Key key, Page page, int n2) {
        switch (key.type) {
            case 0: 
            case 1: {
                return (byte)key.ival - page.data[4 + n2];
            }
            case 3: {
                return (short)key.ival - Bytes.unpack2(page.data, 4 + n2 * 2);
            }
            case 2: {
                return (char)key.ival - (char)Bytes.unpack2(page.data, 4 + n2 * 2);
            }
            case 4: 
            case 10: {
                int n3 = Bytes.unpack4(page.data, 4 + n2 * 4);
                return key.ival < n3 ? -1 : (key.ival == n3 ? 0 : 1);
            }
            case 5: 
            case 9: {
                long l2 = Bytes.unpack8(page.data, 4 + n2 * 8);
                return key.lval < l2 ? -1 : (key.lval == l2 ? 0 : 1);
            }
            case 6: {
                float f2 = Float.intBitsToFloat(Bytes.unpack4(page.data, 4 + n2 * 4));
                return key.dval < (double)f2 ? -1 : (key.dval == (double)f2 ? 0 : 1);
            }
            case 7: {
                double d2 = Double.longBitsToDouble(Bytes.unpack8(page.data, 4 + n2 * 8));
                return key.dval < d2 ? -1 : (key.dval == d2 ? 0 : 1);
            }
        }
        Assert.failed("Invalid type");
        return 0;
    }

    static final int compareStr(Key key, Page page, int n2) {
        char[] cArray = (char[])key.oval;
        int n3 = cArray.length;
        int n4 = BtreePage.getKeyStrSize(page, n2);
        int n5 = n3 < n4 ? n3 : n4;
        int n6 = BtreePage.getKeyStrOffs(page, n2) + 4;
        byte[] byArray = page.data;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = cArray[i2] - (char)Bytes.unpack2(byArray, n6);
            if (n7 != 0) {
                return n7;
            }
            n6 += 2;
        }
        return n3 - n4;
    }

    static final int comparePrefix(char[] cArray, Page page, int n2) {
        int n3 = cArray.length;
        int n4 = BtreePage.getKeyStrSize(page, n2);
        int n5 = n3 < n4 ? n3 : n4;
        int n6 = BtreePage.getKeyStrOffs(page, n2) + 4;
        byte[] byArray = page.data;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = cArray[i2] - (char)Bytes.unpack2(byArray, n6);
            if (n7 != 0) {
                return n7;
            }
            n6 += 2;
        }
        return n5 - n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean find(StorageImpl storageImpl, int n2, Key key, Key key2, Btree btree, int n3, ArrayList arrayList) {
        int n4;
        Page page = storageImpl.getPage(n2);
        int n5 = 0;
        int n6 = n4 = BtreePage.getnItems(page);
        --n3;
        try {
            int n7;
            block66: {
                block64: {
                    block65: {
                        block63: {
                            block53: {
                                block54: {
                                    int n8;
                                    block62: {
                                        block60: {
                                            block61: {
                                                block59: {
                                                    block51: {
                                                        block52: {
                                                            int n9;
                                                            block58: {
                                                                block56: {
                                                                    block57: {
                                                                        block55: {
                                                                            block48: {
                                                                                block49: {
                                                                                    block50: {
                                                                                        block47: {
                                                                                            if (btree.type != 8) break block47;
                                                                                            if (key == null) break block48;
                                                                                            break block49;
                                                                                        }
                                                                                        if (btree.type != 21) break block50;
                                                                                        if (key == null) break block51;
                                                                                        break block52;
                                                                                    }
                                                                                    if (key == null) break block53;
                                                                                    break block54;
                                                                                }
                                                                                while (n5 < n6) {
                                                                                    n9 = n5 + n6 >> 1;
                                                                                    if (BtreePage.compareStr(key, page, n9) >= key.inclusion) {
                                                                                        n5 = n9 + 1;
                                                                                        continue;
                                                                                    }
                                                                                    n6 = n9;
                                                                                }
                                                                                Assert.that(n6 == n5);
                                                                            }
                                                                            if (key2 == null) break block55;
                                                                            if (n3 != 0) break block56;
                                                                            break block57;
                                                                        }
                                                                        if (n3 == 0) {
                                                                            while (n5 < n4) {
                                                                                int n10 = BtreePage.getKeyStrOid(page, n5);
                                                                                arrayList.add(storageImpl.lookupObject(n10, null));
                                                                                ++n5;
                                                                            }
                                                                            return true;
                                                                        }
                                                                        break block58;
                                                                    }
                                                                    while (n5 < n4) {
                                                                        if (-BtreePage.compareStr(key2, page, n5) >= key2.inclusion) {
                                                                            n9 = 0;
                                                                            return n9 != 0;
                                                                        }
                                                                        int n11 = BtreePage.getKeyStrOid(page, n5);
                                                                        arrayList.add(storageImpl.lookupObject(n11, null));
                                                                        ++n5;
                                                                    }
                                                                    return true;
                                                                }
                                                                do {
                                                                    if (!BtreePage.find(storageImpl, BtreePage.getKeyStrOid(page, n5), key, key2, btree, n3, arrayList)) {
                                                                        n9 = 0;
                                                                        return n9 != 0;
                                                                    }
                                                                    if (n5 != n4) continue;
                                                                    n9 = 1;
                                                                    return n9 != 0;
                                                                } while (BtreePage.compareStr(key2, page, n5++) >= 0);
                                                                n9 = 0;
                                                                return n9 != 0;
                                                            }
                                                            do {
                                                                if (BtreePage.find(storageImpl, BtreePage.getKeyStrOid(page, n5), key, key2, btree, n3, arrayList)) continue;
                                                                n9 = 0;
                                                                return n9 != 0;
                                                            } while (++n5 <= n4);
                                                            return true;
                                                        }
                                                        while (n5 < n6) {
                                                            n8 = n5 + n6 >> 1;
                                                            if (btree.compareByteArrays(key, page, n8) >= key.inclusion) {
                                                                n5 = n8 + 1;
                                                                continue;
                                                            }
                                                            n6 = n8;
                                                        }
                                                        Assert.that(n6 == n5);
                                                    }
                                                    if (key2 == null) break block59;
                                                    if (n3 != 0) break block60;
                                                    break block61;
                                                }
                                                if (n3 == 0) {
                                                    while (n5 < n4) {
                                                        int n12 = BtreePage.getKeyStrOid(page, n5);
                                                        arrayList.add(storageImpl.lookupObject(n12, null));
                                                        ++n5;
                                                    }
                                                    return true;
                                                }
                                                break block62;
                                            }
                                            while (n5 < n4) {
                                                if (-btree.compareByteArrays(key2, page, n5) >= key2.inclusion) {
                                                    n8 = 0;
                                                    return n8 != 0;
                                                }
                                                int n13 = BtreePage.getKeyStrOid(page, n5);
                                                arrayList.add(storageImpl.lookupObject(n13, null));
                                                ++n5;
                                            }
                                            return true;
                                        }
                                        do {
                                            if (!BtreePage.find(storageImpl, BtreePage.getKeyStrOid(page, n5), key, key2, btree, n3, arrayList)) {
                                                n8 = 0;
                                                return n8 != 0;
                                            }
                                            if (n5 != n4) continue;
                                            n8 = 1;
                                            return n8 != 0;
                                        } while (btree.compareByteArrays(key2, page, n5++) >= 0);
                                        n8 = 0;
                                        return n8 != 0;
                                    }
                                    do {
                                        if (BtreePage.find(storageImpl, BtreePage.getKeyStrOid(page, n5), key, key2, btree, n3, arrayList)) continue;
                                        n8 = 0;
                                        return n8 != 0;
                                    } while (++n5 <= n4);
                                    return true;
                                }
                                while (n5 < n6) {
                                    n7 = n5 + n6 >> 1;
                                    if (BtreePage.compare(key, page, n7) >= key.inclusion) {
                                        n5 = n7 + 1;
                                        continue;
                                    }
                                    n6 = n7;
                                }
                                Assert.that(n6 == n5);
                            }
                            if (key2 == null) break block63;
                            if (n3 != 0) break block64;
                            break block65;
                        }
                        if (n3 == 0) {
                            while (n5 < n4) {
                                int n14 = BtreePage.getReference(page, 1022 - n5);
                                arrayList.add(storageImpl.lookupObject(n14, null));
                                ++n5;
                            }
                            return true;
                        }
                        break block66;
                    }
                    while (true) {
                        if (n5 >= n4) {
                            n7 = 1;
                            return n7 != 0;
                        }
                        if (-BtreePage.compare(key2, page, n5) >= key2.inclusion) {
                            n7 = 0;
                            return n7 != 0;
                        }
                        int n15 = BtreePage.getReference(page, 1022 - n5);
                        arrayList.add(storageImpl.lookupObject(n15, null));
                        ++n5;
                    }
                }
                do {
                    if (!BtreePage.find(storageImpl, BtreePage.getReference(page, 1022 - n5), key, key2, btree, n3, arrayList)) {
                        n7 = 0;
                        return n7 != 0;
                    }
                    if (n5 != n4) continue;
                    n7 = 1;
                    return n7 != 0;
                } while (BtreePage.compare(key2, page, n5++) >= 0);
                n7 = 0;
                return n7 != 0;
            }
            do {
                if (BtreePage.find(storageImpl, BtreePage.getReference(page, 1022 - n5), key, key2, btree, n3, arrayList)) continue;
                n7 = 0;
                return n7 != 0;
            } while (++n5 <= n4);
            return true;
        }
        finally {
            storageImpl.pool.unfix(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prefixSearch(StorageImpl storageImpl, int n2, char[] cArray, int n3, ArrayList arrayList) {
        block13: {
            int n4;
            Page page = storageImpl.getPage(n2);
            int n5 = 0;
            int n6 = n4 = BtreePage.getnItems(page);
            --n3;
            try {
                int n7;
                while (n5 < n6) {
                    n7 = n5 + n6 >> 1;
                    if (BtreePage.comparePrefix(cArray, page, n7) > 0) {
                        n5 = n7 + 1;
                        continue;
                    }
                    n6 = n7;
                }
                Assert.that(n6 == n5);
                if (n3 == 0) {
                    while (n5 < n4) {
                        if (BtreePage.comparePrefix(cArray, page, n5) < 0) {
                            n7 = 0;
                            return n7 != 0;
                        }
                        int n8 = BtreePage.getKeyStrOid(page, n5);
                        arrayList.add(storageImpl.lookupObject(n8, null));
                        ++n5;
                    }
                    break block13;
                }
                do {
                    if (!BtreePage.prefixSearch(storageImpl, BtreePage.getKeyStrOid(page, n5), cArray, n3, arrayList)) {
                        n7 = 0;
                        return n7 != 0;
                    }
                    if (n5 != n4) continue;
                    n7 = 1;
                    return n7 != 0;
                } while (BtreePage.comparePrefix(cArray, page, n5++) >= 0);
                n7 = 0;
                return n7 != 0;
            }
            finally {
                storageImpl.pool.unfix(page);
            }
        }
        return true;
    }

    static int allocate(StorageImpl storageImpl, int n2, int n3, BtreeKey btreeKey) {
        int n4 = storageImpl.allocatePage();
        Page page = storageImpl.putPage(n4);
        BtreePage.setnItems(page, 1);
        if (n3 == 8) {
            char[] cArray = (char[])btreeKey.key.oval;
            int n5 = cArray.length;
            BtreePage.setSize(page, n5 * 2);
            BtreePage.setKeyStrOffs(page, 0, 4092 - n5 * 2);
            BtreePage.setKeyStrSize(page, 0, n5);
            BtreePage.setKeyStrOid(page, 0, btreeKey.oid);
            BtreePage.setKeyStrOid(page, 1, n2);
            BtreePage.setKeyStrChars(page, 4092 - n5 * 2, cArray);
        } else if (n3 == 21) {
            byte[] byArray = (byte[])btreeKey.key.oval;
            int n6 = byArray.length;
            BtreePage.setSize(page, n6);
            BtreePage.setKeyStrOffs(page, 0, 4092 - n6);
            BtreePage.setKeyStrSize(page, 0, n6);
            BtreePage.setKeyStrOid(page, 0, btreeKey.oid);
            BtreePage.setKeyStrOid(page, 1, n2);
            BtreePage.setKeyBytes(page, 4092 - n6, byArray);
        } else {
            btreeKey.pack(page, 0);
            BtreePage.setReference(page, 1021, n2);
        }
        storageImpl.pool.unfix(page);
        return n4;
    }

    static void memcpy(Page page, int n2, Page page2, int n3, int n4, int n5) {
        System.arraycopy(page2.data, 4 + n3 * n5, page.data, 4 + n2 * n5, n4 * n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int insert(StorageImpl storageImpl, int n2, Btree btree, BtreeKey btreeKey, int n3, boolean bl2, boolean bl3) {
        int n4;
        Page page;
        block36: {
            block35: {
                block34: {
                    block33: {
                        int n5;
                        page = storageImpl.getPage(n2);
                        int n6 = 0;
                        int n7 = n5 = BtreePage.getnItems(page);
                        int n8 = bl2 ? 1 : 0;
                        try {
                            int n9;
                            if (btree.type == 8) {
                                int n10;
                                while (n6 < n7) {
                                    n10 = n6 + n7 >> 1;
                                    if (BtreePage.compareStr(btreeKey.key, page, n10) >= n8) {
                                        n6 = n10 + 1;
                                        continue;
                                    }
                                    n7 = n10;
                                }
                                Assert.that(n6 == n7);
                                if (--n3 != 0) {
                                    int n11 = BtreePage.insert(storageImpl, BtreePage.getKeyStrOid(page, n7), btree, btreeKey, n3, bl2, bl3);
                                    Assert.that(n11 != 3);
                                    if (n11 != 1) {
                                        n10 = n11;
                                        Object var19_18 = null;
                                        if (page == null) return n10;
                                        storageImpl.pool.unfix(page);
                                        return n10;
                                    }
                                } else if (n7 < n5 && BtreePage.compareStr(btreeKey.key, page, n7) == 0) {
                                    if (bl3) {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        btreeKey.oldOid = BtreePage.getKeyStrOid(page, n7);
                                        BtreePage.setKeyStrOid(page, n7, btreeKey.oid);
                                        n10 = 5;
                                        Object var19_19 = null;
                                        if (page == null) return n10;
                                        storageImpl.pool.unfix(page);
                                        return n10;
                                    }
                                    if (bl2) {
                                        n10 = 4;
                                        Object var19_20 = null;
                                        if (page == null) return n10;
                                        storageImpl.pool.unfix(page);
                                        return n10;
                                    }
                                }
                                storageImpl.pool.unfix(page);
                                page = null;
                                page = storageImpl.putPage(n2);
                                n10 = BtreePage.insertStrKey(storageImpl, page, n7, btreeKey, n3);
                                Object var19_21 = null;
                                if (page == null) return n10;
                                storageImpl.pool.unfix(page);
                                return n10;
                            }
                            if (btree.type == 21) {
                                while (n6 < n7) {
                                    n4 = n6 + n7 >> 1;
                                    if (btree.compareByteArrays(btreeKey.key, page, n4) >= n8) {
                                        n6 = n4 + 1;
                                        continue;
                                    }
                                    n7 = n4;
                                }
                                Assert.that(n6 == n7);
                                if (--n3 != 0) {
                                    int n12 = BtreePage.insert(storageImpl, BtreePage.getKeyStrOid(page, n7), btree, btreeKey, n3, bl2, bl3);
                                    Assert.that(n12 != 3);
                                    if (n12 != 1) {
                                        n4 = n12;
                                        break block33;
                                    }
                                } else if (n7 < n5 && btree.compareByteArrays(btreeKey.key, page, n7) == 0) {
                                    if (bl3) {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        btreeKey.oldOid = BtreePage.getKeyStrOid(page, n7);
                                        BtreePage.setKeyStrOid(page, n7, btreeKey.oid);
                                        n4 = 5;
                                        break block34;
                                    }
                                    if (bl2) {
                                        n4 = 4;
                                        break block35;
                                    }
                                }
                                storageImpl.pool.unfix(page);
                                page = null;
                                page = storageImpl.putPage(n2);
                                n4 = BtreePage.insertByteArrayKey(storageImpl, page, n7, btreeKey, n3);
                                break block36;
                            }
                            while (n6 < n7) {
                                n9 = n6 + n7 >> 1;
                                if (BtreePage.compare(btreeKey.key, page, n9) >= n8) {
                                    n6 = n9 + 1;
                                    continue;
                                }
                                n7 = n9;
                            }
                            Assert.that(n6 == n7);
                            if (--n3 != 0) {
                                int n13 = BtreePage.insert(storageImpl, BtreePage.getReference(page, 1023 - n7 - 1), btree, btreeKey, n3, bl2, bl3);
                                Assert.that(n13 != 3);
                                if (n13 != 1) {
                                    n9 = n13;
                                    Object var19_26 = null;
                                    if (page == null) return n9;
                                    storageImpl.pool.unfix(page);
                                    return n9;
                                }
                                ++n5;
                            } else if (n7 < n5 && BtreePage.compare(btreeKey.key, page, n7) == 0) {
                                if (bl3) {
                                    storageImpl.pool.unfix(page);
                                    page = null;
                                    page = storageImpl.putPage(n2);
                                    btreeKey.oldOid = BtreePage.getReference(page, 1023 - n7 - 1);
                                    BtreePage.setReference(page, 1023 - n7 - 1, btreeKey.oid);
                                    n9 = 5;
                                    Object var19_27 = null;
                                    if (page == null) return n9;
                                    storageImpl.pool.unfix(page);
                                    return n9;
                                }
                                if (bl2) {
                                    n9 = 4;
                                    Object var19_28 = null;
                                    if (page == null) return n9;
                                    storageImpl.pool.unfix(page);
                                    return n9;
                                }
                            }
                            storageImpl.pool.unfix(page);
                            page = null;
                            page = storageImpl.putPage(n2);
                            n9 = ClassDescriptor.sizeof[btree.type];
                            int n14 = 4092 / (4 + n9);
                            if (n5 < n14) {
                                BtreePage.memcpy(page, n7 + 1, page, n7, n5 - n7, n9);
                                BtreePage.memcpy(page, 1023 - n5 - 1, page, 1023 - n5, n5 - n7, 4);
                                btreeKey.pack(page, n7);
                                BtreePage.setnItems(page, BtreePage.getnItems(page) + 1);
                                int n15 = 0;
                                Object var19_29 = null;
                                if (page == null) return n15;
                                storageImpl.pool.unfix(page);
                                return n15;
                            }
                            n2 = storageImpl.allocatePage();
                            Page page2 = storageImpl.putPage(n2);
                            Assert.that(n5 == n14);
                            int n16 = n14 / 2;
                            if (n7 < n16) {
                                BtreePage.memcpy(page2, 0, page, 0, n7, n9);
                                BtreePage.memcpy(page2, n7 + 1, page, n7, n16 - n7 - 1, n9);
                                BtreePage.memcpy(page, 0, page, n16 - 1, n14 - n16 + 1, n9);
                                BtreePage.memcpy(page2, 1023 - n7, page, 1023 - n7, n7, 4);
                                btreeKey.pack(page2, n7);
                                BtreePage.memcpy(page2, 1023 - n16, page, 1023 - n16 + 1, n16 - n7 - 1, 4);
                                BtreePage.memcpy(page, 1023 - n14 + n16 - 1, page, 1023 - n14, n14 - n16 + 1, 4);
                            } else {
                                BtreePage.memcpy(page2, 0, page, 0, n16, n9);
                                BtreePage.memcpy(page, 0, page, n16, n7 - n16, n9);
                                BtreePage.memcpy(page, n7 - n16 + 1, page, n7, n14 - n7, n9);
                                BtreePage.memcpy(page2, 1023 - n16, page, 1023 - n16, n16, 4);
                                BtreePage.memcpy(page, 1023 - n7 + n16, page, 1023 - n7, n7 - n16, 4);
                                btreeKey.pack(page, n7 - n16);
                                BtreePage.memcpy(page, 1023 - n14 + n16 - 1, page, 1023 - n14, n14 - n7, 4);
                            }
                            btreeKey.oid = n2;
                            btreeKey.extract(page2, 4 + (n16 - 1) * n9, btree.type);
                            if (n3 == 0) {
                                BtreePage.setnItems(page, n14 - n16 + 1);
                                BtreePage.setnItems(page2, n16);
                            } else {
                                BtreePage.setnItems(page, n14 - n16);
                                BtreePage.setnItems(page2, n16 - 1);
                            }
                            storageImpl.pool.unfix(page2);
                            int n17 = 1;
                            Object var19_30 = null;
                            if (page == null) return n17;
                            storageImpl.pool.unfix(page);
                            return n17;
                        }
                        catch (Throwable throwable) {
                            Object var19_31 = null;
                            if (page == null) throw throwable;
                            storageImpl.pool.unfix(page);
                            throw throwable;
                        }
                    }
                    Object var19_22 = null;
                    if (page == null) return n4;
                    storageImpl.pool.unfix(page);
                    return n4;
                }
                Object var19_23 = null;
                if (page == null) return n4;
                storageImpl.pool.unfix(page);
                return n4;
            }
            Object var19_24 = null;
            if (page == null) return n4;
            storageImpl.pool.unfix(page);
            return n4;
        }
        Object var19_25 = null;
        if (page == null) return n4;
        storageImpl.pool.unfix(page);
        return n4;
    }

    static int insertStrKey(StorageImpl storageImpl, Page page, int n2, BtreeKey btreeKey, int n3) {
        int n4;
        char[] cArray;
        int n5;
        int n6 = BtreePage.getnItems(page);
        int n7 = BtreePage.getSize(page);
        if (n7 + (n5 = (cArray = (char[])btreeKey.key.oval).length) * 2 + ((n4 = n3 != 0 ? n6 + 1 : n6) + 1) * 8 > 4092) {
            int n8 = storageImpl.allocatePage();
            Page page2 = storageImpl.putPage(n8);
            int n9 = 0;
            int n10 = n5 * 2 + 8;
            int n11 = -2147483647;
            int n12 = 0;
            int n13 = 0;
            while (true) {
                int n14;
                int n15;
                int n16 = n6 - n13 - 1;
                int n17 = BtreePage.getKeyStrSize(page, n13);
                if (n12 == n2) {
                    n17 = n5;
                    n10 = 0;
                    n15 = n5;
                    if (n3 == 0) {
                        n14 = 0;
                        ++n16;
                    } else {
                        n14 = BtreePage.getKeyStrSize(page, n13);
                    }
                } else {
                    n15 = n14 = n17;
                    if (n3 != 0) {
                        if (n13 + 1 != n2) {
                            n14 += BtreePage.getKeyStrSize(page, n13 + 1);
                            --n16;
                        } else {
                            n10 = 0;
                        }
                    }
                }
                int n18 = n9 + n15 * 2 + (n12 + 1) * 8 - (n16 * 8 + n7 - n14 * 2 + n10);
                if (n18 >= -n11) {
                    if (n3 == 0) {
                        btreeKey.getStr(page2, n12 - 1);
                    } else {
                        Assert.that("String fits in the B-Tree page", n9 + (n12 + 1) * 8 <= 4092);
                        if (n12 != n2) {
                            btreeKey.getStr(page, n13);
                            BtreePage.setKeyStrOid(page2, n12, BtreePage.getKeyStrOid(page, n13));
                            n7 -= n17 * 2;
                            ++n13;
                        } else {
                            BtreePage.setKeyStrOid(page2, n12, btreeKey.oid);
                        }
                    }
                    n6 = BtreePage.compactifyStrings(page, n13);
                    if (n12 < n2 || n12 == n2 && n3 == 0) {
                        BtreePage.memcpy(page, n2 - n13 + 1, page, n2 - n13, n4 - n2, 8);
                        ++n6;
                        Assert.that("String fits in the B-Tree page", (n7 += n5 * 2) + (n4 - n13 + 1) * 8 <= 4092);
                        BtreePage.setKeyStrOffs(page, n2 - n13, 4092 - n7);
                        BtreePage.setKeyStrSize(page, n2 - n13, n5);
                        BtreePage.setKeyStrOid(page, n2 - n13, btreeKey.oid);
                        BtreePage.setKeyStrChars(page, 4092 - n7, cArray);
                    }
                    BtreePage.setnItems(page2, n12);
                    BtreePage.setSize(page2, n9);
                    BtreePage.setSize(page, n7);
                    BtreePage.setnItems(page, n6);
                    btreeKey.oid = n8;
                    storageImpl.pool.unfix(page2);
                    return 1;
                }
                n11 = n18;
                Assert.that("String fits in the B-Tree page", (n9 += n17 * 2) + (n12 + 1) * 8 <= 4092);
                BtreePage.setKeyStrSize(page2, n12, n17);
                BtreePage.setKeyStrOffs(page2, n12, 4092 - n9);
                if (n12 == n2) {
                    BtreePage.setKeyStrOid(page2, n12, btreeKey.oid);
                    BtreePage.setKeyStrChars(page2, 4092 - n9, cArray);
                } else {
                    BtreePage.setKeyStrOid(page2, n12, BtreePage.getKeyStrOid(page, n13));
                    BtreePage.memcpy(page2, 4092 - n9, page, BtreePage.getKeyStrOffs(page, n13), n17 * 2, 1);
                    n7 -= n17 * 2;
                    ++n13;
                }
                ++n12;
            }
        }
        BtreePage.memcpy(page, n2 + 1, page, n2, n4 - n2, 8);
        BtreePage.setKeyStrOffs(page, n2, 4092 - (n7 += n5 * 2));
        BtreePage.setKeyStrSize(page, n2, n5);
        BtreePage.setKeyStrOid(page, n2, btreeKey.oid);
        BtreePage.setKeyStrChars(page, 4092 - n7, cArray);
        BtreePage.setnItems(page, ++n6);
        BtreePage.setSize(page, n7);
        return n7 + 8 * (n6 + 1) < 2046 ? 2 : 0;
    }

    static int insertByteArrayKey(StorageImpl storageImpl, Page page, int n2, BtreeKey btreeKey, int n3) {
        int n4;
        byte[] byArray;
        int n5;
        int n6 = BtreePage.getnItems(page);
        int n7 = BtreePage.getSize(page);
        if (n7 + (n5 = (byArray = (byte[])btreeKey.key.oval).length) + ((n4 = n3 != 0 ? n6 + 1 : n6) + 1) * 8 > 4092) {
            int n8 = storageImpl.allocatePage();
            Page page2 = storageImpl.putPage(n8);
            int n9 = 0;
            int n10 = n5 + 8;
            int n11 = -2147483647;
            int n12 = 0;
            int n13 = 0;
            while (true) {
                int n14;
                int n15;
                int n16 = n6 - n13 - 1;
                int n17 = BtreePage.getKeyStrSize(page, n13);
                if (n12 == n2) {
                    n17 = n5;
                    n10 = 0;
                    n15 = n5;
                    if (n3 == 0) {
                        n14 = 0;
                        ++n16;
                    } else {
                        n14 = BtreePage.getKeyStrSize(page, n13);
                    }
                } else {
                    n15 = n14 = n17;
                    if (n3 != 0) {
                        if (n13 + 1 != n2) {
                            n14 += BtreePage.getKeyStrSize(page, n13 + 1);
                            --n16;
                        } else {
                            n10 = 0;
                        }
                    }
                }
                int n18 = n9 + n15 + (n12 + 1) * 8 - (n16 * 8 + n7 - n14 + n10);
                if (n18 >= -n11) {
                    if (n3 == 0) {
                        btreeKey.getByteArray(page2, n12 - 1);
                    } else {
                        Assert.that("String fits in the B-Tree page", n9 + (n12 + 1) * 8 <= 4092);
                        if (n12 != n2) {
                            btreeKey.getByteArray(page, n13);
                            BtreePage.setKeyStrOid(page2, n12, BtreePage.getKeyStrOid(page, n13));
                            n7 -= n17;
                            ++n13;
                        } else {
                            BtreePage.setKeyStrOid(page2, n12, btreeKey.oid);
                        }
                    }
                    n6 = BtreePage.compactifyByteArrays(page, n13);
                    if (n12 < n2 || n12 == n2 && n3 == 0) {
                        BtreePage.memcpy(page, n2 - n13 + 1, page, n2 - n13, n4 - n2, 8);
                        ++n6;
                        Assert.that("String fits in the B-Tree page", (n7 += n5) + (n4 - n13 + 1) * 8 <= 4092);
                        BtreePage.setKeyStrOffs(page, n2 - n13, 4092 - n7);
                        BtreePage.setKeyStrSize(page, n2 - n13, n5);
                        BtreePage.setKeyStrOid(page, n2 - n13, btreeKey.oid);
                        BtreePage.setKeyBytes(page, 4092 - n7, byArray);
                    }
                    BtreePage.setnItems(page2, n12);
                    BtreePage.setSize(page2, n9);
                    BtreePage.setSize(page, n7);
                    BtreePage.setnItems(page, n6);
                    btreeKey.oid = n8;
                    storageImpl.pool.unfix(page2);
                    return 1;
                }
                n11 = n18;
                Assert.that("String fits in the B-Tree page", (n9 += n17) + (n12 + 1) * 8 <= 4092);
                BtreePage.setKeyStrSize(page2, n12, n17);
                BtreePage.setKeyStrOffs(page2, n12, 4092 - n9);
                if (n12 == n2) {
                    BtreePage.setKeyStrOid(page2, n12, btreeKey.oid);
                    BtreePage.setKeyBytes(page2, 4092 - n9, byArray);
                } else {
                    BtreePage.setKeyStrOid(page2, n12, BtreePage.getKeyStrOid(page, n13));
                    BtreePage.memcpy(page2, 4092 - n9, page, BtreePage.getKeyStrOffs(page, n13), n17, 1);
                    n7 -= n17;
                    ++n13;
                }
                ++n12;
            }
        }
        BtreePage.memcpy(page, n2 + 1, page, n2, n4 - n2, 8);
        BtreePage.setKeyStrOffs(page, n2, 4092 - (n7 += n5));
        BtreePage.setKeyStrSize(page, n2, n5);
        BtreePage.setKeyStrOid(page, n2, btreeKey.oid);
        BtreePage.setKeyBytes(page, 4092 - n7, byArray);
        BtreePage.setnItems(page, ++n6);
        BtreePage.setSize(page, n7);
        return n7 + 8 * (n6 + 1) < 2046 ? 2 : 0;
    }

    static int compactifyStrings(Page page, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = BtreePage.getnItems(page);
        int[] nArray = new int[2047];
        int[] nArray2 = new int[2047];
        if (n2 == 0) {
            return n6;
        }
        int n7 = 0;
        if (n2 < 0) {
            n2 = -n2;
            for (n5 = 0; n5 < n6 - n2; ++n5) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5) >>> 1;
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = n5;
                    continue;
                }
                ++n7;
            }
            while (n5 < n6) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5) >>> 1;
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = -1;
                }
                ++n5;
            }
        } else {
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 == 0) continue;
                n3 = BtreePage.getKeyStrOffs(page, n5) >>> 1;
                nArray[n3 + n4] = n4;
                nArray2[n3 + n4] = -1;
            }
            while (n5 < n6) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5) >>> 1;
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = n5 - n2;
                } else {
                    ++n7;
                }
                BtreePage.setKeyStrOid(page, n5 - n2, BtreePage.getKeyStrOid(page, n5));
                BtreePage.setKeyStrSize(page, n5 - n2, n4);
                ++n5;
            }
            BtreePage.setKeyStrOid(page, n5 - n2, BtreePage.getKeyStrOid(page, n5));
        }
        int n8 = n6 -= n2;
        n6 -= n7;
        n5 = n3 = 2046;
        while (n6 != 0) {
            n4 = nArray[n5];
            int n9 = nArray2[n5];
            if (n9 >= 0) {
                --n6;
                BtreePage.setKeyStrOffs(page, n9, (n3 -= n4) * 2);
                if (n3 != n5 - n4) {
                    BtreePage.memcpy(page, n3, page, n5 - n4, n4, 2);
                }
            }
            n5 -= n4;
        }
        return n8;
    }

    static int compactifyByteArrays(Page page, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = BtreePage.getnItems(page);
        int[] nArray = new int[4093];
        int[] nArray2 = new int[4093];
        if (n2 == 0) {
            return n6;
        }
        int n7 = 0;
        if (n2 < 0) {
            n2 = -n2;
            for (n5 = 0; n5 < n6 - n2; ++n5) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5);
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = n5;
                    continue;
                }
                ++n7;
            }
            while (n5 < n6) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5);
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = -1;
                }
                ++n5;
            }
        } else {
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 == 0) continue;
                n3 = BtreePage.getKeyStrOffs(page, n5);
                nArray[n3 + n4] = n4;
                nArray2[n3 + n4] = -1;
            }
            while (n5 < n6) {
                n4 = BtreePage.getKeyStrSize(page, n5);
                if (n4 != 0) {
                    n3 = BtreePage.getKeyStrOffs(page, n5);
                    nArray[n3 + n4] = n4;
                    nArray2[n3 + n4] = n5 - n2;
                } else {
                    ++n7;
                }
                BtreePage.setKeyStrOid(page, n5 - n2, BtreePage.getKeyStrOid(page, n5));
                BtreePage.setKeyStrSize(page, n5 - n2, n4);
                ++n5;
            }
            BtreePage.setKeyStrOid(page, n5 - n2, BtreePage.getKeyStrOid(page, n5));
        }
        int n8 = n6 -= n2;
        n6 -= n7;
        n5 = n3 = 4092;
        while (n6 != 0) {
            n4 = nArray[n5];
            int n9 = nArray2[n5];
            if (n9 >= 0) {
                --n6;
                BtreePage.setKeyStrOffs(page, n9, n3 -= n4);
                if (n3 != n5 - n4) {
                    BtreePage.memcpy(page, n3, page, n5 - n4, n4, 1);
                }
            }
            n5 -= n4;
        }
        return n8;
    }

    static int removeStrKey(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2) * 2;
        int n4 = BtreePage.getKeyStrOffs(page, n2);
        int n5 = BtreePage.getSize(page);
        int n6 = BtreePage.getnItems(page);
        if ((n6 + 1) * 8 >= 4092) {
            BtreePage.memcpy(page, n2, page, n2 + 1, n6 - n2 - 1, 8);
        } else {
            BtreePage.memcpy(page, n2, page, n2 + 1, n6 - n2, 8);
        }
        if (n3 != 0) {
            BtreePage.memcpy(page, 4092 - n5 + n3, page, 4092 - n5, n5 - 4092 + n4, 1);
            int n7 = n6;
            while (--n7 >= 0) {
                if (BtreePage.getKeyStrOffs(page, n7) >= n4) continue;
                BtreePage.setKeyStrOffs(page, n7, BtreePage.getKeyStrOffs(page, n7) + n3);
            }
            BtreePage.setSize(page, n5 -= n3);
        }
        BtreePage.setnItems(page, n6 - 1);
        return n5 + 8 * n6 < 2046 ? 2 : 0;
    }

    static int removeByteArrayKey(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2);
        int n4 = BtreePage.getKeyStrOffs(page, n2);
        int n5 = BtreePage.getSize(page);
        int n6 = BtreePage.getnItems(page);
        if ((n6 + 1) * 8 >= 4092) {
            BtreePage.memcpy(page, n2, page, n2 + 1, n6 - n2 - 1, 8);
        } else {
            BtreePage.memcpy(page, n2, page, n2 + 1, n6 - n2, 8);
        }
        if (n3 != 0) {
            BtreePage.memcpy(page, 4092 - n5 + n3, page, 4092 - n5, n5 - 4092 + n4, 1);
            int n7 = n6;
            while (--n7 >= 0) {
                if (BtreePage.getKeyStrOffs(page, n7) >= n4) continue;
                BtreePage.setKeyStrOffs(page, n7, BtreePage.getKeyStrOffs(page, n7) + n3);
            }
            BtreePage.setSize(page, n5 -= n3);
        }
        BtreePage.setnItems(page, n6 - 1);
        return n5 + 8 * n6 < 2046 ? 2 : 0;
    }

    static int replaceStrKey(StorageImpl storageImpl, Page page, int n2, BtreeKey btreeKey, int n3) {
        btreeKey.oid = BtreePage.getKeyStrOid(page, n2);
        BtreePage.removeStrKey(page, n2);
        return BtreePage.insertStrKey(storageImpl, page, n2, btreeKey, n3);
    }

    static int replaceByteArrayKey(StorageImpl storageImpl, Page page, int n2, BtreeKey btreeKey, int n3) {
        btreeKey.oid = BtreePage.getKeyStrOid(page, n2);
        BtreePage.removeByteArrayKey(page, n2);
        return BtreePage.insertByteArrayKey(storageImpl, page, n2, btreeKey, n3);
    }

    static int handlePageUnderflow(StorageImpl storageImpl, Page page, int n2, int n3, BtreeKey btreeKey, int n4) {
        int n5;
        int n6 = BtreePage.getnItems(page);
        if (n3 == 8) {
            int n7;
            Page page2 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2));
            int n8 = BtreePage.getnItems(page2);
            if (n2 < n6) {
                int n9;
                Page page3 = storageImpl.getPage(BtreePage.getKeyStrOid(page, n2 + 1));
                int n10 = BtreePage.getnItems(page3);
                int n11 = (n8 + n10) * 8 + BtreePage.getSize(page2) + BtreePage.getSize(page3);
                if (n4 != 1) {
                    n11 += BtreePage.getKeyStrSize(page, n2) * 2 + 16;
                }
                if (n11 > 4092) {
                    int n12;
                    int n13;
                    int n14;
                    storageImpl.pool.unfix(page3);
                    page3 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2 + 1));
                    int n15 = BtreePage.getSize(page2);
                    int n16 = BtreePage.getSize(page3);
                    if (n4 != 1) {
                        n14 = BtreePage.getKeyStrSize(page, n2);
                        n13 = BtreePage.getKeyStrSize(page3, 0);
                    } else {
                        n14 = n13 = BtreePage.getKeyStrSize(page3, 0);
                    }
                    int n17 = 0;
                    int n18 = n8 * 8 + n15 - (n10 * 8 + n16);
                    while (true) {
                        if ((n12 = (n8 + ++n17) * 8 + n15 + n14 * 2 - ((n10 - n17) * 8 + n16 - n13 * 2)) >= 0) {
                            if (n12 < -n18) break;
                            --n17;
                            break;
                        }
                        n15 += n14 * 2;
                        n16 -= n13 * 2;
                        n18 = n12;
                        if (n4 != 1) {
                            n14 = n13;
                            n13 = BtreePage.getKeyStrSize(page3, n17);
                            continue;
                        }
                        n14 = n13 = BtreePage.getKeyStrSize(page3, n17);
                    }
                    n12 = 0;
                    if (n17 > 0) {
                        int n19;
                        int n20 = n17;
                        if (n4 != 1) {
                            n19 = BtreePage.getKeyStrSize(page, n2);
                            BtreePage.setSize(page2, BtreePage.getSize(page2) + n19 * 2);
                            BtreePage.setKeyStrOffs(page2, n8, 4092 - BtreePage.getSize(page2));
                            BtreePage.setKeyStrSize(page2, n8, n19);
                            BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, n8), page, BtreePage.getKeyStrOffs(page, n2), n19 * 2, 1);
                            BtreePage.setKeyStrOid(page2, ++n8 + --n20, BtreePage.getKeyStrOid(page3, n20));
                            BtreePage.setSize(page3, BtreePage.getSize(page3) - BtreePage.getKeyStrSize(page3, n20) * 2);
                        }
                        for (int i2 = 0; i2 < n20; ++i2) {
                            n19 = BtreePage.getKeyStrSize(page3, i2);
                            BtreePage.setSize(page2, BtreePage.getSize(page2) + n19 * 2);
                            BtreePage.setSize(page3, BtreePage.getSize(page3) - n19 * 2);
                            BtreePage.setKeyStrOffs(page2, n8, 4092 - BtreePage.getSize(page2));
                            BtreePage.setKeyStrSize(page2, n8, n19);
                            BtreePage.setKeyStrOid(page2, n8, BtreePage.getKeyStrOid(page3, i2));
                            BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, n8), page3, BtreePage.getKeyStrOffs(page3, i2), n19 * 2, 1);
                            ++n8;
                        }
                        btreeKey.getStr(page3, n17 - 1);
                        n12 = BtreePage.replaceStrKey(storageImpl, page, n2, btreeKey, n4);
                        BtreePage.setnItems(page2, n8);
                        BtreePage.setnItems(page3, BtreePage.compactifyStrings(page3, n17));
                    }
                    storageImpl.pool.unfix(page2);
                    storageImpl.pool.unfix(page3);
                    return n12;
                }
                if (n4 != 1) {
                    n9 = BtreePage.getKeyStrSize(page, n2);
                    BtreePage.setKeyStrSize(page2, n8, n9);
                    BtreePage.setSize(page2, BtreePage.getSize(page2) + n9 * 2);
                    BtreePage.setKeyStrOffs(page2, n8, 4092 - BtreePage.getSize(page2));
                    BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, n8), page, BtreePage.getKeyStrOffs(page, n2), n9 * 2, 1);
                    BtreePage.setKeyStrOid(page2, ++n8 + n10, BtreePage.getKeyStrOid(page3, n10));
                }
                n9 = 0;
                while (n9 < n10) {
                    BtreePage.setKeyStrSize(page2, n8, BtreePage.getKeyStrSize(page3, n9));
                    BtreePage.setKeyStrOffs(page2, n8, BtreePage.getKeyStrOffs(page3, n9) - BtreePage.getSize(page2));
                    BtreePage.setKeyStrOid(page2, n8, BtreePage.getKeyStrOid(page3, n9));
                    ++n9;
                    ++n8;
                }
                BtreePage.setSize(page2, BtreePage.getSize(page2) + BtreePage.getSize(page3));
                BtreePage.setnItems(page2, n8);
                BtreePage.memcpy(page2, 4092 - BtreePage.getSize(page2), page3, 4092 - BtreePage.getSize(page3), BtreePage.getSize(page3), 1);
                storageImpl.pool.unfix(page2);
                storageImpl.pool.unfix(page3);
                storageImpl.freePage(BtreePage.getKeyStrOid(page, n2 + 1));
                BtreePage.setKeyStrOid(page, n2 + 1, BtreePage.getKeyStrOid(page, n2));
                return BtreePage.removeStrKey(page, n2);
            }
            Page page4 = storageImpl.getPage(BtreePage.getKeyStrOid(page, n2 - 1));
            int n21 = BtreePage.getnItems(page4);
            int n22 = (n8 + n21) * 8 + BtreePage.getSize(page2) + BtreePage.getSize(page4);
            if (n4 != 1) {
                n22 += BtreePage.getKeyStrSize(page, n2 - 1) * 2 + 16;
            }
            if (n22 > 4092) {
                int n23;
                int n24;
                int n25;
                storageImpl.pool.unfix(page4);
                page4 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2 - 1));
                int n26 = BtreePage.getSize(page2);
                int n27 = BtreePage.getSize(page4);
                if (n4 != 1) {
                    n25 = BtreePage.getKeyStrSize(page, n2 - 1);
                    n24 = BtreePage.getKeyStrSize(page4, n21 - 1);
                } else {
                    n25 = n24 = BtreePage.getKeyStrSize(page4, n21 - 1);
                }
                int n28 = 0;
                int n29 = n8 * 8 + n26 - (n21 * 8 + n27);
                while (true) {
                    if ((n23 = (n8 + ++n28) * 8 + n26 + n25 * 2 - ((n21 - n28) * 8 + n27 - n24 * 2)) >= 0) {
                        if (n23 < -n29) break;
                        --n28;
                        break;
                    }
                    n29 = n23;
                    n26 += n25 * 2;
                    n27 -= n24 * 2;
                    if (n4 != 1) {
                        n25 = n24;
                        n24 = BtreePage.getKeyStrSize(page4, n21 - n28 - 1);
                        continue;
                    }
                    n25 = n24 = BtreePage.getKeyStrSize(page4, n21 - n28 - 1);
                }
                n23 = 0;
                if (n28 > 0) {
                    int n30;
                    int n31 = n28;
                    Assert.that(n28 < n21);
                    if (n4 != 1) {
                        BtreePage.setSize(page4, BtreePage.getSize(page4) - BtreePage.getKeyStrSize(page4, n21 - n31) * 2);
                        BtreePage.memcpy(page2, n28, page2, 0, n8 + 1, 8);
                        BtreePage.setKeyStrOid(page2, --n31, BtreePage.getKeyStrOid(page4, n21));
                        n30 = BtreePage.getKeyStrSize(page, n2 - 1);
                        BtreePage.setKeyStrSize(page2, n31, n30);
                        BtreePage.setSize(page2, BtreePage.getSize(page2) + n30 * 2);
                        BtreePage.setKeyStrOffs(page2, n31, 4092 - BtreePage.getSize(page2));
                        BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, n31), page, BtreePage.getKeyStrOffs(page, n2 - 1), n30 * 2, 1);
                    } else {
                        BtreePage.memcpy(page2, n28, page2, 0, n8, 8);
                    }
                    for (int i3 = 0; i3 < n31; ++i3) {
                        n30 = BtreePage.getKeyStrSize(page4, n21 - n31 + i3);
                        BtreePage.setSize(page2, BtreePage.getSize(page2) + n30 * 2);
                        BtreePage.setSize(page4, BtreePage.getSize(page4) - n30 * 2);
                        BtreePage.setKeyStrOffs(page2, i3, 4092 - BtreePage.getSize(page2));
                        BtreePage.setKeyStrSize(page2, i3, n30);
                        BtreePage.setKeyStrOid(page2, i3, BtreePage.getKeyStrOid(page4, n21 - n31 + i3));
                        BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, i3), page4, BtreePage.getKeyStrOffs(page4, n21 - n31 + i3), n30 * 2, 1);
                    }
                    BtreePage.setnItems(page2, n8 += n28);
                    btreeKey.getStr(page4, n21 - n31 - 1);
                    n23 = BtreePage.replaceStrKey(storageImpl, page, n2 - 1, btreeKey, n4);
                    BtreePage.setnItems(page4, BtreePage.compactifyStrings(page4, -n28));
                }
                storageImpl.pool.unfix(page2);
                storageImpl.pool.unfix(page4);
                return n23;
            }
            if (n4 != 1) {
                BtreePage.memcpy(page2, n21 + 1, page2, 0, n8 + 1, 8);
                n7 = BtreePage.getKeyStrSize(page, n2 - 1);
                BtreePage.setKeyStrSize(page2, n21, n7);
                BtreePage.setSize(page2, BtreePage.getSize(page2) + n7 * 2);
                BtreePage.setKeyStrOffs(page2, n21, 4092 - BtreePage.getSize(page2));
                BtreePage.setKeyStrOid(page2, n21, BtreePage.getKeyStrOid(page4, n21));
                BtreePage.memcpy(page2, BtreePage.getKeyStrOffs(page2, n21), page, BtreePage.getKeyStrOffs(page, n2 - 1), n7 * 2, 1);
                ++n8;
            } else {
                BtreePage.memcpy(page2, n21, page2, 0, n8, 8);
            }
            for (n7 = 0; n7 < n21; ++n7) {
                BtreePage.setKeyStrOid(page2, n7, BtreePage.getKeyStrOid(page4, n7));
                BtreePage.setKeyStrSize(page2, n7, BtreePage.getKeyStrSize(page4, n7));
                BtreePage.setKeyStrOffs(page2, n7, BtreePage.getKeyStrOffs(page4, n7) - BtreePage.getSize(page2));
            }
            BtreePage.setnItems(page2, n8 += n21);
            BtreePage.setSize(page2, BtreePage.getSize(page2) + BtreePage.getSize(page4));
            BtreePage.memcpy(page2, 4092 - BtreePage.getSize(page2), page4, 4092 - BtreePage.getSize(page4), BtreePage.getSize(page4), 1);
            storageImpl.pool.unfix(page2);
            storageImpl.pool.unfix(page4);
            storageImpl.freePage(BtreePage.getKeyStrOid(page, n2 - 1));
            return BtreePage.removeStrKey(page, n2 - 1);
        }
        if (n3 == 21) {
            int n32;
            Page page5 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2));
            int n33 = BtreePage.getnItems(page5);
            if (n2 < n6) {
                int n34;
                Page page6 = storageImpl.getPage(BtreePage.getKeyStrOid(page, n2 + 1));
                int n35 = BtreePage.getnItems(page6);
                int n36 = (n33 + n35) * 8 + BtreePage.getSize(page5) + BtreePage.getSize(page6);
                if (n4 != 1) {
                    n36 += BtreePage.getKeyStrSize(page, n2) + 16;
                }
                if (n36 > 4092) {
                    int n37;
                    int n38;
                    int n39;
                    storageImpl.pool.unfix(page6);
                    page6 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2 + 1));
                    int n40 = BtreePage.getSize(page5);
                    int n41 = BtreePage.getSize(page6);
                    if (n4 != 1) {
                        n39 = BtreePage.getKeyStrSize(page, n2);
                        n38 = BtreePage.getKeyStrSize(page6, 0);
                    } else {
                        n39 = n38 = BtreePage.getKeyStrSize(page6, 0);
                    }
                    int n42 = 0;
                    int n43 = n33 * 8 + n40 - (n35 * 8 + n41);
                    while (true) {
                        if ((n37 = (n33 + ++n42) * 8 + n40 + n39 - ((n35 - n42) * 8 + n41 - n38)) >= 0) {
                            if (n37 < -n43) break;
                            --n42;
                            break;
                        }
                        n40 += n39;
                        n41 -= n38;
                        n43 = n37;
                        if (n4 != 1) {
                            n39 = n38;
                            n38 = BtreePage.getKeyStrSize(page6, n42);
                            continue;
                        }
                        n39 = n38 = BtreePage.getKeyStrSize(page6, n42);
                    }
                    n37 = 0;
                    if (n42 > 0) {
                        int n44;
                        int n45 = n42;
                        if (n4 != 1) {
                            n44 = BtreePage.getKeyStrSize(page, n2);
                            BtreePage.setSize(page5, BtreePage.getSize(page5) + n44);
                            BtreePage.setKeyStrOffs(page5, n33, 4092 - BtreePage.getSize(page5));
                            BtreePage.setKeyStrSize(page5, n33, n44);
                            BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, n33), page, BtreePage.getKeyStrOffs(page, n2), n44, 1);
                            BtreePage.setKeyStrOid(page5, ++n33 + --n45, BtreePage.getKeyStrOid(page6, n45));
                            BtreePage.setSize(page6, BtreePage.getSize(page6) - BtreePage.getKeyStrSize(page6, n45));
                        }
                        for (int i4 = 0; i4 < n45; ++i4) {
                            n44 = BtreePage.getKeyStrSize(page6, i4);
                            BtreePage.setSize(page5, BtreePage.getSize(page5) + n44);
                            BtreePage.setSize(page6, BtreePage.getSize(page6) - n44);
                            BtreePage.setKeyStrOffs(page5, n33, 4092 - BtreePage.getSize(page5));
                            BtreePage.setKeyStrSize(page5, n33, n44);
                            BtreePage.setKeyStrOid(page5, n33, BtreePage.getKeyStrOid(page6, i4));
                            BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, n33), page6, BtreePage.getKeyStrOffs(page6, i4), n44, 1);
                            ++n33;
                        }
                        btreeKey.getByteArray(page6, n42 - 1);
                        n37 = BtreePage.replaceByteArrayKey(storageImpl, page, n2, btreeKey, n4);
                        BtreePage.setnItems(page5, n33);
                        BtreePage.setnItems(page6, BtreePage.compactifyByteArrays(page6, n42));
                    }
                    storageImpl.pool.unfix(page5);
                    storageImpl.pool.unfix(page6);
                    return n37;
                }
                if (n4 != 1) {
                    n34 = BtreePage.getKeyStrSize(page, n2);
                    BtreePage.setKeyStrSize(page5, n33, n34);
                    BtreePage.setSize(page5, BtreePage.getSize(page5) + n34);
                    BtreePage.setKeyStrOffs(page5, n33, 4092 - BtreePage.getSize(page5));
                    BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, n33), page, BtreePage.getKeyStrOffs(page, n2), n34, 1);
                    BtreePage.setKeyStrOid(page5, ++n33 + n35, BtreePage.getKeyStrOid(page6, n35));
                }
                n34 = 0;
                while (n34 < n35) {
                    BtreePage.setKeyStrSize(page5, n33, BtreePage.getKeyStrSize(page6, n34));
                    BtreePage.setKeyStrOffs(page5, n33, BtreePage.getKeyStrOffs(page6, n34) - BtreePage.getSize(page5));
                    BtreePage.setKeyStrOid(page5, n33, BtreePage.getKeyStrOid(page6, n34));
                    ++n34;
                    ++n33;
                }
                BtreePage.setSize(page5, BtreePage.getSize(page5) + BtreePage.getSize(page6));
                BtreePage.setnItems(page5, n33);
                BtreePage.memcpy(page5, 4092 - BtreePage.getSize(page5), page6, 4092 - BtreePage.getSize(page6), BtreePage.getSize(page6), 1);
                storageImpl.pool.unfix(page5);
                storageImpl.pool.unfix(page6);
                storageImpl.freePage(BtreePage.getKeyStrOid(page, n2 + 1));
                BtreePage.setKeyStrOid(page, n2 + 1, BtreePage.getKeyStrOid(page, n2));
                return BtreePage.removeByteArrayKey(page, n2);
            }
            Page page7 = storageImpl.getPage(BtreePage.getKeyStrOid(page, n2 - 1));
            int n46 = BtreePage.getnItems(page7);
            int n47 = (n33 + n46) * 8 + BtreePage.getSize(page5) + BtreePage.getSize(page7);
            if (n4 != 1) {
                n47 += BtreePage.getKeyStrSize(page, n2 - 1) + 16;
            }
            if (n47 > 4092) {
                int n48;
                int n49;
                int n50;
                storageImpl.pool.unfix(page7);
                page7 = storageImpl.putPage(BtreePage.getKeyStrOid(page, n2 - 1));
                int n51 = BtreePage.getSize(page5);
                int n52 = BtreePage.getSize(page7);
                if (n4 != 1) {
                    n50 = BtreePage.getKeyStrSize(page, n2 - 1);
                    n49 = BtreePage.getKeyStrSize(page7, n46 - 1);
                } else {
                    n50 = n49 = BtreePage.getKeyStrSize(page7, n46 - 1);
                }
                int n53 = 0;
                int n54 = n33 * 8 + n51 - (n46 * 8 + n52);
                while (true) {
                    if ((n48 = (n33 + ++n53) * 8 + n51 + n50 - ((n46 - n53) * 8 + n52 - n49)) >= 0) {
                        if (n48 < -n54) break;
                        --n53;
                        break;
                    }
                    n54 = n48;
                    n51 += n50;
                    n52 -= n49;
                    if (n4 != 1) {
                        n50 = n49;
                        n49 = BtreePage.getKeyStrSize(page7, n46 - n53 - 1);
                        continue;
                    }
                    n50 = n49 = BtreePage.getKeyStrSize(page7, n46 - n53 - 1);
                }
                n48 = 0;
                if (n53 > 0) {
                    int n55;
                    int n56 = n53;
                    Assert.that(n53 < n46);
                    if (n4 != 1) {
                        BtreePage.setSize(page7, BtreePage.getSize(page7) - BtreePage.getKeyStrSize(page7, n46 - n56));
                        BtreePage.memcpy(page5, n53, page5, 0, n33 + 1, 8);
                        BtreePage.setKeyStrOid(page5, --n56, BtreePage.getKeyStrOid(page7, n46));
                        n55 = BtreePage.getKeyStrSize(page, n2 - 1);
                        BtreePage.setKeyStrSize(page5, n56, n55);
                        BtreePage.setSize(page5, BtreePage.getSize(page5) + n55);
                        BtreePage.setKeyStrOffs(page5, n56, 4092 - BtreePage.getSize(page5));
                        BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, n56), page, BtreePage.getKeyStrOffs(page, n2 - 1), n55, 1);
                    } else {
                        BtreePage.memcpy(page5, n53, page5, 0, n33, 8);
                    }
                    for (int i5 = 0; i5 < n56; ++i5) {
                        n55 = BtreePage.getKeyStrSize(page7, n46 - n56 + i5);
                        BtreePage.setSize(page5, BtreePage.getSize(page5) + n55);
                        BtreePage.setSize(page7, BtreePage.getSize(page7) - n55);
                        BtreePage.setKeyStrOffs(page5, i5, 4092 - BtreePage.getSize(page5));
                        BtreePage.setKeyStrSize(page5, i5, n55);
                        BtreePage.setKeyStrOid(page5, i5, BtreePage.getKeyStrOid(page7, n46 - n56 + i5));
                        BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, i5), page7, BtreePage.getKeyStrOffs(page7, n46 - n56 + i5), n55, 1);
                    }
                    BtreePage.setnItems(page5, n33 += n53);
                    btreeKey.getByteArray(page7, n46 - n56 - 1);
                    n48 = BtreePage.replaceByteArrayKey(storageImpl, page, n2 - 1, btreeKey, n4);
                    BtreePage.setnItems(page7, BtreePage.compactifyByteArrays(page7, -n53));
                }
                storageImpl.pool.unfix(page5);
                storageImpl.pool.unfix(page7);
                return n48;
            }
            if (n4 != 1) {
                BtreePage.memcpy(page5, n46 + 1, page5, 0, n33 + 1, 8);
                n32 = BtreePage.getKeyStrSize(page, n2 - 1);
                BtreePage.setKeyStrSize(page5, n46, n32);
                BtreePage.setSize(page5, BtreePage.getSize(page5) + n32);
                BtreePage.setKeyStrOffs(page5, n46, 4092 - BtreePage.getSize(page5));
                BtreePage.setKeyStrOid(page5, n46, BtreePage.getKeyStrOid(page7, n46));
                BtreePage.memcpy(page5, BtreePage.getKeyStrOffs(page5, n46), page, BtreePage.getKeyStrOffs(page, n2 - 1), n32, 1);
                ++n33;
            } else {
                BtreePage.memcpy(page5, n46, page5, 0, n33, 8);
            }
            for (n32 = 0; n32 < n46; ++n32) {
                BtreePage.setKeyStrOid(page5, n32, BtreePage.getKeyStrOid(page7, n32));
                BtreePage.setKeyStrSize(page5, n32, BtreePage.getKeyStrSize(page7, n32));
                BtreePage.setKeyStrOffs(page5, n32, BtreePage.getKeyStrOffs(page7, n32) - BtreePage.getSize(page5));
            }
            BtreePage.setnItems(page5, n33 += n46);
            BtreePage.setSize(page5, BtreePage.getSize(page5) + BtreePage.getSize(page7));
            BtreePage.memcpy(page5, 4092 - BtreePage.getSize(page5), page7, 4092 - BtreePage.getSize(page7), BtreePage.getSize(page7), 1);
            storageImpl.pool.unfix(page5);
            storageImpl.pool.unfix(page7);
            storageImpl.freePage(BtreePage.getKeyStrOid(page, n2 - 1));
            return BtreePage.removeByteArrayKey(page, n2 - 1);
        }
        Page page8 = storageImpl.putPage(BtreePage.getReference(page, 1023 - n2 - 1));
        int n57 = BtreePage.getnItems(page8);
        int n58 = ClassDescriptor.sizeof[n3];
        if (n2 < n6) {
            int n59;
            Page page9 = storageImpl.getPage(BtreePage.getReference(page, 1023 - n2 - 2));
            int n60 = BtreePage.getnItems(page9);
            Assert.that(n60 >= n57);
            if (n4 != 1) {
                BtreePage.memcpy(page8, n57, page, n2, 1, n58);
                ++n57;
                ++n60;
            }
            if ((n59 = (n57 + n60) * (4 + n58)) > 4092) {
                int n61 = n60 - (n57 + n60 >> 1);
                storageImpl.pool.unfix(page9);
                page9 = storageImpl.putPage(BtreePage.getReference(page, 1023 - n2 - 2));
                BtreePage.memcpy(page8, n57, page9, 0, n61, n58);
                BtreePage.memcpy(page9, 0, page9, n61, n60 - n61, n58);
                BtreePage.memcpy(page8, 1023 - n57 - n61, page9, 1023 - n61, n61, 4);
                BtreePage.memcpy(page9, 1023 - n60 + n61, page9, 1023 - n60, n60 - n61, 4);
                BtreePage.memcpy(page, n2, page8, n57 + n61 - 1, 1, n58);
                BtreePage.setnItems(page9, BtreePage.getnItems(page9) - n61);
                BtreePage.setnItems(page8, BtreePage.getnItems(page8) + n61);
                storageImpl.pool.unfix(page8);
                storageImpl.pool.unfix(page9);
                return 0;
            }
            BtreePage.memcpy(page8, n57, page9, 0, n60, n58);
            BtreePage.memcpy(page8, 1023 - n57 - n60, page9, 1023 - n60, n60, 4);
            storageImpl.freePage(BtreePage.getReference(page, 1023 - n2 - 2));
            BtreePage.memcpy(page, 1023 - n6, page, 1023 - n6 - 1, n6 - n2 - 1, 4);
            BtreePage.memcpy(page, n2, page, n2 + 1, n6 - n2 - 1, n58);
            BtreePage.setnItems(page8, BtreePage.getnItems(page8) + n60);
            BtreePage.setnItems(page, n6 - 1);
            storageImpl.pool.unfix(page8);
            storageImpl.pool.unfix(page9);
            return n6 * (n58 + 4) < 2046 ? 2 : 0;
        }
        Page page10 = storageImpl.getPage(BtreePage.getReference(page, 1023 - n2));
        int n62 = BtreePage.getnItems(page10);
        Assert.that(n62 >= n57);
        if (n4 != 1) {
            ++n57;
            ++n62;
        }
        if ((n5 = (n57 + n62) * (4 + n58)) > 4092) {
            int n63 = n62 - (n57 + n62 >> 1);
            storageImpl.pool.unfix(page10);
            page10 = storageImpl.putPage(BtreePage.getReference(page, 1023 - n2));
            BtreePage.memcpy(page8, n63, page8, 0, n57, n58);
            BtreePage.memcpy(page8, 0, page10, n62 - n63, n63, n58);
            BtreePage.memcpy(page8, 1023 - n57 - n63, page8, 1023 - n57, n57, 4);
            BtreePage.memcpy(page8, 1023 - n63, page10, 1023 - n62, n63, 4);
            if (n4 != 1) {
                BtreePage.memcpy(page8, n63 - 1, page, n2 - 1, 1, n58);
            }
            BtreePage.memcpy(page, n2 - 1, page10, n62 - n63 - 1, 1, n58);
            BtreePage.setnItems(page10, BtreePage.getnItems(page10) - n63);
            BtreePage.setnItems(page8, BtreePage.getnItems(page8) + n63);
            storageImpl.pool.unfix(page8);
            storageImpl.pool.unfix(page10);
            return 0;
        }
        BtreePage.memcpy(page8, n62, page8, 0, n57, n58);
        BtreePage.memcpy(page8, 0, page10, 0, n62, n58);
        BtreePage.memcpy(page8, 1023 - n57 - n62, page8, 1023 - n57, n57, 4);
        BtreePage.memcpy(page8, 1023 - n62, page10, 1023 - n62, n62, 4);
        if (n4 != 1) {
            BtreePage.memcpy(page8, n62 - 1, page, n2 - 1, 1, n58);
        }
        storageImpl.freePage(BtreePage.getReference(page, 1023 - n2));
        BtreePage.setReference(page, 1023 - n2, BtreePage.getReference(page, 1023 - n2 - 1));
        BtreePage.setnItems(page8, BtreePage.getnItems(page8) + n62);
        BtreePage.setnItems(page, n6 - 1);
        storageImpl.pool.unfix(page8);
        storageImpl.pool.unfix(page10);
        return n6 * (n58 + 4) < 2046 ? 2 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int remove(StorageImpl storageImpl, int n2, Btree btree, BtreeKey btreeKey, int n3) {
        int n4;
        Page page;
        block42: {
            int n5;
            block41: {
                page = storageImpl.getPage(n2);
                try {
                    int n6;
                    int n7 = BtreePage.getnItems(page);
                    int n8 = 0;
                    int n9 = n7;
                    if (btree.type == 8) {
                        while (n8 < n9) {
                            int n10 = n8 + n9 >> 1;
                            if (BtreePage.compareStr(btreeKey.key, page, n10) > 0) {
                                n8 = n10 + 1;
                                continue;
                            }
                            n9 = n10;
                        }
                        if (--n3 != 0) {
                            do {
                                switch (BtreePage.remove(storageImpl, BtreePage.getKeyStrOid(page, n9), btree, btreeKey, n3)) {
                                    case 2: {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        int n11 = BtreePage.handlePageUnderflow(storageImpl, page, n9, btree.type, btreeKey, n3);
                                        Object var14_19 = null;
                                        if (page == null) return n11;
                                        storageImpl.pool.unfix(page);
                                        return n11;
                                    }
                                    case 0: {
                                        int n12 = 0;
                                        Object var14_20 = null;
                                        if (page == null) return n12;
                                        storageImpl.pool.unfix(page);
                                        return n12;
                                    }
                                    case 1: {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        int n13 = BtreePage.insertStrKey(storageImpl, page, n9, btreeKey, n3);
                                        Object var14_21 = null;
                                        if (page == null) return n13;
                                        storageImpl.pool.unfix(page);
                                        return n13;
                                    }
                                }
                            } while (++n9 <= n7);
                        } else {
                            while (n9 < n7 && BtreePage.compareStr(btreeKey.key, page, n9) == 0) {
                                n6 = BtreePage.getKeyStrOid(page, n9);
                                if (n6 == btreeKey.oid || btreeKey.oid == 0) {
                                    btreeKey.oldOid = n6;
                                    storageImpl.pool.unfix(page);
                                    page = null;
                                    page = storageImpl.putPage(n2);
                                    int n14 = BtreePage.removeStrKey(page, n9);
                                    Object var14_22 = null;
                                    if (page == null) return n14;
                                    storageImpl.pool.unfix(page);
                                    return n14;
                                }
                                ++n9;
                            }
                        }
                    } else if (btree.type == 21) {
                        while (n8 < n9) {
                            int n15 = n8 + n9 >> 1;
                            if (btree.compareByteArrays(btreeKey.key, page, n15) > 0) {
                                n8 = n15 + 1;
                                continue;
                            }
                            n9 = n15;
                        }
                        if (--n3 != 0) {
                            do {
                                switch (BtreePage.remove(storageImpl, BtreePage.getKeyStrOid(page, n9), btree, btreeKey, n3)) {
                                    case 2: {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        int n16 = BtreePage.handlePageUnderflow(storageImpl, page, n9, btree.type, btreeKey, n3);
                                        Object var14_23 = null;
                                        if (page == null) return n16;
                                        storageImpl.pool.unfix(page);
                                        return n16;
                                    }
                                    case 0: {
                                        int n17 = 0;
                                        Object var14_24 = null;
                                        if (page == null) return n17;
                                        storageImpl.pool.unfix(page);
                                        return n17;
                                    }
                                    case 1: {
                                        storageImpl.pool.unfix(page);
                                        page = null;
                                        page = storageImpl.putPage(n2);
                                        int n18 = BtreePage.insertByteArrayKey(storageImpl, page, n9, btreeKey, n3);
                                        Object var14_25 = null;
                                        if (page == null) return n18;
                                        storageImpl.pool.unfix(page);
                                        return n18;
                                    }
                                }
                            } while (++n9 <= n7);
                        } else {
                            while (n9 < n7 && btree.compareByteArrays(btreeKey.key, page, n9) == 0) {
                                n6 = BtreePage.getKeyStrOid(page, n9);
                                if (n6 == btreeKey.oid || btreeKey.oid == 0) {
                                    btreeKey.oldOid = n6;
                                    storageImpl.pool.unfix(page);
                                    page = null;
                                    page = storageImpl.putPage(n2);
                                    int n19 = BtreePage.removeByteArrayKey(page, n9);
                                    Object var14_26 = null;
                                    if (page == null) return n19;
                                    storageImpl.pool.unfix(page);
                                    return n19;
                                }
                                ++n9;
                            }
                        }
                    } else {
                        n6 = ClassDescriptor.sizeof[btree.type];
                        while (n8 < n9) {
                            int n20 = n8 + n9 >> 1;
                            if (BtreePage.compare(btreeKey.key, page, n20) > 0) {
                                n8 = n20 + 1;
                                continue;
                            }
                            n9 = n20;
                        }
                        if (--n3 == 0) {
                            int n21 = btreeKey.oid;
                            while (n9 < n7 && BtreePage.compare(btreeKey.key, page, n9) == 0) {
                                if (BtreePage.getReference(page, 1023 - n9 - 1) == n21 || n21 == 0) {
                                    btreeKey.oldOid = BtreePage.getReference(page, 1023 - n9 - 1);
                                    storageImpl.pool.unfix(page);
                                    page = null;
                                    page = storageImpl.putPage(n2);
                                    BtreePage.memcpy(page, n9, page, n9 + 1, n7 - n9 - 1, n6);
                                    BtreePage.memcpy(page, 1023 - n7 + 1, page, 1023 - n7, n7 - n9 - 1, 4);
                                    BtreePage.setnItems(page, --n7);
                                    n5 = n7 * (n6 + 4) < 2046 ? 2 : 0;
                                    break block41;
                                }
                                ++n9;
                            }
                            n4 = 3;
                            break block42;
                        }
                        do {
                            switch (BtreePage.remove(storageImpl, BtreePage.getReference(page, 1023 - n9 - 1), btree, btreeKey, n3)) {
                                case 2: {
                                    storageImpl.pool.unfix(page);
                                    page = null;
                                    page = storageImpl.putPage(n2);
                                    int n22 = BtreePage.handlePageUnderflow(storageImpl, page, n9, btree.type, btreeKey, n3);
                                    Object var14_29 = null;
                                    if (page == null) return n22;
                                    storageImpl.pool.unfix(page);
                                    return n22;
                                }
                                case 0: {
                                    int n23 = 0;
                                    Object var14_30 = null;
                                    if (page == null) return n23;
                                    storageImpl.pool.unfix(page);
                                    return n23;
                                }
                            }
                        } while (++n9 <= n7);
                    }
                    n6 = 3;
                    Object var14_31 = null;
                    if (page == null) return n6;
                    storageImpl.pool.unfix(page);
                    return n6;
                }
                catch (Throwable throwable) {
                    Object var14_32 = null;
                    if (page == null) throw throwable;
                    storageImpl.pool.unfix(page);
                    throw throwable;
                }
            }
            Object var14_27 = null;
            if (page == null) return n5;
            storageImpl.pool.unfix(page);
            return n5;
        }
        Object var14_28 = null;
        if (page == null) return n4;
        storageImpl.pool.unfix(page);
        return n4;
    }

    static void purge(StorageImpl storageImpl, int n2, int n3, int n4) {
        if (--n4 != 0) {
            Page page = storageImpl.getPage(n2);
            int n5 = BtreePage.getnItems(page) + 1;
            if (n3 == 8 || n3 == 21) {
                while (--n5 >= 0) {
                    BtreePage.purge(storageImpl, BtreePage.getKeyStrOid(page, n5), n3, n4);
                }
            } else {
                while (--n5 >= 0) {
                    BtreePage.purge(storageImpl, BtreePage.getReference(page, 1023 - n5 - 1), n3, n4);
                }
            }
            storageImpl.pool.unfix(page);
        }
        storageImpl.freePage(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int traverseForward(StorageImpl storageImpl, int n2, int n3, int n4, IPersistent[] iPersistentArray, int n5) {
        Page page = storageImpl.getPage(n2);
        try {
            int n6 = BtreePage.getnItems(page);
            if (--n4 != 0) {
                if (n3 == 8 || n3 == 21) {
                    for (int i2 = 0; i2 <= n6; ++i2) {
                        n5 = BtreePage.traverseForward(storageImpl, BtreePage.getKeyStrOid(page, i2), n3, n4, iPersistentArray, n5);
                    }
                } else {
                    for (int i3 = 0; i3 <= n6; ++i3) {
                        n5 = BtreePage.traverseForward(storageImpl, BtreePage.getReference(page, 1023 - i3 - 1), n3, n4, iPersistentArray, n5);
                    }
                }
            } else if (n3 == 8 || n3 == 21) {
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n7 = BtreePage.getKeyStrOid(page, i4);
                    iPersistentArray[n5++] = storageImpl.lookupObject(n7, null);
                }
            } else {
                for (int i5 = 0; i5 < n6; ++i5) {
                    int n8 = BtreePage.getReference(page, 1022 - i5);
                    iPersistentArray[n5++] = storageImpl.lookupObject(n8, null);
                }
            }
            int n9 = n5;
            return n9;
        }
        finally {
            storageImpl.pool.unfix(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int markPage(StorageImpl storageImpl, int n2, int n3, int n4) {
        int n5 = 1;
        Page page = storageImpl.getGCPage(n2);
        try {
            int n6 = BtreePage.getnItems(page);
            if (--n4 != 0) {
                if (n3 == 8 || n3 == 21) {
                    for (int i2 = 0; i2 <= n6; ++i2) {
                        n5 += BtreePage.markPage(storageImpl, BtreePage.getKeyStrOid(page, i2), n3, n4);
                    }
                } else {
                    for (int i3 = 0; i3 <= n6; ++i3) {
                        n5 += BtreePage.markPage(storageImpl, BtreePage.getReference(page, 1023 - i3 - 1), n3, n4);
                    }
                }
            } else if (n3 == 8 || n3 == 21) {
                for (int i4 = 0; i4 < n6; ++i4) {
                    storageImpl.markOid(BtreePage.getKeyStrOid(page, i4));
                }
            } else {
                for (int i5 = 0; i5 < n6; ++i5) {
                    storageImpl.markOid(BtreePage.getReference(page, 1022 - i5));
                }
            }
        }
        finally {
            storageImpl.pool.unfix(page);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exportPage(StorageImpl storageImpl, XMLExporter xMLExporter, int n2, int n3, int n4) throws IOException {
        Page page = storageImpl.getPage(n2);
        try {
            int n5 = BtreePage.getnItems(page);
            if (--n4 != 0) {
                if (n3 == 8 || n3 == 21) {
                    for (int i2 = 0; i2 <= n5; ++i2) {
                        BtreePage.exportPage(storageImpl, xMLExporter, BtreePage.getKeyStrOid(page, i2), n3, n4);
                    }
                } else {
                    for (int i3 = 0; i3 <= n5; ++i3) {
                        BtreePage.exportPage(storageImpl, xMLExporter, BtreePage.getReference(page, 1023 - i3 - 1), n3, n4);
                    }
                }
            } else if (n3 == 8 || n3 == 21) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    xMLExporter.exportAssoc(BtreePage.getKeyStrOid(page, i4), page.data, 4 + BtreePage.getKeyStrOffs(page, i4), BtreePage.getKeyStrSize(page, i4), n3);
                }
            } else {
                for (int i5 = 0; i5 < n5; ++i5) {
                    xMLExporter.exportAssoc(BtreePage.getReference(page, 1022 - i5), page.data, 4 + i5 * ClassDescriptor.sizeof[n3], ClassDescriptor.sizeof[n3], n3);
                }
            }
        }
        finally {
            storageImpl.pool.unfix(page);
        }
    }
}

