/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.Assert;
import org.garret.perst.Key;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;

class BtreeKey {
    Key key;
    int oid;
    int oldOid;

    BtreeKey(Key key, int n2) {
        this.key = key;
        this.oid = n2;
    }

    final void getStr(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2);
        int n4 = 4 + BtreePage.getKeyStrOffs(page, n2);
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = (char)Bytes.unpack2(page.data, n4);
            n4 += 2;
        }
        this.key = new Key(cArray);
    }

    final void getByteArray(Page page, int n2) {
        int n3 = BtreePage.getKeyStrSize(page, n2);
        int n4 = 4 + BtreePage.getKeyStrOffs(page, n2);
        byte[] byArray = new byte[n3];
        System.arraycopy(page.data, n4, byArray, 0, n3);
        this.key = new Key(byArray);
    }

    final void extract(Page page, int n2, int n3) {
        byte[] byArray = page.data;
        switch (n3) {
            case 0: {
                this.key = new Key(byArray[n2] != 0);
                break;
            }
            case 1: {
                this.key = new Key(byArray[n2]);
                break;
            }
            case 3: {
                this.key = new Key(Bytes.unpack2(byArray, n2));
                break;
            }
            case 2: {
                this.key = new Key((char)Bytes.unpack2(byArray, n2));
                break;
            }
            case 4: 
            case 10: {
                this.key = new Key(Bytes.unpack4(byArray, n2));
                break;
            }
            case 5: 
            case 9: {
                this.key = new Key(Bytes.unpack8(byArray, n2));
                break;
            }
            case 6: {
                this.key = new Key(Float.intBitsToFloat(Bytes.unpack4(byArray, n2)));
                break;
            }
            case 7: {
                this.key = new Key(Double.longBitsToDouble(Bytes.unpack8(byArray, n2)));
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
    }

    final void pack(Page page, int n2) {
        byte[] byArray = page.data;
        switch (this.key.type) {
            case 0: 
            case 1: {
                byArray[4 + n2] = (byte)this.key.ival;
                break;
            }
            case 2: 
            case 3: {
                Bytes.pack2(byArray, 4 + n2 * 2, (short)this.key.ival);
                break;
            }
            case 4: 
            case 10: {
                Bytes.pack4(byArray, 4 + n2 * 4, this.key.ival);
                break;
            }
            case 5: 
            case 9: {
                Bytes.pack8(byArray, 4 + n2 * 8, this.key.lval);
                break;
            }
            case 6: {
                Bytes.pack4(byArray, 4 + n2 * 4, Float.floatToIntBits((float)this.key.dval));
                break;
            }
            case 7: {
                Bytes.pack8(byArray, 4 + n2 * 8, Double.doubleToLongBits(this.key.dval));
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
        Bytes.pack4(byArray, 4 + (1023 - n2 - 1) * 4, this.oid);
    }
}

