/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.Assert;
import org.garret.perst.IValue;

public class Rectangle
implements IValue,
Cloneable {
    private int top;
    private int left;
    private int bottom;
    private int right;

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final int getRight() {
        return this.right;
    }

    public final long area() {
        return (long)(this.bottom - this.top) * (long)(this.right - this.left);
    }

    public static long joinArea(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = rectangle.left < rectangle2.left ? rectangle.left : rectangle2.left;
        int n3 = rectangle.right > rectangle2.right ? rectangle.right : rectangle2.right;
        int n4 = rectangle.top < rectangle2.top ? rectangle.top : rectangle2.top;
        int n5 = rectangle.bottom > rectangle2.bottom ? rectangle.bottom : rectangle2.bottom;
        return (long)(n5 - n4) * (long)(n3 - n2);
    }

    public Object clone() {
        try {
            Rectangle rectangle = (Rectangle)super.clone();
            rectangle.top = this.top;
            rectangle.left = this.left;
            rectangle.bottom = this.bottom;
            rectangle.right = this.right;
            return rectangle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Rectangle(Rectangle rectangle) {
        this.top = rectangle.top;
        this.left = rectangle.left;
        this.bottom = rectangle.bottom;
        this.right = rectangle.right;
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        Assert.that(n2 <= n4 && n3 <= n5);
        this.top = n2;
        this.left = n3;
        this.bottom = n4;
        this.right = n5;
    }

    public Rectangle() {
    }

    public final void join(Rectangle rectangle) {
        if (this.left > rectangle.left) {
            this.left = rectangle.left;
        }
        if (this.right < rectangle.right) {
            this.right = rectangle.right;
        }
        if (this.top > rectangle.top) {
            this.top = rectangle.top;
        }
        if (this.bottom < rectangle.bottom) {
            this.bottom = rectangle.bottom;
        }
    }

    public static Rectangle join(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = new Rectangle(rectangle);
        rectangle3.join(rectangle2);
        return rectangle3;
    }

    public final boolean intersects(Rectangle rectangle) {
        return this.left <= rectangle.right && this.top <= rectangle.bottom && this.right >= rectangle.left && this.bottom >= rectangle.top;
    }

    public final boolean contains(Rectangle rectangle) {
        return this.left <= rectangle.left && this.top <= rectangle.top && this.right >= rectangle.right && this.bottom >= rectangle.bottom;
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.left == rectangle.left && this.top == rectangle.top && this.right == rectangle.right && this.bottom == rectangle.bottom;
        }
        return false;
    }

    public int hashCode() {
        return this.top ^ this.bottom << 1 ^ this.left << 2 ^ this.right << 3;
    }

    public String toString() {
        return "top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right;
    }
}

