/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.xmlrules;

import java.net.URL;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.RuleSetBase;
import org.apache.commons.gs.digester.xmlrules.DigesterRuleParser;
import org.apache.commons.gs.digester.xmlrules.XmlLoadException;
import org.xml.sax.InputSource;

public class FromXmlRuleSet
extends RuleSetBase {
    public static final String DIGESTER_DTD_PATH = "org/apache/commons/digester/xmlrules/digester-rules.dtd";
    private XMLRulesLoader rulesLoader;
    private DigesterRuleParser parser;
    private Digester rulesDigester;

    public FromXmlRuleSet(URL uRL) {
        this(uRL, new DigesterRuleParser(), new Digester());
    }

    public FromXmlRuleSet(URL uRL, Digester digester) {
        this(uRL, new DigesterRuleParser(), digester);
    }

    public FromXmlRuleSet(URL uRL, DigesterRuleParser digesterRuleParser) {
        this(uRL, digesterRuleParser, new Digester());
    }

    public FromXmlRuleSet(URL uRL, DigesterRuleParser digesterRuleParser, Digester digester) {
        this.init(new URLXMLRulesLoader(uRL), digesterRuleParser, digester);
    }

    public FromXmlRuleSet(InputSource inputSource) {
        this(inputSource, new DigesterRuleParser(), new Digester());
    }

    public FromXmlRuleSet(InputSource inputSource, Digester digester) {
        this(inputSource, new DigesterRuleParser(), digester);
    }

    public FromXmlRuleSet(InputSource inputSource, DigesterRuleParser digesterRuleParser) {
        this(inputSource, digesterRuleParser, new Digester());
    }

    public FromXmlRuleSet(InputSource inputSource, DigesterRuleParser digesterRuleParser, Digester digester) {
        this.init(new InputSourceXMLRulesLoader(inputSource), digesterRuleParser, digester);
    }

    private void init(XMLRulesLoader xMLRulesLoader, DigesterRuleParser digesterRuleParser, Digester digester) {
        this.rulesLoader = xMLRulesLoader;
        this.parser = digesterRuleParser;
        this.rulesDigester = digester;
    }

    public void addRuleInstances(Digester digester) throws XmlLoadException {
        this.addRuleInstances(digester, null);
    }

    public void addRuleInstances(Digester digester, String string) throws XmlLoadException {
        URL uRL = this.getClass().getClassLoader().getResource(DIGESTER_DTD_PATH);
        if (uRL == null) {
            throw new XmlLoadException("Cannot find resource \"org/apache/commons/digester/xmlrules/digester-rules.dtd\"");
        }
        this.parser.setDigesterRulesDTD(uRL.toString());
        this.parser.setTarget(digester);
        this.parser.setBasePath(string);
        this.rulesDigester.addRuleSet(this.parser);
        this.rulesDigester.push(this.parser);
        this.rulesLoader.loadRules();
    }

    public static class 1 {
    }

    private class InputSourceXMLRulesLoader
    extends XMLRulesLoader {
        private InputSource inputSource;

        public InputSourceXMLRulesLoader(InputSource inputSource) {
            super(null);
            this.inputSource = inputSource;
        }

        public void loadRules() throws XmlLoadException {
            try {
                FromXmlRuleSet.this.rulesDigester.parse(this.inputSource);
            }
            catch (Exception exception) {
                throw new XmlLoadException(exception);
            }
        }
    }

    private class URLXMLRulesLoader
    extends XMLRulesLoader {
        private URL url;

        public URLXMLRulesLoader(URL uRL) {
            super(null);
            this.url = uRL;
        }

        public void loadRules() throws XmlLoadException {
            try {
                FromXmlRuleSet.this.rulesDigester.parse(this.url.openStream());
            }
            catch (Exception exception) {
                throw new XmlLoadException(exception);
            }
        }
    }

    private static abstract class XMLRulesLoader {
        private XMLRulesLoader() {
        }

        public abstract void loadRules() throws XmlLoadException;

        public /* synthetic */ XMLRulesLoader(1 var1_1) {
            this();
        }
    }
}

