/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.gs.digester.plugins.strategies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.gs.digester.Digester;
import org.apache.commons.gs.digester.plugins.PluginException;
import org.apache.commons.gs.digester.plugins.RuleLoader;
import org.apache.commons.gs.digester.xmlrules.FromXmlRuleSet;
import org.xml.sax.InputSource;

public class LoaderFromStream
extends RuleLoader {
    private byte[] input;
    private FromXmlRuleSet ruleSet;

    public LoaderFromStream(InputStream inputStream) throws Exception {
        this.load(inputStream);
    }

    private void load(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        this.input = byteArrayOutputStream.toByteArray();
    }

    public void addRules(Digester digester, String string) throws PluginException {
        Logger logger = digester.getLogger();
        boolean bl2 = logger.isLoggable(Level.FINE);
        if (bl2) {
            logger.fine("LoaderFromStream: loading rules for plugin at path [" + string + "]");
        }
        InputSource inputSource = new InputSource(new ByteArrayInputStream(this.input));
        FromXmlRuleSet fromXmlRuleSet = new FromXmlRuleSet(inputSource);
        fromXmlRuleSet.addRuleInstances(digester, string);
    }
}

