/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.benchmark;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.Trace2DLtd;
import com.j_spaces.cli.RuntimeInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.cluster.JSpaceClusteredProxy;
import com.j_spaces.examples.benchmark.BenchmarkOutput;
import com.j_spaces.examples.benchmark.BenchmarkTest;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.map.CacheFinder;
import com.j_spaces.map.IMap;
import com.j_spaces.obf.dn;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.benchmark.BenchmarkGUIConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GigaBenchmark
implements BenchmarkOutput,
ActionListener,
ItemListener {
    private JLabel commitLabel2;
    private JLabel commitLabel1;
    private JFrame parentFrame;
    private JButton stopBtn;
    private JButton startBtn;
    private JButton clearConsoleBtn;
    private JButton chooseBtn;
    private JTextArea consoleOutput;
    private JTextField fNameTextField;
    private JSpinner timeout;
    private JSpinner entrySize;
    private JSpinner batchSize;
    private JSpinner noOfIterations;
    private JSpinner noOfThreads;
    private JSpinner showRate;
    private JSpinner noOfReadOps;
    private JSpinner commitEveryTx;
    private JSpinner samplesBufferSize;
    private JSpinner leaseTime;
    private JTable table;
    private DefaultTableModel tableModel;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private ButtonGroup buttonGroup_2 = new ButtonGroup();
    private ButtonGroup operationGroup = new ButtonGroup();
    private JCheckBox cleanSpace;
    private JCheckBox parallelOps;
    private JCheckBox saveToFileCB;
    private JCheckBox displayThreadsTP;
    private JCheckBox masterLocalCacheCB;
    private JCheckBox noWriteLease;
    private JCheckBox foreverLease;
    private JCheckBox clusteredProxyCheckBox;
    private JComboBox objectTypesCombo;
    private JRadioButton writeTakeOp;
    private JRadioButton writeReadOp;
    private JRadioButton writeNotifyOp;
    private JRadioButton writeOp;
    private JRadioButton takeOp;
    private JRadioButton readOp;
    private JRadioButton noTX;
    private JRadioButton localTX;
    private JRadioButton distributedTX;
    private ButtonGroup mapGroup;
    private JRadioButton putRadio;
    private JRadioButton getRadio;
    private JRadioButton removeRadio;
    private JRadioButton putRemRadio;
    private JRadioButton putGetRadio;
    private JRadioButton javaSpaceRadio;
    private JRadioButton mapRadio;
    private JLabel fNameLabel;
    private JLabel noOfReadLabel;
    private JProgressBar progressBar;
    private Chart2D chart;
    private Trace2DLtd globalTrace;
    private HashMap threadTraces = new HashMap();
    private String theURL;
    private final int INIT_PROGRESS_VALUE = 10;
    private JButton saveConfigurationButton;
    public int _noOfIterations = 0;
    public int _noOfReadOps = 0;
    public int totalOperations = 0;
    public PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
    public BenchmarkTest benchmark = null;
    private JLabel graphLabel = new JLabel();
    private static DefaultComboBoxModel comboBoxModel;
    private JComboBox configurationsCombo;
    private JButton renameConfigurationButton;
    private JButton newConfigurationButton;
    private JButton deleteConfigurationButton;
    private static final String OP_NAME_JAVASPACE = "JavaSpace";
    private static final String OP_NAME_MAP = "Map";
    private static final String ARGUMENT_NAME_TAKE = "-take";
    private static final String ARGUMENT_NAME_READ = "-read";
    private static final String ARGUMENT_NAME_NOTIFY = "-notify";
    private static final String ARGUMENT_NAME_MAP = "-map";
    private static final String ARGUMENT_NAME_ONLY = "-only";
    private static final String ARGUMENT_NAME_SECOND = "second";
    private static final String ARGUMENT_NAME_FIRST = "first";
    public static GigaBenchmark window;
    private ArrayList args = new ArrayList();
    private ArrayList colors = new ArrayList();
    private Iterator colorsIterator;
    private IJSpace theSpace = null;
    private IJSpace regularSpaceProxy = null;
    private JSpaceClusteredProxy clusteredSpaceProxy = null;
    private String spaceName;
    private IMap theCache = null;
    private static final int COLUMN_LEFT = 100;
    private static final int LABEL_WITH = 110;
    private static final int LABEL_HIGH = 20;
    private static final int SPINNER_WITH = 70;
    private static final int SPINNER_HIGH = 20;
    private final Integer DEFAULT_REGULAR_TIMEOUT = new Integer(0);
    private final Integer DEFAULT_PARALLEL_TIMEOUT = new Integer(5000);
    private String curSpaceURL;
    private String hostName = "localhost";
    private static Map allConfigurationsMap;
    private static Vector allConfigNamesVector;
    private static final String locationDirPath;
    private static final String configFileExtension = ".xml";
    private static final String DEFAULT_CONFIG_NAME = "default";
    private static final String ROOT_NAME = "benchmarkConfig";
    private static final String ELEMENT_NAME = "name";
    private static final String OPTION_TAG_NAME = "option";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String NAME_THREADS = "Threads";
    private static final String NAME_ITERATIONS = "Iterations";
    private static final String NAME_ENTRY_SIZE = "EntrySize";
    private static final String NAME_SAMPLING_RATE = "SamplingRate";
    private static final String NAME_BATCH_SIZE = "BatchSize";
    private static final String NAME_READ_TAKE_TIMEOUT = "ReadTakeTimeout";
    private static final String NAME_OBJECT_TYPE = "ObjectType";
    private static final String NAME_NO_WRITE_LEASE = "NoWriteLease";
    private static final String NAME_FOREVER_LEASE = "ForeverLease";
    private static final String NAME_LEASE_TIME = "LeaseTime";
    private static final String NAME_CLUSTERED_PROXY = "ClusteredProxy";
    private static final String NAME_DISPLAY_THREADS_THROUGHPUT = "DisplayThreadsThroughput";
    private static final String NAME_CLEAN_SPACE = "CleanSpace";
    private static final String NAME_OPERATION_TYPE = "OperationType";
    private static final String NAME_OPERATION_NAME = "OperationName";
    private static final String NAME_PARALLEL_OPERATIONS = "ParallelOperations";
    private static final String NAME_REPEAT_READ = "RepeatRead";
    private static final String NAME_TRANSACTION_TYPE = "TransactionType";
    private static final String NAME_COMMIT_EVERY = "CommitEvery";
    private static final String NAME_MASTER_LOCAL_CACHE = "MasterLocalCache";
    private static final String NAME_CACHE_TYPE = "CacheType";
    private ObjectTypeItem objectEntryItem = new ObjectTypeItem("Entry", "entry");
    private ObjectTypeItem objectPojoItem = new ObjectTypeItem("POJO", "pojo");
    private ObjectTypeItem objectExternItem = new ObjectTypeItem("Externalizable", "ext");
    private ObjectTypeItem objectSerializableItem = new ObjectTypeItem("Serializable", "ser");
    private ObjectTypeItem objectFifoItem = new ObjectTypeItem("FIFO", "fifo");
    private ObjectTypeItem objectUidItem = new ObjectTypeItem("UID", "uid");
    private ObjectTypeItem[] objectTypeItems = new ObjectTypeItem[]{this.objectEntryItem, this.objectPojoItem, this.objectExternItem, this.objectSerializableItem, this.objectFifoItem, this.objectUidItem};
    private Map objectTypeItemsMap = new HashMap();
    private static Logger _logger;
    private static final String NAME_SAVE_RESULTS_TO_FILE = "SaveResultsToFile";
    private static final String NAME_FILE_NAME = "FileName";
    private ConfigurationNameDialog renameConfigurationDialog;
    private ConfigurationNameDialog newConfigurationDialog;
    private static DocumentBuilderFactory factory;
    private static DocumentBuilder builder;

    public void restore() {
        window = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GigaBenchmark(JFrame jFrame, JPanel jPanel, IJSpace iJSpace, String string, String string2) {
        window = this;
        this.parentFrame = jFrame;
        this.spaceName = string;
        this.hostName = string2;
        ObjectTypeItem[] objectTypeItemArray = this.objectTypeItems;
        int n2 = objectTypeItemArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectTypeItem objectTypeItem = objectTypeItemArray[i2];
            this.objectTypeItemsMap.put(objectTypeItem.getMessageTypeParameterName(), objectTypeItem);
        }
        boolean bl2 = false;
        try {
            if (iJSpace instanceof JSpaceClusteredProxy) {
                this.clusteredSpaceProxy = (JSpaceClusteredProxy)iJSpace;
                this.regularSpaceProxy = this.clusteredSpaceProxy.getContainer().getSpace(string, this.clusteredSpaceProxy.isEmbedded());
                bl2 = true;
            } else {
                this.regularSpaceProxy = iJSpace;
            }
            this.initialize(jPanel);
        }
        catch (Exception exception) {
            SpaceBrowser.showException(exception.toString(), exception);
        }
        finally {
            this.clusteredProxyCheckBox.setEnabled(bl2);
            this.clusteredProxyCheckBox.setSelected(false);
        }
        this.colors.add(Color.BLUE);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.YELLOW);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.DARK_GRAY);
        this.colors.add(Color.ORANGE);
        this.colors.add(Color.PINK);
        this.colorsIterator = this.colors.iterator();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.configurationsCombo && itemEvent.getStateChange() == 1) {
            String string = itemEvent.getItem().toString();
            boolean bl2 = string.equals(DEFAULT_CONFIG_NAME);
            this.renameConfigurationButton.setEnabled(!bl2);
            this.deleteConfigurationButton.setEnabled(!bl2);
            BenchmarkGUIConfiguration benchmarkGUIConfiguration = (BenchmarkGUIConfiguration)allConfigurationsMap.get(string);
            this.initPanel(benchmarkGUIConfiguration);
        }
    }

    private void initPanel(BenchmarkGUIConfiguration benchmarkGUIConfiguration) {
        if (benchmarkGUIConfiguration == null) {
            return;
        }
        this.noOfThreads.setValue(benchmarkGUIConfiguration.getThreadsNumber());
        this.noOfIterations.setValue(benchmarkGUIConfiguration.getIterationsNumber());
        this.entrySize.setValue(benchmarkGUIConfiguration.getEntrySize());
        this.showRate.setValue(benchmarkGUIConfiguration.getSamplingRate());
        this.batchSize.setValue(benchmarkGUIConfiguration.getBatchesNumber());
        this.timeout.setValue(benchmarkGUIConfiguration.getReadTakeTimeout());
        Object v2 = this.objectTypeItemsMap.get(benchmarkGUIConfiguration.getObjectType());
        if (v2 == null) {
            this.objectTypesCombo.setSelectedIndex(0);
        } else {
            this.objectTypesCombo.setSelectedItem(v2);
        }
        boolean bl2 = benchmarkGUIConfiguration.isForeverLease();
        this.noWriteLease.setSelected(benchmarkGUIConfiguration.isNoWriteLease());
        this.foreverLease.setSelected(bl2);
        this.leaseTime.setEnabled(!bl2);
        if (!bl2) {
            this.leaseTime.setValue(benchmarkGUIConfiguration.getLeaseTime());
        } else {
            this.leaseTime.setValue(((SpinnerNumberModel)this.leaseTime.getModel()).getMinimum());
        }
        this.clusteredProxyCheckBox.setSelected(benchmarkGUIConfiguration.isClusteredProxy());
        this.displayThreadsTP.setSelected(benchmarkGUIConfiguration.isDisplayThreadsThroughput());
        this.cleanSpace.setSelected(benchmarkGUIConfiguration.isCleanSpace());
        String string = benchmarkGUIConfiguration.getOperationType();
        String string2 = benchmarkGUIConfiguration.getOperationName();
        if (string.equals(OP_NAME_JAVASPACE)) {
            this.javaSpaceRadio.setSelected(true);
            if (string2.equals("Write")) {
                this.writeOp.setSelected(true);
            } else if (string2.equals("Read")) {
                this.readOp.setSelected(true);
            } else if (string2.equals("Take")) {
                this.takeOp.setSelected(true);
            } else if (string2.equals("WriteAndRead")) {
                this.writeReadOp.setSelected(true);
            } else if (string2.equals("WriteAndTake")) {
                this.writeTakeOp.setSelected(true);
            } else if (string2.equals("WriteAndNotify")) {
                this.writeNotifyOp.setSelected(true);
            }
            this.selectJavaSpaceRB();
        } else {
            this.mapRadio.setSelected(true);
            if (string2.equals("Put")) {
                this.putRadio.setSelected(true);
            } else if (string2.equals("Get")) {
                this.getRadio.setSelected(true);
            } else if (string2.equals("Remove")) {
                this.removeRadio.setSelected(true);
            } else if (string2.equals("PutAndGet")) {
                this.putGetRadio.setSelected(true);
            } else if (string2.equals("PutAndRemove")) {
                this.putRemRadio.setSelected(true);
            }
            this.selectMapRB();
        }
        this.parallelOps.setSelected(benchmarkGUIConfiguration.isParallelOperations());
        this.noOfReadOps.setValue(benchmarkGUIConfiguration.getRepeatOperationsNumber());
        String string3 = benchmarkGUIConfiguration.getTransactionType();
        if (string3.equals("None")) {
            this.noTX.setSelected(true);
            this.commitEveryTx.setEnabled(false);
        } else if (string3.equals("Local")) {
            this.localTX.setSelected(true);
            this.commitEveryTx.setEnabled(true);
        } else {
            this.distributedTX.setSelected(true);
            this.commitEveryTx.setEnabled(true);
        }
        if (!string3.equals("None")) {
            this.commitEveryTx.setValue(benchmarkGUIConfiguration.getCommitFrequency());
        } else {
            this.commitEveryTx.setValue(((SpinnerNumberModel)this.commitEveryTx.getModel()).getMinimum());
        }
        boolean bl3 = benchmarkGUIConfiguration.isMasterLocalCache();
        this.masterLocalCacheCB.setSelected(bl3);
        boolean bl4 = benchmarkGUIConfiguration.isSaveResultsToFile();
        this.saveToFileCB.setSelected(bl4);
        this.fNameTextField.setText(benchmarkGUIConfiguration.getFileName());
        this.fNameLabel.setEnabled(bl4);
        this.fNameTextField.setEnabled(bl4);
        this.chooseBtn.setEnabled(bl4);
    }

    private void selectJavaSpaceRB() {
        this.setButtonGroupEnabled(this.buttonGroup, true);
        this.setButtonGroupEnabled(this.mapGroup, false);
        this.objectTypesCombo.setEnabled(true);
        boolean bl2 = this.writeReadOp.isSelected() || this.writeTakeOp.isSelected() || this.writeNotifyOp.isSelected();
        this.parallelOps.setEnabled(bl2);
        if (!bl2) {
            this.parallelOps.setSelected(false);
            this.timeout.setValue(this.DEFAULT_REGULAR_TIMEOUT);
        }
        if (this.writeOp.isSelected() || this.writeTakeOp.isSelected() || this.takeOp.isSelected()) {
            this.noOfReadOps.setEnabled(false);
            this.noOfReadLabel.setEnabled(false);
        } else {
            this.noOfReadOps.setEnabled(true);
            this.noOfReadLabel.setEnabled(true);
        }
    }

    private void selectMapRB() {
        this.setButtonGroupEnabled(this.buttonGroup, false);
        this.setButtonGroupEnabled(this.mapGroup, true);
        this.objectTypesCombo.setEnabled(false);
        boolean bl2 = this.putGetRadio.isSelected() || this.putRemRadio.isSelected();
        this.parallelOps.setEnabled(bl2);
        if (!bl2) {
            this.parallelOps.setSelected(false);
            this.timeout.setValue(this.DEFAULT_REGULAR_TIMEOUT);
        }
        if (this.putRadio.isSelected() || this.removeRadio.isSelected() || this.putRemRadio.isSelected()) {
            this.noOfReadOps.setEnabled(false);
            this.noOfReadLabel.setEnabled(false);
        } else {
            this.noOfReadOps.setEnabled(true);
            this.noOfReadLabel.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.javaSpaceRadio) {
            this.selectJavaSpaceRB();
        } else if (object == this.mapRadio) {
            this.selectMapRB();
        } else if (object == this.foreverLease) {
            this.leaseTime.setEnabled(!this.foreverLease.isSelected());
        } else if (object == this.clearConsoleBtn) {
            this.consoleOutput.setText("");
        } else if (object == this.stopBtn) {
            this.benchmark.a(this);
        } else if (object == this.saveConfigurationButton) {
            this.saveConfiguration((String)this.configurationsCombo.getSelectedItem());
        } else if (object == this.renameConfigurationButton) {
            this.renameSelectedConfiguration();
        } else if (object == this.newConfigurationButton) {
            this.createNewConfiguration();
        } else if (object == this.deleteConfigurationButton) {
            this.deleteConfiguration();
        }
    }

    private void createNewConfiguration() {
        if (this.newConfigurationDialog == null) {
            this.newConfigurationDialog = new ConfigurationNameDialog(this.parentFrame, "New Configuration");
            JSpaceUtilities.setCenterAWTWindow(this.newConfigurationDialog);
        }
        String string = (String)this.configurationsCombo.getSelectedItem();
        this.newConfigurationDialog.setVisible("");
        String string2 = this.newConfigurationDialog.getNewName();
        if (string2 == null) {
            return;
        }
        allConfigNamesVector.add(string2);
        comboBoxModel = new DefaultComboBoxModel(allConfigNamesVector);
        this.configurationsCombo.setModel(comboBoxModel);
        this.configurationsCombo.setSelectedItem(string2);
        this.saveConfiguration(string2);
        this.saveConfigurationButton.setEnabled(true);
        this.renameConfigurationButton.setEnabled(true);
        this.deleteConfigurationButton.setEnabled(true);
    }

    private boolean isConfigNameExists(String string) {
        return allConfigNamesVector.contains(string);
    }

    private void renameSelectedConfiguration() {
        if (this.renameConfigurationDialog == null) {
            this.renameConfigurationDialog = new ConfigurationNameDialog(this.parentFrame, "Rename Configuration");
            JSpaceUtilities.setCenterAWTWindow(this.renameConfigurationDialog);
        }
        String string = (String)this.configurationsCombo.getSelectedItem();
        this.renameConfigurationDialog.setVisible(string);
        String string2 = this.renameConfigurationDialog.getNewName();
        if (string2 == null) {
            return;
        }
        int n2 = allConfigNamesVector.indexOf(string);
        allConfigNamesVector.setElementAt(string2, n2);
        comboBoxModel = new DefaultComboBoxModel(allConfigNamesVector);
        this.configurationsCombo.setModel(comboBoxModel);
        this.configurationsCombo.setSelectedIndex(n2);
        File file = new File(locationDirPath + string + configFileExtension);
        boolean bl2 = file.delete();
        this.saveConfiguration(string2);
    }

    private void deleteConfiguration() {
        String string = (String)this.configurationsCombo.getSelectedItem();
        String string2 = "Are you sure you want to delete '" + string + "' Configuration?";
        int n2 = JOptionPane.showConfirmDialog(this.parentFrame, string2, "Delete Configuration", 0, 2);
        if (n2 == 0) {
            allConfigNamesVector.remove(string);
            comboBoxModel = new DefaultComboBoxModel(allConfigNamesVector);
            this.configurationsCombo.setModel(comboBoxModel);
            int n3 = comboBoxModel.getSize();
            String string3 = (String)this.configurationsCombo.getSelectedItem();
            if (n3 == 0) {
                this.renameConfigurationButton.setEnabled(false);
                this.saveConfigurationButton.setEnabled(false);
                this.deleteConfigurationButton.setEnabled(false);
            } else {
                boolean bl2 = string3.equals(DEFAULT_CONFIG_NAME);
                this.renameConfigurationButton.setEnabled(!bl2);
                this.deleteConfigurationButton.setEnabled(!bl2);
            }
            if (string3 != null) {
                BenchmarkGUIConfiguration benchmarkGUIConfiguration = (BenchmarkGUIConfiguration)allConfigurationsMap.get(string3);
                this.initPanel(benchmarkGUIConfiguration);
            }
            File file = new File(locationDirPath + string + configFileExtension);
            file.delete();
        }
    }

    private void setButtonGroupEnabled(ButtonGroup buttonGroup, boolean bl2) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ((JRadioButton)enumeration.nextElement()).setEnabled(bl2);
        }
        if (this.parallelOps != null) {
            this.parallelOps.setEnabled(false);
            this.timeout.setValue(this.DEFAULT_REGULAR_TIMEOUT);
        }
    }

    public void alert(String string) {
        JOptionPane.showMessageDialog(this.parentFrame, string, "Invalid parameter", 0);
        this.stopTest();
    }

    public void stopTest() {
        this.startBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.progressBar.setValue(0);
    }

    public void addThreadTPSample(String string, String string2, String string3, double d2, String string4, String string5, boolean bl2) {
        this.tableModel.insertRow(0, new Object[]{string, string2, string3, dn.q.format(d2), string4, string5});
        if (this.displayThreadsTP.isSelected()) {
            Trace2DLtd trace2DLtd = (Trace2DLtd)this.threadTraces.get(string3);
            if (trace2DLtd == null) {
                trace2DLtd = new Trace2DLtd();
                trace2DLtd.setPhysicalUnits(NAME_ITERATIONS, "TP, msg/sec");
                if (!this.colorsIterator.hasNext()) {
                    this.colorsIterator = this.colors.iterator();
                }
                trace2DLtd.setColor((Color)this.colorsIterator.next());
                trace2DLtd.setName(string3 + " - Throughput");
                this.threadTraces.put(string3, trace2DLtd);
                this.chart.addTrace((ITrace2D)trace2DLtd);
                if (!bl2) {
                    trace2DLtd.addPoint(0.0, 0.0);
                } else {
                    trace2DLtd.addPoint((double)this._noOfIterations, 0.0);
                }
            }
            try {
                double d3 = new Double(string);
                if (bl2) {
                    d3 += (double)this._noOfIterations;
                }
                if (trace2DLtd.getMaxX() <= d3) {
                    System.out.println("Thread TP, iNo = " + d3);
                    trace2DLtd.addPoint(d3, d2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
    }

    public void addGlobalTPSample(String string, double d2, int n2, boolean bl2, boolean bl3) throws Exception {
        block11: {
            System.out.println("globalTP=" + d2);
            try {
                if (this.globalTrace == null) {
                    int n3 = (Integer)this.samplesBufferSize.getValue();
                    this.globalTrace = new Trace2DLtd(n3);
                    this.globalTrace.setPhysicalUnits(NAME_ITERATIONS, "TP, msg/sec");
                    this.globalTrace.setColor(Color.RED);
                    this.globalTrace.setName("Global Throughput");
                    this.chart.addTrace((ITrace2D)this.globalTrace);
                    this.globalTrace.addPoint(0.0, 0.0);
                }
                if (this.masterLocalCacheCB.isSelected()) {
                    double d3 = new Double(this.totalOperations);
                    double d4 = new Double(string);
                    if (bl2) {
                        d4 += (double)this._noOfIterations;
                    }
                    if (this.globalTrace.getMaxX() < d3) {
                        this.globalTrace.addPoint(d4, _Double.valueOf(d2).doubleValue());
                    }
                    int n4 = bl3 ? 2 * (int)d4 : (!bl2 ? (int)d4 : this.progressBar.getMaximum() / 2 + (int)d4);
                    int n5 = this.progressBar.getValue();
                    if (n5 < n4 && n5 >= 10) {
                        this.progressBar.setValue(n4);
                    }
                } else {
                    double d5 = Double.valueOf(string);
                    if (bl2) {
                        d5 += (double)this._noOfIterations;
                    }
                    if (this.globalTrace.getMaxX() <= d5) {
                        System.out.println("Global TP, iNo = " + d5);
                        double d6 = _Double.valueOf(d2);
                        this.globalTrace.addPoint(d5, d6);
                    }
                    int n6 = bl3 ? 2 * new Integer(string) : (!bl2 ? new Integer(string) : this.progressBar.getMaximum() / 2 + new Integer(string));
                    int n7 = this.progressBar.getValue();
                    if (n7 < n6 && n7 >= 10) {
                        this.progressBar.setValue(n6);
                    }
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block11;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void cleanup() {
        List list = this.chart.getTraces();
        int n2 = list.size();
        for (int i2 = n2 - 1; i2 > -1; --i2) {
            this.chart.removeTrace((ITrace2D)list.get(i2));
        }
        this.threadTraces.clear();
        this.globalTrace = null;
        this.progressBar.setValue(0);
        this.tableModel.setRowCount(0);
    }

    public void showException(String string, Throwable throwable) {
        SpaceBrowser spaceBrowser = (SpaceBrowser)this.parentFrame;
        SpaceBrowser.showException(string, throwable);
    }

    private void launchBenchmark(IJSpace iJSpace) throws Exception {
        Object object;
        Object object2;
        this.theSpace = iJSpace;
        this.cleanup();
        String string = String.valueOf(this.masterLocalCacheCB.isSelected());
        String string2 = this.regularSpaceProxy.getContainer().getName();
        String string3 = "rmi:";
        String string4 = "";
        if (this.regularSpaceProxy.getContainer().isEmbedded()) {
            string3 = "java:";
            string4 = ":10098";
        }
        this.theURL = string3 + "//" + this.hostName + string4 + '/' + string2 + '/' + this.spaceName + '?' + "useLocalCache" + "=" + string;
        System.out.println("------->URL:" + this.theURL);
        try {
            Object object3 = object2 = this.clusteredProxyCheckBox.isSelected() ? this.clusteredSpaceProxy : this.regularSpaceProxy;
            if (this.mapRadio.isSelected()) {
                this.theCache = (IMap)CacheFinder.find(this.theURL, (IJSpace)object2);
                if (this.theCache != null) {
                    this.theCache.setVersioned(false);
                    this.theSpace = this.theCache.getMasterSpace();
                }
            } else {
                this.theSpace = this.masterLocalCacheCB.isSelected() ? (IJSpace)SpaceFinder.find(this.theURL, (IJSpace)object2) : object2;
            }
        }
        catch (FinderException finderException) {
            this.showException("Can't start benchmark", finderException);
            return;
        }
        this.theSpace.setNOWriteLeaseMode(this.noWriteLease.isSelected());
        object2 = "";
        this.args.clear();
        if (this.mapRadio.isSelected()) {
            this.args.add(this.theURL);
        } else {
            this.args.add(this.curSpaceURL);
        }
        if (this.cleanSpace.isSelected()) {
            this.args.add("-clean");
        }
        this.args.add("-tr");
        this.args.add(this.noOfThreads.getValue().toString());
        this.args.add("-i");
        int n2 = Integer.valueOf(this.noOfIterations.getValue().toString()) * 1000;
        this.args.add(String.valueOf(n2));
        Integer n3 = (Integer)this.batchSize.getValue();
        if (n3 > 0) {
            this.args.add("-m");
            this.args.add(n3.toString());
        }
        this.args.add("-s");
        this.args.add(this.entrySize.getValue().toString());
        if (this.localTX.isSelected()) {
            this.args.add("-tx");
            this.args.add(this.commitEveryTx.getValue().toString());
        }
        if (this.distributedTX.isSelected()) {
            this.args.add("-dtx");
            this.args.add(this.commitEveryTx.getValue().toString());
        }
        if (this.masterLocalCacheCB.isSelected()) {
            this.args.add("-cache");
        }
        if (this.noOfReadOps.isEnabled()) {
            Integer n4 = (Integer)this.noOfReadOps.getValue();
            this.args.add("-rt");
            this.args.add(n4.toString());
        }
        boolean bl2 = false;
        if (this.javaSpaceRadio.isSelected()) {
            if (this.writeTakeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_TAKE);
                object2 = "JavaSpace,Write & Take";
                bl2 = true;
            } else if (this.writeReadOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_READ);
                object2 = "JavaSpace,Write & Read";
                bl2 = true;
            } else if (this.writeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_FIRST);
                object2 = "JavaSpace,Write";
            } else if (this.readOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_READ);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                object2 = "JavaSpace,Read";
            } else if (this.takeOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_TAKE);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                object2 = "JavaSpace,Take";
            } else if (this.writeNotifyOp.isSelected()) {
                this.args.add(ARGUMENT_NAME_NOTIFY);
                object2 = "JavaSpace,Write & Notify";
                bl2 = true;
            }
        }
        if (this.parallelOps.isSelected()) {
            this.args.add("-parallel");
        }
        if (this.objectTypesCombo.isEnabled()) {
            object = (ObjectTypeItem)this.objectTypesCombo.getSelectedItem();
            this.args.add("-objecttype");
            this.args.add(((ObjectTypeItem)object).getMessageTypeParameterName());
        }
        object = (Integer)this.timeout.getValue();
        this.args.add("-t");
        this.args.add(((Integer)object).toString());
        this.args.add("-showrate");
        int n5 = Integer.valueOf(this.showRate.getValue().toString()) * 1000;
        this.args.add(String.valueOf(n5));
        this.args.add("-showthreadrate");
        n5 = Integer.valueOf(this.showRate.getValue().toString()) * 1000;
        this.args.add(String.valueOf(n5));
        if (this.saveToFileCB.isSelected()) {
            this.args.add("-f");
            this.args.add(this.fNameTextField.getText());
        }
        this.args.add("-gui");
        if (this.mapRadio.isSelected()) {
            if (this.putRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_FIRST);
                object2 = "Map,Put";
            } else if (this.getRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_READ);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                object2 = "Map,Get";
            } else if (this.removeRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_TAKE);
                this.args.add(ARGUMENT_NAME_ONLY);
                this.args.add(ARGUMENT_NAME_SECOND);
                object2 = "Map,Remove";
            } else if (this.putRemRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_TAKE);
                object2 = "Map,Put & Remove";
                bl2 = true;
            } else if (this.putGetRadio.isSelected()) {
                this.args.add(ARGUMENT_NAME_MAP);
                this.args.add(ARGUMENT_NAME_READ);
                object2 = "Map,Put & Get";
                bl2 = true;
            }
        }
        this.args.add("-leasetime");
        if (this.foreverLease.isSelected()) {
            this.args.add(String.valueOf(Long.MAX_VALUE));
        } else {
            this.args.add(this.leaseTime.getValue().toString());
        }
        String string5 = this.args.toString();
        this.aPrintStream.println("Launching benchmark with arguments:");
        this.aPrintStream.println(string5);
        this.progressBar.setValue(0);
        this._noOfIterations = Integer.valueOf(this.noOfIterations.getValue().toString()) * 1000;
        this._noOfReadOps = 1;
        if (this.noOfReadOps.isEnabled()) {
            this._noOfReadOps = Integer.valueOf(this.noOfReadOps.getValue().toString());
        }
        object2 = (String)object2 + " Number of Iteration:" + this._noOfIterations;
        this.totalOperations = this._noOfIterations * this._noOfReadOps;
        if (bl2) {
            this.totalOperations += this._noOfIterations;
        }
        this.progressBar.setMaximum(this.totalOperations);
        this.progressBar.setValue(10);
        this.graphLabel.setText((String)object2);
        this.aPrintStream.println("---------------------------------------------------");
        this.aPrintStream.println("Benchmark Start Time:" + new Date(System.currentTimeMillis()));
        this.aPrintStream.println("System Info:" + RuntimeInfo.getEnvironmentInfo());
        Runnable runnable = new Runnable(){

            public void run() {
                String[] stringArray = GigaBenchmark.this.args.toArray(new String[0]);
                try {
                    GigaBenchmark.this.benchmark = new BenchmarkTest();
                    GigaBenchmark.this.benchmark.a(stringArray, GigaBenchmark.this.aPrintStream, GigaBenchmark.this.theSpace, GigaBenchmark.this.theCache, GigaBenchmark.this);
                }
                catch (Throwable throwable) {
                    GigaBenchmark.this.showException("Failed to run Benchmark", throwable);
                }
            }
        };
        new Thread(runnable).start();
    }

    private JPanel createOperationsPanel() {
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Operations", 0, 0, null, null));
        this.javaSpaceRadio = new JRadioButton(OP_NAME_JAVASPACE);
        this.mapRadio = new JRadioButton(OP_NAME_MAP);
        this.mapGroup = new ButtonGroup();
        this.operationGroup = new ButtonGroup();
        this.operationGroup.add(this.javaSpaceRadio);
        this.operationGroup.add(this.mapRadio);
        this.javaSpaceRadio.addActionListener(this);
        this.mapRadio.addActionListener(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (GigaBenchmark.this.javaSpaceRadio.isSelected()) {
                    GigaBenchmark.this.parallelOps.setEnabled(GigaBenchmark.this.writeTakeOp.isSelected() || GigaBenchmark.this.writeReadOp.isSelected() || GigaBenchmark.this.writeNotifyOp.isSelected());
                } else if (GigaBenchmark.this.mapRadio.isSelected()) {
                    GigaBenchmark.this.parallelOps.setEnabled(GigaBenchmark.this.putGetRadio.isSelected() || GigaBenchmark.this.putRemRadio.isSelected());
                }
                if (!GigaBenchmark.this.parallelOps.isEnabled()) {
                    GigaBenchmark.this.parallelOps.setSelected(false);
                    GigaBenchmark.this.timeout.setValue(GigaBenchmark.this.DEFAULT_REGULAR_TIMEOUT);
                }
                boolean bl2 = object != GigaBenchmark.this.writeOp && object != GigaBenchmark.this.putRadio && object != GigaBenchmark.this.writeTakeOp && object != GigaBenchmark.this.takeOp && object != GigaBenchmark.this.removeRadio && object != GigaBenchmark.this.putRemRadio;
                GigaBenchmark.this.noOfReadOps.setEnabled(bl2);
                GigaBenchmark.this.noOfReadLabel.setEnabled(bl2);
            }
        };
        this.putRadio = new JRadioButton("Put");
        this.putRadio.setSelected(true);
        this.getRadio = new JRadioButton("Get");
        this.removeRadio = new JRadioButton("Remove");
        this.putRemRadio = new JRadioButton("Put and Remove");
        this.putGetRadio = new JRadioButton("Put and Get");
        this.putRadio.addActionListener(actionListener);
        this.getRadio.addActionListener(actionListener);
        this.removeRadio.addActionListener(actionListener);
        this.putGetRadio.addActionListener(actionListener);
        this.putRemRadio.addActionListener(actionListener);
        this.mapGroup.add(this.putRadio);
        this.mapGroup.add(this.getRadio);
        this.mapGroup.add(this.removeRadio);
        this.mapGroup.add(this.putRemRadio);
        this.mapGroup.add(this.putGetRadio);
        this.putRadio.setBounds(20, 200, 120, 30);
        this.getRadio.setBounds(20, 220, 120, 30);
        this.removeRadio.setBounds(20, 240, 120, 30);
        this.putRemRadio.setBounds(20, 280, 120, 30);
        this.putGetRadio.setBounds(20, 260, 120, 30);
        jPanel.add(this.putRadio);
        jPanel.add(this.getRadio);
        jPanel.add(this.removeRadio);
        jPanel.add(this.putRemRadio);
        jPanel.add(this.putGetRadio);
        this.javaSpaceRadio.setBounds(10, 18, 120, 30);
        this.mapRadio.setBounds(10, 177, 120, 30);
        jPanel.add(this.javaSpaceRadio);
        jPanel.add(this.mapRadio);
        this.javaSpaceRadio.setSelected(true);
        this.setButtonGroupEnabled(this.mapGroup, false);
        this.writeNotifyOp = new JRadioButton();
        this.writeNotifyOp.setBounds(20, 143, 120, 30);
        this.writeNotifyOp.addActionListener(actionListener);
        jPanel.add(this.writeNotifyOp);
        this.buttonGroup.add(this.writeNotifyOp);
        this.writeNotifyOp.setText("Write and Notify");
        this.writeOp = new JRadioButton();
        this.writeOp.setBounds(20, 43, 120, 30);
        jPanel.add(this.writeOp);
        this.writeOp.addActionListener(actionListener);
        this.buttonGroup.add(this.writeOp);
        this.writeOp.setText("Write");
        this.writeOp.setSelected(true);
        this.takeOp = new JRadioButton();
        this.takeOp.setBounds(20, 83, 120, 30);
        jPanel.add(this.takeOp);
        this.takeOp.addActionListener(actionListener);
        this.buttonGroup.add(this.takeOp);
        this.takeOp.setText("Take");
        this.readOp = new JRadioButton();
        this.readOp.setBounds(20, 63, 120, 30);
        jPanel.add(this.readOp);
        this.readOp.addActionListener(actionListener);
        this.buttonGroup.add(this.readOp);
        this.readOp.setText("Read");
        this.writeTakeOp = new JRadioButton();
        this.writeTakeOp.setBounds(20, 123, 120, 30);
        jPanel.add(this.writeTakeOp);
        this.writeTakeOp.addActionListener(actionListener);
        this.writeTakeOp.setSelected(false);
        this.buttonGroup.add(this.writeTakeOp);
        this.writeTakeOp.setText("Write and Take");
        this.writeReadOp = new JRadioButton();
        this.writeReadOp.setBounds(20, 103, 120, 30);
        jPanel.add(this.writeReadOp);
        this.writeReadOp.addActionListener(actionListener);
        this.buttonGroup.add(this.writeReadOp);
        this.writeReadOp.setText("Write and Read");
        this.parallelOps = new JCheckBox();
        this.parallelOps.setBounds(10, 310, 120, 30);
        jPanel.add(this.parallelOps);
        this.parallelOps.setText("Parallel operations");
        this.parallelOps.setEnabled(false);
        this.parallelOps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GigaBenchmark.this.parallelOps.isSelected()) {
                    GigaBenchmark.this.timeout.setValue(GigaBenchmark.this.DEFAULT_PARALLEL_TIMEOUT);
                } else {
                    GigaBenchmark.this.timeout.setValue(GigaBenchmark.this.DEFAULT_REGULAR_TIMEOUT);
                }
            }
        });
        this.noOfReadLabel = new JLabel();
        this.noOfReadLabel.setBounds(15, 355, 140, 20);
        jPanel.add(this.noOfReadLabel);
        this.noOfReadLabel.setText("Repeat Read/Get Operation:");
        this.noOfReadOps = new JSpinner();
        this.noOfReadOps.setBounds(160, 355, 50, 20);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setStepSize(_Integer.valueOf(1));
        spinnerNumberModel.setValue(_Integer.valueOf(1));
        spinnerNumberModel.setMinimum(_Integer.valueOf(1));
        this.noOfReadOps.setModel(spinnerNumberModel);
        jPanel.add(this.noOfReadOps);
        return jPanel;
    }

    private JPanel createTBDPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "", 0, 0, null, null));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        this.cleanSpace = new JCheckBox("Clean Space");
        this.cleanSpace.setToolTipText("Clean space before the test");
        this.displayThreadsTP = new JCheckBox("Display Thread TP", false);
        this.displayThreadsTP.setEnabled(false);
        this.clusteredProxyCheckBox = new JCheckBox("Use Clustered Proxy");
        jPanel.add((Component)this.clusteredProxyCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.cleanSpace, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.displayThreadsTP, gridBagConstraints);
        return jPanel;
    }

    private JPanel createResultsOutputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        Dimension dimension = new Dimension(200, 37);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Results Output", 0, 0, null, null));
        this.saveToFileCB = new JCheckBox();
        this.saveToFileCB.setBounds(15, 26, 120, 20);
        this.saveToFileCB.setText("Save results to file");
        this.saveToFileCB.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl2 = GigaBenchmark.this.saveToFileCB.isSelected();
                GigaBenchmark.this.fNameLabel.setEnabled(bl2);
                GigaBenchmark.this.fNameTextField.setEnabled(bl2);
                GigaBenchmark.this.chooseBtn.setEnabled(bl2);
                if (!GigaBenchmark.this.fNameTextField.isEnabled()) {
                    GigaBenchmark.this.fNameTextField.setText("");
                }
            }
        });
        this.fNameLabel = new JLabel();
        this.fNameLabel.setEnabled(false);
        this.fNameLabel.setBounds(20, 56, 55, 20);
        this.fNameLabel.setText("File name:");
        this.fNameTextField = new JTextField();
        this.fNameTextField.setEnabled(false);
        this.fNameTextField.setBounds(70, 56, 92, 20);
        this.chooseBtn = new JButton();
        this.chooseBtn.setEnabled(false);
        this.chooseBtn.setBounds(165, 56, 28, 20);
        this.chooseBtn.setText("...");
        this.chooseBtn.addActionListener(new ResultsFileHandler());
        jPanel.add(this.saveToFileCB);
        jPanel.add(this.fNameLabel);
        jPanel.add(this.fNameTextField);
        jPanel.add(this.chooseBtn);
        return jPanel;
    }

    private JPanel createMasterLocalPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        Dimension dimension = new Dimension(500, 55);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Master-Local", 0, 0, null, null));
        this.masterLocalCacheCB = new JCheckBox("Use Local Cache");
        this.masterLocalCacheCB.setBounds(15, 20, 140, 20);
        jPanel.add(this.masterLocalCacheCB);
        return jPanel;
    }

    private JPanel createConfigurationPanel() {
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(310, 130);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Configuration", 0, 0, null, null));
        this.saveConfigurationButton = new JButton("Save");
        this.saveConfigurationButton.addActionListener(this);
        this.renameConfigurationButton = new JButton("Rename");
        this.renameConfigurationButton.addActionListener(this);
        this.newConfigurationButton = new JButton("New");
        this.newConfigurationButton.addActionListener(this);
        this.deleteConfigurationButton = new JButton("Delete");
        this.deleteConfigurationButton.addActionListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.configurationsCombo = new JComboBox(comboBoxModel);
        Object object = this.configurationsCombo.getSelectedItem();
        if (object != null && !object.equals(DEFAULT_CONFIG_NAME)) {
            this.renameConfigurationButton.setEnabled(true);
            this.deleteConfigurationButton.setEnabled(true);
        } else {
            this.renameConfigurationButton.setEnabled(false);
            this.deleteConfigurationButton.setEnabled(false);
        }
        if (allConfigNamesVector.size() > 0) {
            this.saveConfigurationButton.setEnabled(true);
        } else {
            this.saveConfigurationButton.setEnabled(false);
        }
        this.configurationsCombo.addItemListener(this);
        Dimension dimension2 = new Dimension(75, 23);
        Dimension dimension3 = new Dimension(245, 22);
        this.configurationsCombo.setPreferredSize(dimension3);
        this.configurationsCombo.setMaximumSize(dimension3);
        this.saveConfigurationButton.setPreferredSize(new Dimension(100, 25));
        this.saveConfigurationButton.setMaximumSize(new Dimension(75, 25));
        this.renameConfigurationButton.setPreferredSize(dimension2);
        this.renameConfigurationButton.setMaximumSize(dimension2);
        this.deleteConfigurationButton.setPreferredSize(dimension2);
        this.deleteConfigurationButton.setMaximumSize(dimension2);
        this.newConfigurationButton.setPreferredSize(dimension2);
        this.newConfigurationButton.setMaximumSize(dimension2);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.configurationsCombo);
        box.add(Box.createHorizontalGlue());
        box2.add(Box.createHorizontalGlue());
        box2.add(this.newConfigurationButton);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.deleteConfigurationButton);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.renameConfigurationButton);
        box2.add(Box.createHorizontalGlue());
        box3.add(Box.createHorizontalGlue());
        box3.add(this.saveConfigurationButton);
        box3.add(Box.createHorizontalGlue());
        Box box4 = new Box(1);
        box4.add(Box.createVerticalStrut(1));
        box4.add(box);
        box4.add(Box.createVerticalStrut(5));
        box4.add(box2);
        box4.add(Box.createVerticalStrut(1));
        box4.setBorder(new TitledBorder(new EtchedBorder(), "", 0, 0, null, null));
        jPanel.add(box4);
        jPanel.add(Box.createVerticalStrut(6));
        jPanel.add(box3);
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel createTransactionPanel() {
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(220, 80);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        jPanel.setLayout(null);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (GigaBenchmark.this.noTX != null && GigaBenchmark.this.commitLabel1 != null && GigaBenchmark.this.commitEveryTx != null && GigaBenchmark.this.commitLabel2 != null) {
                    GigaBenchmark.this.commitLabel1.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                    GigaBenchmark.this.commitEveryTx.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                    GigaBenchmark.this.commitLabel2.setEnabled(!GigaBenchmark.this.noTX.isSelected());
                }
            }
        };
        this.noTX = new JRadioButton();
        this.noTX.setBounds(13, 14, 120, 30);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Transaction", 0, 0, null, null));
        jPanel.setLayout(null);
        jPanel.add(this.noTX);
        this.buttonGroup_2.add(this.noTX);
        this.noTX.setText("None");
        this.noTX.addChangeListener(changeListener);
        this.noTX.setSelected(true);
        this.localTX = new JRadioButton();
        this.localTX.setBounds(13, 41, 120, 30);
        jPanel.add(this.localTX);
        this.buttonGroup_2.add(this.localTX);
        this.localTX.setText("Local");
        this.localTX.addChangeListener(changeListener);
        this.localTX.setSelected(false);
        this.distributedTX = new JRadioButton();
        this.distributedTX.setBounds(13, 71, 120, 30);
        jPanel.add(this.distributedTX);
        this.buttonGroup_2.add(this.distributedTX);
        this.distributedTX.setText("Distributed");
        this.distributedTX.addChangeListener(changeListener);
        this.distributedTX.setSelected(false);
        this.commitLabel1 = new JLabel();
        this.commitLabel1.setEnabled(false);
        this.commitLabel1.setBounds(20, 105, 70, 20);
        jPanel.add(this.commitLabel1);
        this.commitLabel1.setText("Commit every");
        this.commitEveryTx = new JSpinner();
        this.commitEveryTx.setEnabled(false);
        this.commitEveryTx.setBounds(90, 105, 55, 20);
        jPanel.add(this.commitEveryTx);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setStepSize(_Integer.valueOf(1000));
        spinnerNumberModel.setValue(_Integer.valueOf(1));
        spinnerNumberModel.setMinimum(_Integer.valueOf(1));
        this.commitEveryTx.setModel(spinnerNumberModel);
        this.commitLabel2 = new JLabel();
        this.commitLabel2.setEnabled(false);
        this.commitLabel2.setBounds(150, 105, 60, 20);
        jPanel.add(this.commitLabel2);
        this.commitLabel2.setText("operations");
        return jPanel;
    }

    private JPanel createLeasePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Lease", 0, 0, null, null));
        this.noWriteLease = new JCheckBox("Return Lease", false);
        this.foreverLease = new JCheckBox("FOREVER Lease", true);
        JLabel jLabel = new JLabel("Lease Time[ms]:");
        this.leaseTime = new JSpinner();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        this.leaseTime.setModel(spinnerNumberModel);
        spinnerNumberModel.setStepSize(_Integer.valueOf(100));
        spinnerNumberModel.setValue(_Integer.valueOf(10000));
        spinnerNumberModel.setMinimum(_Integer.valueOf(1));
        this.leaseTime.setEnabled(false);
        this.foreverLease.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        jPanel.add((Component)this.noWriteLease, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.foreverLease, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.leaseTime, new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 21, 1, new Insets(2, 1, 2, 55), 0, 3));
        return jPanel;
    }

    private JPanel createOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Options", 0, 0, null, null));
        this.noOfThreads = new JSpinner();
        this.noOfThreads.setBounds(100, 78, 80, 20);
        this.noOfThreads.setToolTipText("Number of threads");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(_Integer.valueOf(1));
        spinnerNumberModel.setStepSize(_Integer.valueOf(1));
        spinnerNumberModel.setMaximum(null);
        spinnerNumberModel.setMinimum(_Integer.valueOf(1));
        this.noOfThreads.setModel(spinnerNumberModel);
        this.noOfThreads.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = (Integer)GigaBenchmark.this.noOfThreads.getValue();
                GigaBenchmark.this.displayThreadsTP.setEnabled(n2 != 1);
                if (n2 == 1) {
                    GigaBenchmark.this.displayThreadsTP.setSelected(false);
                }
            }
        });
        this.noOfIterations = new JSpinner();
        this.noOfIterations.setBounds(100, 123, 80, 20);
        this.noOfIterations.setToolTipText("Number of iterations");
        this.batchSize = new JSpinner();
        this.batchSize.setBounds(100, 110, 70, 20);
        this.batchSize.setToolTipText("Number of multiple operations (0 if single operations are used)");
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel();
        spinnerNumberModel2.setMaximum(null);
        spinnerNumberModel2.setValue(_Integer.valueOf(0));
        spinnerNumberModel2.setStepSize(_Integer.valueOf(1));
        spinnerNumberModel2.setMinimum(_Integer.valueOf(0));
        this.batchSize.setModel(spinnerNumberModel2);
        this.entrySize = new JSpinner();
        SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel();
        spinnerNumberModel3.setValue(_Integer.valueOf(128));
        spinnerNumberModel3.setStepSize(_Integer.valueOf(128));
        spinnerNumberModel3.setMinimum(_Integer.valueOf(1));
        this.entrySize.setModel(spinnerNumberModel3);
        this.objectTypesCombo = new JComboBox<ObjectTypeItem>(this.objectTypeItems);
        this.showRate = new JSpinner();
        this.showRate.setBounds(100, 361, 61, 20);
        this.showRate.setToolTipText("Display throughput every N iterations");
        SpinnerNumberModel spinnerNumberModel4 = new SpinnerNumberModel();
        spinnerNumberModel4.setMaximum(_Integer.valueOf(10000000));
        spinnerNumberModel4.setStepSize(_Integer.valueOf(1));
        spinnerNumberModel4.setMinimum(_Integer.valueOf(1));
        spinnerNumberModel4.setValue(_Integer.valueOf(2));
        this.showRate.setModel(spinnerNumberModel4);
        JLabel jLabel = new JLabel("Threads:");
        JLabel jLabel2 = new JLabel("Iterations:");
        JLabel jLabel3 = new JLabel("Batches:");
        JLabel jLabel4 = new JLabel("Entry size:");
        JLabel jLabel5 = new JLabel("Sampling rate:");
        JLabel jLabel6 = new JLabel("000");
        JLabel jLabel7 = new JLabel("000");
        JLabel jLabel8 = new JLabel("Bytes");
        JLabel jLabel9 = new JLabel("Read/Take timeout:");
        JLabel jLabel10 = new JLabel("Object type:");
        this.noOfIterations.setValue(_Integer.valueOf(10));
        SpinnerNumberModel spinnerNumberModel5 = new SpinnerNumberModel();
        spinnerNumberModel5.setMaximum(null);
        spinnerNumberModel5.setStepSize(_Integer.valueOf(1));
        spinnerNumberModel5.setValue(_Integer.valueOf(10));
        spinnerNumberModel5.setMinimum(_Integer.valueOf(1));
        this.noOfIterations.setModel(spinnerNumberModel5);
        this.timeout = new JSpinner();
        this.timeout.setBounds(84, 142, 60, 20);
        SpinnerNumberModel spinnerNumberModel6 = new SpinnerNumberModel();
        spinnerNumberModel6.setValue(_Integer.valueOf(0));
        spinnerNumberModel6.setMinimum(_Integer.valueOf(0));
        this.timeout.setModel(spinnerNumberModel6);
        jLabel6.setBounds(this.noOfIterations.getX() + this.noOfIterations.getWidth(), 50, 110, 20);
        jLabel7.setBounds(this.showRate.getX() + this.showRate.getWidth(), 90, 110, 20);
        jLabel8.setBounds(this.entrySize.getX() + this.entrySize.getWidth(), 70, 70, 20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 21, 1, new Insets(2, 10, 2, 3), 0, 3);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 21, 1, new Insets(2, 1, 2, 1), 0, 3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 21, 1, new Insets(2, 1, 2, 1), 0, 3);
        Dimension dimension = new Dimension(60, 19);
        this.objectTypesCombo.setPreferredSize(dimension);
        this.objectTypesCombo.setMaximumSize(dimension);
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)jLabel10, gridBagConstraints);
        jPanel.add((Component)this.objectTypesCombo, gridBagConstraints2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.noOfThreads, gridBagConstraints2);
        gridBagConstraints.gridy = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints3.gridy = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)this.noOfIterations, gridBagConstraints2);
        jPanel.add((Component)jLabel6, gridBagConstraints3);
        gridBagConstraints.gridy = 3;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints3.gridy = 3;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jPanel.add((Component)this.entrySize, gridBagConstraints2);
        jPanel.add((Component)jLabel8, gridBagConstraints3);
        gridBagConstraints.gridy = 4;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints3.gridy = 4;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        jPanel.add((Component)this.showRate, gridBagConstraints2);
        jPanel.add((Component)jLabel7, gridBagConstraints3);
        gridBagConstraints.gridy = 5;
        gridBagConstraints2.gridy = 5;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jPanel.add((Component)this.batchSize, gridBagConstraints2);
        gridBagConstraints.gridy = 6;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints3.gridy = 6;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        jPanel.add((Component)this.timeout, gridBagConstraints2);
        jPanel.add((Component)new JLabel("[ms]"), gridBagConstraints3);
        return jPanel;
    }

    private void initialize(JPanel jPanel) {
        String string;
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.createOperationsPanel();
        JComponent jComponent = new JTabbedPane();
        jComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        ((JTabbedPane)jComponent).setTabPlacement(3);
        jComponent.setBounds(2, -1, 582, 501);
        jComponent.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        jPanel.add((Component)jComponent, "Center");
        JComponent jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(1, 3));
        JComponent jComponent3 = new Box(1);
        Serializable serializable = new Box(1);
        JPanel jPanel3 = this.createOptionsPanel();
        JPanel jPanel4 = this.createLeasePanel();
        JPanel jPanel5 = this.createTBDPanel();
        jComponent3.add(jPanel3);
        jComponent3.add(Box.createVerticalStrut(7));
        jComponent3.add(jPanel4);
        jComponent3.add(Box.createVerticalStrut(10));
        jComponent3.add(jPanel5);
        jComponent3.add(Box.createVerticalStrut(3));
        jComponent2.add(jComponent3);
        ((JTabbedPane)jComponent).addTab("Settings", null, jComponent2, null);
        String string2 = null;
        try {
            string2 = this.regularSpaceProxy.getContainer().getName();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        this.curSpaceURL = string = "rmi://" + this.hostName + "/" + string2 + "/" + this.spaceName;
        jComponent2.add(jPanel2);
        jComponent2.add((Component)serializable);
        JPanel jPanel6 = this.createTransactionPanel();
        JPanel jPanel7 = this.createMasterLocalPanel();
        JPanel jPanel8 = this.createResultsOutputPanel();
        JPanel jPanel9 = this.createConfigurationPanel();
        ((Container)serializable).add(jPanel6);
        ((Container)serializable).add(Box.createVerticalStrut(7));
        ((Container)serializable).add(jPanel7);
        ((Container)serializable).add(Box.createVerticalStrut(7));
        ((Container)serializable).add(jPanel8);
        ((Container)serializable).add(Box.createVerticalStrut(7));
        ((Container)serializable).add(jPanel9);
        if (this.configurationsCombo.getModel().getSize() > 0) {
            this.initPanel((BenchmarkGUIConfiguration)allConfigurationsMap.get(this.configurationsCombo.getSelectedItem()));
        }
        this.tableModel = new DefaultTableModel(new Object[]{"Iteration #", "Operation", "Thread #", "Thread Throughput, msg/sec", "Global Throughput, msg/sec", "Free Memory, Mb"}, 0){

            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(true);
        this.table.setBorder(new LineBorder(Color.LIGHT_GRAY, 1, false));
        JComponent jComponent4 = new JScrollPane(this.table);
        ((JScrollPane)jComponent4).setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JComponent jComponent5 = new JPanel();
        jComponent5.setLayout(new BorderLayout());
        jComponent5.add((Component)jComponent4, "Center");
        ((JTabbedPane)jComponent).addTab("Table", null, jComponent5, null);
        Serializable serializable2 = new JPanel();
        Serializable serializable3 = new FlowLayout();
        ((FlowLayout)serializable3).setAlignment(2);
        ((Container)serializable2).setLayout((LayoutManager)((Object)serializable3));
        jComponent5.add((Component)serializable2, "South");
        Serializable serializable4 = new JButton();
        ((JComponent)serializable4).setPreferredSize(new Dimension(84, 28));
        ((Container)serializable2).add((Component)serializable4);
        ((AbstractButton)serializable4).setText("Clear");
        ((AbstractButton)serializable4).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GigaBenchmark.this.cleanup();
            }
        });
        jComponent4 = new JPanel();
        jComponent4.setBorder(new EmptyBorder(3, 3, 0, 3));
        this.chart = new Chart2D();
        this.chart.setBorder((Border)new LineBorder(new Color(127, 157, 185), 1, false));
        this.chart.setGridX(true);
        this.chart.setDecimalsX(0);
        this.chart.setGridY(true);
        this.chart.setGridColor(Color.LIGHT_GRAY);
        jComponent4.setLayout(new BorderLayout());
        jComponent4.add((Component)this.chart, "Center");
        jComponent4.add((Component)this.graphLabel, "North");
        this.chart.setBounds(5, 5, 565, 430);
        jComponent5 = new JPanel();
        serializable2 = new FlowLayout();
        ((FlowLayout)serializable2).setAlignment(2);
        jComponent5.setLayout((LayoutManager)((Object)serializable2));
        jComponent5.setAlignmentX(1.0f);
        serializable3 = new JButton();
        ((JComponent)serializable3).setPreferredSize(new Dimension(84, 28));
        jComponent5.add((Component)serializable3);
        ((AbstractButton)serializable3).setText("Clear");
        ((AbstractButton)serializable3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GigaBenchmark.this.cleanup();
            }
        });
        serializable3 = new JLabel();
        ((JComponent)serializable3).setPreferredSize(new Dimension(10, 0));
        jComponent5.add((Component)serializable3);
        serializable3 = new JSeparator();
        ((JSeparator)serializable3).setOrientation(1);
        ((JComponent)serializable3).setPreferredSize(new Dimension(2, 20));
        jComponent5.add((Component)serializable3);
        serializable3 = new JLabel();
        ((JComponent)serializable3).setPreferredSize(new Dimension(10, 0));
        jComponent5.add((Component)serializable3);
        serializable3 = new JLabel();
        ((Component)serializable3).setBounds(394, 442, 60, 20);
        jComponent5.add((Component)serializable3);
        ((JLabel)serializable3).setText("Display last");
        this.samplesBufferSize = new JSpinner();
        serializable4 = new SpinnerNumberModel();
        ((SpinnerNumberModel)serializable4).setValue(_Integer.valueOf(100));
        ((SpinnerNumberModel)serializable4).setStepSize(_Integer.valueOf(10));
        ((SpinnerNumberModel)serializable4).setMaximum(_Integer.valueOf(1000));
        ((SpinnerNumberModel)serializable4).setMinimum(_Integer.valueOf(10));
        this.samplesBufferSize.setModel((SpinnerModel)((Object)serializable4));
        this.samplesBufferSize.setBounds(458, 442, 60, 20);
        jComponent5.add(this.samplesBufferSize);
        this.samplesBufferSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                List list = GigaBenchmark.this.chart.getTraces();
                for (int i2 = list.size() - 1; i2 > -1; --i2) {
                    Trace2DLtd trace2DLtd = (Trace2DLtd)list.get(i2);
                    trace2DLtd.addPoint(0.0, 0.0);
                    trace2DLtd.setMaxSize(((Integer)GigaBenchmark.this.samplesBufferSize.getValue()).intValue());
                }
            }
        });
        JLabel jLabel = new JLabel();
        jLabel.setBounds(523, 442, 44, 20);
        jComponent5.add(jLabel);
        jLabel.setText("samples");
        jComponent4.add((Component)jComponent5, "South");
        ((JTabbedPane)jComponent).addTab("Graph", null, jComponent4, null);
        jComponent4 = new JPanel();
        jComponent4.setBorder(new EmptyBorder(5, 5, 0, 5));
        jComponent4.setLayout(new BorderLayout());
        ((JTabbedPane)jComponent).addTab("Summary", null, jComponent4, null);
        jComponent5 = new JScrollPane();
        jComponent5.setBounds(2, 2, 570, 430);
        jComponent4.add(jComponent5);
        this.consoleOutput = new JTextArea();
        serializable2 = this.consoleOutput.getFont();
        this.consoleOutput.setFont(new Font(((Font)serializable2).getName(), ((Font)serializable2).getStyle(), ((Font)serializable2).getSize() + 3));
        ((JScrollPane)jComponent5).setViewportView(this.consoleOutput);
        this.consoleOutput.setEditable(false);
        this.consoleOutput.setBorder(new LineBorder(Color.LIGHT_GRAY, 1, false));
        jComponent5 = new JPanel();
        serializable2 = new FlowLayout();
        ((FlowLayout)serializable2).setAlignment(2);
        jComponent5.setLayout((LayoutManager)((Object)serializable2));
        jComponent4.add((Component)jComponent5, "South");
        this.clearConsoleBtn = new JButton();
        this.clearConsoleBtn.setPreferredSize(new Dimension(84, 28));
        jComponent5.add(this.clearConsoleBtn);
        this.clearConsoleBtn.setText("Clear");
        this.clearConsoleBtn.addActionListener(this);
        jComponent = new JPanel();
        jComponent.setBorder(new EmptyBorder(10, 10, 0, 10));
        jComponent.setLayout(new BorderLayout());
        jComponent.setMinimumSize(new Dimension(100, 100));
        jComponent.setMaximumSize(new Dimension(100, 100));
        jComponent.setAlignmentX(1.0f);
        jComponent.setBounds(0, 715, 582, 1);
        jPanel.add((Component)jComponent, "South");
        jComponent2 = new JSeparator();
        jComponent.add((Component)jComponent2, "North");
        jComponent3 = new JPanel();
        serializable = new FlowLayout();
        ((FlowLayout)serializable).setVgap(10);
        ((FlowLayout)serializable).setHgap(10);
        ((FlowLayout)serializable).setAlignment(2);
        jComponent3.setLayout((LayoutManager)((Object)serializable));
        jComponent.add((Component)jComponent3, "East");
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        jComponent3.add(this.progressBar);
        this.startBtn = new JButton();
        jComponent3.add(this.startBtn);
        this.startBtn.setPreferredSize(new Dimension(84, 28));
        this.startBtn.setText("Start");
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GigaBenchmark.this.cleanSpace.isSelected()) {
                    String string = "Space will be cleaned since you have \"Clean Space\" option selected.\nAre you sure you want to continue?";
                    if (JOptionPane.showConfirmDialog(GigaBenchmark.this.parentFrame, string, "Warning", 0, 2) == 1) {
                        return;
                    }
                }
                int n2 = (Integer)GigaBenchmark.this.noOfIterations.getValue() * 1000;
                GigaBenchmark.this.progressBar.setMaximum(n2);
                GigaBenchmark.this.startBtn.setEnabled(false);
                GigaBenchmark.this.stopBtn.setEnabled(true);
                try {
                    GigaBenchmark.this.launchBenchmark(GigaBenchmark.this.theSpace);
                }
                catch (Exception exception) {
                    GigaBenchmark.this.showException("Benchmark", exception);
                }
            }
        });
        this.stopBtn = new JButton();
        this.stopBtn.setPreferredSize(new Dimension(84, 28));
        jComponent3.add(this.stopBtn);
        this.stopBtn.setEnabled(false);
        this.stopBtn.setText("Stop");
        this.stopBtn.addActionListener(this);
    }

    private static String initConfiguration(File file) {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = builder.parse(fileInputStream);
            Element element = document.getDocumentElement();
            string = element.getAttribute("name");
            BenchmarkGUIConfiguration benchmarkGUIConfiguration = new BenchmarkGUIConfiguration();
            NodeList nodeList = element.getElementsByTagName(OPTION_TAG_NAME);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                String string2 = element2.getAttribute("name");
                String string3 = element2.getAttribute(VALUE_ATTR_NAME);
                GigaBenchmark.fillConfigurationInstance(benchmarkGUIConfiguration, string2, string3);
            }
            allConfigurationsMap.put(string, benchmarkGUIConfiguration);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return string;
    }

    private static void fillConfigurationInstance(BenchmarkGUIConfiguration benchmarkGUIConfiguration, String string, String string2) {
        if (string.equals(NAME_THREADS)) {
            benchmarkGUIConfiguration.setThreadsNumber(Integer.valueOf(string2));
        } else if (string.equals(NAME_ITERATIONS)) {
            benchmarkGUIConfiguration.setIterationsNumber(_Integer.valueOf(Integer.valueOf(string2) / 1000));
        } else if (string.equals(NAME_ENTRY_SIZE)) {
            benchmarkGUIConfiguration.setEntrySize(Integer.valueOf(string2));
        } else if (string.equals(NAME_SAMPLING_RATE)) {
            benchmarkGUIConfiguration.setSamplingRate(_Integer.valueOf(Integer.valueOf(string2) / 1000));
        } else if (string.equals(NAME_BATCH_SIZE)) {
            benchmarkGUIConfiguration.setBatchesNumber(Integer.valueOf(string2));
        } else if (string.equals(NAME_READ_TAKE_TIMEOUT)) {
            benchmarkGUIConfiguration.setReadTakeTimeout(Integer.valueOf(string2));
        } else if (string.equals(NAME_OBJECT_TYPE)) {
            benchmarkGUIConfiguration.setObjectType(string2);
        } else if (string.equals(NAME_NO_WRITE_LEASE)) {
            benchmarkGUIConfiguration.setNoWriteLease(Boolean.valueOf(string2));
        } else if (string.equals(NAME_FOREVER_LEASE)) {
            benchmarkGUIConfiguration.setForeverLease(Boolean.valueOf(string2));
        } else if (string.equals(NAME_LEASE_TIME)) {
            benchmarkGUIConfiguration.setLeaseTime(Integer.valueOf(string2));
        } else if (string.equals(NAME_CLUSTERED_PROXY)) {
            benchmarkGUIConfiguration.setClusteredProxy(Boolean.valueOf(string2));
        } else if (string.equals(NAME_DISPLAY_THREADS_THROUGHPUT)) {
            benchmarkGUIConfiguration.setDisplayThreadsThroughput(Boolean.valueOf(string2));
        } else if (string.equals(NAME_CLEAN_SPACE)) {
            benchmarkGUIConfiguration.setCleanSpace(Boolean.valueOf(string2));
        } else if (string.equals(NAME_OPERATION_TYPE)) {
            benchmarkGUIConfiguration.setOperationType(string2);
        } else if (string.equals(NAME_OPERATION_NAME)) {
            benchmarkGUIConfiguration.setOperationName(string2);
        } else if (string.equals(NAME_PARALLEL_OPERATIONS)) {
            benchmarkGUIConfiguration.setParallelOperations(Boolean.valueOf(string2));
        } else if (string.equals(NAME_REPEAT_READ)) {
            benchmarkGUIConfiguration.setRepeatOperationsNumber(Integer.valueOf(string2));
        } else if (string.equals(NAME_TRANSACTION_TYPE)) {
            benchmarkGUIConfiguration.setTransactionType(string2);
        } else if (string.equals(NAME_COMMIT_EVERY)) {
            benchmarkGUIConfiguration.setCommitFrequency(Integer.valueOf(string2));
        } else if (string.equals(NAME_MASTER_LOCAL_CACHE)) {
            benchmarkGUIConfiguration.setMasterLocalCache(Boolean.valueOf(string2));
        } else if (string.equals(NAME_CACHE_TYPE)) {
            benchmarkGUIConfiguration.setMasterLocalCacheType(string2);
        } else if (string.equals(NAME_SAVE_RESULTS_TO_FILE)) {
            benchmarkGUIConfiguration.setSaveResultsToFile(Boolean.valueOf(string2));
        } else if (string.equals(NAME_FILE_NAME)) {
            benchmarkGUIConfiguration.setFileName(string2);
        }
    }

    private void saveConfiguration(String string) {
        File file = new File(locationDirPath + string + configFileExtension);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(ROOT_NAME);
            element.setAttribute("name", string);
            document.appendChild(element);
            Element element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_THREADS);
            element2.setAttribute(VALUE_ATTR_NAME, this.noOfThreads.getValue().toString());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_ITERATIONS);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf((Integer)this.noOfIterations.getValue() * 1000));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_ENTRY_SIZE);
            element2.setAttribute(VALUE_ATTR_NAME, this.entrySize.getValue().toString());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_SAMPLING_RATE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf((Integer)this.showRate.getValue() * 1000));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_BATCH_SIZE);
            element2.setAttribute(VALUE_ATTR_NAME, this.batchSize.getValue().toString());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_READ_TAKE_TIMEOUT);
            element2.setAttribute(VALUE_ATTR_NAME, this.timeout.getValue().toString());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_OBJECT_TYPE);
            element2.setAttribute(VALUE_ATTR_NAME, ((ObjectTypeItem)this.objectTypesCombo.getSelectedItem()).getMessageTypeParameterName());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_NO_WRITE_LEASE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.noWriteLease.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_FOREVER_LEASE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.foreverLease.isSelected()));
            element.appendChild(element2);
            if (this.leaseTime.isEnabled()) {
                element2 = document.createElement(OPTION_TAG_NAME);
                element2.setAttribute("name", NAME_LEASE_TIME);
                element2.setAttribute(VALUE_ATTR_NAME, this.leaseTime.getValue().toString());
                element.appendChild(element2);
            }
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_CLUSTERED_PROXY);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.clusteredProxyCheckBox.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_DISPLAY_THREADS_THROUGHPUT);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.displayThreadsTP.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_CLEAN_SPACE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.cleanSpace.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_OPERATION_TYPE);
            if (this.javaSpaceRadio.isSelected()) {
                element2.setAttribute(VALUE_ATTR_NAME, OP_NAME_JAVASPACE);
            } else {
                element2.setAttribute(VALUE_ATTR_NAME, OP_NAME_MAP);
            }
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_OPERATION_NAME);
            if (this.javaSpaceRadio.isSelected()) {
                if (this.writeTakeOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "WriteAndTake");
                } else if (this.writeReadOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "WriteAndRead");
                } else if (this.writeNotifyOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "WriteAndNotify");
                } else if (this.writeOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Write");
                } else if (this.readOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Read");
                } else if (this.takeOp.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Take");
                }
            } else {
                if (this.putRadio.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Put");
                } else if (this.getRadio.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Get");
                }
                if (this.removeRadio.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "Remove");
                }
                if (this.putGetRadio.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "PutAndGet");
                }
                if (this.putRemRadio.isSelected()) {
                    element2.setAttribute(VALUE_ATTR_NAME, "PutAndRemove");
                }
            }
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_PARALLEL_OPERATIONS);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.parallelOps.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_REPEAT_READ);
            element2.setAttribute(VALUE_ATTR_NAME, this.noOfReadOps.getValue().toString());
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_TRANSACTION_TYPE);
            if (this.noTX.isSelected()) {
                element2.setAttribute(VALUE_ATTR_NAME, "None");
            } else if (this.localTX.isSelected()) {
                element2.setAttribute(VALUE_ATTR_NAME, "Local");
            } else {
                element2.setAttribute(VALUE_ATTR_NAME, "Distributed");
            }
            element.appendChild(element2);
            if (this.commitEveryTx.isEnabled()) {
                element2 = document.createElement(OPTION_TAG_NAME);
                element2.setAttribute("name", NAME_COMMIT_EVERY);
                element2.setAttribute(VALUE_ATTR_NAME, this.commitEveryTx.getValue().toString());
                element.appendChild(element2);
            }
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_MASTER_LOCAL_CACHE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.masterLocalCacheCB.isSelected()));
            element.appendChild(element2);
            if (this.masterLocalCacheCB.isSelected()) {
                element2 = document.createElement(OPTION_TAG_NAME);
                element2.setAttribute("name", NAME_CACHE_TYPE);
                element.appendChild(element2);
            }
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_SAVE_RESULTS_TO_FILE);
            element2.setAttribute(VALUE_ATTR_NAME, String.valueOf(this.saveToFileCB.isSelected()));
            element.appendChild(element2);
            element2 = document.createElement(OPTION_TAG_NAME);
            element2.setAttribute("name", NAME_FILE_NAME);
            element2.setAttribute(VALUE_ATTR_NAME, this.fNameTextField.getText());
            element.appendChild(element2);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            JSpaceUtilities.domWriter(element, printStream, "");
            printStream.close();
            GigaBenchmark.initConfiguration(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showException("File not found", fileNotFoundException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.showException("ParserConfigurationException", parserConfigurationException);
        }
    }

    static {
        File[] fileArray;
        window = null;
        _logger = Logger.getLogger("com.gigaspaces.ui.spacebrowser");
        factory = DocumentBuilderFactory.newInstance();
        locationDirPath = System.getProperty("user.home") + File.separator + "benchmarkConfigurations" + File.separator;
        File file = new File(locationDirPath);
        if (!file.exists()) {
            file.mkdir();
        }
        int n2 = (fileArray = file.listFiles()) == null ? 0 : fileArray.length;
        allConfigNamesVector = new Vector(n2);
        allConfigurationsMap = new HashMap(n2);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            File file2 = fileArray[i2];
            String string = file2.getName();
            if (!string.endsWith(configFileExtension)) continue;
            String string2 = GigaBenchmark.initConfiguration(file2);
            allConfigNamesVector.add(string2);
        }
        if (allConfigNamesVector.contains(DEFAULT_CONFIG_NAME)) {
            allConfigNamesVector.remove(DEFAULT_CONFIG_NAME);
            allConfigNamesVector.setElementAt(DEFAULT_CONFIG_NAME, 0);
        }
        comboBoxModel = new DefaultComboBoxModel(allConfigNamesVector);
    }

    public class ObjectTypeItem {
        private String _objectName;
        private String _objectTypeParameterName;

        public ObjectTypeItem(String string, String string2) {
            this._objectName = string;
            this._objectTypeParameterName = string2;
        }

        public String toString() {
            return this._objectName;
        }

        public String getMessageTypeParameterName() {
            return this._objectTypeParameterName;
        }
    }

    private class ConfigurationNameDialog
    extends JDialog
    implements ActionListener {
        private JButton okButton;
        private JButton cancelButton;
        private JTextField nameField;
        private String returnedVal;

        public ConfigurationNameDialog(JFrame jFrame, String string) {
            super(jFrame, string, true);
            this.init();
            this.setSize(new Dimension(300, 120));
            this.setResizable(false);
        }

        private void init() {
            JLabel jLabel = new JLabel("Please enter new configuration name:");
            Box box = new Box(0);
            box.add(Box.createHorizontalStrut(15));
            box.add(jLabel);
            box.add(Box.createHorizontalGlue());
            Box box2 = this.createTextFieldBox();
            Box box3 = this.createButtonBox();
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(Box.createVerticalStrut(5));
            container.add(box);
            container.add(Box.createVerticalStrut(3));
            container.add(box2);
            container.add(Box.createVerticalStrut(5));
            container.add(box3);
            container.add(Box.createVerticalStrut(5));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ConfigurationNameDialog.this.returnedVal = null;
                    ConfigurationNameDialog.this.setVisible(false);
                }

                public void windowOpened(WindowEvent windowEvent) {
                    ConfigurationNameDialog.this.nameField.setCaretPosition(ConfigurationNameDialog.this.nameField.getText().length());
                }
            });
        }

        public void setVisible(String string) {
            this.nameField.setText(string);
            this.nameField.selectAll();
            this.setVisible(true);
        }

        private Box createTextFieldBox() {
            this.nameField = new JTextField();
            Box box = new Box(0);
            box.add(Box.createHorizontalStrut(10));
            box.add(this.nameField);
            box.add(Box.createHorizontalStrut(10));
            Dimension dimension = new Dimension(270, 22);
            this.nameField.setPreferredSize(dimension);
            this.nameField.setMaximumSize(dimension);
            this.nameField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ConfigurationNameDialog.this.createNewConfig();
                    }
                }
            });
            return box;
        }

        private Box createButtonBox() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.setMnemonic('O');
            this.cancelButton.setMnemonic('C');
            Dimension dimension = new Dimension(70, 23);
            this.okButton.setPreferredSize(dimension);
            this.cancelButton.setPreferredSize(dimension);
            Box box = new Box(0);
            box.add(Box.createHorizontalGlue());
            box.add(this.okButton);
            box.add(Box.createHorizontalStrut(10));
            box.add(this.cancelButton);
            box.add(Box.createHorizontalGlue());
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            return box;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                this.createNewConfig();
            } else if (object == this.cancelButton) {
                this.returnedVal = null;
                this.setVisible(false);
            }
        }

        public String getNewName() {
            return this.returnedVal;
        }

        private void createNewConfig() {
            if (JSpaceUtilities.isEmpty(this.nameField.getText(), true)) {
                JOptionPane.showMessageDialog(this, "Name can not be empty. Please provide valid name.", "Configuration Name", 1);
            } else if (GigaBenchmark.this.isConfigNameExists(this.nameField.getText())) {
                JOptionPane.showMessageDialog(this, "Configuration with this name already exists.\nPlease provide another name.", "Configuration Name", 1);
            } else {
                this.returnedVal = this.nameField.getText();
                this.setVisible(false);
            }
        }
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray) throws IOException {
            String string = new String(byArray);
            GigaBenchmark.this.consoleOutput.append(string);
            GigaBenchmark.this.consoleOutput.setCaretPosition(GigaBenchmark.this.consoleOutput.getDocument().getLength());
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            String string = new String(byArray, n2, n3);
            GigaBenchmark.this.consoleOutput.append(string);
            GigaBenchmark.this.consoleOutput.setCaretPosition(GigaBenchmark.this.consoleOutput.getDocument().getLength());
        }
    }

    public class ResultsFileHandler
    implements ActionListener {
        public JFileChooser chooser = new JFileChooser();

        public ResultsFileHandler() {
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    boolean bl2 = false;
                    if (file != null && (file.getName().toLowerCase().endsWith(".xls") || file.isDirectory())) {
                        bl2 = true;
                    }
                    return bl2;
                }

                public String getDescription() {
                    return "GigaBenchmark Results XLS";
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            while (this.saveFile() == -1) {
            }
        }

        public int saveFile() {
            int n2 = this.chooser.showSaveDialog(GigaBenchmark.this.parentFrame);
            if (n2 == 0) {
                File file = this.chooser.getSelectedFile();
                String string = file.getName();
                if (!string.toLowerCase().endsWith(".xls")) {
                    string = string + ".xls";
                    file = new File(file.getAbsolutePath() + ".xls");
                }
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(GigaBenchmark.this.parentFrame, "The file \"" + file.getAbsolutePath() + "\" exists. Overwrite?", "Save", 0, 2)) == 1) {
                    return -1;
                }
                GigaBenchmark.this.fNameTextField.setText(file.getAbsolutePath());
            }
            return 0;
        }
    }
}

