/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.filters;

import com.j_spaces.core.filters.UserDefinedRole;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.components.ItemsControlPanel;
import com.j_spaces.tools.filters.UserDefinedRoleDialog;
import com.j_spaces.tools.filters.UserDetailsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class RolesManagerDialog
extends JDialog {
    public UserDetailsDialog parentDialog;
    public UserDefinedRoleDialog roleDetailsDialog;
    public ItemsControlPanel rolesPanel;
    public JButton butOK = new JButton("Close");
    public JButton butCancel = new JButton("Cancel");
    public boolean isAddAction;

    public RolesManagerDialog(UserDetailsDialog userDetailsDialog, boolean bl2) {
        super(userDetailsDialog, "Roles Manager", bl2);
        this.parentDialog = userDetailsDialog;
        this.roleDetailsDialog = new UserDefinedRoleDialog(this, true);
        this.rolesPanel = new ItemsControlPanel(new Object[]{"Role name", "Restrict System Roles"}, "User Defined Roles", false);
        this.rolesPanel.setDataModel(new CustomRolesTableModel());
        this.init();
        this.pack();
    }

    public void setUserDefinedRoles(UserDefinedRole[] userDefinedRoleArray) {
        this.rolesPanel.clean();
        for (int i2 = 0; i2 < userDefinedRoleArray.length; ++i2) {
            this.rolesPanel.addRow(new Object[]{userDefinedRoleArray[i2], userDefinedRoleArray[i2].inheritRoles.toString()});
        }
        this.rolesPanel.setSelectedRow(0);
    }

    public void fromRoleDialog_pressedOK(UserDefinedRole userDefinedRole) {
        if (this.isAddAction) {
            this.rolesPanel.addRow(new Object[]{userDefinedRole, userDefinedRole.inheritRoles});
            this.rolesPanel.setSelectedRow(this.rolesPanel.getDataModel().getRowCount() - 1);
            this.parentDialog.fromRoleManager_actionAddRole(userDefinedRole);
        } else {
            Vector vector = this.rolesPanel.getSelectedRowData();
            vector.clear();
            vector.add(0, userDefinedRole);
            vector.add(1, userDefinedRole.inheritRoles);
        }
    }

    public List getRoleNamesList() {
        Vector<String> vector = new Vector<String>();
        Vector<Vector> vector2 = this.rolesPanel.getDataModel().getDataVector();
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            Vector vector3 = vector2.get(i2);
            vector.add(vector3.get(0).toString());
        }
        return vector;
    }

    public UserDefinedRole[] getUserDefinedRoles() {
        Vector<Vector> vector = this.rolesPanel.getDataModel().getDataVector();
        UserDefinedRole[] userDefinedRoleArray = new UserDefinedRole[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Vector vector2 = vector.get(i2);
            userDefinedRoleArray[i2] = (UserDefinedRole)vector2.get(0);
        }
        return userDefinedRoleArray;
    }

    private void init() {
        this.rolesPanel.getButton("Add").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RolesManagerDialog.this.isAddAction = true;
                RolesManagerDialog.this.roleDetailsDialog.showDialogToAddNewRole();
            }
        });
        this.rolesPanel.getButton("Edit").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RolesManagerDialog.this.rolesPanel.hasSelectedRow()) {
                    RolesManagerDialog.this.isAddAction = false;
                    RolesManagerDialog.this.roleDetailsDialog.showDialogToEditRole((UserDefinedRole)RolesManagerDialog.this.rolesPanel.getSelectedRowData().get(0));
                }
            }
        });
        this.butCancel.setMnemonic(67);
        this.butCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RolesManagerDialog.this.dispose();
            }
        });
        this.butOK.setMnemonic(79);
        this.butOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RolesManagerDialog.this.parentDialog.fromRoleManager_actionOK();
                RolesManagerDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.butOK);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.rolesPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
    }

    public void show() {
        JSpaceUtilities.setLocationRelativeTo(this, this.parentDialog);
        super.show();
    }

    private class CustomRolesTableModel
    extends DefaultTableModel {
        public CustomRolesTableModel() {
            super(new Object[]{"Role name", "Restrict System Roles"}, 0);
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }
}

