/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.cluster.view;

import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.tools.cluster.ClusterMemberInfo;
import com.j_spaces.tools.cluster.GroupInfo;
import com.j_spaces.tools.cluster.view.ColumnHeaderToolTips;
import com.j_spaces.tools.cluster.view.ColumnSortListener;
import com.j_spaces.tools.general.GSCheckBoxCellRenderer;
import com.j_spaces.tools.general.GSRegularCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class MemberTransmissionPanel
extends JPanel {
    private GroupInfo m_ownerGroup;
    private ClusterMemberInfo[] m_membersInfo;
    private String m_lastSelectedMemberName;
    private MemberTransmissionTableModel m_transmTableModel;
    private JTextField m_sourceMember;
    private JTable m_table;
    private JScrollPane _transmisTableScrollPane;
    private String[] m_columnLabels;
    private String[] m_columnToolTips;
    private Font m_columnFont;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.ui.cluster.view");

    public MemberTransmissionPanel(GroupInfo groupInfo) {
        block4: {
            this.m_sourceMember = new JTextField();
            this.m_columnLabels = new String[]{"Enable", "Target Member", "Take", "Write", "Notify", "Sync on Commit"};
            this.m_columnToolTips = new String[]{"Enable/Disable Transmission", "Where a source member will be transmit operations", "Take operation", "Write operation", "Notify operation", "Sync on commit"};
            this.m_ownerGroup = groupInfo;
            if (groupInfo != null) {
                this.m_membersInfo = groupInfo.groupMembers;
            }
            try {
                this.init();
                if (groupInfo != null) {
                    this.init(groupInfo);
                }
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                _logger.log(Level.SEVERE, exception.toString(), exception);
            }
        }
    }

    public void init(GroupInfo groupInfo) {
        this.m_ownerGroup = groupInfo;
        if (groupInfo != null) {
            this.m_membersInfo = groupInfo.groupMembers;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_columnFont == null) {
            this.m_columnFont = this.m_table.getFont();
            this.m_table.getTableHeader().setFont(this.m_columnFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.m_columnFont);
            int n2 = 0;
            for (int i2 = 0; i2 < this.m_table.getColumnCount(); ++i2) {
                TableColumn tableColumn = this.m_table.getColumnModel().getColumn(i2);
                n2 = fontMetrics.stringWidth(this.m_columnLabels[i2]);
                if (i2 == 1) {
                    n2 += 30;
                }
                tableColumn.setPreferredWidth(n2);
            }
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.m_sourceMember.setEditable(false);
        this.m_sourceMember.setFont(new Font("Arial", 1, 12));
        this.m_transmTableModel = new MemberTransmissionTableModel();
        this.m_table = new JTable(this.m_transmTableModel);
        this.m_table.setSelectionMode(0);
        this.m_table.setAutoscrolls(true);
        this.m_table.setAutoCreateColumnsFromModel(false);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
        this.add((Component)this.m_sourceMember, "North");
        this.add((Component)new JScrollPane(this.m_table), "Center");
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
        for (int i2 = 0; i2 < this.m_table.getColumnCount(); ++i2) {
            TableColumn tableColumn = this.m_table.getColumnModel().getColumn(i2);
            columnHeaderToolTips.setToolTip(tableColumn, this.m_columnToolTips[i2]);
            if (i2 != 1) {
                tableColumn.setCellRenderer(new GSCheckBoxCellRenderer());
                continue;
            }
            tableColumn.setCellRenderer(new GSRegularCellRenderer());
        }
        jTableHeader.addMouseMotionListener(columnHeaderToolTips);
        jTableHeader.addMouseListener(new ColumnSortListener());
    }

    private ClusterMemberInfo getMemberInfo(String string) {
        for (int i2 = 0; i2 < this.m_membersInfo.length; ++i2) {
            if (!this.m_membersInfo[i2].memberName.equals(string)) continue;
            return this.m_membersInfo[i2];
        }
        return null;
    }

    public void updateTransmTable(String string) {
        ClusterMemberInfo clusterMemberInfo = this.getMemberInfo(string);
        if (clusterMemberInfo != null && this.m_ownerGroup.repInfo != null) {
            this.m_transmTableModel.updateMemberInfo(clusterMemberInfo);
            this.m_table.validate();
            this.m_table.repaint();
            this.m_lastSelectedMemberName = string;
            this.m_sourceMember.setText("Source member: " + string);
        }
    }

    public void clearTransmDetails() {
        this.m_transmTableModel.clear();
        this.m_sourceMember.setText("");
    }

    public void addClusterMember(ClusterMemberInfo clusterMemberInfo) {
        ClusterMemberInfo[] clusterMemberInfoArray = new ClusterMemberInfo[this.m_membersInfo.length + 1];
        for (int i2 = 0; i2 < this.m_membersInfo.length; ++i2) {
            clusterMemberInfoArray[i2] = this.m_membersInfo[i2];
        }
        clusterMemberInfoArray[i2] = clusterMemberInfo;
        this.m_membersInfo = clusterMemberInfoArray;
        this.updateTransmTable(clusterMemberInfo.memberName);
    }

    public class MemberTransmissionTableModel
    extends DefaultTableModel {
        public MemberTransmissionTableModel() {
            for (int i2 = 0; i2 < MemberTransmissionPanel.this.m_columnLabels.length; ++i2) {
                this.addColumn(MemberTransmissionPanel.this.m_columnLabels[i2]);
            }
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public Class getColumnClass(int n2) {
            Vector vector = (Vector)this.dataVector.elementAt(0);
            return vector.elementAt(n2).getClass();
        }

        public void clear() {
            int n2 = this.getRowCount();
            this.dataVector.clear();
            if (n2 > 0) {
                this.fireTableRowsDeleted(0, n2);
            }
        }

        public void updateMemberInfo(ClusterMemberInfo clusterMemberInfo) {
            Boolean bl2 = Boolean.FALSE;
            Boolean bl3 = Boolean.FALSE;
            Boolean bl4 = Boolean.FALSE;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = this.dataVector.size();
            this.dataVector.clear();
            if (!clusterMemberInfo.isMirror()) {
                if (clusterMemberInfo.m_replTransmissionPolicies != null && clusterMemberInfo.m_replTransmissionPolicies.size() > 0) {
                    Iterator iterator = clusterMemberInfo.m_replTransmissionPolicies.iterator();
                    while (iterator.hasNext()) {
                        ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)iterator.next();
                        bl2 = replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(84) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        bl3 = replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(87) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        bl4 = replicationTransmissionPolicy.m_RepTransmissionOperations.indexOf(78) != -1 ? Boolean.TRUE : Boolean.FALSE;
                        this.addRow(new Object[]{new Boolean(!replicationTransmissionPolicy.m_DisableTransmission), replicationTransmissionPolicy.m_TargetSpace, bl2, bl3, bl4, new Boolean(replicationTransmissionPolicy.m_SyncOnCommit)});
                        arrayList.add(replicationTransmissionPolicy.m_TargetSpace);
                    }
                    for (int i2 = 0; i2 < MemberTransmissionPanel.this.m_membersInfo.length; ++i2) {
                        if (arrayList.contains(((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i2].memberName) || ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i2].memberName.equals(clusterMemberInfo.memberName)) continue;
                        this.addRow(new Object[]{Boolean.TRUE, ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i2].memberName, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, new Boolean(false)});
                    }
                } else {
                    for (int i3 = 0; i3 < MemberTransmissionPanel.this.m_membersInfo.length; ++i3) {
                        if (((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i3].memberName.equals(clusterMemberInfo.memberName)) continue;
                        this.addRow(new Object[]{Boolean.TRUE, ((MemberTransmissionPanel)MemberTransmissionPanel.this).m_membersInfo[i3].memberName, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, new Boolean(false)});
                    }
                }
            } else if (n2 > 0) {
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }
    }
}

