/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceImpl;
import com.j_spaces.jmx.JMXSpace;
import com.j_spaces.jmx.JMXSpaceContainer;
import com.j_spaces.jmx.JMXSpaceExt;
import com.j_spaces.jmx.jini.JiniConnectorServerImpl;
import com.j_spaces.jmx.util.HtmlAdaptorFactory;
import com.j_spaces.jmx.util.JMXServiceURLFactory;
import com.j_spaces.jmx.util.ObjectNameFactory;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;

public class JMXProvider {
    public static final String CONTAINER_MBEAN_DESCR_URL = ResourceLoader.getResourceURL("ContainerMBeanDescriptors.xml").toString();
    public static final String JSPACE_MBEAN_DESCR_URL = ResourceLoader.getResourceURL("JavaSpaceMBeanDescriptors.xml").toString();
    public static final String JSPACE_EXT_MBEAN_DESCR_URL = ResourceLoader.getResourceURL("JavaSpaceExtMBeanDescriptors.xml").toString();
    public static final String JINI_CONNECTOR_MBEAN_DESCR_URL = ResourceLoader.getResourceURL("JiniConnectorMBeanDescriptors.xml").toString();
    public static final String DEFAULT_DOMAIN = "com.gigaspaces";
    private static MBeanServer a;
    private static JMXConnectorServer b;
    private static Hashtable c;
    private static boolean d;
    private static Properties e;
    private static Logger f;
    private static final String g = "Failed to receive MBean Server.";
    static /* synthetic */ Class class$javax$naming$NameAlreadyBoundException;

    private JMXProvider() {
    }

    public static synchronized MBeanServer getMBeanServer() {
        block13: {
            if (a == null) {
                try {
                    try {
                        a = ManagementFactory.getPlatformMBeanServer();
                    }
                    catch (Throwable throwable) {
                        a = MBeanServerFactory.createMBeanServer();
                    }
                    String string = JProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.url", "localhost:10098");
                    String string2 = "service:jmx:rmi:///jndi/rmi://" + string + "/jmxrmi";
                    Properties properties = System.getProperties();
                    b = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(string2), properties, a);
                    if (!b.isActive()) {
                        b.start();
                    }
                    if (f.isLoggable(Level.INFO)) {
                        f.info("\nNew JMXConnectorServer was successfully registered into the MBeanServer using service url: " + string2 + "\n");
                    }
                }
                catch (IOException iOException) {
                    String string;
                    Class<?> clazz = class$javax$naming$NameAlreadyBoundException;
                    if (clazz == null) {
                        clazz = class$javax$naming$NameAlreadyBoundException = new NameAlreadyBoundException[0].getClass().getComponentType();
                    }
                    if ((string = JSpaceUtilities.getCauseExceptionMessageFromHierarchy(iOException, clazz)) != null) {
                        if (f.isLoggable(Level.FINEST)) {
                            f.log(Level.FINEST, g + iOException.toString(), iOException);
                        }
                    } else if (f.isLoggable(Level.WARNING)) {
                        f.log(Level.WARNING, g + iOException.toString(), iOException);
                    }
                }
                catch (Throwable throwable) {
                    if (!f.isLoggable(Level.WARNING)) break block13;
                    f.log(Level.WARNING, g + throwable.toString(), throwable);
                }
            }
        }
        return a;
    }

    public static boolean isJMXEnabled() {
        return d;
    }

    public static String getJmxProperty(String string) {
        return e != null ? e.getProperty(string) : null;
    }

    public static void startManagementAgent(Properties properties) {
        e = properties;
        d = true;
        System.setProperty("setup.jmx.enabled", "true");
        boolean bl2 = Boolean.valueOf(properties.getProperty("setup.jmx.adaptor.html.enabled", "false"));
        boolean bl3 = Boolean.valueOf(properties.getProperty("setup.jmx.adaptor.snmp.enabled", "false"));
        boolean bl4 = Boolean.valueOf(properties.getProperty("setup.jmx.connector.rmi.enabled", "false"));
        boolean bl5 = Boolean.valueOf(properties.getProperty("setup.jmx.connector.jini.enabled", "false"));
        String string = properties.getProperty("setup.jmx.agent_domain");
        if (string == null || string.trim().length() <= 0) {
            string = JProperties.getProperty("com.j_spaces.core.container.name");
        }
        a = MBeanServerFactory.createMBeanServer(string);
        if (f.isLoggable(Level.INFO)) {
            f.info("Create the JMX agent at domain: " + string);
        }
        if (bl2) {
            HtmlAdaptorFactory.startHtmlAdaptor(a, properties);
        }
        if (bl5) {
            JMXProvider.a(properties);
        }
        if (bl4) {
            JMXProvider.b(properties);
        }
        JMXProvider.registerMLetService("MLetService");
    }

    private static void a(Properties properties) {
        block3: {
            try {
                JiniConnectorServerImpl jiniConnectorServerImpl = new JiniConnectorServerImpl(JINI_CONNECTOR_MBEAN_DESCR_URL);
                ObjectName objectName = new ObjectName(properties.getProperty("setup.jmx.connector.jini.objectname", "Connector:type=JINI"));
                JMXProvider.getMBeanServer().registerMBean(jiniConnectorServerImpl, objectName);
                jiniConnectorServerImpl.start();
                if (f.isLoggable(Level.INFO)) {
                    f.info("JiniConnectorServer started ");
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block3;
                f.log(Level.WARNING, exception.toString(), exception);
            }
        }
    }

    private static void b(Properties properties) {
        block5: {
            try {
                String string;
                String string2 = InetAddress.getLocalHost().getHostName();
                String string3 = JProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.url", "localhost:10098");
                JMXServiceURL jMXServiceURL = JMXServiceURLFactory.createConnectorServiceURL("rmi", string3, string2);
                JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, null, JMXProvider.getMBeanServer());
                if (f.isLoggable(Level.INFO)) {
                    f.info("JMXServiceURL=" + jMXServiceURL);
                }
                if ((string = properties.getProperty("setup.jmx.connector.rmi.objectname")) == null || string.length() <= 0) {
                    throw new MalformedObjectNameException("Missed or invalid ObjectName definition for RMIConnectionServer.");
                }
                JMXProvider.getMBeanServer().registerMBean(jMXConnectorServer, new ObjectName(string));
                jMXConnectorServer.start();
                if (f.isLoggable(Level.INFO)) {
                    f.info("RMIConnectorServer started at: " + jMXServiceURL);
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block5;
                f.log(Level.WARNING, exception.toString(), exception);
            }
        }
    }

    public static void registerContainerMBean(IJSpaceContainer iJSpaceContainer) throws Exception {
        MBeanServer mBeanServer = JMXProvider.getMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        String string = iJSpaceContainer.getName();
        if (c.containsKey(string)) {
            return;
        }
        JMXSpaceContainer jMXSpaceContainer = new JMXSpaceContainer(iJSpaceContainer, CONTAINER_MBEAN_DESCR_URL);
        ObjectName objectName = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, jMXSpaceContainer.getType(), string);
        c.put(string, mBeanServer.registerMBean(jMXSpaceContainer, objectName));
        if (f.isLoggable(Level.INFO)) {
            f.info("\nContainer <" + string + "> MBean was registered successfully.\n");
        }
    }

    public static void unregisterContainerMBean(IJSpaceContainer iJSpaceContainer) throws Exception {
        block5: {
            if (JMXProvider.getMBeanServer() == null) {
                return;
            }
            String string = iJSpaceContainer.getName();
            try {
                ObjectInstance objectInstance = (ObjectInstance)c.remove(string);
                if (objectInstance != null) {
                    JMXProvider.getMBeanServer().unregisterMBean(objectInstance.getObjectName());
                    if (f.isLoggable(Level.INFO)) {
                        f.info("Container <" + string + "> MBean was unregistered successfully.");
                    }
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block5;
                f.log(Level.WARNING, "Failed to unregister MBean for <" + string + "> container", exception);
            }
        }
    }

    public static void registerSpaceMBean(String string, JSpaceImpl jSpaceImpl) {
        block5: {
            MBeanServer mBeanServer = JMXProvider.getMBeanServer();
            if (mBeanServer == null) {
                return;
            }
            if (c.containsKey(string)) {
                return;
            }
            try {
                IJSpace iJSpace = jSpaceImpl.getSpaceProxy(false, null);
                JMXSpace jMXSpace = new JMXSpace(iJSpace, JSPACE_MBEAN_DESCR_URL);
                ObjectName objectName = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, jMXSpace.getType(), jSpaceImpl.c + '-' + string);
                c.put(string, mBeanServer.registerMBean(jMXSpace, objectName));
                JMXSpaceExt jMXSpaceExt = new JMXSpaceExt(iJSpace, jMXSpace.m_spaceConfig, JSPACE_EXT_MBEAN_DESCR_URL);
                ObjectName objectName2 = ObjectNameFactory.buildObjectName(DEFAULT_DOMAIN, jMXSpaceExt.getType(), jSpaceImpl.c + '-' + string);
                c.put(string + "Ext", mBeanServer.registerMBean(jMXSpaceExt, objectName2));
                if (f.isLoggable(Level.INFO)) {
                    f.info("\nSpace <" + string + "> MBean was registered successfully.\n");
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block5;
                f.log(Level.WARNING, "Failed to register MBean for " + string + " space.", exception);
            }
        }
    }

    public static void unregisterSpaceMBean(String string) {
        block6: {
            if (JMXProvider.getMBeanServer() == null) {
                return;
            }
            try {
                ObjectInstance objectInstance = (ObjectInstance)c.remove(string);
                if (objectInstance != null) {
                    JMXProvider.getMBeanServer().unregisterMBean(objectInstance.getObjectName());
                }
                if ((objectInstance = (ObjectInstance)c.remove(string + "Ext")) != null) {
                    JMXProvider.getMBeanServer().unregisterMBean(objectInstance.getObjectName());
                }
                if (f.isLoggable(Level.INFO)) {
                    f.info("Space <" + string + "> MBean was unregister successfully.");
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block6;
                f.log(Level.WARNING, "Failed to unregister MBean for <" + string + "> space.", exception);
            }
        }
    }

    public static void registerMLetService(String string) {
        block5: {
            if (JMXProvider.getMBeanServer() == null) {
                return;
            }
            if (c.containsKey(string)) {
                return;
            }
            try {
                c.put(string, JMXProvider.getMBeanServer().registerMBean(new MLet(), new ObjectName("Service:type=MLET,name=" + string)));
                if (f.isLoggable(Level.INFO)) {
                    f.info("MLet service <" + string + "> started successfully.");
                }
            }
            catch (Exception exception) {
                if (!f.isLoggable(Level.WARNING)) break block5;
                f.log(Level.WARNING, "Failed to register MLET service : ", exception);
            }
        }
    }

    static {
        c = new Hashtable();
        f = Logger.getLogger("com.gigaspaces.admin");
    }
}

