/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class GSObjectMessageImpl
extends GSMessageImpl
implements ObjectMessage {
    public GSObjectMessageImpl(GSSessionImpl gSSessionImpl, Serializable serializable) throws JMSException {
        super(gSSessionImpl, "Object");
        if (serializable != null) {
            this.setObject(serializable);
        }
    }

    public GSObjectMessageImpl(GSSessionImpl gSSessionImpl) throws JMSException {
        this(gSSessionImpl, (Serializable)null);
    }

    public final void setObject(Serializable serializable) throws MessageNotWriteableException, JMSException {
        try {
            this.setBodyAsBytes(null);
            this.m_body_object = serializable;
            this.getBodyAsBytes();
        }
        catch (IOException iOException) {
            MessageFormatException messageFormatException = new MessageFormatException(iOException.getMessage());
            messageFormatException.setLinkedException(iOException);
            throw messageFormatException;
        }
    }

    public final Serializable getObject() throws MessageFormatException {
        if (this.m_body_object == null) {
            try {
                super.buildBodyFromBytes();
            }
            catch (Exception exception) {
                MessageFormatException messageFormatException = new MessageFormatException("Error while deserializing the wrapped object: " + exception.getMessage());
                throw messageFormatException;
            }
        }
        return this.m_body_object;
    }

    public final void clearBody() throws JMSException {
        super.clearBody();
        this.m_bodyRO = false;
    }

    public String toString() {
        return '(' + super.toString() + " ,object message body= " + this.m_body_object + " ,m_body_bytes= " + this.m_body_bytes + ')';
    }

    public void prepare() throws Exception {
        super.prepare();
        this.convertBodyToBytes();
        this.clearBody();
    }

    public void writeBody(DataOutput dataOutput) throws IOException {
        SerializationHelper.writeObject((OutputStream)((Object)dataOutput), this.m_body_object);
    }

    public void readBody(DataInput dataInput) throws IOException {
        try {
            this.m_body_object = (Serializable)SerializationHelper.readObject((InputStream)((Object)dataInput));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
    }
}

