/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Integer;

public class LoadBalancingPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String m_GroupName;
    public List loadBalanceGroupMembersNames;
    public List loadBalanceGroupMembersURLs;
    public String m_ImplementationClassName;
    public boolean m_ApplyOwnership;
    public boolean m_DisableParallelScattering;
    public boolean m_DisableMultiSpacesBroadcast;
    public static final int DEFAULT_BROADCAST_THREADPOOL_MIN_SIZE = 4;
    public static final int DEFAULT_BROADCAST_THREADPOOL_MAX_SIZE = 64;
    public int m_broadcastThreadpoolMinSize = 4;
    public int m_broadcastThreadpoolMaxSize = 64;
    public LoadBalancingPolicyDescription m_WriteOperationsPolicy;
    public LoadBalancingPolicyDescription m_ReadOperationsPolicy;
    public LoadBalancingPolicyDescription m_TakeOperationsPolicy;
    public LoadBalancingPolicyDescription m_NotifyOperationsPolicy;
    public LoadBalancingPolicyDescription m_DefaultPolicy;
    public static final int OPERATION_NONE = 0;
    public static final int OPERATION_WRITE = 1;
    public static final int OPERATION_READ = 2;
    public static final int OPERATION_READIE = 3;
    public static final int OPERATION_TAKE = 4;
    public static final int OPERATION_TAKEIE = 5;
    public static final int OPERATION_NOTIFY = 6;
    public static final int OPERATION_COUNT = 7;
    public static final int OPERATION_CLEAR = 8;
    public static final int OPERATION_WRITE_MULTIPLE = 9;
    public static final int OPERATION_READ_MULTIPLE = 10;
    public static final int OPERATION_TAKE_MULTIPLE = 11;
    public static final int OPERATION_UPDATE = 12;
    public static final int OPERATION_UPDATE_MULTIPLE = 13;

    public String getPolicyTypeFromOperationId(int n2) {
        switch (n2) {
            case 0: {
                return "none-policy";
            }
            case 1: {
                return this.m_WriteOperationsPolicy != null ? this.m_WriteOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 2: {
                return this.m_ReadOperationsPolicy != null ? this.m_ReadOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 3: {
                return this.m_ReadOperationsPolicy != null ? this.m_ReadOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 4: {
                return this.m_TakeOperationsPolicy != null ? this.m_TakeOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 5: {
                return this.m_TakeOperationsPolicy != null ? this.m_TakeOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 6: {
                return this.m_NotifyOperationsPolicy != null ? this.m_NotifyOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 7: {
                return this.m_ReadOperationsPolicy != null ? this.m_ReadOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 8: {
                return this.m_TakeOperationsPolicy != null ? this.m_TakeOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 9: {
                return this.m_WriteOperationsPolicy != null ? this.m_WriteOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 10: {
                return this.m_ReadOperationsPolicy != null ? this.m_ReadOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 11: {
                return this.m_TakeOperationsPolicy != null ? this.m_TakeOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 12: {
                return this.m_WriteOperationsPolicy != null ? this.m_WriteOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
            case 13: {
                return this.m_WriteOperationsPolicy != null ? this.m_WriteOperationsPolicy.m_PolicyType : this.m_DefaultPolicy.m_PolicyType;
            }
        }
        return "unknown operation id: " + n2;
    }

    public static String getOperationName(int n2) {
        switch (n2) {
            case 0: {
                return "none";
            }
            case 1: {
                return "write";
            }
            case 2: {
                return "read";
            }
            case 3: {
                return "read if exists";
            }
            case 4: {
                return "take";
            }
            case 5: {
                return "take if exists";
            }
            case 6: {
                return "notify";
            }
            case 7: {
                return "count";
            }
            case 8: {
                return "clear";
            }
            case 9: {
                return "write multiple";
            }
            case 10: {
                return "read multiple";
            }
            case 11: {
                return "take multiple";
            }
            case 12: {
                return "update";
            }
            case 13: {
                return "update multiple";
            }
        }
        return "unknown operation id: " + n2;
    }

    public List getRecoverableTargets(String string, String string2) {
        LinkedList<SpaceURL> linkedList = new LinkedList<SpaceURL>();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.loadBalanceGroupMembersNames.size(); ++i2) {
            SpaceURL spaceURL;
            String string3 = (String)this.loadBalanceGroupMembersNames.get(i2);
            if (string3.equals(string2) || (spaceURL = (SpaceURL)((SpaceURL)this.loadBalanceGroupMembersURLs.get(i2)).clone()) == null) continue;
            if (spaceURL.getProtocol().equalsIgnoreCase("jini:")) {
                if (!bl2) {
                    SpaceURL spaceURL2 = (SpaceURL)spaceURL.clone();
                    spaceURL2.setPropertiesPrefix("jini:", "*", "*", "*");
                    spaceURL2.setProperty("clustername", string);
                    spaceURL2.setProperty("state", JSpaceState.convertToString(_Integer.valueOf(1)));
                    linkedList.addFirst(spaceURL2);
                    bl2 = true;
                }
                if (spaceURL.getProperty("host") == null || "*".equals(spaceURL.getProperty("host"))) continue;
                spaceURL.setProperty("clustername", string);
                spaceURL.setProperty("state", JSpaceState.convertToString(_Integer.valueOf(1)));
                linkedList.add(spaceURL);
                continue;
            }
            linkedList.add(spaceURL);
        }
        return linkedList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("------------ LoadBalancing Policy ---------\n");
        stringBuffer.append("Group Name -\t" + this.m_GroupName + "\n");
        stringBuffer.append("Load Balancing Group Members Name -\t" + this.loadBalanceGroupMembersNames + "\n");
        stringBuffer.append("Load Balancing Group Members URL -\t" + this.loadBalanceGroupMembersURLs + "\n");
        stringBuffer.append("Implementation Class Name -\t" + this.m_ImplementationClassName + "\n");
        stringBuffer.append("Is apply ownership -\t" + this.m_ApplyOwnership + "\n");
        stringBuffer.append("Is disable Parallel Scattering -\t" + this.m_DisableParallelScattering + "\n");
        stringBuffer.append("Is disable Multi Spaces Broadcast -\t" + this.m_DisableMultiSpacesBroadcast + "\n");
        stringBuffer.append("Broadcast Thread Pool Min Size -\t" + this.m_broadcastThreadpoolMinSize + "\n");
        stringBuffer.append("Broadcast Thread Pool Max Size -\t" + this.m_broadcastThreadpoolMaxSize + "\n");
        stringBuffer.append("\nWrite Operations Policy -\t" + this.m_WriteOperationsPolicy + "\n");
        stringBuffer.append("\nRead Operations Policy -\t" + this.m_ReadOperationsPolicy + "\n");
        stringBuffer.append("\nTake Operations Policy -\t" + this.m_TakeOperationsPolicy + "\n");
        stringBuffer.append("\nNotify Operations Policy -\t" + this.m_NotifyOperationsPolicy + "\n");
        stringBuffer.append("\nDefault Policy -\t" + this.m_DefaultPolicy + "\n");
        return stringBuffer.toString();
    }

    public static final class BroadcastCondition
    extends Enum_ {
        public static final BroadcastCondition BROADCAST_IF_NULL_VALUES = new BroadcastCondition("BROADCAST_IF_NULL_VALUES", 0);
        public static final BroadcastCondition UNCONDITIONAL = new BroadcastCondition("UNCONDITIONAL", 1);
        public static final BroadcastCondition BROADCAST_DISABLED = new BroadcastCondition("BROADCAST_DISABLED", 2);
        private static final /* synthetic */ BroadcastCondition[] $VALUES;
        static /* synthetic */ Class class$com$j_spaces$core$cluster$LoadBalancingPolicy$BroadcastCondition;

        public static final BroadcastCondition[] values() {
            return (BroadcastCondition[])$VALUES.clone();
        }

        public static BroadcastCondition valueOf(String string) {
            Class<?> clazz = class$com$j_spaces$core$cluster$LoadBalancingPolicy$BroadcastCondition;
            if (clazz == null) {
                clazz = class$com$j_spaces$core$cluster$LoadBalancingPolicy$BroadcastCondition = new BroadcastCondition[0].getClass().getComponentType();
            }
            return (BroadcastCondition)Enum_.valueOf(clazz, string);
        }

        private BroadcastCondition(String string, int n2) {
            super(string, n2);
        }

        static {
            $VALUES = new BroadcastCondition[]{BROADCAST_IF_NULL_VALUES, UNCONDITIONAL, BROADCAST_DISABLED};
            Class<?> clazz = class$com$j_spaces$core$cluster$LoadBalancingPolicy$BroadcastCondition;
            if (clazz == null) {
                clazz = class$com$j_spaces$core$cluster$LoadBalancingPolicy$BroadcastCondition = new BroadcastCondition[0].getClass().getComponentType();
            }
            Enum_.setEnumConstants(clazz, BroadcastCondition.values());
        }
    }

    public static class LoadBalancingPolicyDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String m_PolicyType;
        public Properties m_Properties;
        public BroadcastCondition m_BroadcastCondition;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n");
            stringBuffer.append("------------Load Balancing Policy Description---------\n");
            stringBuffer.append("Policy Type -\t" + this.m_PolicyType + "\n");
            stringBuffer.append("Properties -\t" + JSpaceUtilities.getPropertiesPresentation(this.m_Properties) + "\n");
            stringBuffer.append("Broadcast Condition -\t" + this.m_BroadcastCondition + "\n");
            return stringBuffer.toString();
        }
    }
}

