/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.j_spaces.core.CreateException;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.LoadBalanceImpl;
import com.j_spaces.core.cluster.LoadBalancingPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationTransmissionPolicy;
import com.j_spaces.core.cluster.sync_replication.MulticastProtocolAdaptor;
import com.j_spaces.core.cluster.sync_replication.SyncReplPolicy;
import com.j_spaces.core.exception.ClusterConfigurationException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.obf.aa;
import com.j_spaces.obf.dm;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.retrotranslator.runtime.java.lang._Boolean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ClusterXML {
    public static final String CLUSTER_MEMBER_URL_PROTOCOL_PREFIX = "com.gs.cluster.url-protocol-prefix";
    public static final String CLUSTER_MEMBER_URL_PROTOCOL_PREFIX_DEF = "jini://*/";
    private static boolean f = Boolean.getBoolean("com.gs.clusterXML.debug");
    public static final String CLUSTER_SCHEMA_NAME_TAG = "cluster-schema-name";
    public static final String CLUSTER_SCHEMA_DESCRIPTION_TAG = "description";
    public static final String CLUSTER_XML_FILE_SUFFIX = "-cluster.xml";
    public static final String CLUSTER_XML_DYNAMIC_MEMBERS_TAG = "dynamic-members-generation";
    public static final String CLUSTER_SCHEMA_XSL_FILE_SUFFIX = "-cluster-schema.xsl";
    public static final String CLUSTER_SCHEMA_NAME_ASYNC_REPLICATED = "async_replicated";
    public static final String CLUSTER_SCHEMA_NAME_ASYNC_REPLICATED_SYNC2BACKUP = "async-repl-sync2backup";
    public static final String CLUSTER_SCHEMA_NAME_SYNC_REPLICATED = "sync_replicated";
    public static final String CLUSTER_SCHEMA_NAME_PARTITIONED = "partitioned";
    public static final String CLUSTER_SCHEMA_NAME_OWENERSHIP_REPLICATED = "ownership-replicated";
    public static final String CLUSTER_SCHEMA_NAME_PRIMARY_BACKUP = "primary_backup";
    public static final String CLUSTER_SCHEMA_NAME_PARTITIONED_SYNC2BACKUP = "partitioned-sync2backup";
    public static final String[] CLUSTER_PREDEFINED_SCHEMAS = new String[]{"async_replicated", "sync_replicated", "partitioned", "primary_backup", "partitioned-sync2backup", "async-repl-sync2backup", "ownership-replicated"};
    public static final String CLUSTER_CONFIG_TAG = "cluster-config";
    public static final String GROUP_TAG = "group";
    public static final String GROUPS_TAG = "groups";
    public static final String GROUPS_MEMBERS = "group-members";
    public static final String GROUP_NAME_TAG = "group-name";
    public static final String MEMBER_TAG = "member";
    public static final String PARAM_TAG = "param";
    public static final String PARAM_NAME_TAG = "param-name";
    public static final String PARAM_VALUE_TAG = "param-value";
    public static final String MEMBER_NAME_TAG = "member-name";
    public static final String MEMBER_URL_TAG = "member-url";
    public static final String FAIL_OVER_POLICY_TAG = "fail-over-policy";
    public static final String FAIL_OVER_FIND_TIMEOUT_TAG = "fail-over-find-timeout";
    public static final String FAIL_OVER_FAILBACK_TAG = "fail-back";
    public static final String FAIL_OVER_DISABLE_ALTERNATE_GROUP_TAG = "disable-alternate-group";
    public static final String ALTERNATE_GROUP_TAG = "alternate-groups";
    public static final String FAIL_OVER_BACKUP_MEMBER_TAG = "backup-member";
    public static final String FAIL_OVER_BACKUP_MEMBERS_TAG = "backup-members";
    public static final String FAIL_OVER_BACKUP_MEMBERS_ONLY_TAG = "backup-members-only";
    public static final String FAIL_OVER_BACKUP_MEMBER_ONLY_TAG = "backup-member-only";
    public static final String FAIL_OVER_SOURCE_MEMBER_TAG = "source-member";
    public static final String POLICY_TYPE_TAG = "policy-type";
    public static final String BROADCAST_CONDITION_TAG = "broadcast-condition";
    public static final String CLUSTER_MEMBERS_TAG = "cluster-members";
    public static final String CLUSTER_NAME_TAG = "cluster-name";
    public static final String MIRROR_SERVICE_TAG = "mirror-service";
    public static final String MIRROR_SERVICE_URL_TAG = "url";
    public static final String MIRROR_SERVICE_BULK_SIZE_TAG = "bulk-size";
    public static final String MIRROR_SERVICE_INTERVAL_MILLIS_TAG = "interval-millis";
    public static final String MIRROR_SERVICE_INTERVAL_OPERS_TAG = "interval-opers";
    public static final String MIRROR_SERVICE_ENABLED_DEFAULT_VALUE = String.valueOf(false);
    public static final String MIRROR_SERVICE_URL_DEFAULT_VALUE = "jini://*/mirror-service_container/mirror-service";
    public static final String MIRROR_SERVICE_BULK_SIZE_DEFAULT_VALUE = String.valueOf(100);
    public static final String MIRROR_SERVICE_INTERVAL_MILLIS_DEFAULT_VALUE = String.valueOf(2000);
    public static final String MIRROR_SERVICE_INTERVAL_OPERS_DEFAULT_VALUE = String.valueOf(100);
    public static final String PROXY_BROADCAST_THREADPOOL_MIN_SIZE_DEFAULT_VALUE = String.valueOf(4);
    public static final String PROXY_BROADCAST_THREADPOOL_MAX_SIZE_DEFAULT_VALUE = String.valueOf(64);
    public static final String CACHE_LOADER_TAG = "cache-loader";
    public static final String CACHE_LOADER_EXTERNAL_DATA_SOURCE = "external-data-source";
    public static final String CACHE_LOADER_CENTRAL_DATA_SOURCE = "central-data-source";
    public static final String CACHE_LOADER_EXTERNAL_DATA_SOURCE_DEFAULT_VALUE = "${com.gs.cluster.cache-loader.external-data-source}";
    public static final String CACHE_LOADER_CENTRAL_DATA_SOURCE_DEFAULT_VALUE = "${com.gs.cluster.cache-loader.central-data-source}";
    public static final String ASYNC_REPLICATION_TAG = "async-replication";
    public static final String REPL_POLICY_TAG = "repl-policy";
    public static final String REPL_SYNC_ON_COMMIT_TAG = "sync-on-commit";
    public static final String REPL_SYNC_ON_COMMIT_TIMEOUT_TAG = "sync-on-commit-timeout";
    public static final String REPL_NOTIFY_TEMPLATE_TAG = "replicate-notify-templates";
    public static final String REPL_TRIGGER_NOTIFY_TEMPLATES_TAG = "trigger-notify-templates";
    public static final String REPL_CHUNK_SIZE_TAG = "repl-chunk-size";
    public static final String REPL_INTERVAL_MILLIS_TAG = "repl-interval-millis";
    public static final String REPL_INTERVAL_OPERS_TAG = "repl-interval-opers";
    public static final String REPL_FIND_TIMEOUT_TAG = "repl-find-timeout";
    public static final String REPL_FIND_REPORT_INTERVAL_TAG = "repl-find-report-interval";
    public static final String REPL_MEMORY_RECOVERY_TAG = "recovery";
    public static final String REPL_ORIGINAL_STATE_TAG = "repl-original-state";
    public static final String REPL_REDO_LOG_CAPACITY_TAG = "redo-log-capacity";
    public static final String RECOVERY_CHUNK_SIZE_TAG = "recovery-chunk-size";
    public static final String REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE = String.valueOf(30000);
    public static final String REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE = String.valueOf(-1);
    public static final String RECOVERY_CHUNK_SIZE_DEFAULT_VALUE = String.valueOf(1000);
    public static final String REPL_TRANSMISSION_TAG = "repl-transmission-policy";
    public static final String REPL_DISABLE_TRANSMISSION_TAG = "disable-transmission";
    public static final String REPL_TARGET_MEMBER_TAG = "target-member";
    public static final String REPL_TRANSMISSION_OPERATIONS_TAG = "transmission-operations";
    public static final String[] REPL_TRANSMISSION_OPERATIONS = new String[]{"notify", "take", "write"};
    public static final String REPL_FILTERS_TAG = "repl-filters";
    public static final String REPL_INPUT_FILTER_CLASSNAME_TAG = "input-filter-className";
    public static final String REPL_INPUT_FILTER_PARAM_URL_TAG = "input-filter-paramUrl";
    public static final String REPL_OUTPUT_FILTER_CLASSNAME_TAG = "output-filter-className";
    public static final String REPL_OUTPUT_FILTER_PARAM_URL_TAG = "output-filter-paramUrl";
    public static final String REPL_ACTIVE_WHEN_BACKUP_TAG = "active-when-backup";
    public static final String REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG = "shutdown-space-on-init-failure";
    public static final String REPL_ACTIVE_WHEN_BACKUP_DEFAULT = "true";
    public static final String REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT = "false";
    public static final String REPL_MEMBER_RECOVERY_TAG = "repl-recovery";
    public static final String ENABLED_TAG = "enabled";
    public static final String REPL_SOURCE_MEMBER_URL_TAG = "source-member-name";
    public static final String LOAD_BAL_TAG = "load-bal-policy";
    public static final String LOAD_BAL_IMPL_CLASS_TAG = "load-bal-impl-class";
    public static final String APPLY_OWNERSHIP_TAG = "apply-ownership";
    public static final String DISABLE_PARALLEL_SCATTERING_TAG = "disable-parallel-scattering";
    public static final String PROXY_BROADCAST_THREADPOOL_MIN_SIZE_TAG = "proxy-broadcast-threadpool-min-size";
    public static final String PROXY_BROADCAST_THREADPOOL_MAX_SIZE_TAG = "proxy-broadcast-threadpool-max-size";
    public static final String NOTIFY_RECOVERY_TAG = "notify-recovery";
    public static final String NOTIFY_RECOVERY_DEFAULT_VALUE = String.valueOf(true);
    public static final String WRITE_TAG = "write";
    public static final String READ_TAG = "read";
    public static final String TAKE_TAG = "take";
    public static final String NOTIFY_TAG = "notify";
    public static final String DEFAULT_TAG = "default";
    public static final String BC_IF_NULL_VALUES_TAG = "broadcast-if-null-values";
    public static final String BC_UNCONDITIONAL_TAG = "unconditional";
    public static final String BC_BROADCAST_DISABLED_TAG = "broadcast-disabled";
    public static final String REPL_RECEIVER_ACK_POSTFIX = "-rec-ack";
    public static final String REPLICATION_MODE_TAG = "replication-mode";
    public static final String COMMUNICATION_MODE_TAG = "communication-mode";
    public static final String SYNC_REPL_UNICAST_TAG = "unicast";
    public static final String SYNC_REPL_MULTICAST_TAG = "multicast";
    public static final String SYNC_REPLICATION_TAG = "sync-replication";
    public static final String MIN_WORK_THREADS_TAG = "min-work-threads";
    public static final String MAX_WORK_THREADS_TAG = "max-work-threads";
    public static final String RESPONSE_TIMEOUT_TAG = "response-timeout";
    public static final String TODO_QUEUE_TIMEOUT_TAG = "todo-queue-timeout";
    public static final String HOLD_TXN_LOCK_TAG = "hold-txn-lock";
    public static final String IP_GROUP_TAG = "ip-group";
    public static final String PORT_TAG = "port";
    public static final String TTL_TAG = "ttl";
    public static final String TTL_DEFAULT_VALUE = String.valueOf(4);
    public static final String ACK_INTERVAL_TAG = "ack-interval";
    public static final String ADAPTIVE_MULTICAST_TAG = "adaptive";
    public static final String HOLD_TXN_LOCK_DEFAULT_VALUE = String.valueOf(false);
    public static final String FAIL_IN_GROUP = "fail-in-group";
    public static final String FAIL_TO_BACKUP = "fail-to-backup";
    public static final String FAIL_TO_ALTERNATE = "fail-to-alternate";
    public static final String FULL_REPLICATION = "full-replication";
    public static final String PARTIAL_REPLICATION = "partial-replication";
    public static final String[] FAIL_OVER_POLICIES = new String[]{"fail-in-group", "fail-to-backup", "fail-to-alternate"};
    public static final String DCACHE_TAG = "dist-cache";
    public static final String DCACHE_CONFIG_NAME_TAG = "config-name";
    public static final String JMS_TAG = "jms";
    public static final String JMS_CONFIG_NAME_TAG = "config-name";
    public static final String a = "clusterXML-Schema.xsd";
    public static final String b = "/transmission-policy-template.xml";
    public static final String FIRST_AVAILABLE_MEMBER = "First available member";
    public static final String c = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String d = "http://www.w3.org/2001/XMLSchema";
    public static final String e = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private ClusterPolicy g;
    private String h;
    private String[] i;
    private Map j;
    private Document k;
    private String l;
    private SpaceURL m;
    private String n;
    private boolean o = false;
    private boolean p = true;
    private StringBuffer q;
    private static TransformerFactory r;
    public static final String BC_BROADCAST_IF_NULL_VALUES = "broadcast-if-null-values";
    public static final String BC_UNCONDITIONAL = "unconditional";
    public static final String BC_BROADCAST_DISABLED = "broadcast-disabled";
    public static final String[] BROADCAST_CONDITIONS_ARRAY;
    private static final Logger s;
    private static boolean t;
    static /* synthetic */ Class class$com$j_spaces$core$cluster$LoadBalanceImpl;
    static /* synthetic */ Class class$com$j_spaces$core$cluster$sync_replication$MulticastProtocolAdaptor;

    public ClusterXML(SpaceURL spaceURL, String string, String string2) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this.m = spaceURL;
        String string3 = null;
        if (spaceURL != null) {
            string3 = spaceURL.getClusterSchema();
        }
        if (!JSpaceUtilities.isEmpty(string3)) {
            int n2 = 0;
            int n3 = 0;
            String string4 = spaceURL.getProperty("total_members");
            String[] stringArray = string4.trim().split(",");
            if (stringArray.length > 1) {
                n2 = Integer.valueOf(stringArray[0]);
                n3 = Integer.valueOf(stringArray[1]);
            } else {
                n2 = Integer.valueOf(stringArray[0]);
            }
            this.a(n2, n3, string3, string2, null, null, spaceURL.getProperty(GROUPS_TAG), spaceURL);
        } else {
            this.b(string);
        }
    }

    public ClusterXML(int n2, int n3, String string, String string2, String string3, String string4, String string5) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this.a(n2, n3, string, string2, string3, string4, string5, null);
    }

    private void a(int n2, int n3, String string, String string2, String string3, String string4, String string5, SpaceURL spaceURL) throws IOException, CreateException {
        this.m = spaceURL;
        this.n = string;
        this.o = true;
        this.p = true;
        try {
            if (r == null) {
                r = TransformerFactory.newInstance();
            }
            Transformer transformer = r.newTransformer();
            InputStream inputStream = null;
            try {
                inputStream = ResourceLoader.findClusterXSLSchema(string);
                if (inputStream == null) {
                    throw new CreateException("Failed to load a cluster using a cluster schema. Failed to load the < " + string + " > cluster xsl schema.");
                }
                if (this.d()) {
                    this.a(inputStream, null, null, null, " Using Semi-Dynamic Cluster " + (spaceURL != null ? "\nand SpaceURL:" + spaceURL.getURL() : "\nand cluster schema: " + string));
                }
            }
            catch (Exception exception) {
                if (s.isLoggable(Level.SEVERE)) {
                    s.log(Level.SEVERE, exception.toString(), exception);
                }
                throw new CreateException("Failed to load a cluster using a cluster schema. Failed to load the < " + string + " > cluster xsl schema.", exception);
            }
            Document document = JSpaceUtilities.buildClusterXMLDom(n2, n3, string, string2, string3, string4, string5);
            if (this.d() && transformer != null) {
                this.a(null, (Element)document.getFirstChild(), null, transformer, null);
                inputStream = ResourceLoader.findClusterXSLSchema(string);
            }
            this.k = JSpaceUtilities.convertToClusterConfiguration(document, inputStream);
            JSpaceUtilities.convertDOMTreeFromSystemProperty(this.k);
            this.l = string;
            if (this.d() && transformer != null) {
                this.a(null, null, this.k, transformer, null);
            }
            JSpaceUtilities.normalize(this.k);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (s.isLoggable(Level.SEVERE)) {
                s.log(Level.SEVERE, transformerConfigurationException.toString(), transformerConfigurationException.getException());
            }
            throw new CreateException("Failed to create Transformer instance. Failed to load a cluster using a cluster schema. ", transformerConfigurationException.getException());
        }
        catch (TransformerException transformerException) {
            if (s.isLoggable(Level.SEVERE)) {
                s.log(Level.SEVERE, transformerException.toString(), transformerException.getException());
            }
            throw new CreateException("Failed to load a cluster using a cluster schema. ", transformerException.getException());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (s.isLoggable(Level.SEVERE)) {
                s.log(Level.SEVERE, parserConfigurationException.toString(), parserConfigurationException);
            }
            throw new CreateException("Failed to load a cluster using a cluster schema. ", parserConfigurationException);
        }
        this.b();
    }

    private void b() throws ClusterConfigurationException {
        if (System.getProperty("java.runtime.version").indexOf("1.4") > -1) {
            String[] stringArray = this.getClusterMemberNames();
            if (s.isLoggable(Level.FINE)) {
                s.fine("cluster members: " + Arrays.asList(stringArray));
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                this.a(string);
            }
            String[] stringArray2 = this.getGroupMemberNames();
            if (s.isLoggable(Level.FINE)) {
                s.fine("cluster Group members: " + Arrays.asList(stringArray2));
            }
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                this.a(stringArray2[i3]);
            }
        }
    }

    private void a(String string) throws ClusterConfigurationException {
        if (string.indexOf(":") == -1) {
            String string2 = "\"-Xbootclasspath/p:%XML_JARS%\"";
            if (!System.getProperty("file.separator").equals("\\")) {
                string2 = "\"-Xbootclasspath/p:${XML_JARS}\"";
            }
            throw new ClusterConfigurationException("The used JDK 1.4.x default Xalan implementation, does not support proper xsl transformations.\n Please use the Xalan package located under <GigaSpaces Root Directory>/lib/xml\n and add the following to the Java command line: " + string2);
        }
    }

    public ClusterXML(String string) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this.b(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void b(String string) throws IOException, SAXException, ParserConfigurationException, CreateException {
        String string2 = System.getProperty("com.gs.xmlschema.validation", REPL_ACTIVE_WHEN_BACKUP_DEFAULT);
        String string3 = null;
        Transformer transformer = null;
        try {
            if (r == null) {
                r = TransformerFactory.newInstance();
            }
            transformer = r.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (!s.isLoggable(Level.SEVERE)) throw new ClusterConfigurationException("Failed to create Transformer instance. Failed to load a cluster using a cluster schema < " + string + " > ", transformerConfigurationException.getException());
            s.log(Level.SEVERE, transformerConfigurationException.toString(), transformerConfigurationException.getException());
            throw new ClusterConfigurationException("Failed to create Transformer instance. Failed to load a cluster using a cluster schema < " + string + " > ", transformerConfigurationException.getException());
        }
        Document document = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                Object object;
                boolean bl2;
                String string4;
                this.l = string4 = stringTokenizer.nextToken();
                if (new File(string4).isFile()) {
                    try {
                        document = JSpaceUtilities.getDocumentBuilder(true, true).parse(string4);
                        this.n = ClusterXML.getNodeValueIfExists(document, CLUSTER_SCHEMA_NAME_TAG);
                        String string5 = ClusterXML.getNodeValueIfExists(document, GROUPS_TAG);
                        if (this.n != null) {
                            if (string5 != null) {
                                throw new ClusterConfigurationException("Failed to load static cluster members configuration file: " + string4 + ". \nThe file should not include <groups> element, " + "since it contains <" + CLUSTER_SCHEMA_NAME_TAG + "> element.");
                            }
                            InputStream inputStream = ResourceLoader.findClusterXSLSchema(this.n);
                            this.k = JSpaceUtilities.convertToClusterConfiguration(document, inputStream);
                            JSpaceUtilities.convertDOMTreeFromSystemProperty(this.k);
                            if (this.d() && transformer != null) {
                                this.a(null, (Element)document.getFirstChild(), this.k, transformer, "load a cluster using a cluster schema < " + this.n + " > " + "and a static cluster members xml file < " + string4 + " >");
                            }
                            this.l = this.n;
                            JSpaceUtilities.normalize(this.k);
                            break;
                        }
                        if (string5 == null) {
                            String string6 = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + string4;
                            throw new ClusterConfigurationException(string6);
                        }
                        if (string2.equalsIgnoreCase(REPL_ACTIVE_WHEN_BACKUP_DEFAULT)) {
                            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                            documentBuilderFactory.setValidating(true);
                            documentBuilderFactory.setAttribute(c, d);
                            documentBuilderFactory.setAttribute(e, ResourceLoader.getResourceURL(a).toString());
                            documentBuilder = documentBuilderFactory.newDocumentBuilder();
                            documentBuilder.setErrorHandler(new aa(null));
                            this.k = documentBuilder.parse(string4);
                        } else {
                            this.k = JSpaceUtilities.getDocumentBuilder(true, true).parse(string4);
                        }
                        JSpaceUtilities.convertDOMTreeFromSystemProperty(this.k);
                        if (!this.d() || transformer == null) break;
                        this.a(null, null, this.k, transformer, " Using static cluster config file " + string4);
                        break;
                    }
                    catch (Throwable throwable) {
                        if (!s.isLoggable(Level.SEVERE)) throw new ClusterConfigurationException(throwable.toString(), throwable);
                        s.log(Level.SEVERE, throwable.toString(), throwable);
                        throw new ClusterConfigurationException(throwable.toString(), throwable);
                    }
                }
                String string7 = string4.substring(string4.lastIndexOf("/") + 1);
                boolean bl3 = bl2 = string4.startsWith("http://");
                if (!string4.startsWith("/config/") && !bl2) throw new ClusterConfigurationException("Failed to load static cluster members configuration file: \n" + string4 + ". The file path is invalid.");
                if (!bl2) {
                    int n2 = string4.lastIndexOf(CLUSTER_XML_FILE_SUFFIX);
                    int n3 = string4.lastIndexOf("-cluster-config.xml");
                    if (n3 > 0) {
                        string7 = string4.substring(0, n3);
                        object = ResourceLoader.getResourceURL(string4);
                        if (object == null) {
                            object = ResourceLoader.getResourceURL(string7);
                        }
                        if (object == null) throw new ClusterConfigurationException("Failed to load a static cluster config file < " + string4 + " > ");
                        string3 = ((URL)object).toExternalForm();
                    } else if (n2 > 0) {
                        string7 = string4.substring(0, n2);
                        object = ResourceLoader.getResourceURL(string4);
                        if (object == null) {
                            object = ResourceLoader.getResourceURL(string7);
                        }
                        if (object == null) throw new ClusterConfigurationException("Failed to load a static cluster members file < " + string4 + " > ");
                        string3 = ((URL)object).toExternalForm();
                    } else {
                        object = ResourceLoader.getResourceURL(string4 + CLUSTER_XML_FILE_SUFFIX);
                        if (object == null) throw new ClusterConfigurationException("Failed to load a static cluster members file < " + string4 + "-cluster.xml >");
                        string3 = ((URL)object).toExternalForm();
                    }
                } else {
                    string3 = string4;
                }
                try {
                    document = JSpaceUtilities.getDocumentBuilder(true, true).parse(string3);
                    this.n = ClusterXML.getNodeValueIfExists(document, CLUSTER_SCHEMA_NAME_TAG);
                    String string8 = ClusterXML.getNodeValueIfExists(document, GROUPS_TAG);
                    if (this.n != null) {
                        if (string8 != null) {
                            throw new ClusterConfigurationException("Failed to load static cluster members configuration file: " + string3 + ". \nThe file should not include <groups> element, " + "since it contains <" + CLUSTER_SCHEMA_NAME_TAG + "> element.");
                        }
                        InputStream inputStream = ResourceLoader.findClusterXSLSchema(this.n);
                        this.k = JSpaceUtilities.convertToClusterConfiguration(document, inputStream);
                        JSpaceUtilities.convertDOMTreeFromSystemProperty(this.k);
                        if (this.d() && transformer != null) {
                            this.a(null, document.getDocumentElement(), this.k, transformer, "load a cluster using a cluster schema < " + this.n + " > " + "and a static cluster members xml file < " + string3 + " >");
                        }
                        this.l = this.n;
                        JSpaceUtilities.normalize(this.k);
                        break;
                    }
                    if (string8 == null) {
                        String string9 = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + string4;
                        throw new ClusterConfigurationException(string9);
                    }
                    if (string2.equalsIgnoreCase(REPL_ACTIVE_WHEN_BACKUP_DEFAULT)) {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        object = documentBuilderFactory.newDocumentBuilder();
                        documentBuilderFactory.setValidating(true);
                        documentBuilderFactory.setAttribute(c, d);
                        documentBuilderFactory.setAttribute(e, ResourceLoader.getResourceURL(a).toString());
                        object = documentBuilderFactory.newDocumentBuilder();
                        ((DocumentBuilder)object).setErrorHandler(new aa(null));
                        this.k = ((DocumentBuilder)object).parse(string3);
                    } else {
                        this.k = JSpaceUtilities.getDocumentBuilder(true, true).parse(string4);
                    }
                    JSpaceUtilities.convertDOMTreeFromSystemProperty(this.k);
                    if (!this.d() || transformer == null) break;
                    this.a(null, null, this.k, transformer, " Using static cluster config file " + string4);
                    break;
                }
                catch (Throwable throwable) {
                    if (!s.isLoggable(Level.SEVERE)) throw new ClusterConfigurationException(throwable.toString(), throwable);
                    s.log(Level.SEVERE, throwable.toString(), throwable);
                    throw new ClusterConfigurationException(throwable.toString(), throwable);
                }
            }
            catch (ClusterConfigurationException clusterConfigurationException) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw clusterConfigurationException;
                }
                if (!s.isLoggable(Level.SEVERE)) continue;
                s.log(Level.SEVERE, "ClusterXML: " + clusterConfigurationException.toString(), clusterConfigurationException);
            }
        }
        JSpaceUtilities.normalize(this.k);
        this.b();
    }

    public ClusterXML(Document document, String string) {
        this.k = document;
        this.l = string;
        JSpaceUtilities.normalize(this.k);
    }

    public boolean useClusterSchema() {
        return this.n != null;
    }

    public boolean isGenerateMembersDynamically() {
        return this.p;
    }

    public String getClusterSchemaName() {
        return this.n;
    }

    public String[] getClusterMemberNames() {
        NodeList nodeList = this.k.getElementsByTagName(CLUSTER_MEMBERS_TAG);
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(MEMBER_NAME_TAG);
        int n2 = nodeList2.getLength();
        this.i = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.i[i2] = nodeList2.item(i2).getFirstChild().getNodeValue().trim();
        }
        return this.i;
    }

    public String[] getGroupMemberNames() {
        NodeList nodeList = this.k.getElementsByTagName(GROUPS_MEMBERS);
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(MEMBER_NAME_TAG);
        int n2 = nodeList2.getLength();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = nodeList2.item(i2).getFirstChild().getNodeValue().trim();
        }
        return stringArray;
    }

    public ClusterPolicy createClusterPolicy(String string) throws CreateException {
        ClusterPolicy[] clusterPolicyArray;
        if (this.j == null) {
            this.i = this.getClusterMemberNames();
            if (this.i != null && this.i.length > 0) {
                int n2;
                this.j = new HashMap();
                clusterPolicyArray = new ClusterPolicy[this.i.length];
                for (int i2 = 0; i2 < this.i.length; ++i2) {
                    clusterPolicyArray[i2] = this.c(this.i[i2]);
                }
                ArrayList<ReplicationPolicy> arrayList = new ArrayList<ReplicationPolicy>(this.i.length);
                ArrayList<String> arrayList2 = new ArrayList<String>(this.i.length);
                for (n2 = 0; n2 < clusterPolicyArray.length; ++n2) {
                    if (clusterPolicyArray[n2].m_ReplicationPolicy == null || arrayList2.contains(clusterPolicyArray[n2].m_ReplicationPolicy.m_ReplicationGroupName)) continue;
                    arrayList.add(clusterPolicyArray[n2].m_ReplicationPolicy);
                    arrayList2.add(clusterPolicyArray[n2].m_ReplicationPolicy.m_ReplicationGroupName);
                }
                if (arrayList.isEmpty()) {
                    arrayList = null;
                } else {
                    arrayList.trimToSize();
                }
                for (n2 = 0; n2 < this.i.length; ++n2) {
                    clusterPolicyArray[n2].m_ReplicationGroups = arrayList;
                    this.j.put(this.i[n2], clusterPolicyArray[n2]);
                }
            }
        }
        if ((clusterPolicyArray = (ClusterPolicy[])this.j.get(string)) == null) {
            clusterPolicyArray = this.c(string);
        }
        return clusterPolicyArray;
    }

    private ClusterPolicy c(String string) throws CreateException {
        String string2;
        Object object;
        Object object2;
        this.h = string;
        this.g = new ClusterPolicy();
        this.g.m_ClusterSchemaName = this.n == null ? this.l : this.l;
        Hashtable<Object, ReplicationTransmissionPolicy> hashtable = new Hashtable<Object, ReplicationTransmissionPolicy>();
        this.g.m_ClusterName = ClusterXML.getNodeValueIfExists(this.k.getDocumentElement(), CLUSTER_NAME_TAG);
        this.g.m_ClusterGroupMember = this.h;
        String string3 = ClusterXML.getNodeValueIfExists(this.k.getDocumentElement(), NOTIFY_RECOVERY_TAG);
        if (string3 != null) {
            this.g.m_NotifyRecovery = JSpaceUtilities.parseBooleanTag(NOTIFY_RECOVERY_TAG, string3);
        }
        this.g.m_DCacheConfigName = ClusterXML.getNodeValueIfExists(this.k.getDocumentElement(), "config-name");
        String string4 = string.substring(string.indexOf(":") + 1);
        if (this.g.m_DCacheConfigName == null) {
            this.g.m_DCacheConfigName = JProperties.getSpaceProperty(string4, "dist-cache.config-name", "DefaultConfig");
        }
        try {
            object2 = ResourceLoader.findConfigDCache(this.g.m_DCacheConfigName, null, string4, this.l);
            this.g.m_DCacheAttributes = (JSpaceAttributes)JProperties.convertXML((InputStream)object2);
        }
        catch (Exception exception) {
            throw new CreateException("Failed to initialize DCache config file: " + exception.toString(), exception);
        }
        object2 = this.k.getElementsByTagName(JMS_TAG);
        if (object2.item(0) != null) {
            this.g.m_jmsConfigName = ClusterXML.getNodeValueIfExists((Element)object2.item(0), "config-name");
        }
        String string5 = null;
        if (this.g.m_jmsConfigName == null) {
            this.g.m_jmsConfigName = JProperties.getSpaceProperty(string4, "jms.config-name", "DefaultConfig");
        }
        try {
            object = ResourceLoader.findConfigClusteredJMS(this.g.m_jmsConfigName, null, string4, this.l);
            this.g.m_jmsProperties = JProperties.convertXML((InputStream)object);
        }
        catch (Exception exception) {
            throw new CreateException("Failed to initialize JMS clustered config file: " + string5 + " " + exception.toString(), exception);
        }
        this.g.m_CacheLoaderConfig = new ClusterPolicy.CacheLoaderConfig();
        object = ClusterXML.getNodeValueIfExists(this.k.getDocumentElement(), CACHE_LOADER_EXTERNAL_DATA_SOURCE);
        if (object != null) {
            this.g.m_CacheLoaderConfig.externalDataSource = JSpaceUtilities.parseBooleanTag(CACHE_LOADER_EXTERNAL_DATA_SOURCE, (String)object);
        }
        if ((string2 = ClusterXML.getNodeValueIfExists(this.k.getDocumentElement(), CACHE_LOADER_CENTRAL_DATA_SOURCE)) != null) {
            this.g.m_CacheLoaderConfig.centralDataSource = JSpaceUtilities.parseBooleanTag(CACHE_LOADER_CENTRAL_DATA_SOURCE, string2);
        }
        this.a(this.k);
        NodeList nodeList = this.k.getElementsByTagName(GROUP_TAG);
        if (nodeList.getLength() == 0) {
            throw new CreateException("<group> tag not found in " + this.l + " cluster config file.");
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string6 = null;
            Element element = (Element)nodeList.item(i2);
            NodeList nodeList2 = element.getElementsByTagName(MEMBER_NAME_TAG);
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                Serializable serializable;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n2;
                Node node;
                Node node2 = nodeList2.item(i3).getFirstChild();
                String string7 = node2.getNodeValue();
                if (!string7.equals(this.h)) continue;
                string6 = ClusterXML.getNodeValueIfExists(element, GROUP_NAME_TAG);
                if (string6 == null) {
                    throw new CreateException("<group-name> tag not found in " + this.l + " cluster config file.");
                }
                ArrayList arrayList = new ArrayList();
                ArrayList<SpaceURL> arrayList2 = new ArrayList<SpaceURL>();
                Vector<String> vector = new Vector<String>();
                for (int i4 = 0; i4 < nodeList2.getLength(); ++i4) {
                    node = nodeList2.item(i4);
                    vector.add(node.getFirstChild().getNodeValue().trim());
                }
                NodeList nodeList3 = this.k.getElementsByTagName(CLUSTER_MEMBERS_TAG);
                if (nodeList2.getLength() == 0) {
                    throw new CreateException("<cluster-members> tag not found in " + this.l + " cluster config file.");
                }
                node = (Element)nodeList3.item(0);
                NodeList nodeList4 = node.getElementsByTagName(MEMBER_NAME_TAG);
                for (n2 = 0; n2 < nodeList4.getLength(); ++n2) {
                    object6 = nodeList4.item(n2).getFirstChild().getNodeValue().trim();
                    for (int i5 = 0; i5 < vector.size(); ++i5) {
                        if (!((String)object6).equalsIgnoreCase((String)vector.elementAt(i5))) continue;
                        object5 = nodeList4.item(n2).getNextSibling();
                        arrayList.add(vector.elementAt(i5));
                        object4 = object5.getFirstChild();
                        if (object4 == null) {
                            throw new CreateException("The member-name-url is NULL: <" + (String)object6 + "> in \"cluster-members\" section.Check " + this.l + " cluster config file.");
                        }
                        object3 = object4.getNodeValue().trim();
                        String string8 = SpaceURL.concatAttrIfNotExist((String)object3, "ignoreValidation", REPL_ACTIVE_WHEN_BACKUP_DEFAULT);
                        try {
                            serializable = null;
                            if (this.m != null) {
                                serializable = this.m.getCustomProperties();
                            }
                            arrayList2.add(SpaceURLParser.parseURL(string8, (Properties)serializable));
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new RuntimeException(new ClusterConfigurationException("Failed to parse cluster member url: " + string8, malformedURLException));
                        }
                        if (this.g.m_ReplicationPolicy != null) continue;
                        serializable = this.createReplDescPolicy((String)object6, (Element)nodeList2.item(i5).getParentNode(), vector);
                        hashtable.put(object6, (ReplicationTransmissionPolicy)serializable);
                    }
                }
                if (this.g.m_ReplicationPolicy == null) {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    object6 = new HashSet();
                    String[] stringArray = hashtable.keySet().iterator();
                    while (stringArray.hasNext()) {
                        int n3;
                        object5 = (String)stringArray.next();
                        object4 = (ReplicationPolicy.ReplicationPolicyDescription)hashtable.get(object5);
                        if (((ReplicationPolicy.ReplicationPolicyDescription)object4).replTransmissionPolicies == null) {
                            ((HashSet)object6).clear();
                            break;
                        }
                        object3 = (ArrayList)arrayList.clone();
                        ((ArrayList)object3).remove(object5);
                        for (n3 = 0; n3 < ((ReplicationPolicy.ReplicationPolicyDescription)object4).replTransmissionPolicies.size(); ++n3) {
                            serializable = (ReplicationTransmissionPolicy)((ReplicationPolicy.ReplicationPolicyDescription)object4).replTransmissionPolicies.get(n3);
                            if (!serializable.m_DisableTransmission) {
                                hashSet.add(serializable.m_TargetSpace);
                                continue;
                            }
                            ((ArrayList)object3).remove(serializable.m_TargetSpace);
                            ((HashSet)object6).add(serializable.m_TargetSpace);
                        }
                        for (n3 = 0; n3 < ((ArrayList)object3).size(); ++n3) {
                            hashSet.add(((ArrayList)object3).get(n3));
                            hashSet.add(object5);
                        }
                    }
                    stringArray = ((HashSet)object6).toArray(new String[((HashSet)object6).size()]);
                    for (int i6 = 0; i6 < stringArray.length; ++i6) {
                        if (hashSet.contains(stringArray[i6])) continue;
                        throw new CreateException("IllegalReplicatonDefinitionError: This member: " + stringArray[i6] + " is not transmiting and not receiving replication from any other member in replication group. Check out the replication transmission matrix.");
                    }
                }
                if (!arrayList.contains(this.h)) {
                    throw new CreateException("This member-name: <" + this.h + "> not defined in \"cluster-members\" section.Check " + this.l + " cluster config file.");
                }
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    if (arrayList.contains(vector.elementAt(n2)) || !s.isLoggable(Level.INFO)) continue;
                    s.info("WARNING: This member-name: <" + (String)vector.elementAt(n2) + "> not defined in \"cluster-members\" section. Check " + this.l + " cluster config file.");
                }
                if (this.g.m_LoadBalancingPolicy != null && element.getElementsByTagName(LOAD_BAL_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this.h + "> can be defined only in one LoadBalancing group.The member was already defined in <" + this.g.m_LoadBalancingPolicy.m_GroupName + "> LoadBalancing group.");
                }
                if (this.g.m_LoadBalancingPolicy != null && element.getElementsByTagName(FAIL_OVER_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this.h + "> can't be defined in different LoadBalancing and FailOver groups.Check definition of <" + this.g.m_LoadBalancingPolicy.m_GroupName + "> and <" + string6 + "> groups.");
                }
                if (this.g.m_LoadBalancingPolicy == null) {
                    this.g.m_LoadBalancingPolicy = this.a(element, string6, arrayList, arrayList2);
                }
                if (this.g.m_ReplicationPolicy != null && element.getElementsByTagName(REPL_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this.h + "> can be defined only in one Replication group.The member was already defined in <" + this.g.m_ReplicationPolicy.m_ReplicationGroupName + "> Replication group.");
                }
                if (this.g.m_ReplicationPolicy == null) {
                    this.g.m_ReplicationPolicy = this.a(element, string6, arrayList, arrayList2, hashtable);
                }
                if (this.g.m_FailOverPolicy != null && element.getElementsByTagName(FAIL_OVER_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this.h + "> can be defined only in one FailOver group.The member was already defined in <" + this.g.m_FailOverPolicy.failOverGroupName + "> FailOver group.");
                }
                if (this.g.m_FailOverPolicy != null && element.getElementsByTagName(LOAD_BAL_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this.h + "> can't be defined in different FailOver and LoadBalancing groups.Check definition of <" + this.g.m_FailOverPolicy.failOverGroupName + "> and <" + string6 + "> groups.");
                }
                if (this.g.m_FailOverPolicy != null) break;
                Hashtable hashtable2 = new Hashtable();
                this.g.m_FailOverPolicy = this.b(element, string6, arrayList, arrayList2, hashtable2);
                if (this.g.m_FailOverPolicy == null || this.g.m_LoadBalancingPolicy != null) break;
                this.g.m_LoadBalancingPolicy = this.a(string6, arrayList, arrayList2);
                break;
            }
            if (this.g.m_LoadBalancingPolicy != null && this.g.m_FailOverPolicy != null && this.g.m_ReplicationPolicy != null) break;
        }
        if (this.g.m_LoadBalancingPolicy == null && this.g.m_FailOverPolicy == null && this.g.m_ReplicationPolicy == null) {
            throw new CreateException("An attempt to create CLUSTERED SPACE failed. This member: " + this.h + " must be defined at least in one group member in " + this.l + " CLUSTER CONFIG XML file.");
        }
        return this.g;
    }

    private ReplicationPolicy a(Element element, String string, ArrayList arrayList, ArrayList arrayList2, Hashtable hashtable) throws CreateException {
        Object object;
        NodeList nodeList;
        String string2;
        NodeList nodeList2 = element.getElementsByTagName(REPL_POLICY_TAG);
        if (nodeList2.getLength() <= 0) {
            return null;
        }
        Element element2 = (Element)nodeList2.item(0);
        NodeList nodeList3 = element2.getElementsByTagName(POLICY_TYPE_TAG);
        if (nodeList3.getLength() == 0) {
            throw new CreateException("<policy-type> tag not found under <repl-policy> tag.Check " + this.l + " cluster config file.");
        }
        ReplicationPolicy replicationPolicy = new ReplicationPolicy();
        this.g.m_Replicated = true;
        replicationPolicy.clusterName = this.g.m_ClusterName;
        replicationPolicy.m_ReplicationGroupName = string;
        replicationPolicy.m_ReplicationGroupMembersNames = (List)arrayList.clone();
        replicationPolicy.m_ReplicationGroupMembersURLs = (List)dm.b(arrayList2);
        replicationPolicy.m_OwnMemberName = this.h;
        replicationPolicy.m_ReplMemberPolicyDescTable = hashtable;
        replicationPolicy.m_SyncReplPolicy = new SyncReplPolicy(this.h);
        this.a(replicationPolicy);
        String string3 = ClusterXML.getNodeValueIfExists(element2, REPLICATION_MODE_TAG);
        if (string3 != null) {
            replicationPolicy.m_IsSyncReplicationEnabled = ClusterXML.calculateSyncReplicationValue(string3);
            replicationPolicy.isOneWayReplication = ClusterXML.calculateOneWayReplicationValue(string3);
        }
        replicationPolicy.m_ReplicationMode = string3;
        String string4 = ClusterXML.getNodeValueIfExists(element2, COMMUNICATION_MODE_TAG);
        if (string4.equalsIgnoreCase(SYNC_REPL_MULTICAST_TAG)) {
            Class<?> clazz = class$com$j_spaces$core$cluster$sync_replication$MulticastProtocolAdaptor;
            if (clazz == null) {
                clazz = class$com$j_spaces$core$cluster$sync_replication$MulticastProtocolAdaptor = new MulticastProtocolAdaptor[0].getClass().getComponentType();
            }
            replicationPolicy.protocolAdaptorClass = clazz.getName();
            replicationPolicy.communicationMode = SYNC_REPL_MULTICAST_TAG;
            if (!replicationPolicy.m_IsSyncReplicationEnabled) {
                replicationPolicy.isOneWayReplication = true;
            }
        }
        if ((string2 = ClusterXML.getNodeValueIfExists(element2, POLICY_TYPE_TAG)).equalsIgnoreCase(FULL_REPLICATION)) {
            replicationPolicy.m_PolicyType = 0;
        } else if (string2.equalsIgnoreCase(PARTIAL_REPLICATION)) {
            replicationPolicy.m_PolicyType = 1;
        } else {
            throw new CreateException("Unknown replication policy type. Check <policy-type> tag value under <repl-policy> tag.Check " + this.l + " cluster config file.");
        }
        String string5 = ClusterXML.getNodeValueIfExists(element2, REPL_MEMORY_RECOVERY_TAG);
        if (string5 != null) {
            if (this.g.m_CacheLoaderConfig.externalDataSource && this.g.m_CacheLoaderConfig.centralDataSource) {
                replicationPolicy.m_Recovery = false;
                if (s.isLoggable(Level.FINE)) {
                    s.fine("Recognized external-&-central data-source; Recovery explicitly set to <false>");
                }
            } else {
                replicationPolicy.m_Recovery = JSpaceUtilities.parseBooleanTag(REPL_MEMORY_RECOVERY_TAG, string5);
            }
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_REDO_LOG_CAPACITY_TAG)) != null) {
            replicationPolicy.maxRedoLogCapacity = Long.parseLong(string5);
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, RECOVERY_CHUNK_SIZE_TAG)) != null) {
            replicationPolicy.setRecoveryChunkSize(Integer.parseInt(string5));
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_NOTIFY_TEMPLATE_TAG)) != null) {
            replicationPolicy.m_ReplicateNotifyTemplates = JSpaceUtilities.parseBooleanTag(REPL_NOTIFY_TEMPLATE_TAG, string5);
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_TRIGGER_NOTIFY_TEMPLATES_TAG)) != null) {
            replicationPolicy.m_TriggerNotifyTemplates = JSpaceUtilities.parseBooleanTag(REPL_TRIGGER_NOTIFY_TEMPLATES_TAG, string5);
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_FIND_TIMEOUT_TAG)) != null) {
            replicationPolicy.m_SpaceFinderTimeout = Long.parseLong(string5);
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_FIND_REPORT_INTERVAL_TAG)) != null) {
            replicationPolicy.m_SpaceFinderReportInterval = Long.parseLong(string5);
        }
        if ((string5 = ClusterXML.getNodeValueIfExists(element2, REPL_ORIGINAL_STATE_TAG)) != null) {
            replicationPolicy.setReplicatedOriginalState(JSpaceUtilities.parseBooleanTag(REPL_ORIGINAL_STATE_TAG, string5));
        }
        if ((nodeList = element2.getElementsByTagName(ASYNC_REPLICATION_TAG)).getLength() > 0) {
            object = (Element)nodeList.item(0);
            string5 = ClusterXML.getNodeValueIfExists((Element)object, REPL_CHUNK_SIZE_TAG);
            if (string5 != null) {
                replicationPolicy.m_ReplicationChunkSize = Integer.parseInt(string5);
            }
            if ((string5 = ClusterXML.getNodeValueIfExists((Element)object, REPL_INTERVAL_MILLIS_TAG)) != null) {
                replicationPolicy.m_ReplicationIntervalMillis = Long.parseLong(string5);
            }
            if ((string5 = ClusterXML.getNodeValueIfExists((Element)object, REPL_INTERVAL_OPERS_TAG)) != null) {
                replicationPolicy.m_ReplicationIntervalOperations = Integer.parseInt(string5);
            }
            if ((string5 = ClusterXML.getNodeValueIfExists((Element)object, REPL_SYNC_ON_COMMIT_TAG)) != null) {
                replicationPolicy.m_SyncOnCommit = JSpaceUtilities.parseBooleanTag(REPL_SYNC_ON_COMMIT_TAG, string5);
            }
            if ((string5 = ClusterXML.getNodeValueIfExists((Element)object, REPL_SYNC_ON_COMMIT_TIMEOUT_TAG)) != null) {
                replicationPolicy.m_SyncOnCommitTimeout = Long.parseLong(string5);
            }
        }
        if ((object = element2.getElementsByTagName(SYNC_REPLICATION_TAG)).getLength() > 0) {
            Object object2;
            NodeList nodeList4;
            Element element3 = (Element)element2.getElementsByTagName(SYNC_REPLICATION_TAG).item(0);
            string5 = ClusterXML.getNodeValueIfExists(element3, TODO_QUEUE_TIMEOUT_TAG);
            if (string5 != null) {
                replicationPolicy.m_SyncReplPolicy.setTodoQueueTimeout(Long.parseLong(string5));
            }
            if ((string5 = ClusterXML.getNodeValueIfExists(element3, HOLD_TXN_LOCK_TAG)) != null) {
                replicationPolicy.m_SyncReplPolicy.setHoldTxnLockUntilSyncReplication(JSpaceUtilities.parseBooleanTag(HOLD_TXN_LOCK_TAG, string5));
            }
            if ((nodeList4 = element3.getElementsByTagName(SYNC_REPL_UNICAST_TAG)).getLength() > 0) {
                object2 = (Element)nodeList4.item(0);
                string5 = ClusterXML.getNodeValueIfExists((Element)object2, MIN_WORK_THREADS_TAG);
                if (string5 != null) {
                    replicationPolicy.m_SyncReplPolicy.setUnicastMinThreadPoolSize(Integer.parseInt(string5));
                }
                if ((string5 = ClusterXML.getNodeValueIfExists((Element)object2, MAX_WORK_THREADS_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setUnicastMaxThreadPoolSize(Integer.parseInt(string5));
                }
            }
            if ((object2 = element3.getElementsByTagName(SYNC_REPL_MULTICAST_TAG)).getLength() > 0) {
                Element element4 = (Element)object2.item(0);
                string5 = ClusterXML.getNodeValueIfExists(element4, IP_GROUP_TAG);
                if (string5 != null) {
                    replicationPolicy.m_SyncReplPolicy.setMulticastIpGroup(string5);
                }
                if ((string5 = ClusterXML.getNodeValueIfExists(element4, PORT_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setMulticastPort(Integer.parseInt(string5));
                }
                if ((string5 = ClusterXML.getNodeValueIfExists(element4, TTL_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setMulticastTTL(Integer.parseInt(string5));
                }
                if ((string5 = ClusterXML.getNodeValueIfExists(element4, MIN_WORK_THREADS_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setMulticastMinThreadPoolSize(Integer.parseInt(string5));
                }
                if ((string5 = ClusterXML.getNodeValueIfExists(element4, MAX_WORK_THREADS_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setMulticastMaxThreadPoolSize(Integer.parseInt(string5));
                }
                if ((string5 = ClusterXML.getNodeValueIfExists(element4, ADAPTIVE_MULTICAST_TAG)) != null) {
                    replicationPolicy.m_SyncReplPolicy.setAdaptiveMulticast(JSpaceUtilities.parseBooleanTag(ADAPTIVE_MULTICAST_TAG, string5));
                }
            }
        }
        return replicationPolicy;
    }

    private void a(ReplicationPolicy replicationPolicy) {
        ReplicationPolicy.MirrorServiceConfig mirrorServiceConfig = null;
        Element element = ClusterXML.getFirstMatchElement(this.k.getDocumentElement(), MIRROR_SERVICE_TAG);
        if (element != null) {
            boolean bl2 = JSpaceUtilities.parseBooleanTag(ENABLED_TAG, ClusterXML.getNodeValueIfExists(element, ENABLED_TAG));
            boolean bl3 = Boolean.valueOf(REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT);
            if (this.m != null) {
                bl3 = _Boolean.parseBoolean(this.m.getProperty("mirror", REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT));
            }
            if (bl2 || bl3) {
                Object object;
                String string = ClusterXML.getNodeValueIfExists(element, MIRROR_SERVICE_URL_TAG);
                if (string == null) {
                    ClusterConfigurationException clusterConfigurationException = new ClusterConfigurationException("Mirror service enabled for replication group: " + replicationPolicy.m_ReplicationGroupName + ", but mirror url is missing. Check " + this.l + " cluster config file.");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)(clusterConfigurationException == null ? null : clusterConfigurationException.toString()));
                    illegalArgumentException.initCause(clusterConfigurationException);
                    throw illegalArgumentException;
                }
                mirrorServiceConfig = new ReplicationPolicy.MirrorServiceConfig();
                try {
                    object = null;
                    if (this.m != null) {
                        object = this.m.getCustomProperties();
                    }
                    mirrorServiceConfig.serviceURL = SpaceURLParser.parseURL(string, (Properties)object);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(new ClusterConfigurationException("Failed to parse mirror-service finder URL: " + mirrorServiceConfig.serviceURL, malformedURLException));
                }
                object = this.m.getProperty(GROUPS_TAG);
                if (this.m != null && object != null) {
                    mirrorServiceConfig.serviceURL.setProperty(GROUPS_TAG, (String)object);
                }
                if ((string = ClusterXML.getNodeValueIfExists(element, MIRROR_SERVICE_BULK_SIZE_TAG)) != null) {
                    mirrorServiceConfig.bulkSize = Integer.parseInt(string);
                }
                if ((string = ClusterXML.getNodeValueIfExists(element, MIRROR_SERVICE_INTERVAL_MILLIS_TAG)) != null) {
                    mirrorServiceConfig.intervalMillis = Long.parseLong(string);
                }
                if ((string = ClusterXML.getNodeValueIfExists(element, MIRROR_SERVICE_INTERVAL_OPERS_TAG)) != null) {
                    mirrorServiceConfig.intervalOpers = Integer.parseInt(string);
                }
                replicationPolicy.setMirrorServiceConfig(mirrorServiceConfig);
                replicationPolicy.m_ReplicationGroupMembersNames.add(mirrorServiceConfig.serviceURL.getMemberName());
                replicationPolicy.m_ReplicationGroupMembersURLs.add(mirrorServiceConfig.serviceURL);
                mirrorServiceConfig.memberName = mirrorServiceConfig.serviceURL.getMemberName();
            }
        }
    }

    private FailOverPolicy b(Element element, String string, ArrayList arrayList, ArrayList arrayList2, Hashtable hashtable) throws CreateException {
        FailOverPolicy failOverPolicy = null;
        NodeList nodeList = element.getElementsByTagName(FAIL_OVER_POLICY_TAG);
        if (nodeList.getLength() > 0) {
            NodeList nodeList2;
            Element element2 = (Element)nodeList.item(0);
            failOverPolicy = new FailOverPolicy();
            failOverPolicy.failOverGroupName = string;
            failOverPolicy.failOverGroupMembersNames = (List)arrayList.clone();
            failOverPolicy.failOverGroupMembersURLs = (List)dm.b(arrayList2);
            hashtable.put(string, failOverPolicy);
            String string2 = ClusterXML.getNodeValueIfExists(element2, FAIL_OVER_FIND_TIMEOUT_TAG);
            if (string2 != null) {
                failOverPolicy.spaceFinderTimeout = Long.parseLong(string2);
            }
            if ((string2 = ClusterXML.getNodeValueIfExists(element2, FAIL_OVER_FAILBACK_TAG)) != null) {
                failOverPolicy.setFailBackEnabled(JSpaceUtilities.parseBooleanTag(FAIL_OVER_FAILBACK_TAG, string2));
            }
            if ((nodeList2 = element2.getElementsByTagName(ALTERNATE_GROUP_TAG)).getLength() > 0) {
                Vector<String> vector = new Vector<String>();
                NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName(GROUP_TAG);
                for (int i2 = 0; i2 < nodeList3.getLength(); ++i2) {
                    String string3;
                    Node node = nodeList3.item(i2).getFirstChild();
                    if (node == null || (string3 = node.getNodeValue().trim()).trim().length() <= 0 || string3.trim().equalsIgnoreCase(string)) continue;
                    vector.add(string3.trim());
                }
                if (!vector.isEmpty()) {
                    failOverPolicy.alterGroup = this.a(this.k, failOverPolicy, vector.toArray(new String[vector.size()]), hashtable);
                }
            }
            failOverPolicy.m_WriteFOPolicy = this.a(element2, WRITE_TAG, string, (List)arrayList, failOverPolicy.alterGroup);
            failOverPolicy.m_ReadFOPolicy = this.a(element2, READ_TAG, string, (List)arrayList, failOverPolicy.alterGroup);
            failOverPolicy.m_TakeFOPolicy = this.a(element2, TAKE_TAG, string, (List)arrayList, failOverPolicy.alterGroup);
            failOverPolicy.m_NotifyFOPolicy = this.a(element2, NOTIFY_TAG, string, (List)arrayList, failOverPolicy.alterGroup);
            failOverPolicy.m_DefaultFOPolicy = this.a(element2, DEFAULT_TAG, string, (List)arrayList, failOverPolicy.alterGroup);
            if (failOverPolicy.m_DefaultFOPolicy == null && (failOverPolicy.m_WriteFOPolicy == null || failOverPolicy.m_ReadFOPolicy == null || failOverPolicy.m_TakeFOPolicy == null || failOverPolicy.m_NotifyFOPolicy == null)) {
                throw new CreateException("Default FailOver Policy not defined in <" + string + "> group. Check " + this.l + " CLUSTER CONFIG XML file.");
            }
            failOverPolicy.buildElectionGroups(this.h);
        }
        return failOverPolicy;
    }

    private FailOverPolicy.FailOverPolicyDescription a(Element element, String string, String string2, List list, String[] stringArray) throws CreateException {
        FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            failOverPolicyDescription = new FailOverPolicy.FailOverPolicyDescription();
            Element element2 = (Element)nodeList.item(0);
            String string3 = ClusterXML.getNodeValueIfExists(element2, POLICY_TYPE_TAG);
            if (string3 == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + string + "] operation under " + FAIL_OVER_POLICY_TAG + " tag.");
            }
            for (int i2 = 0; i2 < FAIL_OVER_POLICIES.length; ++i2) {
                if (!string3.equalsIgnoreCase(FAIL_OVER_POLICIES[i2])) continue;
                failOverPolicyDescription.m_PolicyType = i2;
            }
            if (failOverPolicyDescription.m_PolicyType == -1) {
                throw new CreateException("IllegalFailOverDefinitionError: Unknown failOver policy type: " + string3 + ".Check definition of " + string2 + " group in " + this.l + " CLUSTER CONFIG XML file.");
            }
            String string4 = ClusterXML.getNodeValueIfExists(element2, FAIL_OVER_DISABLE_ALTERNATE_GROUP_TAG);
            if (string4 != null) {
                failOverPolicyDescription.m_DisableAlternateGroups = JSpaceUtilities.parseBooleanTag(FAIL_OVER_DISABLE_ALTERNATE_GROUP_TAG, string4);
            }
            if (string3.equalsIgnoreCase(FAIL_TO_ALTERNATE)) {
                if (stringArray == null || stringArray.length <= 0) {
                    throw new CreateException("IllegalFailOverDefinitionError: At least one alternate group should be defined  in \"fail-to-alternate\" policy. Check definition of " + string2 + " group in " + this.l + " CLUSTER CONFIG XML file.");
                }
                failOverPolicyDescription.m_DisableAlternateGroups = false;
            } else if (string3.equalsIgnoreCase(FAIL_TO_BACKUP)) {
                String string5;
                Object object;
                NodeList nodeList2 = element.getElementsByTagName(FAIL_OVER_BACKUP_MEMBERS_TAG);
                if (nodeList2.getLength() <= 0) {
                    throw new CreateException("IllegalFailOverDefinitionError: At lease one backup member should be defined in \"fail-to-backup\" policy. Check definition of " + string2 + " group in " + this.l + " CLUSTER CONFIG XML file.");
                }
                failOverPolicyDescription.m_BackupMemberNames = new HashMap();
                Element element3 = (Element)nodeList2.item(0);
                NodeList nodeList3 = element3.getElementsByTagName(MEMBER_TAG);
                if (nodeList3.getLength() <= 0) {
                    throw new CreateException("IllegalFailOverDefinitionError: At lease one backup member should be defined in \"fail-to-backup\" policy. Check definition of " + string2 + " group in " + this.l + " CLUSTER CONFIG XML file.");
                }
                for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                    object = new ArrayList();
                    Element element4 = (Element)nodeList3.item(i3);
                    string5 = ClusterXML.getNodeValueIfExists(element4, FAIL_OVER_SOURCE_MEMBER_TAG);
                    NodeList nodeList4 = element4.getElementsByTagName(FAIL_OVER_BACKUP_MEMBER_TAG);
                    for (int i4 = 0; i4 < nodeList4.getLength(); ++i4) {
                        String string6 = nodeList4.item(i4).getFirstChild().getNodeValue();
                        if (!list.contains(string6)) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + string6 + " backup member not part of " + string2 + " group. Check " + this.l + " CLUSTER CONFIG XML file.");
                        }
                        if (string6.equalsIgnoreCase(string5)) {
                            throw new CreateException("IllegalFailOverDefinitionError: source member: " + string5 + " == " + string6 + " backup member. Check definition of " + string2 + " group in " + this.l + " CLUSTER CONFIG XML file.");
                        }
                        if (object.contains(string6)) continue;
                        object.add(string6);
                    }
                    if (!list.contains(string5)) {
                        throw new CreateException("IllegalFailOverDefinitionError: " + string5 + " source backup member not part of " + string2 + " group. Check " + this.l + " CLUSTER CONFIG XML file.");
                    }
                    failOverPolicyDescription.m_BackupMemberNames.put(string5, object);
                }
                failOverPolicyDescription.m_BackupOnly = new ArrayList();
                NodeList nodeList5 = element.getElementsByTagName(FAIL_OVER_BACKUP_MEMBERS_ONLY_TAG);
                if (nodeList5.getLength() > 0) {
                    object = (Element)nodeList5.item(0);
                    nodeList3 = object.getElementsByTagName(FAIL_OVER_BACKUP_MEMBER_ONLY_TAG);
                    for (int i5 = 0; i5 < nodeList3.getLength(); ++i5) {
                        string5 = nodeList3.item(i5).getFirstChild().getNodeValue();
                        if (!list.contains(string5)) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + string5 + " backup only member not part of " + string2 + " failOver group. Check " + this.l + " CLUSTER CONFIG XML file.");
                        }
                        if (failOverPolicyDescription.m_BackupMemberNames.get(string5) != null) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + string5 + " source member can't be defined as backup only member. Check " + this.l + " CLUSTER CONFIG XML file.");
                        }
                        if (failOverPolicyDescription.m_BackupOnly.contains(string5)) continue;
                        failOverPolicyDescription.m_BackupOnly.add(string5);
                    }
                }
            }
        }
        return failOverPolicyDescription;
    }

    private LoadBalancingPolicy a(Element element, String string, ArrayList arrayList, ArrayList arrayList2) throws CreateException {
        LoadBalancingPolicy loadBalancingPolicy = null;
        NodeList nodeList = element.getElementsByTagName(LOAD_BAL_TAG);
        if (nodeList.getLength() > 0) {
            String string2;
            Element element2 = (Element)nodeList.item(0);
            loadBalancingPolicy = new LoadBalancingPolicy();
            loadBalancingPolicy.m_GroupName = string;
            loadBalancingPolicy.loadBalanceGroupMembersNames = (List)arrayList.clone();
            loadBalancingPolicy.loadBalanceGroupMembersURLs = (List)dm.b(arrayList2);
            loadBalancingPolicy.m_ImplementationClassName = ClusterXML.getNodeValueIfExists(element2, LOAD_BAL_IMPL_CLASS_TAG);
            String string3 = ClusterXML.getNodeValueIfExists(element2, APPLY_OWNERSHIP_TAG);
            loadBalancingPolicy.m_ApplyOwnership = string3 != null ? JSpaceUtilities.parseBooleanTag(APPLY_OWNERSHIP_TAG, string3) : false;
            String string4 = ClusterXML.getNodeValueIfExists(element2, DISABLE_PARALLEL_SCATTERING_TAG);
            loadBalancingPolicy.m_DisableParallelScattering = string4 != null ? JSpaceUtilities.parseBooleanTag(DISABLE_PARALLEL_SCATTERING_TAG, string4) : false;
            String string5 = ClusterXML.getNodeValueIfExists(element2, PROXY_BROADCAST_THREADPOOL_MIN_SIZE_TAG);
            if (string5 != null) {
                loadBalancingPolicy.m_broadcastThreadpoolMinSize = Integer.parseInt(string5);
            }
            if ((string2 = ClusterXML.getNodeValueIfExists(element2, PROXY_BROADCAST_THREADPOOL_MAX_SIZE_TAG)) != null) {
                loadBalancingPolicy.m_broadcastThreadpoolMaxSize = Integer.parseInt(string2);
            }
            loadBalancingPolicy.m_WriteOperationsPolicy = this.a(element2, WRITE_TAG);
            loadBalancingPolicy.m_ReadOperationsPolicy = this.a(element2, READ_TAG);
            loadBalancingPolicy.m_TakeOperationsPolicy = this.a(element2, TAKE_TAG);
            loadBalancingPolicy.m_NotifyOperationsPolicy = this.a(element2, NOTIFY_TAG);
            loadBalancingPolicy.m_DefaultPolicy = this.a(element2, DEFAULT_TAG);
            if (loadBalancingPolicy.m_DefaultPolicy == null && (loadBalancingPolicy.m_WriteOperationsPolicy == null || loadBalancingPolicy.m_ReadOperationsPolicy == null || loadBalancingPolicy.m_TakeOperationsPolicy == null || loadBalancingPolicy.m_NotifyOperationsPolicy == null)) {
                throw new CreateException("Default LoadBalancing Policy not defined in group <" + string + ">. Check " + this.l + " CLUSTER CONFIG XML file.");
            }
        }
        return loadBalancingPolicy;
    }

    private LoadBalancingPolicy.LoadBalancingPolicyDescription a(Element element, String string) throws CreateException {
        Properties properties = new Properties();
        LoadBalancingPolicy.LoadBalancingPolicyDescription loadBalancingPolicyDescription = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string2 = ClusterXML.getNodeValueIfExists(element2, POLICY_TYPE_TAG);
            if (string2 == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + string + "] operation under " + LOAD_BAL_TAG + " tag.");
            }
            String string3 = ClusterXML.getNodeValueIfExists(element2, BROADCAST_CONDITION_TAG);
            NodeList nodeList2 = element2.getElementsByTagName(PARAM_TAG);
            for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
                String string4 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), PARAM_NAME_TAG);
                String string5 = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), PARAM_VALUE_TAG);
                if (string4 == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + string + " operation name under " + LOAD_BAL_TAG + " tag. Check " + this.l + " cluster config file.");
                }
                if (string5 == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + string + " operation name under " + LOAD_BAL_TAG + " tag. Check " + this.l + " cluster config file.");
                }
                properties.setProperty(string4, string5);
            }
            loadBalancingPolicyDescription = new LoadBalancingPolicy.LoadBalancingPolicyDescription();
            loadBalancingPolicyDescription.m_PolicyType = string2;
            loadBalancingPolicyDescription.m_Properties = properties.size() > 0 ? properties : null;
            loadBalancingPolicyDescription.m_BroadcastCondition = ClusterXML.getBroadcastConditionValue(string3);
        }
        return loadBalancingPolicyDescription;
    }

    public static LoadBalancingPolicy.BroadcastCondition getBroadcastConditionValue(String string) {
        if ("broadcast-disabled".equals(string)) {
            return LoadBalancingPolicy.BroadcastCondition.BROADCAST_DISABLED;
        }
        if ("unconditional".equals(string)) {
            return LoadBalancingPolicy.BroadcastCondition.UNCONDITIONAL;
        }
        return LoadBalancingPolicy.BroadcastCondition.BROADCAST_IF_NULL_VALUES;
    }

    private void a(Document document) throws CreateException {
        NodeList nodeList = document.getElementsByTagName(CLUSTER_MEMBERS_TAG);
        if (nodeList.getLength() == 0) {
            throw new CreateException("<cluster-members> tag not found in " + this.l + " cluster config file.");
        }
        this.g.m_ClusterMembersProperties = new HashMap();
        this.g.m_AllClusterMemberList = new ArrayList();
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(MEMBER_TAG);
        for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
            Properties properties = new Properties();
            String string = ClusterXML.getNodeValueIfExists((Element)nodeList2.item(i2), MEMBER_NAME_TAG);
            this.g.m_AllClusterMemberList.add(string);
            NodeList nodeList3 = ((Element)nodeList2.item(i2)).getElementsByTagName(PARAM_TAG);
            for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                String string2 = ClusterXML.getNodeValueIfExists((Element)nodeList3.item(i3), PARAM_NAME_TAG);
                String string3 = ClusterXML.getNodeValueIfExists((Element)nodeList3.item(i3), PARAM_VALUE_TAG);
                if (string2 == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + string + " member name. Check " + this.l + " cluster config file.");
                }
                if (string3 == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + string + " member name. Check " + this.l + " cluster config file.");
                }
                properties.setProperty(string2, string3);
            }
            if (nodeList3.getLength() <= 0) continue;
            this.g.m_ClusterMembersProperties.put(string, properties);
        }
    }

    public static Element getFirstMatchElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static String getNodeValueIfExists(Element element, String string) {
        Node node;
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = nodeList.item(0).getFirstChild()) != null) {
            string2 = node.getNodeValue().trim();
        }
        return string2;
    }

    public static String getNodeValueIfExists(Document document, String string) {
        Node node;
        String string2 = null;
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = nodeList.item(0).getFirstChild()) != null) {
            string2 = node.getNodeValue().trim();
        }
        return string2;
    }

    public static boolean calculateOneWayReplicationValue(String string) {
        return string.endsWith(REPL_RECEIVER_ACK_POSTFIX);
    }

    public static boolean calculateSyncReplicationValue(String string) {
        return string.startsWith("sync");
    }

    public static String calculateReplicationMode(boolean bl2, boolean bl3) {
        String string = null;
        string = bl2 ? (bl3 ? "sync-rec-ack" : "sync") : (bl3 ? "async-rec-ack" : "async");
        return string;
    }

    private LoadBalancingPolicy a(String string, List list, List list2) {
        LoadBalancingPolicy loadBalancingPolicy = new LoadBalancingPolicy();
        loadBalancingPolicy.m_GroupName = string;
        loadBalancingPolicy.loadBalanceGroupMembersNames = list;
        loadBalancingPolicy.loadBalanceGroupMembersURLs = list2;
        Class<?> clazz = class$com$j_spaces$core$cluster$LoadBalanceImpl;
        if (clazz == null) {
            clazz = class$com$j_spaces$core$cluster$LoadBalanceImpl = new LoadBalanceImpl[0].getClass().getComponentType();
        }
        loadBalancingPolicy.m_ImplementationClassName = clazz.getName();
        loadBalancingPolicy.m_DefaultPolicy = new LoadBalancingPolicy.LoadBalancingPolicyDescription();
        loadBalancingPolicy.m_DefaultPolicy.m_BroadcastCondition = LoadBalancingPolicy.BroadcastCondition.BROADCAST_IF_NULL_VALUES;
        loadBalancingPolicy.m_DefaultPolicy.m_PolicyType = "local-space";
        return loadBalancingPolicy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] a(Document document, FailOverPolicy failOverPolicy, String[] stringArray, Hashtable hashtable) throws CreateException {
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<FailOverPolicy> vector3 = new Vector<FailOverPolicy>();
        Vector vector4 = new Vector();
        NodeList nodeList = document.getElementsByTagName(GROUP_NAME_TAG);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string = nodeList.item(i2).getFirstChild().getNodeValue().trim();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                Object object;
                int n2;
                Object object2;
                if (!string.equalsIgnoreCase(stringArray[i3])) continue;
                Element element = (Element)nodeList.item(i2).getParentNode();
                NodeList nodeList2 = element.getElementsByTagName(MEMBER_NAME_TAG);
                Vector<String> vector5 = new Vector<String>();
                for (int i4 = 0; i4 < nodeList2.getLength(); ++i4) {
                    object2 = nodeList2.item(i4);
                    vector5.add(object2.getFirstChild().getNodeValue().trim());
                }
                ArrayList arrayList = new ArrayList();
                object2 = new ArrayList();
                NodeList nodeList3 = document.getElementsByTagName(CLUSTER_MEMBERS_TAG);
                Element element2 = (Element)nodeList3.item(0);
                NodeList nodeList4 = element2.getElementsByTagName(MEMBER_NAME_TAG);
                for (n2 = 0; n2 < nodeList4.getLength(); ++n2) {
                    object = nodeList4.item(n2).getFirstChild().getNodeValue().trim();
                    for (int i5 = 0; i5 < vector5.size(); ++i5) {
                        if (!((String)object).equalsIgnoreCase((String)vector5.get(i5))) continue;
                        Node node = nodeList4.item(n2).getNextSibling();
                        String string2 = node.getFirstChild().getNodeValue().trim();
                        failOverPolicy.failOverGroupMembersNames.add(vector5.get(i5));
                        SpaceURL spaceURL = null;
                        try {
                            Properties properties = null;
                            if (this.m != null) {
                                properties = this.m.getCustomProperties();
                            }
                            spaceURL = SpaceURLParser.parseURL(string2, properties);
                            failOverPolicy.failOverGroupMembersURLs.add(spaceURL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new RuntimeException(new ClusterConfigurationException("Failed to parse cluster member url: " + string2, malformedURLException));
                        }
                        arrayList.add(vector5.get(i5));
                        ((ArrayList)object2).add(spaceURL);
                    }
                }
                for (n2 = 0; n2 < vector5.size(); ++n2) {
                    if (arrayList.contains(vector5.elementAt(n2)) || !s.isLoggable(Level.WARNING)) continue;
                    s.warning("This member-name: <" + (String)vector5.elementAt(n2) + "> that defined in group: <" + stringArray[i3] + ">  not defined in \"cluster-members\" section. Check " + this.l + " cluster config file.");
                }
                FailOverPolicy failOverPolicy2 = (FailOverPolicy)hashtable.get(stringArray[i3]);
                if (failOverPolicy2 == null) {
                    failOverPolicy2 = this.b(element, stringArray[i3], arrayList, (ArrayList)object2, hashtable);
                    if (failOverPolicy2 == null) throw new CreateException("IllegalAlternateGroupDefinitionError: In " + string + " alternate group should be defined FailOver Policy. Check " + this.l + " cluster config file.");
                    vector3.add(failOverPolicy2);
                } else {
                    vector3.add(failOverPolicy2);
                }
                object = this.a(element, stringArray[i3], arrayList, (ArrayList)object2);
                if (failOverPolicy2 != null && object == null) {
                    object = this.a(stringArray[i3], arrayList, (List)object2);
                }
                if (object != null) {
                    vector2.add(object);
                }
                vector.add(stringArray[i3]);
                vector4.add(arrayList);
            }
        }
        String[] stringArray2 = vector.toArray(new String[vector.size()]);
        failOverPolicy.m_AlternateLB = vector2.toArray(new LoadBalancingPolicy[vector2.size()]);
        failOverPolicy.m_AlternateFO = vector3.toArray(new FailOverPolicy[vector3.size()]);
        failOverPolicy.m_AlternateGroupMemberNames = vector4.toArray(new List[vector4.size()]);
        for (int i6 = 0; i6 < stringArray.length; ++i6) {
            if (vector.contains(stringArray[i6]) || !s.isLoggable(Level.WARNING)) continue;
            s.warning("WARNING: Fail Over Alternate group <" + stringArray[i6] + "> not defined in " + this.l + " cluster config file.");
        }
        if (vector.isEmpty()) {
            return null;
        }
        String[] stringArray3 = stringArray2;
        return stringArray3;
    }

    public ReplicationPolicy.ReplicationPolicyDescription createReplDescPolicy(String string, Element element, List list) throws CreateException {
        String string2;
        Object object;
        Object object2;
        Element element2 = null;
        ReplicationPolicy.ReplicationPolicyDescription replicationPolicyDescription = new ReplicationPolicy.ReplicationPolicyDescription();
        Element element3 = (Element)element.getParentNode().getParentNode();
        NodeList nodeList = element3.getElementsByTagName(REPL_POLICY_TAG);
        if (nodeList.getLength() == 0) {
            return replicationPolicyDescription;
        }
        element2 = (Element)nodeList.item(0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NodeList nodeList2 = element.getElementsByTagName(REPL_TRANSMISSION_TAG);
        for (int i2 = 0; i2 < nodeList2.getLength(); ++i2) {
            int n2;
            Object object3;
            object2 = (Element)nodeList2.item(i2);
            object = ClusterXML.getNodeValueIfExists((Element)object2, REPL_TARGET_MEMBER_TAG);
            string2 = ClusterXML.getNodeValueIfExists((Element)object2, REPL_TRANSMISSION_OPERATIONS_TAG);
            boolean bl2 = JSpaceUtilities.parseBooleanTag(REPL_DISABLE_TRANSMISSION_TAG, ClusterXML.getNodeValueIfExists((Element)object2, REPL_DISABLE_TRANSMISSION_TAG));
            boolean bl3 = JSpaceUtilities.parseBooleanTag(REPL_SYNC_ON_COMMIT_TAG, ClusterXML.getNodeValueIfExists((Element)object2, REPL_SYNC_ON_COMMIT_TAG));
            String string3 = ClusterXML.getNodeValueIfExists((Element)object2, REPLICATION_MODE_TAG);
            String string4 = ClusterXML.getNodeValueIfExists((Element)object2, COMMUNICATION_MODE_TAG);
            if (element2 == null) {
                throw new CreateException("IllegalReplicatonDefinitionError: Wrong Transmission matrix " + string + ":" + (String)object + " definition. <" + REPL_POLICY_TAG + "> tag not found. Check " + this.l + " cluster config file.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken().trim().toLowerCase();
                if (Arrays.binarySearch(REPL_TRANSMISSION_OPERATIONS, object3) == -1) {
                    throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Unknown replication transmission operation: " + (String)object3 + ". Possible operations: write, take, notify. Check " + this.l + " cluster config file.");
                }
                n2 = Character.toUpperCase(((String)object3).charAt(0));
                if (n2 == 87) {
                    string2 = string2 + 'W';
                } else if (n2 == 84) {
                    string2 = string2 + 'T';
                } else if (n2 == 78) {
                    string2 = string2 + 'N';
                }
                if (((String)object).equalsIgnoreCase(string)) {
                    throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Wrong replication transmission target member: " + (String)object + ". This member: " + string + " can not transmit to it self. Check " + this.l + " cluster config file.");
                }
                if (list.contains(object)) continue;
                throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Unknown replication transmission target member: " + (String)object + ". The target member not in replication group. Check " + this.l + " cluster config file.");
            }
            if (string4 == null) {
                string4 = ClusterXML.getNodeValueIfExists(element2, COMMUNICATION_MODE_TAG);
            }
            object3 = new ReplicationTransmissionPolicy(string, (String)object, string2, bl3, string4, bl2);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ReplicationTransmissionPolicy replicationTransmissionPolicy = (ReplicationTransmissionPolicy)arrayList.get(n2);
                String string5 = replicationTransmissionPolicy.m_TargetSpace;
                if (!((String)object).equalsIgnoreCase(string5)) continue;
                throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Dublicated replication transmission policy for target member: " + (String)object + ". Check " + this.l + " cluster config file.");
            }
            if (((ReplicationTransmissionPolicy)object3).m_DisableTransmission) {
                string3 = ClusterXML.getNodeValueIfExists(element2, REPLICATION_MODE_TAG);
                string4 = ClusterXML.getNodeValueIfExists(element2, COMMUNICATION_MODE_TAG);
            }
            if (string3 != null) {
                ((ReplicationTransmissionPolicy)object3).setOneWayReplication(ClusterXML.calculateOneWayReplicationValue(string3));
                ((ReplicationTransmissionPolicy)object3).setSyncReplication(ClusterXML.calculateSyncReplicationValue(string3));
            }
            if (SYNC_REPL_MULTICAST_TAG.equalsIgnoreCase(string4)) {
                Class<?> clazz = class$com$j_spaces$core$cluster$sync_replication$MulticastProtocolAdaptor;
                if (clazz == null) {
                    clazz = new MulticastProtocolAdaptor[0].getClass().getComponentType();
                }
                ((ReplicationTransmissionPolicy)object3).setProtocolAdaptorClass(clazz.getName());
                if (!((ReplicationTransmissionPolicy)object3).isSyncReplication()) {
                    ((ReplicationTransmissionPolicy)object3).setOneWayReplication(true);
                }
            }
            arrayList.add(object3);
        }
        replicationPolicyDescription.replTransmissionPolicies = arrayList.size() > 0 ? arrayList : null;
        NodeList nodeList3 = element.getElementsByTagName(REPL_FILTERS_TAG);
        if (nodeList3.getLength() > 0) {
            object2 = (Element)nodeList3.item(0);
            replicationPolicyDescription.inputReplicationFilterClassName = ClusterXML.getNodeValueIfExists((Element)object2, REPL_INPUT_FILTER_CLASSNAME_TAG);
            replicationPolicyDescription.inputReplicationFilterParamUrl = ClusterXML.getNodeValueIfExists((Element)object2, REPL_INPUT_FILTER_PARAM_URL_TAG);
            replicationPolicyDescription.outputReplicationFilterClassName = ClusterXML.getNodeValueIfExists((Element)object2, REPL_OUTPUT_FILTER_CLASSNAME_TAG);
            replicationPolicyDescription.outputReplicationFilterParamUrl = ClusterXML.getNodeValueIfExists((Element)object2, REPL_OUTPUT_FILTER_PARAM_URL_TAG);
            object = ClusterXML.getNodeValueIfExists((Element)object2, REPL_ACTIVE_WHEN_BACKUP_TAG);
            if (object == null || ((String)object).length() == 0) {
                object = REPL_ACTIVE_WHEN_BACKUP_DEFAULT;
            }
            replicationPolicyDescription.activeWhenBackup = JSpaceUtilities.parseBooleanTag(REPL_ACTIVE_WHEN_BACKUP_TAG, (String)object);
            object = ClusterXML.getNodeValueIfExists((Element)object2, REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG);
            if (object == null || ((String)object).length() == 0) {
                object = REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT;
            }
            replicationPolicyDescription.shutdownSpaceOnInitFailure = JSpaceUtilities.parseBooleanTag(REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG, (String)object);
        }
        if ((object2 = element.getElementsByTagName(REPL_MEMBER_RECOVERY_TAG)).getLength() > 0) {
            if (element2 == null) {
                throw new CreateException("IllegalReplicatonDefinitionError: Wrong memory recovery " + string + " definition. <" + REPL_POLICY_TAG + "> tag not found. Check " + this.l + " cluster config file.");
            }
            object = (Element)object2.item(0);
            string2 = ClusterXML.getNodeValueIfExists((Element)object, ENABLED_TAG);
            replicationPolicyDescription.memberRecovery = JSpaceUtilities.parseBooleanTag(ENABLED_TAG, string2);
            String string6 = ClusterXML.getNodeValueIfExists((Element)object, REPL_SOURCE_MEMBER_URL_TAG);
            if (string6 != null && !string6.equals(FIRST_AVAILABLE_MEMBER)) {
                replicationPolicyDescription.sourceMemberRecovery = string6;
            }
            if (replicationPolicyDescription.sourceMemberRecovery != null) {
                if (replicationPolicyDescription.sourceMemberRecovery.equalsIgnoreCase(string)) {
                    throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Wrong recovery source member: " + replicationPolicyDescription.sourceMemberRecovery + ". The member: " + string + " can not recovery from it self. Check " + this.l + " cluster config file.");
                }
                if (!list.contains(replicationPolicyDescription.sourceMemberRecovery) && !replicationPolicyDescription.sourceMemberRecovery.equalsIgnoreCase(FIRST_AVAILABLE_MEMBER)) {
                    throw new CreateException("IllegalReplicatonDefinitionError: " + string + " member: Unknown recovery source member: " + replicationPolicyDescription.sourceMemberRecovery + ". The source member is not in replication group. Check " + this.l + " cluster config file.");
                }
            }
        } else {
            object = ClusterXML.getNodeValueIfExists(element2, REPL_MEMORY_RECOVERY_TAG);
            replicationPolicyDescription.memberRecovery = JSpaceUtilities.parseBooleanTag(REPL_MEMORY_RECOVERY_TAG, (String)object);
        }
        return replicationPolicyDescription;
    }

    public Document getXMLRootDocument() {
        return this.k;
    }

    public String getClusterFileURL() {
        return this.l;
    }

    private Element d(String string) {
        NodeList nodeList = this.k.getElementsByTagName(GROUP_TAG);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            NodeList nodeList2 = element.getElementsByTagName(REPL_POLICY_TAG);
            if (nodeList2.getLength() <= 0) continue;
            NodeList nodeList3 = element.getElementsByTagName(MEMBER_NAME_TAG);
            for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                Node node = nodeList3.item(i3).getFirstChild();
                if (!node.getNodeValue().equals(string)) continue;
                return (Element)nodeList3.item(i3).getParentNode();
            }
        }
        return null;
    }

    private void a(String string, String string2, String string3) throws ClusterException {
        Element element = this.d(string);
        if (element == null) {
            throw new ClusterException(string + " couldn't found in no replication group.");
        }
        Element element2 = this.k.createElement(MEMBER_TAG);
        Element element3 = this.k.createElement(MEMBER_NAME_TAG);
        Text text = this.k.createTextNode(string2);
        Element element4 = (Element)element.getParentNode();
        element4.appendChild(element2);
        element2.appendChild(element3).appendChild(text);
        Node node = this.k.getElementsByTagName(CLUSTER_MEMBERS_TAG).item(0);
        Node node2 = element2.cloneNode(true);
        Element element5 = this.k.createElement(MEMBER_URL_TAG);
        Text text2 = this.k.createTextNode(string3);
        node.appendChild(node2).appendChild(element5).appendChild(text2);
    }

    private void e(String string) throws ClusterException {
        Element element = this.d(string);
        if (element == null) {
            throw new ClusterException(string + " couldn't found in no replication group.");
        }
        Node node = element.getParentNode();
        node.removeChild(element);
        Element element2 = (Element)this.k.getElementsByTagName(CLUSTER_MEMBERS_TAG).item(0);
        NodeList nodeList = element2.getElementsByTagName(MEMBER_NAME_TAG);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string2 = nodeList.item(i2).getFirstChild().getNodeValue().trim();
            if (!string2.equalsIgnoreCase(string)) continue;
            Node node2 = nodeList.item(i2).getParentNode();
            element2.removeChild(node2);
            break;
        }
    }

    public void addMember(String string, String string2, String string3) throws ClusterException {
        this.a(string, string2, string3);
        try {
            this.c();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClusterException("Failed to add " + string2 + " member to " + this.l + ". " + fileNotFoundException.toString(), fileNotFoundException);
        }
    }

    public void removeMember(String string) throws ClusterException {
        this.e(string);
        try {
            this.c();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClusterException("Failed to remove " + string + " member from " + this.l + ". " + fileNotFoundException.toString(), fileNotFoundException);
        }
    }

    public void changeMember(String string, String string2, String string3) throws ClusterException {
        this.addMember(string, string2, string3);
        this.removeMember(string);
    }

    private void c() throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new FileOutputStream(this.l));
        JSpaceUtilities.domWriter(this.k.getDocumentElement(), printStream, "");
        printStream.close();
    }

    private void a(InputStream inputStream, Element element, Document document, Transformer transformer, String string) {
        block14: {
            try {
                Object object;
                Object object2;
                Object object3;
                if (this.q == null) {
                    this.q = new StringBuffer();
                }
                if (string != null) {
                    this.q.append("\n\n==============================================================================================\n");
                    this.q.append("Cluster Configuration: " + string + "\n---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info(this.q.toString());
                    }
                }
                if (inputStream != null) {
                    this.q.append("\nCluster XSL: \n---------------------------------------------------------------------------------------- \n");
                    object3 = new StringBuffer();
                    object2 = null;
                    object = new BufferedReader(new InputStreamReader(inputStream));
                    while ((object2 = ((BufferedReader)object).readLine()) != null) {
                        ((StringBuffer)object3).append((String)object2 + "\n");
                    }
                    this.q.append(((StringBuffer)object3).toString());
                    this.q.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info(((StringBuffer)object3).toString() + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
                if (element != null) {
                    this.q.append("\nCluster members XML Document:\n---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info("\nCluster members XML Document:\n ---------------------------------------------------------------------------------------- \n");
                    }
                    object3 = new DOMResult();
                    transformer.transform(new DOMSource(element), (Result)object3);
                    object2 = new ByteArrayOutputStream();
                    JSpaceUtilities.domWriter(((DOMResult)object3).getNode(), new PrintStream((OutputStream)object2), "");
                    ((OutputStream)object2).flush();
                    ((ByteArrayOutputStream)object2).close();
                    object = new String(((ByteArrayOutputStream)object2).toByteArray());
                    this.q.append((String)object);
                    this.q.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info((String)object + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
                if (document != null) {
                    this.q.append("\nTransformed Cluster Config XML Document:\n---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info("\nTransformed Cluster Config XML Document:\n ---------------------------------------------------------------------------------------- \n");
                    }
                    object3 = new DOMResult();
                    transformer.transform(new DOMSource(document), (Result)object3);
                    object2 = new ByteArrayOutputStream();
                    JSpaceUtilities.domWriter(((DOMResult)object3).getNode(), new PrintStream((OutputStream)object2), "");
                    ((OutputStream)object2).flush();
                    ((ByteArrayOutputStream)object2).close();
                    object = new String(((ByteArrayOutputStream)object2).toByteArray());
                    this.q.append((String)object);
                    this.q.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!t && s.isLoggable(Level.INFO)) {
                        s.info((String)object + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
            }
            catch (Exception exception) {
                if (!s.isLoggable(Level.SEVERE)) break block14;
                s.log(Level.SEVERE, "failed to print cluster configuration debug output.", exception);
            }
        }
    }

    public StringBuffer getClusterConfigDebugOutput() {
        return this.q;
    }

    private boolean d() {
        return t || f;
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        Object object;
        ClusterXML clusterXML = new ClusterXML("D:/Work/GigaSpaces4.0/examples/Core_Cluster/replication/config/cluster-config.xml");
        ClusterPolicy clusterPolicy = clusterXML.createClusterPolicy("container2:sp2");
        FailOverPolicy.FailOverPolicyDescription failOverPolicyDescription = clusterPolicy.m_FailOverPolicy.m_WriteFOPolicy;
        if (s.isLoggable(Level.INFO)) {
            s.info("====> LB Group Mem: " + clusterPolicy.m_LoadBalancingPolicy.loadBalanceGroupMembersNames + "\n====> FO Group Mem: " + clusterPolicy.m_FailOverPolicy.failOverGroupMembersNames + "\nfo.m_PolicyType: " + failOverPolicyDescription.m_PolicyType + "fo.m_DisableAlternateGroups: " + failOverPolicyDescription.m_DisableAlternateGroups);
        }
        Iterator iterator = failOverPolicyDescription.m_BackupMemberNames.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            List list = (List)failOverPolicyDescription.m_BackupMemberNames.get(object);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!s.isLoggable(Level.INFO)) continue;
                s.info((String)object + " ===> " + (String)list.get(i2));
            }
        }
        for (n2 = 0; n2 < failOverPolicyDescription.m_BackupOnly.size(); ++n2) {
            if (!s.isLoggable(Level.INFO)) continue;
            s.info(" backup only: " + (String)failOverPolicyDescription.m_BackupOnly.get(n2));
        }
        for (n2 = 0; n2 < clusterPolicy.m_FailOverPolicy.m_AlternateFO.length; ++n2) {
            object = clusterPolicy.m_FailOverPolicy.m_AlternateFO[n2];
            for (int i3 = 0; i3 < ((FailOverPolicy)object).failOverGroupMembersNames.size(); ++i3) {
                if (!s.isLoggable(Level.INFO)) continue;
                s.info("FO Mem: " + (String)((FailOverPolicy)object).failOverGroupMembersNames.get(i3));
            }
        }
        for (n2 = 0; n2 < clusterPolicy.m_FailOverPolicy.m_AlternateLB.length; ++n2) {
            object = clusterPolicy.m_FailOverPolicy.m_AlternateLB[n2];
            for (int i4 = 0; i4 < ((LoadBalancingPolicy)object).loadBalanceGroupMembersNames.size(); ++i4) {
                if (!s.isLoggable(Level.INFO)) continue;
                s.info("LB Mem: " + (String)((LoadBalancingPolicy)object).loadBalanceGroupMembersNames.get(i4));
            }
        }
    }

    public static /* synthetic */ Logger a() {
        return s;
    }

    static {
        BROADCAST_CONDITIONS_ARRAY = new String[]{"broadcast-if-null-values", "unconditional", "broadcast-disabled"};
        s = Logger.getLogger("com.gigaspaces.core.config");
        t = Boolean.getBoolean("com.gs.env.report");
    }
}

