/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.INotifyDelegator;
import com.j_spaces.core.client.JSpaceProxyUtil;
import com.j_spaces.core.lrmi.LRMINotifyDelegatorListener;
import com.j_spaces.obf.di;
import com.j_spaces.obf.gh;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class NotifyDelegator
implements INotifyDelegator,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient EventRegistration m_EventRegistration;
    private boolean _fifoEnabled;
    public transient FifoDelegatorThread _fifoDelegatorThread;
    private transient RemoteEventListener m_UserSuppliedListener;
    private transient IJSpace m_Space;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client");
    private static final int _queueSize = Integer.getInteger("com.gs.fifo_notify.queue", Integer.MAX_VALUE);

    public NotifyDelegator(IJSpace iJSpace, RemoteEventListener remoteEventListener, boolean bl2) {
        this(remoteEventListener, bl2);
        this.setSpace(iJSpace);
    }

    public NotifyDelegator(RemoteEventListener remoteEventListener) {
        this.m_UserSuppliedListener = remoteEventListener;
    }

    public NotifyDelegator(RemoteEventListener remoteEventListener, boolean bl2) {
        this.m_UserSuppliedListener = remoteEventListener;
        this._fifoEnabled = bl2;
        if (bl2) {
            this.enableFifo();
        }
    }

    public NotifyDelegator(IJSpace iJSpace, Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2) throws TransactionException, RemoteException {
        this(iJSpace, (Object)entry, transaction, remoteEventListener, l2, marshalledObject, bl2, n2);
    }

    public NotifyDelegator(IJSpace iJSpace, Object object, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2, int n2) throws TransactionException, RemoteException {
        this(remoteEventListener, bl2);
        if (JSpaceProxyUtil.isPojo(object)) {
            object = JSpaceProxyUtil.converter.toEntry(object, true);
        }
        this.setSpace(iJSpace);
        this.m_EventRegistration = di.a(iJSpace, object) ? new di(iJSpace).a((Entry)object, transaction, this.exportListener(iJSpace), l2, marshalledObject, n2) : iJSpace.notify(object, transaction, this.exportListener(iJSpace), l2, marshalledObject, n2);
    }

    private RemoteEventListener exportListener(IJSpace iJSpace) throws RemoteException {
        RemoteEventListener remoteEventListener = (RemoteEventListener)iJSpace.getStubHandler().exportObject(this);
        return new LRMINotifyDelegatorListener(this, remoteEventListener);
    }

    public NotifyDelegator(IJSpace iJSpace, Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject) throws TransactionException, RemoteException {
        this(iJSpace, entry, transaction, remoteEventListener, l2, marshalledObject, false);
    }

    public NotifyDelegator(IJSpace iJSpace, Entry entry, Transaction transaction, RemoteEventListener remoteEventListener, long l2, MarshalledObject marshalledObject, boolean bl2) throws TransactionException, RemoteException {
        this(iJSpace, entry, transaction, remoteEventListener, l2, marshalledObject, bl2, 1);
    }

    private void enableFifo() {
        this._fifoDelegatorThread = new FifoDelegatorThread("NotifyDelegator:FifoDelegatorThread");
    }

    public EventRegistration getEventRegistration() {
        return this.m_EventRegistration;
    }

    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        if (this._fifoEnabled) {
            this._fifoDelegatorThread.b(remoteEvent);
        } else {
            this.notifyEvent(remoteEvent);
        }
    }

    private void notifyEvent(RemoteEvent remoteEvent) throws RemoteException, UnknownEventException {
        EntryArrivedRemoteEvent entryArrivedRemoteEvent = (EntryArrivedRemoteEvent)remoteEvent;
        if (entryArrivedRemoteEvent._spaceProxy == null) {
            entryArrivedRemoteEvent._spaceProxy = this.m_Space;
        }
        this.m_UserSuppliedListener.notify(entryArrivedRemoteEvent);
    }

    public IJSpace getSpace() {
        return this.m_Space;
    }

    public void setSpace(IJSpace iJSpace) {
        this.m_Space = iJSpace instanceof DCacheSpaceImpl ? ((DCacheSpaceImpl)iJSpace).getRemoteSpace() : iJSpace;
    }

    public void close() {
        try {
            Lease lease = this.m_EventRegistration.getLease();
            if (lease != null) {
                lease.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_Space.getStubHandler().unexportObject(this, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._fifoDelegatorThread != null) {
            this._fifoDelegatorThread.a();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this._fifoEnabled);
        objectOutputStream.writeUnshared(this.m_UserSuppliedListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._fifoEnabled = objectInputStream.readBoolean();
        this.m_UserSuppliedListener = (RemoteEventListener)objectInputStream.readUnshared();
        if (this._fifoEnabled) {
            this.enableFifo();
        }
    }

    public static /* synthetic */ int access$200() {
        return _queueSize;
    }

    private final class FifoDelegatorThread
    extends Thread {
        private boolean b = true;
        private final transient gh c = new gh(NotifyDelegator.access$200());

        public FifoDelegatorThread(String string) {
            this.setName(string);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            block3: {
                try {
                    while (this.b) {
                        RemoteEvent remoteEvent = this.c.a();
                        this.a(remoteEvent);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!_logger.isLoggable(Level.FINEST)) break block3;
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", interruptedException);
                }
            }
        }

        private void a(RemoteEvent remoteEvent) {
            block2: {
                try {
                    NotifyDelegator.this.notifyEvent(remoteEvent);
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, "Notify failed while delegating to supplied listener on event: " + remoteEvent + " [ Seq. " + remoteEvent.getSequenceNumber() + " ]", throwable);
                }
            }
        }

        private void b(RemoteEvent remoteEvent) {
            block2: {
                try {
                    this.c.a(remoteEvent);
                }
                catch (InterruptedException interruptedException) {
                    if (!_logger.isLoggable(Level.FINEST)) break block2;
                    _logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", interruptedException);
                }
            }
        }

        private void a() {
            this.b = false;
        }
    }
}

