/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ContextLoaderPlugIn;

public abstract class DelegatingActionUtils {
    public static final String PARAM_AUTOWIRE = "spring.autowire";
    public static final String PARAM_DEPENDENCY_CHECK = "spring.dependencyCheck";
    public static final String AUTOWIRE_BY_NAME = "byName";
    public static final String AUTOWIRE_BY_TYPE = "byType";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$struts$DelegatingActionUtils == null ? (class$org$springframework$web$struts$DelegatingActionUtils = DelegatingActionUtils.class$("org.springframework.web.struts.DelegatingActionUtils")) : class$org$springframework$web$struts$DelegatingActionUtils));
    static /* synthetic */ Class class$org$springframework$web$struts$DelegatingActionUtils;
    static /* synthetic */ Class class$org$springframework$web$struts$ContextLoaderPlugIn;

    public static WebApplicationContext getWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) {
        WebApplicationContext wac = null;
        String modulePrefix = null;
        if (moduleConfig != null) {
            modulePrefix = moduleConfig.getPrefix();
            wac = (WebApplicationContext)actionServlet.getServletContext().getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX + modulePrefix);
        }
        if (wac == null && !"".equals(modulePrefix)) {
            wac = (WebApplicationContext)actionServlet.getServletContext().getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX);
        }
        return wac;
    }

    public static WebApplicationContext getRequiredWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        WebApplicationContext wac = DelegatingActionUtils.getWebApplicationContext(actionServlet, moduleConfig);
        if (wac == null) {
            throw new IllegalStateException("Could not find ContextLoaderPlugIn's WebApplicationContext as ServletContext attribute [" + ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX + "]: Did you register [" + (class$org$springframework$web$struts$ContextLoaderPlugIn == null ? (class$org$springframework$web$struts$ContextLoaderPlugIn = DelegatingActionUtils.class$("org.springframework.web.struts.ContextLoaderPlugIn")) : class$org$springframework$web$struts$ContextLoaderPlugIn).getName() + "]?");
        }
        return wac;
    }

    public static WebApplicationContext findRequiredWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        WebApplicationContext wac = DelegatingActionUtils.getWebApplicationContext(actionServlet, moduleConfig);
        if (wac == null) {
            wac = WebApplicationContextUtils.getRequiredWebApplicationContext(actionServlet.getServletContext());
        }
        return wac;
    }

    public static String determineActionBeanName(ActionMapping mapping) {
        String prefix = mapping.getModuleConfig().getPrefix();
        String path = mapping.getPath();
        String beanName = prefix + path;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DelegatingActionProxy with mapping path '" + path + "' and module prefix '" + prefix + "' delegating to Spring bean with name [" + beanName + "]"));
        }
        return beanName;
    }

    public static int getAutowireMode(ActionServlet actionServlet) {
        String autowire = actionServlet.getInitParameter(PARAM_AUTOWIRE);
        if (autowire != null) {
            if (AUTOWIRE_BY_NAME.equals(autowire)) {
                return 1;
            }
            if (!AUTOWIRE_BY_TYPE.equals(autowire)) {
                throw new IllegalArgumentException("ActionServlet 'autowire' parameter must be 'byName' or 'byType'");
            }
        }
        return 2;
    }

    public static boolean getDependencyCheck(ActionServlet actionServlet) {
        String dependencyCheck = actionServlet.getInitParameter(PARAM_DEPENDENCY_CHECK);
        return Boolean.valueOf(dependencyCheck);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

