/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyMatches;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanWrapperImpl
extends AbstractPropertyAccessor
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$BeanWrapperImpl == null ? (class$org$springframework$beans$BeanWrapperImpl = BeanWrapperImpl.class$("org.springframework.beans.BeanWrapperImpl")) : class$org$springframework$beans$BeanWrapperImpl));
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private TypeConverterDelegate typeConverterDelegate;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map nestedBeanWrappers;
    static /* synthetic */ Class class$org$springframework$beans$BeanWrapperImpl;

    public BeanWrapperImpl() {
        this(true);
    }

    public BeanWrapperImpl(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.registerDefaultEditors();
        }
        this.typeConverterDelegate = new TypeConverterDelegate(this);
    }

    public BeanWrapperImpl(Object object) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Class clazz) {
        this.registerDefaultEditors();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public BeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    private BeanWrapperImpl(Object object, String nestedPath, BeanWrapperImpl superBw) {
        this.setWrappedInstance(object, nestedPath, superBw.getWrappedInstance());
        this.setExtractOldValueForEditor(superBw.isExtractOldValueForEditor());
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        Assert.notNull(object, "Bean object must not be null");
        this.object = object;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootObject : object;
        this.nestedBeanWrappers = null;
        this.typeConverterDelegate = new TypeConverterDelegate(this, object);
        this.setIntrospectionClass(object.getClass());
    }

    public Object getWrappedInstance() {
        return this.object;
    }

    public Class getWrappedClass() {
        return this.object.getClass();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public Object getRootInstance() {
        return this.rootObject;
    }

    public Class getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(clazz)) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        Assert.notNull(propertyName, "Property name must not be null");
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd != null) {
            return pd;
        }
        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "No property '" + propertyName + "' found");
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String propertyName) throws BeansException {
        Assert.state(this.object != null, "BeanWrapper does not hold a bean instance");
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        return nestedBw.cachedIntrospectionResults.getPropertyDescriptor(this.getFinalPath(nestedBw, propertyName));
    }

    public boolean isReadableProperty(String propertyName) {
        block4: {
            Assert.notNull(propertyName, "Property name must not be null");
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getReadMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWritableProperty(String propertyName) {
        block4: {
            Assert.notNull(propertyName, "Property name must not be null");
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getWriteMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            Object value = this.getPropertyValue(propertyName);
            if (value != null) {
                return value.getClass();
            }
            Class editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    public Object doTypeConversionIfNecessary(Object value, Class requiredType) throws TypeMismatchException {
        return this.convertIfNecessary(value, requiredType, null);
    }

    public Object convertIfNecessary(Object value, Class requiredType) throws TypeMismatchException {
        return this.convertIfNecessary(value, requiredType, null);
    }

    public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }

    private String getFinalPath(BeanWrapper bw, String nestedPath) {
        if (bw == this) {
            return nestedPath;
        }
        return nestedPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(nestedPath) + 1);
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) throws BeansException {
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(propertyPath);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    private BeanWrapperImpl getNestedBeanWrapper(String nestedProperty) throws BeansException {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        String canonicalName = tokens.canonicalName;
        Object propertyValue = this.getPropertyValue(tokens);
        if (propertyValue == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
        }
        BeanWrapperImpl nestedBw = (BeanWrapperImpl)this.nestedBeanWrappers.get(canonicalName);
        if (nestedBw == null || nestedBw.getWrappedInstance() != propertyValue) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating new nested BeanWrapper for property '" + canonicalName + "'"));
            }
            nestedBw = this.newNestedBeanWrapper(propertyValue, this.nestedPath + canonicalName + ".");
            this.copyDefaultEditorsTo(nestedBw);
            this.copyCustomEditorsTo(nestedBw, canonicalName);
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("Using cached nested BeanWrapper for property '" + canonicalName + "'"));
        }
        return nestedBw;
    }

    protected BeanWrapperImpl newNestedBeanWrapper(Object object, String nestedPath) {
        return new BeanWrapperImpl(object, nestedPath, this);
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, "][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        return nestedBw.getPropertyValue(tokens);
    }

    private Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(tokens.actualName);
        if (pd == null || pd.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        Method readMethod = pd.getReadMethod();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("About to invoke read method [" + readMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
        }
        try {
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            Object value = readMethod.invoke(this.object, (Object[])null);
            if (tokens.keys != null) {
                block5: for (int i = 0; i < tokens.keys.length; ++i) {
                    String key = tokens.keys[i];
                    if (value == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value.getClass().isArray()) {
                        value = Array.get(value, Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof List) {
                        List list = (List)value;
                        value = list.get(Integer.parseInt(key));
                        continue;
                    }
                    if (value instanceof Set) {
                        Set set = (Set)value;
                        int index = Integer.parseInt(key);
                        if (index < 0 || index >= set.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index + " from Set of size " + set.size() + ", accessed using property path '" + propertyName + "'");
                        }
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index) {
                                value = elem;
                                continue block5;
                            }
                            ++j;
                        }
                        continue;
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        Class mapKeyType = null;
                        if (JdkVersion.isAtLeastJava15()) {
                            mapKeyType = GenericCollectionTypeResolver.getMapKeyReturnType(pd.getReadMethod(), i + 1);
                        }
                        Object convertedMapKey = this.typeConverterDelegate.convertIfNecessary(key, mapKeyType);
                        value = map.get(convertedMapKey);
                        continue;
                    }
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + value + "]");
                }
            }
            return value;
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        BeanWrapperImpl nestedBw = null;
        try {
            nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        nestedBw.setPropertyValue(tokens, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyValue(PropertyTokenHolder tokens, Object newValue) throws BeansException {
        Object oldValue;
        Method writeMethod;
        PropertyDescriptor pd;
        String propertyName;
        block36: {
            propertyName = tokens.canonicalName;
            if (tokens.keys != null) {
                PropertyTokenHolder getterTokens = new PropertyTokenHolder();
                getterTokens.canonicalName = tokens.canonicalName;
                getterTokens.actualName = tokens.actualName;
                getterTokens.keys = new String[tokens.keys.length - 1];
                System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
                Object propValue = null;
                try {
                    propValue = this.getPropertyValue(getterTokens);
                }
                catch (NotReadablePropertyException ex) {
                    throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", ex);
                }
                String key = tokens.keys[tokens.keys.length - 1];
                if (propValue == null) {
                    throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
                }
                if (propValue.getClass().isArray()) {
                    Class<?> requiredType = propValue.getClass().getComponentType();
                    int arrayIndex = Integer.parseInt(key);
                    Object oldValue2 = null;
                    try {
                        if (this.isExtractOldValueForEditor()) {
                            oldValue2 = Array.get(propValue, arrayIndex);
                        }
                        Object convertedValue = this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue2, newValue, requiredType);
                        Array.set(propValue, Integer.parseInt(key), convertedValue);
                        return;
                    }
                    catch (IllegalArgumentException ex) {
                        PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue2, newValue);
                        throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid array index in property path '" + propertyName + "'", ex);
                    }
                }
                if (propValue instanceof List) {
                    PropertyDescriptor pd2 = this.getPropertyDescriptorInternal(tokens.actualName);
                    Class requiredType = null;
                    if (JdkVersion.isAtLeastJava15()) {
                        requiredType = GenericCollectionTypeResolver.getCollectionReturnType(pd2.getReadMethod(), tokens.keys.length);
                    }
                    List list = (List)propValue;
                    int index = Integer.parseInt(key);
                    Object oldValue3 = null;
                    if (this.isExtractOldValueForEditor() && index < list.size()) {
                        oldValue3 = list.get(index);
                    }
                    try {
                        Object convertedValue = this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue3, newValue, requiredType);
                        if (index < list.size()) {
                            list.set(index, convertedValue);
                            return;
                        }
                        if (index < list.size()) return;
                        for (int i = list.size(); i < index; ++i) {
                            try {
                                list.add(null);
                                continue;
                            }
                            catch (NullPointerException ex) {
                                throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                            }
                        }
                        list.add(convertedValue);
                        return;
                    }
                    catch (IllegalArgumentException ex) {
                        PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue3, newValue);
                        throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
                    }
                }
                if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + newValue + "]");
                PropertyDescriptor pd3 = this.getPropertyDescriptorInternal(tokens.actualName);
                Class mapKeyType = null;
                Class mapValueType = null;
                if (JdkVersion.isAtLeastJava15()) {
                    mapKeyType = GenericCollectionTypeResolver.getMapKeyReturnType(pd3.getReadMethod(), tokens.keys.length);
                    mapValueType = GenericCollectionTypeResolver.getMapValueReturnType(pd3.getReadMethod(), tokens.keys.length);
                }
                Map map = (Map)propValue;
                Object oldValue4 = null;
                if (this.isExtractOldValueForEditor()) {
                    oldValue4 = map.get(key);
                }
                Object convertedMapKey = null;
                Object convertedMapValue = null;
                try {
                    convertedMapKey = this.typeConverterDelegate.convertIfNecessary(key, mapKeyType);
                }
                catch (IllegalArgumentException ex) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue4, newValue);
                    throw new TypeMismatchException(pce, mapKeyType, (Throwable)ex);
                }
                try {
                    convertedMapValue = this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue4, newValue, mapValueType);
                }
                catch (IllegalArgumentException ex) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue4, newValue);
                    throw new TypeMismatchException(pce, mapValueType, (Throwable)ex);
                }
                map.put(convertedMapKey, convertedMapValue);
                return;
            }
            pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd == null || pd.getWriteMethod() == null) {
                PropertyMatches matches = PropertyMatches.forProperty(propertyName, this.getRootClass());
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
            }
            Method readMethod = pd.getReadMethod();
            writeMethod = pd.getWriteMethod();
            oldValue = null;
            if (this.isExtractOldValueForEditor() && readMethod != null) {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                try {
                    oldValue = readMethod.invoke(this.object, new Object[0]);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block36;
                    logger.debug((Object)("Could not read previous value of property '" + this.nestedPath + propertyName + "'"), (Throwable)ex);
                }
            }
        }
        try {
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(oldValue, newValue, pd);
            if (pd.getPropertyType().isPrimitive() && (convertedValue == null || "".equals(convertedValue))) {
                throw new IllegalArgumentException("Invalid value [" + newValue + "] for property '" + pd.getName() + "' of primitive type [" + pd.getPropertyType() + "]");
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("About to invoke write method [" + writeMethod + "] on object of class [" + this.object.getClass().getName() + "]"));
            }
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(this.object, convertedValue);
            if (!logger.isTraceEnabled()) return;
            logger.trace((Object)("Invoked write method [" + writeMethod + "] with value of type [" + pd.getPropertyType().getName() + "]"));
            return;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, pd.getPropertyType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BeanWrapperImpl: wrapping class [");
        sb.append(this.getWrappedClass().getName()).append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

