/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.common.collect.ImmutableList;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.DocInfo;
import com.google.doclava.Errors;
import com.google.doclava.Project;
import com.google.doclava.SinceTagger;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.Visibility;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageInfo
extends DocInfo
implements ContainerInfo {
    public static final String DEFAULT_PACKAGE = "default package";
    public static final Comparator<PackageInfo> ORDER_BY_NAME = new Comparator<PackageInfo>(){

        @Override
        public int compare(PackageInfo a, PackageInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private String mName;
    private PackageDoc mPackage;
    private ImmutableList<ClassInfo> mAnnotations;
    private ImmutableList<ClassInfo> mInterfaces;
    private ImmutableList<ClassInfo> mOrdinaryClasses;
    private ImmutableList<ClassInfo> mEnums;
    private ImmutableList<ClassInfo> mExceptions;
    private ImmutableList<ClassInfo> mErrors;
    private HashMap<String, ClassInfo> mClasses = new HashMap();

    public PackageInfo(PackageDoc pkg, String name, SourcePositionInfo position) {
        super(pkg.getRawCommentText(), position);
        this.mName = name.isEmpty() ? DEFAULT_PACKAGE : name;
        this.mPackage = pkg;
    }

    public PackageInfo(String name) {
        super("", null);
        this.mName = name;
    }

    public PackageInfo(String name, SourcePositionInfo position) {
        super("", position);
        this.mName = name.isEmpty() ? DEFAULT_PACKAGE : name;
    }

    @Override
    public boolean isDefinedLocally() {
        return true;
    }

    @Override
    public String relativePath() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-summary.html";
        return s;
    }

    public String fullDescriptionFile() {
        String s = this.mName;
        s = s.replace('.', '/');
        s = s + "/package-descr.html";
        return s;
    }

    public String fullDescriptionHtmlPage() {
        return this.htmlPage().replace("/package-summary.html", "/package-descr.html");
    }

    @Override
    public ContainerInfo parent() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.comment().isHidden();
    }

    @Override
    public boolean checkLevel() {
        return !this.isHidden();
    }

    public String name() {
        return this.mName;
    }

    @Override
    public String qualifiedName() {
        return this.mName;
    }

    public List<TagInfo> inlineTags() {
        return this.comment().tags();
    }

    public List<TagInfo> firstSentenceTags() {
        return this.comment().briefTags();
    }

    public void makeLink(Data data, String base) {
        if (this.checkLevel()) {
            data.setValue(base + ".link", this.htmlPage());
        }
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
    }

    public void makeClassLinkListHDF(Data data, String base) {
        this.makeLink(data, base);
        ClassInfo.makeLinkListHDF(data, base + ".annotations", this.getAnnotations());
        ClassInfo.makeLinkListHDF(data, base + ".interfaces", this.getInterfaces());
        ClassInfo.makeLinkListHDF(data, base + ".classes", this.ordinaryClasses());
        ClassInfo.makeLinkListHDF(data, base + ".enums", this.enums());
        ClassInfo.makeLinkListHDF(data, base + ".exceptions", this.exceptions());
        ClassInfo.makeLinkListHDF(data, base + ".errors", this.errors());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
    }

    private void checkInitVisibleCalled() {
        if (this.mAnnotations == null || this.mInterfaces == null || this.mOrdinaryClasses == null || this.mEnums == null || this.mExceptions == null || this.mErrors == null) {
            throw new IllegalStateException("Call initVisible() first!");
        }
    }

    public List<ClassInfo> getAnnotations() {
        this.checkInitVisibleCalled();
        return this.mAnnotations;
    }

    public List<ClassInfo> getInterfaces() {
        this.checkInitVisibleCalled();
        return this.mInterfaces;
    }

    public List<ClassInfo> ordinaryClasses() {
        this.checkInitVisibleCalled();
        return this.mOrdinaryClasses;
    }

    public List<ClassInfo> enums() {
        this.checkInitVisibleCalled();
        return this.mEnums;
    }

    public List<ClassInfo> exceptions() {
        this.checkInitVisibleCalled();
        return this.mExceptions;
    }

    public List<ClassInfo> errors() {
        this.checkInitVisibleCalled();
        return this.mErrors;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    @Override
    public void initVisible(Project project) {
        super.initVisible(project);
        this.mAnnotations = Visibility.displayClasses(project.getClasses((ClassDoc[])this.mPackage.annotationTypes()));
        this.mInterfaces = Visibility.displayClasses(project.getClasses(this.mPackage.interfaces()));
        this.mOrdinaryClasses = Visibility.displayClasses(project.getClasses(this.mPackage.ordinaryClasses()));
        this.mEnums = Visibility.displayClasses(project.getClasses(this.mPackage.enums()));
        this.mExceptions = Visibility.displayClasses(project.getClasses(this.mPackage.exceptions()));
        this.mErrors = Visibility.displayClasses(project.getClasses(this.mPackage.errors()));
    }

    public void addClass(ClassInfo cl) {
        this.mClasses.put(cl.name(), cl);
    }

    public HashMap<String, ClassInfo> allClasses() {
        return this.mClasses;
    }

    public boolean isConsistent(PackageInfo pInfo) {
        boolean consistent = true;
        for (ClassInfo cInfo : this.mClasses.values()) {
            if (pInfo.mClasses.containsKey(cInfo.name())) {
                if (cInfo.isConsistent(pInfo.mClasses.get(cInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_CLASS, cInfo.position(), "Removed public class " + cInfo.qualifiedName());
            consistent = false;
        }
        for (ClassInfo cInfo : pInfo.mClasses.values()) {
            if (this.mClasses.containsKey(cInfo.name())) continue;
            Errors.error(Errors.ADDED_CLASS, cInfo.position(), "Added class " + cInfo.name() + " to package " + pInfo.name());
            consistent = false;
        }
        return consistent;
    }
}

