/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.ClassInfo;
import com.google.doclava.Errors;
import com.google.doclava.FederatedSite;
import com.google.doclava.FieldInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.apicheck.ApiParseException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FederationTagger {
    private final Map<String, URL> federatedUrls = new HashMap<String, URL>();
    private final Map<String, String> federatedXmls = new HashMap<String, String>();
    private final List<FederatedSite> federatedSites = new ArrayList<FederatedSite>();
    private boolean initialized = false;

    public void addSiteUrl(String name, URL site) {
        this.federatedUrls.put(name, site);
    }

    public void addSiteXml(String name, String file) {
        this.federatedXmls.put(name, file);
    }

    public void tagAll(List<ClassInfo> classDocs) {
        this.initialize();
        for (FederatedSite site : this.federatedSites) {
            this.applyFederation(site, classDocs);
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        for (String name : this.federatedXmls.keySet()) {
            if (this.federatedUrls.containsKey(name)) continue;
            Errors.error(Errors.NO_FEDERATION_DATA, null, "Unknown documentation site for " + name);
        }
        for (String name : this.federatedUrls.keySet()) {
            try {
                if (this.federatedXmls.containsKey(name)) {
                    this.federatedSites.add(new FederatedSite(name, this.federatedUrls.get(name), this.federatedXmls.get(name)));
                    continue;
                }
                this.federatedSites.add(new FederatedSite(name, this.federatedUrls.get(name)));
            }
            catch (ApiParseException e) {
                String error = "Could not add site for federation: " + name;
                if (e.getMessage() != null) {
                    error = error + ": " + e.getMessage();
                }
                Errors.error(Errors.NO_FEDERATION_DATA, null, error);
            }
        }
        this.initialized = true;
    }

    private void applyFederation(FederatedSite federationSource, List<ClassInfo> classDocs) {
        for (ClassInfo classDoc : classDocs) {
            ClassInfo classSpec;
            PackageInfo packageSpec = federationSource.apiInfo().getPackages().get(classDoc.containingPackage().name());
            if (packageSpec == null || (classSpec = packageSpec.allClasses().get(classDoc.name())) == null) continue;
            this.federateMethods(federationSource, classSpec, classDoc);
            this.federateConstructors(federationSource, classSpec, classDoc);
            this.federateFields(federationSource, classSpec, classDoc);
            this.federateClass(federationSource, classDoc);
            this.federatePackage(federationSource, classDoc.containingPackage());
        }
    }

    private void federateMethods(FederatedSite site, ClassInfo federatedClass, ClassInfo localClass) {
        block0: for (MethodInfo method : localClass.getMethods()) {
            for (ClassInfo superclass : federatedClass.hierarchy()) {
                if (!superclass.allMethods().containsKey(method.getHashableName())) continue;
                method.addFederatedReference(site);
                continue block0;
            }
        }
    }

    private void federateConstructors(FederatedSite site, ClassInfo federatedClass, ClassInfo localClass) {
        for (MethodInfo constructor : localClass.getConstructors()) {
            if (!federatedClass.hasConstructor(constructor)) continue;
            constructor.addFederatedReference(site);
        }
    }

    private void federateFields(FederatedSite site, ClassInfo federatedClass, ClassInfo localClass) {
        for (FieldInfo field : localClass.getFields()) {
            if (!federatedClass.allFields().containsKey(field.name())) continue;
            field.addFederatedReference(site);
        }
    }

    private void federateClass(FederatedSite source, ClassInfo doc) {
        doc.addFederatedReference(source);
    }

    private void federatePackage(FederatedSite source, PackageInfo pkg) {
        pkg.addFederatedReference(source);
    }
}

