/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import com.google.clearsilver.jsilver.syntax.node.PVariable;

public class TypeResolver
extends DepthFirstAdapter {
    public void caseAAddExpression(AAddExpression node) {
        super.caseAAddExpression(node);
        PExpression lhs = node.getLeft();
        PExpression rhs = node.getRight();
        if (TypeResolver.isNumeric(lhs) || TypeResolver.isNumeric(rhs)) {
            node.replaceBy(new ANumericAddExpression(lhs, rhs));
        }
    }

    public void caseAEqExpression(AEqExpression node) {
        super.caseAEqExpression(node);
        PExpression lhs = node.getLeft();
        PExpression rhs = node.getRight();
        if (TypeResolver.isNumeric(lhs) || TypeResolver.isNumeric(rhs)) {
            node.replaceBy(new ANumericEqExpression(lhs, rhs));
        }
    }

    public void caseANeExpression(ANeExpression node) {
        super.caseANeExpression(node);
        PExpression lhs = node.getLeft();
        PExpression rhs = node.getRight();
        if (TypeResolver.isNumeric(lhs) || TypeResolver.isNumeric(rhs)) {
            node.replaceBy(new ANumericNeExpression(lhs, rhs));
        }
    }

    static boolean isNumeric(PExpression node) {
        return node instanceof ANumericExpression || node instanceof ANumericAddExpression || node instanceof ASubtractExpression || node instanceof AMultiplyExpression || node instanceof ADivideExpression || node instanceof AModuloExpression || node instanceof ADecimalExpression || node instanceof AHexExpression || node instanceof ANegativeExpression || TypeResolver.isNumericFunction(node);
    }

    static boolean isNumericFunction(PExpression node) {
        String name;
        if (!(node instanceof AFunctionExpression)) {
            return false;
        }
        PVariable functionName = ((AFunctionExpression)node).getName();
        return functionName instanceof ANameVariable && ("max".equals(name = ((ANameVariable)functionName).getWord().getText()) || "min".equals(name) || "abs".equals(name) || "subcount".equals(name));
    }
}

