/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.escape.SimpleEscapingFunction;

public class JsEscapeFunction
extends SimpleEscapingFunction {
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();
    private static final char[] ESCAPE_CHARS;
    private static final char[] UNQUOTED_ESCAPE_CHARS;

    public JsEscapeFunction(boolean isAttrUnquoted) {
        if (isAttrUnquoted) {
            super.setEscapeChars(UNQUOTED_ESCAPE_CHARS);
        } else {
            super.setEscapeChars(ESCAPE_CHARS);
        }
    }

    protected String getEscapeString(char c) {
        return "\\x" + DIGITS[c >> 4 & 0xF] + DIGITS[c & 0xF];
    }

    static {
        char[] SPECIAL_CHARS = new char[]{'/', '\"', '\'', '\\', '>', '<', '&', ';'};
        char[] UNQUOTED_SPECIAL_CHARS = new char[]{'/', '\"', '\'', '\\', '>', '<', '&', ';', '=', ' '};
        ESCAPE_CHARS = new char[32 + SPECIAL_CHARS.length];
        UNQUOTED_ESCAPE_CHARS = new char[33 + UNQUOTED_SPECIAL_CHARS.length];
        for (int n = 0; n < 32; ++n) {
            JsEscapeFunction.ESCAPE_CHARS[n] = (char)n;
            JsEscapeFunction.UNQUOTED_ESCAPE_CHARS[n] = (char)n;
        }
        System.arraycopy(SPECIAL_CHARS, 0, ESCAPE_CHARS, 32, SPECIAL_CHARS.length);
        JsEscapeFunction.UNQUOTED_ESCAPE_CHARS[32] = 127;
        System.arraycopy(UNQUOTED_SPECIAL_CHARS, 0, UNQUOTED_ESCAPE_CHARS, 33, UNQUOTED_SPECIAL_CHARS.length);
    }
}

