/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.exceptions;

import com.google.clearsilver.jsilver.exceptions.JSilverException;

public class JSilverBadSyntaxException
extends JSilverException {
    private final String resourceName;
    private final int line;
    private final int column;
    public static final int UNKNOWN_POSITION = -1;

    public JSilverBadSyntaxException(String message, String lineContent, String resourceName, int line, int column, Throwable cause) {
        super(JSilverBadSyntaxException.makeMessage(message, lineContent, resourceName, line, column), cause);
        this.resourceName = resourceName;
        this.line = line;
        this.column = column;
    }

    private static String makeMessage(String message, String lineContent, String resourceName, int line, int column) {
        StringBuilder result = new StringBuilder(message);
        if (resourceName != null) {
            result.append(" resource=").append(resourceName);
        }
        if (lineContent != null) {
            result.append(" content=").append(lineContent);
        }
        if (line != -1) {
            result.append(" line=").append(line);
        }
        if (column != -1) {
            result.append(" column=").append(column);
        }
        return result.toString();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

