/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;

public class TypeConverter {
    private static final String ZERO = "0";
    private static final String ONE = "1";

    private TypeConverter() {
    }

    public static boolean exists(Data data) {
        return data != null && data.getValue() != null;
    }

    public static String asString(Data data) {
        String value = data != null ? data.getValue() : null;
        return value != null ? value : "";
    }

    public static int parseNumber(String value) throws NumberFormatException {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        return Integer.parseInt(value);
    }

    public static int asNumber(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        if (value.equals(ONE)) {
            return 1;
        }
        if (value.equals(ZERO)) {
            return 0;
        }
        try {
            return TypeConverter.parseNumber(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int asNumber(Data data) {
        return data != null ? data.getIntValue() : 0;
    }

    public static boolean asBoolean(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (value.equals(ONE)) {
            return true;
        }
        if (value.equals(ZERO)) {
            return false;
        }
        if (value.charAt(0) != '0') {
            return true;
        }
        try {
            return TypeConverter.parseNumber(value) != 0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static boolean asBoolean(Data data) {
        return data != null ? data.getBooleanValue() : false;
    }
}

