/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.compiler.TemplateTranslator;
import com.google.clearsilver.jsilver.compiler.VariableTranslator;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAddExpression;
import com.google.clearsilver.jsilver.syntax.node.AAndExpression;
import com.google.clearsilver.jsilver.syntax.node.ADecimalExpression;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.ADivideExpression;
import com.google.clearsilver.jsilver.syntax.node.AEqExpression;
import com.google.clearsilver.jsilver.syntax.node.AExistsExpression;
import com.google.clearsilver.jsilver.syntax.node.AFunctionExpression;
import com.google.clearsilver.jsilver.syntax.node.AGtExpression;
import com.google.clearsilver.jsilver.syntax.node.AGteExpression;
import com.google.clearsilver.jsilver.syntax.node.AHexExpression;
import com.google.clearsilver.jsilver.syntax.node.ALtExpression;
import com.google.clearsilver.jsilver.syntax.node.ALteExpression;
import com.google.clearsilver.jsilver.syntax.node.AModuloExpression;
import com.google.clearsilver.jsilver.syntax.node.AMultiplyExpression;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.ANeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANegativeExpression;
import com.google.clearsilver.jsilver.syntax.node.ANotExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericAddExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericEqExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericExpression;
import com.google.clearsilver.jsilver.syntax.node.ANumericNeExpression;
import com.google.clearsilver.jsilver.syntax.node.AOrExpression;
import com.google.clearsilver.jsilver.syntax.node.AStringExpression;
import com.google.clearsilver.jsilver.syntax.node.ASubtractExpression;
import com.google.clearsilver.jsilver.syntax.node.AVariableExpression;
import com.google.clearsilver.jsilver.syntax.node.PExpression;
import java.util.LinkedList;

public class ExpressionTranslator
extends DepthFirstAdapter {
    private JavaExpression currentJavaExpression;

    public JavaExpression translateToString(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.STRING);
    }

    public JavaExpression translateToBoolean(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.BOOLEAN);
    }

    public JavaExpression translateToNumber(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.INT);
    }

    public JavaExpression translateToData(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.DATA);
    }

    public JavaExpression translateToVarName(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.VAR_NAME);
    }

    public JavaExpression translateToValue(PExpression csExpression) {
        return this.translateUntyped(csExpression).cast(JavaExpression.Type.VALUE);
    }

    public JavaExpression declareAsVariable(String name, PExpression csExpression) {
        JavaExpression expression = this.translateUntyped(csExpression);
        JavaExpression.Type type = expression.getType();
        assert (type != null) : "all subexpressions should be typed";
        return JavaExpression.declare(type, name, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaExpression translateUntyped(PExpression csExpression) {
        try {
            assert (this.currentJavaExpression == null) : "Not reentrant";
            csExpression.apply(this);
            assert (this.currentJavaExpression != null) : "No expression created";
            JavaExpression javaExpression = this.currentJavaExpression;
            return javaExpression;
        }
        finally {
            this.currentJavaExpression = null;
        }
    }

    private void setResult(JavaExpression javaExpression) {
        this.currentJavaExpression = javaExpression;
    }

    public void caseAVariableExpression(AVariableExpression node) {
        JavaExpression varName = new VariableTranslator(this).translate(node.getVariable());
        this.setResult(varName);
    }

    public void caseAStringExpression(AStringExpression node) {
        String value = node.getValue().getText();
        value = value.substring(1, value.length() - 1);
        this.setResult(JavaExpression.string(value));
    }

    public void caseADecimalExpression(ADecimalExpression node) {
        String value = node.getValue().getText();
        this.setResult(JavaExpression.integer(value));
    }

    public void caseAHexExpression(AHexExpression node) {
        String value = node.getValue().getText();
        this.setResult(JavaExpression.integer(value));
    }

    public void caseANumericExpression(ANumericExpression node) {
        this.setResult(this.cast(JavaExpression.Type.INT, node.getExpression()));
    }

    public void caseANotExpression(ANotExpression node) {
        this.setResult(this.prefix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.BOOLEAN, "!", node.getExpression()));
    }

    public void caseAExistsExpression(AExistsExpression node) {
        PExpression expression = node.getExpression();
        if (expression instanceof AVariableExpression) {
            expression.apply(this);
            if (this.currentJavaExpression.getType() == JavaExpression.Type.VAR_NAME) {
                this.currentJavaExpression = JavaExpression.callFindVariable(this.currentJavaExpression, false);
            }
            this.setResult(JavaExpression.call(JavaExpression.Type.BOOLEAN, "exists", this.currentJavaExpression));
        } else {
            this.setResult(JavaExpression.bool(true));
        }
    }

    public void caseAEqExpression(AEqExpression node) {
        JavaExpression left = this.cast(JavaExpression.Type.STRING, node.getLeft());
        JavaExpression right = this.cast(JavaExpression.Type.STRING, node.getRight());
        this.setResult(JavaExpression.callOn(JavaExpression.Type.BOOLEAN, left, "equals", right));
    }

    public void caseANumericEqExpression(ANumericEqExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, "==", node.getLeft(), node.getRight()));
    }

    public void caseANeExpression(ANeExpression node) {
        JavaExpression left = this.cast(JavaExpression.Type.STRING, node.getLeft());
        JavaExpression right = this.cast(JavaExpression.Type.STRING, node.getRight());
        this.setResult(JavaExpression.prefix(JavaExpression.Type.BOOLEAN, "!", JavaExpression.callOn(JavaExpression.Type.BOOLEAN, left, "equals", right)));
    }

    public void caseANumericNeExpression(ANumericNeExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, "!=", node.getLeft(), node.getRight()));
    }

    public void caseALtExpression(ALtExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, "<", node.getLeft(), node.getRight()));
    }

    public void caseAGtExpression(AGtExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, ">", node.getLeft(), node.getRight()));
    }

    public void caseALteExpression(ALteExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, "<=", node.getLeft(), node.getRight()));
    }

    public void caseAGteExpression(AGteExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.INT, ">=", node.getLeft(), node.getRight()));
    }

    public void caseAAndExpression(AAndExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.BOOLEAN, "&&", node.getLeft(), node.getRight()));
    }

    public void caseAOrExpression(AOrExpression node) {
        this.setResult(this.infix(JavaExpression.Type.BOOLEAN, JavaExpression.Type.BOOLEAN, "||", node.getLeft(), node.getRight()));
    }

    public void caseAAddExpression(AAddExpression node) {
        this.setResult(this.infix(JavaExpression.Type.STRING, JavaExpression.Type.STRING, "+", node.getLeft(), node.getRight()));
    }

    public void caseANumericAddExpression(ANumericAddExpression node) {
        this.setResult(this.infix(JavaExpression.Type.INT, JavaExpression.Type.INT, "+", node.getLeft(), node.getRight()));
    }

    public void caseASubtractExpression(ASubtractExpression node) {
        this.setResult(this.infix(JavaExpression.Type.INT, JavaExpression.Type.INT, "-", node.getLeft(), node.getRight()));
    }

    public void caseAMultiplyExpression(AMultiplyExpression node) {
        this.setResult(this.infix(JavaExpression.Type.INT, JavaExpression.Type.INT, "*", node.getLeft(), node.getRight()));
    }

    public void caseADivideExpression(ADivideExpression node) {
        this.setResult(this.infix(JavaExpression.Type.INT, JavaExpression.Type.INT, "/", node.getLeft(), node.getRight()));
    }

    public void caseAModuloExpression(AModuloExpression node) {
        this.setResult(this.infix(JavaExpression.Type.INT, JavaExpression.Type.INT, "%", node.getLeft(), node.getRight()));
    }

    public void caseANegativeExpression(ANegativeExpression node) {
        this.setResult(this.prefix(JavaExpression.Type.INT, JavaExpression.Type.INT, "-", node.getExpression()));
    }

    public void caseAFunctionExpression(AFunctionExpression node) {
        LinkedList<PExpression> argsList = node.getArgs();
        PExpression[] args = argsList.toArray(new PExpression[argsList.size()]);
        final StringBuilder fullFunctionName = new StringBuilder();
        node.getName().apply(new DepthFirstAdapter(){

            public void caseANameVariable(ANameVariable node11) {
                fullFunctionName.append(node11.getWord().getText());
            }

            public void caseADescendVariable(ADescendVariable node12) {
                node12.getParent().apply(this);
                fullFunctionName.append('.');
                node12.getChild().apply(this);
            }
        });
        this.setResult(this.function(fullFunctionName.toString(), args));
    }

    private JavaExpression function(String name, PExpression ... csExpressions) {
        JavaExpression[] args = new JavaExpression[1 + csExpressions.length];
        args[0] = JavaExpression.string(name);
        for (int i = 0; i < csExpressions.length; ++i) {
            args[i + 1] = this.cast(JavaExpression.Type.VALUE, csExpressions[i]);
        }
        return JavaExpression.callOn(JavaExpression.Type.VALUE, TemplateTranslator.CONTEXT, "executeFunction", args);
    }

    private JavaExpression infix(JavaExpression.Type destType, JavaExpression.Type srcType, String infix, PExpression leftNode, PExpression rightNode) {
        JavaExpression left = this.cast(srcType, leftNode);
        JavaExpression right = this.cast(srcType, rightNode);
        return JavaExpression.infix(destType, infix, left, right);
    }

    private JavaExpression prefix(JavaExpression.Type destType, JavaExpression.Type srcType, String prefix, PExpression node) {
        return JavaExpression.prefix(destType, prefix, this.cast(srcType, node));
    }

    private JavaExpression cast(JavaExpression.Type type, PExpression node) {
        node.apply(this);
        return this.currentJavaExpression.cast(type);
    }
}

