/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.html;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HtmlStripFunction
implements TextFilter {
    private static final int MAX_AMP_LENGTH = 9;
    private static final Map<String, String> entityValues;

    public void filter(String in, Appendable out) throws IOException {
        char[] inChars = in.toCharArray();
        StringBuilder amp = new StringBuilder();
        State state = State.DEFAULT;
        block9: for (int i = 0; i < inChars.length; ++i) {
            char c = inChars[i];
            switch (state) {
                case DEFAULT: {
                    switch (c) {
                        case '&': {
                            state = State.IN_AMP;
                            continue block9;
                        }
                        case '<': {
                            state = State.IN_TAG;
                            continue block9;
                        }
                    }
                    out.append(c);
                    continue block9;
                }
                case IN_TAG: {
                    if (c != '>') continue block9;
                    state = State.DEFAULT;
                    continue block9;
                }
                case IN_AMP: {
                    if (c == ';') {
                        state = State.DEFAULT;
                        this.appendDecodedEntityReference(out, amp);
                        amp = new StringBuilder();
                        continue block9;
                    }
                    if (amp.length() < 9) {
                        if (i != inChars.length - 1) {
                            amp.append(c);
                            continue block9;
                        }
                        out.append('&').append(amp).append(c);
                        continue block9;
                    }
                    out.append('&').append(amp).append(c);
                    amp = new StringBuilder();
                    state = State.DEFAULT;
                }
            }
        }
    }

    private void appendDecodedEntityReference(Appendable out, CharSequence entityName) throws IOException {
        if (entityName.length() < 2) {
            return;
        }
        if ((entityName = ((Object)entityName).toString().toLowerCase()).charAt(0) == '#') {
            this.appendNumberedEntity(out, entityName.subSequence(1, entityName.length()));
            return;
        }
        String entity = entityValues.get(entityName);
        if (entity != null) {
            out.append(entity);
        }
    }

    private void appendNumberedEntity(Appendable out, CharSequence entity) throws IOException {
        if (entity.length() != 0) {
            try {
                char c = entity.charAt(0) == 'x' ? (char)Integer.parseInt(((Object)entity.subSequence(1, entity.length())).toString(), 16) : (char)Integer.parseInt(((Object)entity).toString(), 10);
                if (c != '\u0000') {
                    out.append(c);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("amp", "&");
        tempMap.put("quot", "\"");
        tempMap.put("gt", ">");
        tempMap.put("lt", "<");
        tempMap.put("agrave", "\u00e0");
        tempMap.put("aacute", "\u00e1");
        tempMap.put("acirc", "\u00e2");
        tempMap.put("atilde", "\u00e3");
        tempMap.put("auml", "\u00e4");
        tempMap.put("aring", "\u00e5");
        tempMap.put("aelig", "\u00e6");
        tempMap.put("ccedil", "\u00e7");
        tempMap.put("egrave", "\u00e8");
        tempMap.put("eacute", "\u00e9");
        tempMap.put("ecirc", "\u00ea");
        tempMap.put("euml", "\u00eb");
        tempMap.put("eth", "\u00f0");
        tempMap.put("igrave", "\u00ec");
        tempMap.put("iacute", "\u00ed");
        tempMap.put("icirc", "\u00ee");
        tempMap.put("iuml", "\u00ef");
        tempMap.put("ntilde", "\u00f1");
        tempMap.put("nbsp", " ");
        tempMap.put("ograve", "\u00f2");
        tempMap.put("oacute", "\u00f3");
        tempMap.put("ocirc", "\u00f4");
        tempMap.put("otilde", "\u00f5");
        tempMap.put("ouml", "\u00f6");
        tempMap.put("oslash", "\u00f8");
        tempMap.put("szlig", "\u00df");
        tempMap.put("thorn", "\u00fe");
        tempMap.put("ugrave", "\u00f9");
        tempMap.put("uacute", "\u00fa");
        tempMap.put("ucirc", "\u00fb");
        tempMap.put("uuml", "\u00fc");
        tempMap.put("yacute", "\u00fd");
        tempMap.put("copy", "(C)");
        entityValues = Collections.unmodifiableMap(tempMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        DEFAULT,
        IN_AMP,
        IN_TAG;

    }
}

