/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AttrTagInfo;
import com.google.doclava.AttributeInfo;
import com.google.doclava.ConstructorInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.DocInfo;
import com.google.doclava.Doclava;
import com.google.doclava.Errors;
import com.google.doclava.FederatedSite;
import com.google.doclava.FieldInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.Project;
import com.google.doclava.Scoped;
import com.google.doclava.SinceTagger;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TypeInfo;
import com.sun.javadoc.ClassDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends DocInfo
implements ContainerInfo,
Comparable<ClassInfo>,
Scoped {
    public static final Ordering<ClassInfo> ORDER_BY_NAME = new Ordering<ClassInfo>(){

        @Override
        public int compare(ClassInfo a, ClassInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    private ClassDoc mClass;
    private boolean mIsPublic;
    private boolean mIsProtected;
    private boolean mIsPackagePrivate;
    private boolean mIsPrivate;
    private boolean mIsStatic;
    private boolean mIsInterface;
    private boolean mIsAbstract;
    private boolean mIsOrdinaryClass;
    private boolean mIsException;
    private boolean mIsError;
    private boolean mIsEnum;
    private boolean mIsAnnotation;
    private boolean mIsFinal;
    private boolean mIsIncluded;
    private String mName;
    private String mQualifiedName;
    private TypeInfo mTypeInfo;
    private String[] mNameParts;
    private List<ClassInfo> mRealInterfaces = new ArrayList<ClassInfo>();
    private List<ClassInfo> mInterfaces;
    private List<TypeInfo> mRealInterfaceTypes;
    private List<ClassInfo> mInnerClasses;
    private List<MethodInfo> mAllConstructors;
    private List<MethodInfo> mAllSelfMethods = new ArrayList<MethodInfo>();
    private List<MethodInfo> mAnnotationElements;
    private List<FieldInfo> mAllSelfFields = new ArrayList<FieldInfo>();
    private List<FieldInfo> mEnumConstants;
    private PackageInfo mContainingPackage;
    private ClassInfo mContainingClass;
    private ClassInfo mRealSuperclass;
    private TypeInfo mRealSuperclassType;
    private ClassInfo mSuperclass;
    private AnnotationInstanceInfo[] mAnnotations;
    private boolean mSuperclassInit;
    private ImmutableList<MethodInfo> mConstructors;
    private List<ClassInfo> mRealInnerClasses;
    private ImmutableList<MethodInfo> mSelfMethods;
    private ImmutableList<FieldInfo> mSelfFields;
    private List<AttributeInfo> mSelfAttributes;
    private List<MethodInfo> mHiddenMethods;
    private int mHidden = -1;
    private int mCheckLevel = -1;
    private ImmutableList<MethodInfo> mNonWrittenConstructors;
    private boolean mIsDeprecated;
    private HashMap<String, MethodInfo> mApiCheckMethods = new HashMap();
    private HashMap<String, FieldInfo> mApiCheckFields = new HashMap();
    private HashMap<String, ConstructorInfo> mApiCheckConstructors = new HashMap();

    public ClassInfo(String qualifiedName) {
        super("", SourcePositionInfo.UNKNOWN);
        this.mQualifiedName = qualifiedName;
        int pos = qualifiedName.lastIndexOf(46);
        this.mName = pos != -1 ? qualifiedName.substring(pos + 1) : qualifiedName;
    }

    public ClassInfo(ClassDoc cl, String rawCommentText, SourcePositionInfo position, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isStatic, boolean isInterface, boolean isAbstract, boolean isOrdinaryClass, boolean isException, boolean isError, boolean isEnum, boolean isAnnotation, boolean isFinal, boolean isIncluded, String name, String qualifiedName) {
        super(rawCommentText, position);
        this.mClass = cl;
        this.mIsPublic = isPublic;
        this.mIsProtected = isProtected;
        this.mIsPackagePrivate = isPackagePrivate;
        this.mIsPrivate = isPrivate;
        this.mIsStatic = isStatic;
        this.mIsInterface = isInterface;
        this.mIsAbstract = isAbstract;
        this.mIsOrdinaryClass = isOrdinaryClass;
        this.mIsException = isException;
        this.mIsError = isError;
        this.mIsEnum = isEnum;
        this.mIsAnnotation = isAnnotation;
        this.mIsFinal = isFinal;
        this.mIsIncluded = isIncluded;
        this.mName = name;
        this.mQualifiedName = qualifiedName;
        this.mNameParts = name.split("\\.");
    }

    public void init(TypeInfo typeInfo, List<ClassInfo> interfaces, List<TypeInfo> interfaceTypes, List<ClassInfo> innerClasses, List<MethodInfo> allConstructors, List<MethodInfo> methods, List<MethodInfo> annotationElements, List<FieldInfo> fields, List<FieldInfo> enumConstants, PackageInfo containingPackage, ClassInfo containingClass, ClassInfo superclass, TypeInfo superclassType, AnnotationInstanceInfo[] annotations, List<ClassInfo> realInnerClasses) {
        this.mTypeInfo = typeInfo;
        this.mRealInterfaces.addAll(interfaces);
        this.mRealInterfaceTypes = interfaceTypes;
        this.mInnerClasses = innerClasses;
        this.mAllConstructors = allConstructors;
        this.mAllSelfMethods = methods;
        this.mAnnotationElements = annotationElements;
        this.mAllSelfFields = fields;
        this.mEnumConstants = enumConstants;
        this.mContainingPackage = containingPackage;
        this.mContainingClass = containingClass;
        this.mRealSuperclass = superclass;
        this.mRealSuperclassType = superclassType;
        this.mAnnotations = annotations;
        this.mRealInnerClasses = realInnerClasses;
        this.mSuperclassInit = false;
        this.mConstructors = null;
        this.mSelfMethods = null;
        this.mSelfFields = null;
        this.mSelfAttributes = null;
        this.mIsDeprecated = false;
        Collections.sort(this.mEnumConstants, FieldInfo.ORDER_BY_NAME);
        Collections.sort(this.mInnerClasses, ORDER_BY_NAME);
    }

    public List<ClassInfo> getRealInnerClasses() {
        return this.mRealInnerClasses;
    }

    @Override
    public boolean checkLevel() {
        int val = this.mCheckLevel;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = Doclava.checkLevel(this.mIsPublic, this.mIsProtected, this.mIsPackagePrivate, this.mIsPrivate, this.isHidden());
        this.mCheckLevel = v ? 1 : 0;
        return v;
    }

    @Override
    public int compareTo(ClassInfo other) {
        return this.mQualifiedName.compareTo(other.mQualifiedName);
    }

    @Override
    public ContainerInfo parent() {
        return this;
    }

    @Override
    public boolean isPublic() {
        return this.mIsPublic;
    }

    @Override
    public boolean isProtected() {
        return this.mIsProtected;
    }

    @Override
    public boolean isPackagePrivate() {
        return this.mIsPackagePrivate;
    }

    @Override
    public boolean isPrivate() {
        return this.mIsPrivate;
    }

    public boolean isStatic() {
        return this.mIsStatic;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public PackageInfo containingPackage() {
        return this.mContainingPackage;
    }

    public ClassInfo containingClass() {
        return this.mContainingClass;
    }

    public boolean isOrdinaryClass() {
        return this.mIsOrdinaryClass;
    }

    public boolean isException() {
        return this.mIsException;
    }

    public boolean isError() {
        return this.mIsError;
    }

    public boolean isEnum() {
        return this.mIsEnum;
    }

    public boolean isAnnotation() {
        return this.mIsAnnotation;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    @Override
    public boolean isDefinedLocally() {
        return this.mIsIncluded;
    }

    public void addAllTypes(Set<ClassInfo> out) {
        if (!out.add(this)) {
            return;
        }
        if (this.mRealSuperclass != null) {
            this.mRealSuperclass.addAllTypes(out);
        }
        if (this.mSuperclass != null) {
            this.mSuperclass.addAllTypes(out);
        }
        for (ClassInfo i : this.mRealInterfaces) {
            i.addAllTypes(out);
        }
    }

    public List<ClassInfo> getInterfaces() {
        this.checkInitVisibleCalled();
        return this.mInterfaces;
    }

    public List<ClassInfo> realInterfaces() {
        return this.mRealInterfaces;
    }

    List<TypeInfo> realInterfaceTypes() {
        return this.mRealInterfaceTypes;
    }

    public String name() {
        return this.mName;
    }

    public String[] nameParts() {
        return this.mNameParts;
    }

    public String leafName() {
        return this.mNameParts[this.mNameParts.length - 1];
    }

    @Override
    public String qualifiedName() {
        return this.mQualifiedName;
    }

    public List<MethodInfo> allConstructors() {
        return this.mAllConstructors;
    }

    @Override
    public void initVisible(Project project) {
        super.initVisible(project);
        ArrayList<ClassInfo> nonHiddenInterfaces = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.mRealInterfaces) {
            if (!classInfo.checkLevel()) continue;
            nonHiddenInterfaces.add(classInfo);
        }
        Collections.sort(nonHiddenInterfaces);
        this.mInterfaces = ImmutableList.copyOf(nonHiddenInterfaces);
        if (this.mAllConstructors != null) {
            ArrayList<MethodInfo> nonHiddenConstructors = new ArrayList<MethodInfo>();
            ArrayList<MethodInfo> nonWrittenConstructors = new ArrayList<MethodInfo>();
            for (MethodInfo m : this.mAllConstructors) {
                if (m.checkLevel()) {
                    nonHiddenConstructors.add(m);
                    continue;
                }
                nonWrittenConstructors.add(m);
            }
            Collections.sort(nonHiddenConstructors, MethodInfo.ORDER_BY_NAME_AND_SIGNATURE);
            this.mConstructors = ImmutableList.copyOf(nonHiddenConstructors);
            Collections.sort(nonWrittenConstructors, MethodInfo.ORDER_BY_NAME_AND_SIGNATURE);
            this.mNonWrittenConstructors = ImmutableList.copyOf(nonWrittenConstructors);
        }
        if (this.mAllSelfMethods != null) {
            HashMap<String, MethodInfo> methods = new HashMap<String, MethodInfo>();
            HashMap<String, MethodInfo> hiddenMethods = new HashMap<String, MethodInfo>();
            HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
            this.gatherMethods(this, methods, hiddenMethods);
            this.gatherFields(this, fields);
            ClassInfo s = this.mRealSuperclass;
            while (s != null) {
                if (!s.checkLevel()) {
                    s.gatherMethods(this, methods, hiddenMethods);
                    s.gatherFields(this, fields);
                }
                s = s.mRealSuperclass;
            }
            for (ClassInfo ifc : this.mRealInterfaces) {
                if (ifc.checkLevel()) continue;
                ifc.gatherMethods(this, methods, hiddenMethods);
                ifc.gatherFields(this, fields);
            }
            this.mSelfMethods = ImmutableList.copyOf(MethodInfo.ORDER_BY_NAME_AND_SIGNATURE.sortedCopy(methods.values()));
            this.mHiddenMethods = ImmutableList.copyOf(MethodInfo.ORDER_BY_NAME_AND_SIGNATURE.sortedCopy(hiddenMethods.values()));
            this.mSelfFields = ImmutableList.copyOf(FieldInfo.ORDER_BY_NAME.sortedCopy(fields.values()));
        }
        boolean commentDeprecated = this.comment().isDeprecated();
        boolean annotationDeprecated = false;
        if (this.annotations() != null) {
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Class " + this.qualifiedName() + ": @Deprecated annotation and @deprecated comment do not match");
            }
        }
        this.mIsDeprecated = commentDeprecated | annotationDeprecated;
        if (this.mAllConstructors != null) {
            this.selfAttributes();
        }
    }

    public List<MethodInfo> getConstructors() {
        this.checkInitVisibleCalled();
        return this.mConstructors;
    }

    private void checkInitVisibleCalled() {
        if (this.mInterfaces == null) {
            throw new IllegalStateException("Expected initVisible() to be called first; " + this.qualifiedName());
        }
    }

    public List<ClassInfo> innerClasses() {
        return this.mInnerClasses;
    }

    public List<TagInfo> inlineTags() {
        return this.comment().tags();
    }

    public List<TagInfo> firstSentenceTags() {
        return this.comment().briefTags();
    }

    public boolean isDeprecated() {
        return this.mIsDeprecated;
    }

    public List<TagInfo> deprecatedTags() {
        return this.comment().deprecatedTags();
    }

    public List<MethodInfo> annotationElements() {
        return this.mAnnotationElements;
    }

    public AnnotationInstanceInfo[] annotations() {
        return this.mAnnotations;
    }

    public List<FieldInfo> allSelfFields() {
        return this.mAllSelfFields;
    }

    private void gatherMethods(ClassInfo owner, Map<String, MethodInfo> methods, Map<String, MethodInfo> hiddenMethods) {
        for (MethodInfo methodInfo : this.mAllSelfMethods) {
            String hashableName;
            Map<String, MethodInfo> map = methodInfo.checkLevel() ? methods : hiddenMethods;
            if (map.containsKey(hashableName = methodInfo.getHashableName())) continue;
            map.put(hashableName, methodInfo.cloneForClass(owner));
        }
    }

    public void gatherFields(ClassInfo owner, Map<String, FieldInfo> out) {
        for (FieldInfo fieldInfo : this.mAllSelfFields) {
            if (!fieldInfo.checkLevel() || out.containsKey(fieldInfo.name())) continue;
            out.put(fieldInfo.name(), fieldInfo.cloneForClass(owner));
        }
    }

    public List<FieldInfo> getFields() {
        this.checkInitVisibleCalled();
        return this.mSelfFields;
    }

    public ImmutableList<MethodInfo> getMethods() {
        this.checkInitVisibleCalled();
        return this.mSelfMethods;
    }

    public List<MethodInfo> allSelfMethods() {
        return this.mAllSelfMethods;
    }

    public void addMethod(MethodInfo method) {
        this.mApiCheckMethods.put(method.getHashableName(), method);
        this.mAllSelfMethods.add(method);
    }

    public void setContainingPackage(PackageInfo pkg) {
        this.mContainingPackage = pkg;
    }

    public List<AttributeInfo> selfAttributes() {
        if (this.mSelfAttributes == null) {
            AttributeInfo attr;
            FieldInfo field;
            TreeMap<FieldInfo, AttributeInfo> attrs = new TreeMap<FieldInfo, AttributeInfo>();
            for (AttrTagInfo tag : this.comment().attrTags()) {
                FieldInfo field2 = tag.reference();
                if (field2 == null) continue;
                AttributeInfo attr2 = (AttributeInfo)attrs.get(field2);
                if (attr2 == null) {
                    attr2 = new AttributeInfo(this, field2);
                    attrs.put(field2, attr2);
                }
                tag.setAttribute(attr2);
            }
            for (MethodInfo m : this.getMethods()) {
                for (AttrTagInfo tag : m.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(m);
                }
            }
            for (MethodInfo m : this.getConstructors()) {
                for (AttrTagInfo tag : m.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(m);
                }
            }
            this.mSelfAttributes = new ArrayList(attrs.values());
            Collections.sort(this.mSelfAttributes, AttributeInfo.comparator);
        }
        return this.mSelfAttributes;
    }

    public List<FieldInfo> enumConstants() {
        return this.mEnumConstants;
    }

    public ClassInfo superclass() {
        if (!this.mSuperclassInit) {
            if (this.checkLevel()) {
                ClassInfo superclass = this.mRealSuperclass;
                while (superclass != null && !superclass.checkLevel()) {
                    superclass = superclass.mRealSuperclass;
                }
                this.mSuperclass = superclass;
            } else {
                this.mSuperclass = this.mRealSuperclass;
            }
        }
        return this.mSuperclass;
    }

    public ClassInfo realSuperclass() {
        return this.mRealSuperclass;
    }

    public TypeInfo superclassType() {
        return this.mRealSuperclassType;
    }

    public TypeInfo asTypeInfo() {
        return this.mTypeInfo;
    }

    List<TypeInfo> interfaceTypes() {
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
        for (ClassInfo classInfo : this.getInterfaces()) {
            types.add(classInfo.asTypeInfo());
        }
        return types;
    }

    @Override
    public String relativePath() {
        String s = this.containingPackage().name();
        s = s.replace('.', '/');
        s = s + '/';
        s = s + this.name();
        s = s + ".html";
        return s;
    }

    public boolean isDerivedFrom(ClassInfo cl) {
        ClassInfo dad = this.superclass();
        if (dad != null) {
            if (dad.equals(cl)) {
                return true;
            }
            if (dad.isDerivedFrom(cl)) {
                return true;
            }
        }
        for (ClassInfo iface : this.getInterfaces()) {
            if (iface.equals(cl)) {
                return true;
            }
            if (!iface.isDerivedFrom(cl)) continue;
            return true;
        }
        return false;
    }

    public static void makeLinkListHDF(Data data, String base, List<ClassInfo> classes) {
        int i = 0;
        for (ClassInfo cl : classes) {
            if (cl.checkLevel()) {
                cl.asTypeInfo().makeHDF(data, base + "." + i);
            }
            ++i;
        }
    }

    public void makeShortDescrHDF(Data data, String base) {
        this.mTypeInfo.makeHDF(data, base + ".type");
        data.setValue(base + ".kind", this.kind());
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
        this.setFederatedReferences(data, base);
    }

    public void makeHDF(Data data, Iterable<ClassInfo> rootClasses) {
        ClassInfo cl2;
        int i;
        ClassInfo supr;
        String kind;
        String name = this.name();
        String qualified = this.qualifiedName();
        this.mTypeInfo.makeHDF(data, "class.type");
        this.mTypeInfo.makeQualifiedHDF(data, "class.qualifiedType");
        data.setValue("class.name", name);
        data.setValue("class.qualified", qualified);
        if (this.isProtected()) {
            data.setValue("class.scope", "protected");
        } else if (this.isPublic()) {
            data.setValue("class.scope", "public");
        }
        if (this.isStatic()) {
            data.setValue("class.static", "static");
        }
        if (this.isFinal()) {
            data.setValue("class.final", "final");
        }
        if (this.isAbstract() && !this.isInterface()) {
            data.setValue("class.abstract", "abstract");
        }
        if ((kind = this.kind()) != null) {
            data.setValue("class.kind", kind);
        }
        data.setValue("class.since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue("class.since.name", this.getSince());
        this.setFederatedReferences(data, "class");
        this.containingPackage().makeClassLinkListHDF(data, "class.package");
        ArrayList<ClassInfo> superClasses = new ArrayList<ClassInfo>();
        superClasses.add(this);
        for (supr = this.superclass(); supr != null; supr = supr.superclass()) {
            superClasses.add(supr);
        }
        int n = superClasses.size();
        for (i = 0; i < n; ++i) {
            supr = (ClassInfo)superClasses.get(n - i - 1);
            supr.asTypeInfo().makeQualifiedHDF(data, "class.inheritance." + i + ".class");
            supr.asTypeInfo().makeHDF(data, "class.inheritance." + i + ".short_class");
            int j = 0;
            for (TypeInfo t : supr.interfaceTypes()) {
                t.makeHDF(data, "class.inheritance." + i + ".interfaces." + j);
                ++j;
            }
        }
        TagInfo.makeHDF(data, "class.descr", this.inlineTags());
        TagInfo.makeHDF(data, "class.seeAlso", this.comment().seeTags());
        TagInfo.makeHDF(data, "class.deprecated", this.deprecatedTags());
        TreeMap<String, ClassInfo> direct = new TreeMap<String, ClassInfo>();
        TreeMap<String, ClassInfo> indirect = new TreeMap<String, ClassInfo>();
        for (ClassInfo cl2 : rootClasses) {
            if (cl2.superclass() != null && cl2.superclass().equals(this)) {
                direct.put(cl2.name(), cl2);
                continue;
            }
            if (!cl2.isDerivedFrom(this)) continue;
            indirect.put(cl2.name(), cl2);
        }
        i = 0;
        for (ClassInfo cl2 : direct.values()) {
            if (cl2.checkLevel()) {
                cl2.makeShortDescrHDF(data, "class.subclasses.direct." + i);
            }
            ++i;
        }
        i = 0;
        for (ClassInfo cl2 : indirect.values()) {
            if (cl2.checkLevel()) {
                cl2.makeShortDescrHDF(data, "class.subclasses.indirect." + i);
            }
            ++i;
        }
        if ("java.lang.Object".equals(qualified) || "java.io.Serializable".equals(qualified)) {
            data.setValue("class.subclasses.hidden", "1");
        } else {
            data.setValue("class.subclasses.hidden", "0");
        }
        i = 0;
        for (ClassInfo inner : this.innerClasses()) {
            if (inner.checkLevel()) {
                inner.makeShortDescrHDF(data, "class.inners." + i);
            }
            ++i;
        }
        i = 0;
        for (FieldInfo field : this.enumConstants()) {
            if (!field.isConstant()) continue;
            field.makeHDF(data, "class.enumConstants." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo field : this.getFields()) {
            if (!field.isConstant()) continue;
            field.makeHDF(data, "class.constants." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo field : this.getFields()) {
            if (field.isConstant()) continue;
            field.makeHDF(data, "class.fields." + i);
            ++i;
        }
        i = 0;
        for (MethodInfo ctor : this.getConstructors()) {
            if (!ctor.isPublic()) continue;
            ctor.makeHDF(data, "class.ctors.public." + i);
            ++i;
        }
        if (Doclava.checkLevel(3)) {
            i = 0;
            for (MethodInfo ctor : this.getConstructors()) {
                if (!ctor.isProtected()) continue;
                ctor.makeHDF(data, "class.ctors.protected." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(7)) {
            i = 0;
            for (MethodInfo ctor : this.getConstructors()) {
                if (!ctor.isPackagePrivate()) continue;
                ctor.makeHDF(data, "class.ctors.package." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(15)) {
            i = 0;
            for (MethodInfo ctor : this.getConstructors()) {
                if (!ctor.isPrivate()) continue;
                ctor.makeHDF(data, "class.ctors.private." + i);
                ++i;
            }
        }
        i = 0;
        for (MethodInfo method : this.getMethods()) {
            if (!method.isPublic()) continue;
            method.makeHDF(data, "class.methods.public." + i);
            ++i;
        }
        if (Doclava.checkLevel(3)) {
            i = 0;
            for (MethodInfo method : this.getMethods()) {
                if (!method.isProtected()) continue;
                method.makeHDF(data, "class.methods.protected." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(7)) {
            i = 0;
            for (MethodInfo method : this.getMethods()) {
                if (!method.isPackagePrivate()) continue;
                method.makeHDF(data, "class.methods.package." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(15)) {
            i = 0;
            for (MethodInfo method : this.getMethods()) {
                if (!method.isPrivate()) continue;
                method.makeHDF(data, "class.methods.private." + i);
                ++i;
            }
        }
        i = 0;
        for (AttributeInfo attr : this.selfAttributes()) {
            if (!attr.checkLevel()) continue;
            attr.makeHDF(data, "class.attrs." + i);
            ++i;
        }
        TreeSet<ClassInfo> interfaces = new TreeSet<ClassInfo>();
        ClassInfo.addInterfaces(this.getInterfaces(), interfaces);
        cl2 = this.superclass();
        i = 0;
        while (cl2 != null) {
            ClassInfo.addInterfaces(cl2.getInterfaces(), interfaces);
            ClassInfo.makeInheritedHDF(data, i, cl2);
            cl2 = cl2.superclass();
            ++i;
        }
        for (ClassInfo iface : interfaces) {
            ClassInfo.makeInheritedHDF(data, i, iface);
            ++i;
        }
    }

    private static void addInterfaces(List<ClassInfo> ifaces, Set<ClassInfo> out) {
        for (ClassInfo cl : ifaces) {
            out.add(cl);
            ClassInfo.addInterfaces(cl.getInterfaces(), out);
        }
    }

    private static void makeInheritedHDF(Data data, int index, ClassInfo cl) {
        String kind;
        String base = "class.inherited." + index;
        data.setValue(base + ".qualified", cl.qualifiedName());
        if (cl.checkLevel()) {
            data.setValue(base + ".link", cl.htmlPage());
        }
        if ((kind = cl.kind()) != null) {
            data.setValue(base + ".kind", kind);
        }
        if (cl.isDefinedLocally()) {
            data.setValue(base + ".included", "true");
        } else {
            Doclava.federationTagger.tagAll(ImmutableList.of(cl));
            if (!cl.getFederatedReferences().isEmpty()) {
                FederatedSite site = cl.getFederatedReferences().iterator().next();
                data.setValue(base + ".link", site.linkFor(cl.relativePath()));
                data.setValue(base + ".federated", site.name());
            }
        }
        int i = 0;
        for (AttributeInfo attr : cl.selfAttributes()) {
            attr.makeHDF(data, base + ".attrs." + i);
            ++i;
        }
        i = 0;
        for (MethodInfo method : cl.getMethods()) {
            method.makeHDF(data, base + ".methods." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo field : cl.getFields()) {
            if (field.isConstant()) continue;
            field.makeHDF(data, base + ".fields." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo field : cl.getFields()) {
            if (!field.isConstant()) continue;
            field.makeHDF(data, base + ".constants." + i);
            ++i;
        }
    }

    @Override
    public boolean isHidden() {
        int val = this.mHidden;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = this.isHiddenImpl();
        this.mHidden = v ? 1 : 0;
        return v;
    }

    public boolean isHiddenImpl() {
        for (ClassInfo cl = this; cl != null; cl = cl.containingClass()) {
            PackageInfo pkg = cl.containingPackage();
            if (pkg != null && pkg.isHidden()) {
                return true;
            }
            if (!cl.comment().isHidden()) continue;
            return true;
        }
        return false;
    }

    private MethodInfo matchMethod(List<MethodInfo> methods, String name, String[] params, String[] dimensions, boolean varargs) {
        for (MethodInfo method : methods) {
            if (!method.name().equals(name)) continue;
            if (params == null) {
                return method;
            }
            if (!method.matchesParams(params, dimensions, varargs)) continue;
            return method;
        }
        return null;
    }

    public MethodInfo findMethod(String name, String[] params, String[] dimensions, boolean varargs) {
        MethodInfo rv;
        if (this.mAllSelfMethods != null && (rv = this.matchMethod(this.mAllSelfMethods, name, params, dimensions, varargs)) != null) {
            return rv;
        }
        if (this.mAllConstructors != null && (rv = this.matchMethod(this.mAllConstructors, name, params, dimensions, varargs)) != null) {
            return rv;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findMethod(name, params, dimensions, varargs);
        }
        return null;
    }

    public boolean containsMethod(MethodInfo method) {
        for (MethodInfo m : this.getMethods()) {
            if (!m.getHashableName().equals(method.getHashableName())) continue;
            return true;
        }
        return false;
    }

    private ClassInfo searchInnerClasses(String[] nameParts, int index) {
        String part = nameParts[index];
        for (ClassInfo in : this.mInnerClasses) {
            String[] innerParts = in.nameParts();
            if (!part.equals(innerParts[innerParts.length - 1])) continue;
            if (index == nameParts.length - 1) {
                return in;
            }
            return in.searchInnerClasses(nameParts, index + 1);
        }
        return null;
    }

    public ClassInfo extendedFindClass(String className) {
        return this.searchInnerClasses(className.split("\\."), 0);
    }

    public ClassInfo findClass(String className, Project project) {
        return project.getClassReference(this.mClass.findClass(className));
    }

    public ClassInfo findInnerClass(String className, Project project) {
        String[] nodes = className.split("\\.");
        ClassDoc cl = this.mClass;
        for (String n : nodes) {
            if ((cl = cl.findClass(n)) != null) continue;
            return null;
        }
        return project.getClassReference(cl);
    }

    public FieldInfo findField(String name) {
        for (FieldInfo f : this.mAllSelfFields) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        for (FieldInfo f : this.mEnumConstants) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findField(name);
        }
        return null;
    }

    public boolean equals(ClassInfo that) {
        if (that != null) {
            return this.qualifiedName().equals(that.qualifiedName());
        }
        return false;
    }

    public List<MethodInfo> getNonWrittenConstructors() {
        this.checkInitVisibleCalled();
        return this.mNonWrittenConstructors;
    }

    public String kind() {
        if (this.isOrdinaryClass()) {
            return "class";
        }
        if (this.isInterface()) {
            return "interface";
        }
        if (this.isEnum()) {
            return "enum";
        }
        if (this.isError()) {
            return "class";
        }
        if (this.isException()) {
            return "class";
        }
        if (this.isAnnotation()) {
            return "@interface";
        }
        return null;
    }

    public String scope() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isProtected()) {
            return "protected";
        }
        if (this.isPackagePrivate()) {
            return "";
        }
        if (this.isPrivate()) {
            return "private";
        }
        throw new RuntimeException("invalid scope for object " + this);
    }

    public List<MethodInfo> getHiddenMethods() {
        this.checkInitVisibleCalled();
        return this.mHiddenMethods;
    }

    public String toString() {
        return this.qualifiedName();
    }

    private boolean implementsInterface(ClassInfo cl, String iface) {
        if (cl.qualifiedName().equals(iface)) {
            return true;
        }
        for (ClassInfo clImplements : cl.getInterfaces()) {
            if (!this.implementsInterface(clImplements, iface)) continue;
            return true;
        }
        return cl.mSuperclass != null && this.implementsInterface(cl.mSuperclass, iface);
    }

    public void addInterface(ClassInfo iface) {
        this.mRealInterfaces.add(iface);
    }

    public void addConstructor(ConstructorInfo cInfo) {
        this.mApiCheckConstructors.put(cInfo.getHashableName(), cInfo);
    }

    public void addField(FieldInfo fInfo) {
        this.mApiCheckFields.put(fInfo.name(), fInfo);
    }

    public void setSuperClass(ClassInfo superclass) {
        this.mSuperclass = superclass;
    }

    public Map<String, FieldInfo> allFields() {
        return this.mApiCheckFields;
    }

    public Map<String, MethodInfo> allMethods() {
        return this.mApiCheckMethods;
    }

    public Iterable<ClassInfo> hierarchy() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>(4);
        ClassInfo c = this;
        while (c != null) {
            result.add(c);
            c = c.mSuperclass;
        }
        return result;
    }

    public String superclassName() {
        if (this.mSuperclass == null) {
            if (this.mQualifiedName.equals("java.lang.Object")) {
                return null;
            }
            throw new IllegalStateException("Superclass not set for " + this.qualifiedName());
        }
        return this.mSuperclass.mQualifiedName;
    }

    public void setAnnotations(AnnotationInstanceInfo[] annotations) {
        this.mAnnotations = annotations;
    }

    public boolean isConsistent(ClassInfo cl) {
        MethodInfo mi;
        boolean consistent = true;
        if (this.isInterface() != cl.isInterface()) {
            Errors.error(Errors.CHANGED_CLASS, cl.position(), "Class " + cl.qualifiedName() + " changed class/interface declaration");
            consistent = false;
        }
        for (ClassInfo classInfo : this.mRealInterfaces) {
            if (this.implementsInterface(cl, classInfo.mQualifiedName)) continue;
            Errors.error(Errors.REMOVED_INTERFACE, cl.position(), "Class " + this.qualifiedName() + " no longer implements " + classInfo);
        }
        for (ClassInfo classInfo : cl.mRealInterfaces) {
            if (this.implementsInterface(this, classInfo.mQualifiedName)) continue;
            Errors.error(Errors.ADDED_INTERFACE, cl.position(), "Added interface " + classInfo + " to class " + this.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : this.mApiCheckMethods.values()) {
            if (cl.mApiCheckMethods.containsKey(methodInfo.getHashableName())) {
                if (methodInfo.isConsistent(cl.mApiCheckMethods.get(methodInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            mi = ClassInfo.overriddenMethod(methodInfo, cl);
            if (mi == null) {
                mi = ClassInfo.interfaceMethod(methodInfo, cl);
            }
            if (mi != null) continue;
            Errors.error(Errors.REMOVED_METHOD, methodInfo.position(), "Removed public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : cl.mApiCheckMethods.values()) {
            if (this.mApiCheckMethods.containsKey(methodInfo.getHashableName()) || (mi = ClassInfo.overriddenMethod(methodInfo, this)) != null) continue;
            Errors.error(Errors.ADDED_METHOD, methodInfo.position(), "Added public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : this.mApiCheckConstructors.values()) {
            if (cl.mApiCheckConstructors.containsKey(constructorInfo.getHashableName())) {
                if (constructorInfo.isConsistent(cl.mApiCheckConstructors.get(constructorInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_METHOD, constructorInfo.position(), "Removed public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : cl.mApiCheckConstructors.values()) {
            if (this.mApiCheckConstructors.containsKey(constructorInfo.getHashableName())) continue;
            Errors.error(Errors.ADDED_METHOD, constructorInfo.position(), "Added public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (FieldInfo fieldInfo : this.mApiCheckFields.values()) {
            if (cl.mApiCheckFields.containsKey(fieldInfo.name())) {
                if (fieldInfo.isConsistent(cl.mApiCheckFields.get(fieldInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_FIELD, fieldInfo.position(), "Removed field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        for (FieldInfo fieldInfo : cl.mApiCheckFields.values()) {
            if (this.mApiCheckFields.containsKey(fieldInfo.name())) continue;
            Errors.error(Errors.ADDED_FIELD, fieldInfo.position(), "Added public field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        if (this.mIsAbstract != cl.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, cl.position(), "Class " + cl.qualifiedName() + " changed abstract qualifier");
        }
        if (this.mIsFinal != cl.mIsFinal) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, cl.position(), "Class " + cl.qualifiedName() + " changed final qualifier");
        }
        if (this.mIsStatic != cl.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, cl.position(), "Class " + cl.qualifiedName() + " changed static qualifier");
        }
        if (!this.scope().equals(cl.scope())) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, cl.position(), "Class " + cl.qualifiedName() + " scope changed from " + this.scope() + " to " + cl.scope());
        }
        if (!this.isDeprecated() == cl.isDeprecated()) {
            consistent = false;
            Errors.error(Errors.CHANGED_DEPRECATED, cl.position(), "Class " + cl.qualifiedName() + " has changed deprecation state");
        }
        if (this.superclassName() != null) {
            if (cl.superclassName() == null || !this.superclassName().equals(cl.superclassName())) {
                consistent = false;
                Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + this.superclassName() + " to " + cl.superclassName());
            }
        } else if (cl.superclassName() != null) {
            consistent = false;
            Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + "null to " + cl.superclassName());
        }
        return consistent;
    }

    public static MethodInfo overriddenMethod(MethodInfo candidate, ClassInfo newClassObj) {
        if (newClassObj == null) {
            return null;
        }
        for (MethodInfo mi : newClassObj.mApiCheckMethods.values()) {
            if (!mi.matches(candidate)) continue;
            return mi;
        }
        return ClassInfo.overriddenMethod(candidate, newClassObj.mSuperclass);
    }

    public static MethodInfo interfaceMethod(MethodInfo candidate, ClassInfo newClassObj) {
        if (newClassObj == null) {
            return null;
        }
        for (ClassInfo interfaceInfo : newClassObj.getInterfaces()) {
            for (MethodInfo mi : interfaceInfo.mApiCheckMethods.values()) {
                if (!mi.matches(candidate)) continue;
                return mi;
            }
        }
        return ClassInfo.interfaceMethod(candidate, newClassObj.mSuperclass);
    }

    public boolean hasConstructor(MethodInfo constructor) {
        String name = constructor.getHashableName();
        for (ConstructorInfo ctor : this.mApiCheckConstructors.values()) {
            if (!name.equals(ctor.getHashableName())) continue;
            return true;
        }
        return false;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.mTypeInfo = typeInfo;
    }
}

