/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.TypeConverter;
import java.io.IOException;

public abstract class AbstractData
implements Data {
    protected EscapeMode escapeMode = EscapeMode.ESCAPE_NONE;

    public int getIntValue() {
        return TypeConverter.asNumber(this.getValue());
    }

    public boolean getBooleanValue() {
        return TypeConverter.asBoolean(this.getValue());
    }

    public String getValue(String path, String defaultValue) {
        Data child = this.getChild(path);
        if (child == null) {
            return defaultValue;
        }
        String result = child.getValue();
        return result == null ? defaultValue : result;
    }

    public int getIntValue(String path, int defaultValue) {
        Data child = this.getChild(path);
        if (child == null) {
            return defaultValue;
        }
        String result = child.getValue();
        try {
            return result == null ? defaultValue : TypeConverter.parseNumber(result);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getValue(String path) {
        return this.getValue(path, null);
    }

    public int getIntValue(String path) {
        return TypeConverter.asNumber(this.getChild(path));
    }

    public boolean getBooleanValue(String path) {
        return TypeConverter.asBoolean(this.getChild(path));
    }

    public void setValue(String path, String value) {
        Data child = this.createChild(path);
        child.setValue(value);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder out, int indent) {
        try {
            this.write(out, indent);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void optimize() {
    }

    public void setEscapeMode(EscapeMode mode) {
        this.escapeMode = mode;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }
}

