/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import [Ljava.net.NetworkInterface;;
import com.sun.jini.config.Config;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.MultiIPDiscovery;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.DiscoveryPermission;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public class LookupDiscovery
implements DiscoveryManagement,
DiscoveryGroupManagement {
    private static final String COMPONENT_NAME = "net.jini.discovery.LookupDiscovery";
    private static final Logger logger = Logger.getLogger("net.jini.discovery.LookupDiscovery");
    public static final String[] ALL_GROUPS = DiscoveryGroupManagement.ALL_GROUPS;
    public static final String[] NO_GROUPS = DiscoveryGroupManagement.NO_GROUPS;
    private static final int MAX_N_TASKS = 15;
    private static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final int DEFAULT_MULTICAST_TTL = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private boolean terminated = false;
    private ArrayList listeners = new ArrayList(1);
    private Set groups = null;
    private Map registrars = new HashMap(11);
    private Set pendingDiscoveries = new HashSet(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private TaskManager taskManager;
    private WakeupManager discoveryWakeupMgr = null;
    private boolean isDefaultWakeupMgr = false;
    private List tickets;
    private AnnouncementListener announceeThread;
    private Collection requestors = new LinkedList();
    private ResponseListener respondeeThread = null;
    private final SecurityContext securityContext = Security.getContext();
    private HashMap regInfo = new HashMap(11);
    private AnnouncementTimerThread announcementTimerThread;
    private ProxyPreparer registrarPreparer;
    private Discovery protocol2 = Discovery.getProtocol2(null);
    private int multicastRequestMax = 7;
    private long multicastRequestInterval = 5000L;
    private long finalMulticastRequestInterval = 120000L;
    private String multicastRequestHost;
    private DiscoveryConstraints multicastRequestConstraints;
    private NetworkInterface[] nics;
    private int nicRetryInterval = 300000;
    private long multicastAnnouncementInterval = 120000L;
    private long unicastDelayRange = 0L;
    private long initialMulticastRequestDelayRange = 0L;
    private boolean initialRequestorStarted = false;
    private DiscoveryConstraints multicastAnnouncementConstraints;
    private InvocationConstraints rawUnicastDiscoveryConstraints;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;
    private static final int NICS_USE_ALL = 0;
    private static final int NICS_USE_SYS = 1;
    private static final int NICS_USE_LIST = 2;
    private static final int NICS_USE_NONE = 3;
    private int nicsToUse = 0;

    public LookupDiscovery(String[] groups) throws IOException {
        try {
            this.beginDiscovery(groups, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupDiscovery(String[] groups, Configuration config) throws IOException, ConfigurationException {
        this.beginDiscovery(groups, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener l) {
        if (l == null) {
            throw new NullPointerException("can't add null listener");
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.indexOf(l) >= 0) {
                return;
            }
            this.listeners.add(l);
            if (this.registrars.isEmpty()) {
                return;
            }
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iter = this.registrars.values().iterator();
            while (iter.hasNext()) {
                UnicastResponse resp = (UnicastResponse)iter.next();
                groupsMap.put(resp.getRegistrar(), resp.getGroups());
            }
            ArrayList<DiscoveryListener> list = new ArrayList<DiscoveryListener>(1);
            list.add(l);
            this.addNotify(list, groupsMap, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener l) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.registrars.isEmpty()) {
                return new ServiceRegistrar[0];
            }
            Iterator iter = this.registrars.values().iterator();
            ServiceRegistrar[] regs = new ServiceRegistrar[this.registrars.size()];
            int i = 0;
            while (iter.hasNext()) {
                regs[i] = ((UnicastResponse)iter.next()).getRegistrar();
                ++i;
            }
            return regs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar reg) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (reg == null) {
                return;
            }
            this.sendDiscarded(reg, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.nukeThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroups() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                return ALL_GROUPS;
            }
            if (this.groups.isEmpty()) {
                return NO_GROUPS;
            }
            return LookupDiscovery.collectionToStrings(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroups(String[] newGroups) throws IOException {
        this.testArrayForNullElement(newGroups);
        LookupDiscovery.checkGroups(newGroups);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't add to \"any groups\"");
            }
            ArrayList<String> req = new ArrayList<String>(newGroups.length);
            for (int i = 0; i < newGroups.length; ++i) {
                if (!this.groups.add(newGroups[i])) continue;
                req.add(newGroups[i]);
            }
            if (!req.isEmpty()) {
                this.requestGroups(req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(String[] newGroups) throws IOException {
        this.testArrayForNullElement(newGroups);
        LookupDiscovery.checkGroups(newGroups);
        boolean maybeDiscard = false;
        HashSet<String> newGrps = null;
        if (newGroups != null) {
            newGrps = new HashSet<String>(newGroups.length * 2);
            for (int i = 0; i < newGroups.length; ++i) {
                newGrps.add(newGroups[i]);
            }
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (newGroups == null) {
                if (this.groups != null) {
                    this.groups = null;
                    this.requestGroups(null);
                }
                return;
            }
            if (this.groups == null) {
                this.groups = new HashSet(11);
                maybeDiscard = true;
            }
            HashSet toAdd = new HashSet(newGrps);
            toAdd.removeAll(this.groups);
            HashSet toRemove = new HashSet(this.groups);
            toRemove.removeAll(newGrps);
            this.groups.addAll(toAdd);
            if (!toRemove.isEmpty()) {
                maybeDiscard |= this.removeGroupsInt(LookupDiscovery.collectionToStrings(toRemove));
            }
            if (!toAdd.isEmpty()) {
                this.requestGroups(toAdd);
            }
        }
        if (maybeDiscard) {
            this.maybeDiscardRegistrars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroups(String[] oldGroups) {
        boolean maybeDiscard;
        this.testArrayForNullElement(oldGroups);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't remove from \"any groups\"");
            }
            maybeDiscard = this.removeGroupsInt(oldGroups);
        }
        if (maybeDiscard) {
            this.maybeDiscardRegistrars();
        }
    }

    private void sendPacketByNIC(MulticastSocket mcSocket, DatagramPacket[] packet) throws InterruptedIOException {
        switch (this.nicsToUse) {
            case 0: {
                for (int i = 0; i < this.nics.length; ++i) {
                    LogRecord logRec;
                    try {
                        mcSocket.setNetworkInterface(this.nics[i]);
                        LookupDiscovery.sendPacket(mcSocket, packet);
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        logRec = new LogRecord(Levels.HANDLED, "network interface is bad or not configured for multicast: {0}");
                        logRec.setParameters(new Object[]{this.nics[i]});
                        logRec.setThrown(e);
                        logger.log(logRec);
                        continue;
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        logRec = new LogRecord(Levels.HANDLED, "exception while sending packet through network interface: {0}");
                        logRec.setParameters(new Object[]{this.nics[i]});
                        logRec.setThrown(e);
                        logger.log(logRec);
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.nics.length; ++i) {
                    LogRecord logRec;
                    try {
                        mcSocket.setNetworkInterface(this.nics[i]);
                        LookupDiscovery.sendPacket(mcSocket, packet);
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logRec = new LogRecord(Level.SEVERE, "network interface is bad or not configured for multicast: {0}");
                        logRec.setParameters(new Object[]{this.nics[i]});
                        logRec.setThrown(e);
                        logger.log(logRec);
                        continue;
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logRec = new LogRecord(Level.SEVERE, "exception while sending packet through network interface: {0}");
                        logRec.setParameters(new Object[]{this.nics[i]});
                        logRec.setThrown(e);
                        logger.log(logRec);
                    }
                }
                break;
            }
            case 1: {
                try {
                    LookupDiscovery.sendPacket(mcSocket, packet);
                    break;
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break;
                    logger.log(Level.SEVERE, "system default network interface is bad or not configured for multicast", e);
                    break;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.SEVERE)) break;
                    logger.log(Level.SEVERE, "exception while sending packet through system default network interface", e);
                    break;
                }
            }
            case 3: {
                break;
            }
            default: {
                throw new AssertionError((Object)("nicsToUse flag out of range (0-3): " + this.nicsToUse));
            }
        }
    }

    private static void sendPacket(MulticastSocket mcSocket, DatagramPacket[] packet) throws IOException {
        for (int i = 0; i < packet.length; ++i) {
            mcSocket.send(packet[i]);
        }
    }

    private static String getLocalHost() throws UnknownHostException {
        try {
            return ((InetAddress)Security.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost();
                }
            })).getHostAddress();
        }
        catch (PrivilegedActionException e) {
            InetAddress.getLocalHost();
            logger.log(Levels.FAILED, "Unknown host exception", e.getCause());
            throw new UnknownHostException("Host name cleared due to insufficient caller permissions");
        }
    }

    private static void checkGroups(String[] groups) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                sm.checkPermission(new DiscoveryPermission(groups[i]));
            }
        } else {
            sm.checkPermission(new DiscoveryPermission("*"));
        }
    }

    private static final String[] collectionToStrings(Collection c) {
        return c == null ? null : c.toArray(new String[c.size()]);
    }

    private static boolean groupSetsEqual(String[] groupSet0, String[] groupSet1) {
        if (groupSet0.length != groupSet1.length) {
            return false;
        }
        block0: for (int i = 0; i < groupSet0.length; ++i) {
            for (int j = 0; j < groupSet1.length; ++j) {
                if (groupSet0[i].equals(groupSet1[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean registrarsEqual(UnicastResponse resp1, UnicastResponse resp2) {
        return resp1 != null && resp2 != null && resp2.getRegistrar().equals(resp1.getRegistrar());
    }

    private boolean removeGroupsInt(String[] oldGroups) {
        boolean removed = false;
        for (int i = 0; i < oldGroups.length; ++i) {
            removed |= this.groups.remove(oldGroups[i]);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceID[] getServiceIDs() {
        Map map = this.registrars;
        synchronized (map) {
            return this.registrars.keySet().toArray(new ServiceID[this.registrars.size()]);
        }
    }

    private boolean groupsOverlap(String[] possibilities) {
        if (this.groups == null) {
            return true;
        }
        for (int i = 0; i < possibilities.length; ++i) {
            if (!this.groups.contains(possibilities[i])) continue;
            return true;
        }
        return false;
    }

    private void requestGroups(final Collection req) throws IOException {
        try {
            Security.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    Requestor t;
                    Collection collection = LookupDiscovery.this.requestors;
                    synchronized (collection) {
                        if (LookupDiscovery.this.respondeeThread == null) {
                            LookupDiscovery.this.respondeeThread = new ResponseListener();
                            LookupDiscovery.this.respondeeThread.start();
                        }
                        boolean delayFlag = false;
                        if (!LookupDiscovery.this.initialRequestorStarted) {
                            delayFlag = true;
                            LookupDiscovery.this.initialRequestorStarted = true;
                        }
                        t = new Requestor(LookupDiscovery.collectionToStrings(req), LookupDiscovery.this.respondeeThread.getPort(), delayFlag);
                        LookupDiscovery.this.requestors.add(t);
                    }
                    t.start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void prepareSocket(Socket s, DiscoveryConstraints dc) throws SocketException {
        try {
            s.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            s.setKeepAlive(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        s.setSoTimeout(dc.getUnicastSocketTimeout(60000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddNewRegistrar(UnicastResponse resp) {
        Map map = this.registrars;
        synchronized (map) {
            if (!this.groupsOverlap(resp.getGroups())) {
                return;
            }
        }
        try {
            final ServiceRegistrar srcReg = resp.getRegistrar();
            ServiceRegistrar prepReg = (ServiceRegistrar)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    Object proxy = LookupDiscovery.this.registrarPreparer.prepareProxy((Object)srcReg);
                    logger.log(Level.FINEST, "LookupDiscovery - prepared lookup service proxy: {0}", proxy);
                    return proxy;
                }
            }), this.securityContext.getAccessControlContext());
            if (prepReg != srcReg) {
                resp = new UnicastResponse(resp.getHost(), resp.getPort(), resp.getGroups(), prepReg);
            }
        }
        catch (Exception e) {
            Exception e1 = e instanceof PrivilegedActionException ? ((PrivilegedActionException)e).getException() : e;
            logger.log(Level.INFO, "exception while preparing lookup service proxy", e1);
            return;
        }
        map = this.registrars;
        synchronized (map) {
            if (this.groupsOverlap(resp.getGroups()) && !LookupDiscovery.registrarsEqual(resp, this.registrars.put(resp.getRegistrar().getServiceID(), resp))) {
                this.regInfo.put(resp.getRegistrar().getServiceID(), new AnnouncementInfo(System.currentTimeMillis(), -1L));
                if (!this.listeners.isEmpty()) {
                    this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(resp.getRegistrar(), resp.getGroups()), 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDiscardRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iter = this.registrars.values().iterator();
            while (iter.hasNext()) {
                UnicastResponse ent = (UnicastResponse)iter.next();
                if (this.groupsOverlap(ent.getGroups())) continue;
                groupsMap.put(ent.getRegistrar(), ent.getGroups());
                this.regInfo.remove(ent.getRegistrar().getServiceID());
                iter.remove();
            }
            if (!groupsMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(ArrayList notifies, Map groupsMap, int eventType) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(notifies, groupsMap, eventType));
            if (this.notifierThread == null) {
                Security.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        LookupDiscovery.this.notifierThread = new Notifier();
                        LookupDiscovery.this.notifierThread.start();
                        return null;
                    }
                });
            }
        }
    }

    private void nukeThreads() {
        Security.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object t;
                if (LookupDiscovery.this.announcementTimerThread != null) {
                    LookupDiscovery.this.announcementTimerThread.interrupt();
                }
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    Iterator iter = LookupDiscovery.this.requestors.iterator();
                    while (iter.hasNext()) {
                        t = (Thread)iter.next();
                        ((Thread)t).interrupt();
                    }
                    if (LookupDiscovery.this.respondeeThread != null) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                    }
                }
                if (LookupDiscovery.this.announceeThread != null) {
                    LookupDiscovery.this.announceeThread.interrupt();
                }
                collection = LookupDiscovery.this.pendingDiscoveries;
                synchronized (collection) {
                    LookupDiscovery.this.terminateTaskMgr();
                    Iterator i = LookupDiscovery.this.tickets.iterator();
                    while (i.hasNext()) {
                        t = (WakeupManager.Ticket)i.next();
                        i.remove();
                        LookupDiscovery.this.discoveryWakeupMgr.cancel((WakeupManager.Ticket)t);
                    }
                    if (LookupDiscovery.this.isDefaultWakeupMgr) {
                        LookupDiscovery.this.discoveryWakeupMgr.cancelAll();
                        LookupDiscovery.this.discoveryWakeupMgr.stop();
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateTaskMgr() {
        Object object = this.taskManager;
        synchronized (object) {
            ArrayList pendingTasks = this.taskManager.getPending();
            for (int i = 0; i < pendingTasks.size(); ++i) {
                this.taskManager.remove((TaskManager.Task)pendingTasks.get(i));
            }
            Set set = this.pendingDiscoveries;
            synchronized (set) {
                Iterator iter = this.pendingDiscoveries.iterator();
                while (iter.hasNext()) {
                    Object req = iter.next();
                    iter.remove();
                    if (!(req instanceof Socket)) continue;
                    try {
                        ((Socket)req).close();
                    }
                    catch (IOException e) {}
                }
            }
            this.taskManager.terminate();
        }
        object = this.pendingNotifies;
        synchronized (object) {
            this.pendingNotifies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSendEvent(UnicastResponse response, String[] newGroups) {
        ServiceRegistrar reg = response.getRegistrar();
        boolean getActual = true;
        if (newGroups == null) {
            newGroups = this.getActualGroups(reg);
            if (newGroups == null) {
                return;
            }
            getActual = false;
        }
        if (LookupDiscovery.groupSetsEqual(response.getGroups(), newGroups)) {
            return;
        }
        String[] actualGroups = newGroups;
        if (getActual && newGroups.length > 0 && (actualGroups = this.getActualGroups(reg)) == null) {
            return;
        }
        Map map = this.registrars;
        synchronized (map) {
            UnicastResponse resp = (UnicastResponse)this.registrars.get(reg.getServiceID());
            if (resp == null) {
                return;
            }
            this.notifyOnGroupChange(reg, resp.getGroups(), actualGroups);
        }
    }

    private void notifyOnGroupChange(ServiceRegistrar reg, String[] oldGroups, String[] newGroups) {
        boolean equal = LookupDiscovery.groupSetsEqual(oldGroups, newGroups);
        boolean stillInterested = this.groupsOverlap(newGroups);
        if (!equal && stillInterested) {
            this.sendChanged(reg, newGroups);
        } else if (!stillInterested) {
            this.sendDiscarded(reg, newGroups);
        }
    }

    private void sendDiscarded(ServiceRegistrar reg, String[] curGroups) {
        ServiceID srvcID = reg.getServiceID();
        if (curGroups == null) {
            UnicastResponse resp = (UnicastResponse)this.registrars.get(srvcID);
            if (resp == null) {
                return;
            }
            curGroups = resp.getGroups();
        }
        if (this.registrars.remove(srvcID) != null) {
            this.regInfo.remove(srvcID);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(reg, curGroups), 1);
            }
        }
    }

    private void sendChanged(ServiceRegistrar reg, String[] curGroups) {
        UnicastResponse resp = (UnicastResponse)this.registrars.get(reg.getServiceID());
        this.registrars.put(reg.getServiceID(), new UnicastResponse(resp.getHost(), resp.getPort(), curGroups, resp.getRegistrar()));
        if (!this.listeners.isEmpty()) {
            this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(reg, curGroups), 2);
        }
    }

    private Map deepCopy(HashMap groupsMap) {
        HashMap newMap = (HashMap)groupsMap.clone();
        Set eSet = newMap.entrySet();
        Iterator itr = eSet.iterator();
        while (itr.hasNext()) {
            Map.Entry pair = itr.next();
            pair.setValue(((String[])pair.getValue()).clone());
        }
        return newMap;
    }

    private String[] getActualGroups(final ServiceRegistrar reg) {
        try {
            return (String[])AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return reg.getGroups();
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (Throwable e) {
            this.discard(reg);
            return null;
        }
    }

    private Map mapRegToGroups(ServiceRegistrar reg, String[] curGroups) {
        HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
        groupsMap.put(reg, curGroups);
        return groupsMap;
    }

    private void testArrayForNullElement(String[] groupArray) {
        if (groupArray == null) {
            return;
        }
        for (int i = 0; i < groupArray.length; ++i) {
            if (groupArray[i] != null) continue;
            throw new NullPointerException("null element in group array");
        }
    }

    private void beginDiscovery(String[] groups, Configuration config) throws IOException, ConfigurationException {
        this.testArrayForNullElement(groups);
        LookupDiscovery.checkGroups(groups);
        if (groups != null) {
            this.groups = new HashSet(groups.length * 2);
            for (int i = 0; i < groups.length; ++i) {
                this.groups.add(groups[i]);
            }
        }
        this.init(config);
        if (this.nicsToUse == 3) {
            return;
        }
        try {
            Security.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    LookupDiscovery.this.announceeThread = new AnnouncementListener();
                    LookupDiscovery.this.announcementTimerThread = new AnnouncementTimerThread();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (this.groups == null || !this.groups.isEmpty()) {
            this.requestGroups(this.groups);
        }
        this.announceeThread.start();
        this.announcementTimerThread.start();
    }

    private void init(Configuration config) throws IOException, ConfigurationException {
        block16: {
            if (config == null) {
                throw new NullPointerException("config is null");
            }
            this.registrarPreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            MethodConstraints constraints = (MethodConstraints)config.getEntry(COMPONENT_NAME, "discoveryConstraints", MethodConstraints.class, null);
            if (constraints == null) {
                constraints = new BasicMethodConstraints(InvocationConstraints.EMPTY);
            }
            this.multicastRequestConstraints = DiscoveryConstraints.process((InvocationConstraints)constraints.getConstraints(DiscoveryConstraints.multicastRequestMethod));
            this.multicastAnnouncementConstraints = DiscoveryConstraints.process((InvocationConstraints)constraints.getConstraints(DiscoveryConstraints.multicastAnnouncementMethod));
            this.rawUnicastDiscoveryConstraints = constraints.getConstraints(DiscoveryConstraints.unicastDiscoveryMethod);
            try {
                this.taskManager = (TaskManager)config.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class);
            }
            catch (NoSuchEntryException e) {
                this.taskManager = new TaskManager(15, 15000L, 1.0f);
            }
            this.multicastRequestMax = (Integer)config.getEntry(COMPONENT_NAME, "multicastRequestMax", Integer.TYPE, (Object)new Integer(this.multicastRequestMax));
            this.multicastRequestInterval = (Long)config.getEntry(COMPONENT_NAME, "multicastRequestInterval", Long.TYPE, (Object)new Long(this.multicastRequestInterval));
            this.finalMulticastRequestInterval = (Long)config.getEntry(COMPONENT_NAME, "finalMulticastRequestInterval", Long.TYPE, (Object)new Long(this.finalMulticastRequestInterval));
            try {
                this.multicastRequestHost = (String)Config.getNonNullEntry(config, COMPONENT_NAME, "multicastRequestHost", String.class);
            }
            catch (NoSuchEntryException nse) {
                this.multicastRequestHost = LookupDiscovery.getLocalHost();
            }
            try {
                this.nics = (NetworkInterface[])config.getEntry(COMPONENT_NAME, "multicastInterfaces", NetworkInterface;.class);
                if (this.nics == null) {
                    this.nicsToUse = 1;
                    logger.config("LookupDiscovery - using system default network interface for multicast");
                } else if (this.nics.length == 0) {
                    this.nicsToUse = 3;
                    logger.config("LookupDiscovery - MULTICAST DISABLED");
                } else {
                    this.nicsToUse = 2;
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.log(Level.CONFIG, "LookupDiscovery - multicast network interface(s): {0}", Arrays.asList(this.nics));
                    }
                }
            }
            catch (NoSuchEntryException e) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                ArrayList<NetworkInterface> nicList = en != null ? Collections.list(en) : Collections.EMPTY_LIST;
                this.nics = nicList.toArray(new NetworkInterface[nicList.size()]);
                this.nicsToUse = 0;
                if (!logger.isLoggable(Level.CONFIG)) break block16;
                logger.log(Level.CONFIG, "LookupDiscovery - multicast network interface(s): {0}", nicList);
            }
        }
        this.nicRetryInterval = (Integer)config.getEntry(COMPONENT_NAME, "multicastInterfaceRetryInterval", Integer.TYPE, (Object)new Integer(this.nicRetryInterval));
        this.multicastAnnouncementInterval = (Long)config.getEntry(COMPONENT_NAME, "multicastAnnouncementInterval", Long.TYPE, (Object)new Long(this.multicastAnnouncementInterval));
        this.unicastDelayRange = Config.getLongEntry(config, COMPONENT_NAME, "unicastDelayRange", 0L, 0L, Long.MAX_VALUE);
        this.tickets = new ArrayList();
        if (this.unicastDelayRange > 0L) {
            try {
                this.discoveryWakeupMgr = (WakeupManager)config.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class);
            }
            catch (NoSuchEntryException e) {
                this.discoveryWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
                this.isDefaultWakeupMgr = true;
            }
        }
        this.initialMulticastRequestDelayRange = Config.getLongEntry(config, COMPONENT_NAME, "initialMulticastRequestDelayRange", 0L, 0L, Long.MAX_VALUE);
    }

    private MulticastAnnouncement decodeMulticastAnnouncement(final DatagramPacket pkt) throws IOException {
        int pv;
        try {
            pv = ByteBuffer.wrap(pkt.getData(), pkt.getOffset(), pkt.getLength()).getInt();
        }
        catch (BufferUnderflowException e) {
            throw new DiscoveryProtocolException(null, (Throwable)e);
        }
        this.multicastAnnouncementConstraints.checkProtocolVersion(pv);
        final Discovery disco = this.getDiscovery(pv);
        try {
            return (MulticastAnnouncement)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return disco.decodeMulticastAnnouncement(pkt, LookupDiscovery.this.multicastAnnouncementConstraints.getUnfulfilledConstraints(), true);
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private DatagramPacket[] encodeMulticastRequest(final MulticastRequest req) throws IOException {
        final Discovery disco = this.getDiscovery(this.multicastRequestConstraints.chooseProtocolVersion());
        final ArrayList packets = new ArrayList();
        AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

            public Object run() {
                EncodeIterator ei = disco.encodeMulticastRequest(req, LookupDiscovery.this.multicastRequestConstraints.getMulticastMaxPacketSize(512), LookupDiscovery.this.multicastRequestConstraints.getUnfulfilledConstraints());
                while (ei.hasNext()) {
                    try {
                        packets.addAll(Arrays.asList(ei.next()));
                    }
                    catch (Exception e) {
                        logger.log(e instanceof UnsupportedConstraintException ? Levels.HANDLED : Level.INFO, "exception encoding multicast request", e);
                    }
                }
                return null;
            }
        }), this.securityContext.getAccessControlContext());
        if (packets.isEmpty()) {
            throw new DiscoveryProtocolException("no encoded requests");
        }
        return packets.toArray(new DatagramPacket[packets.size()]);
    }

    private UnicastResponse doUnicastDiscovery(final Socket socket, final DiscoveryConstraints unicastDiscoveryConstraints, final Discovery disco) throws IOException, ClassNotFoundException {
        try {
            return (UnicastResponse)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return disco.doUnicastDiscovery(socket, unicastDiscoveryConstraints.getUnfulfilledConstraints(), null, null, null);
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            throw new AssertionError((Object)t);
        }
    }

    private UnicastResponse doUnicastDiscovery(Socket socket, DiscoveryConstraints unicastDiscoveryConstraints) throws IOException, ClassNotFoundException {
        Discovery disco = this.getDiscovery(unicastDiscoveryConstraints.chooseProtocolVersion());
        return this.doUnicastDiscovery(socket, unicastDiscoveryConstraints, disco);
    }

    private Discovery getDiscovery(int version) throws DiscoveryProtocolException {
        switch (version) {
            case 1: {
                return Discovery.getProtocol1();
            }
            case 2: {
                return this.protocol2;
            }
        }
        throw new DiscoveryProtocolException("unsupported protocol version: " + version);
    }

    static /* synthetic */ UnicastResponse access$4200(LookupDiscovery x0, Socket x1, DiscoveryConstraints x2, Discovery x3) throws IOException, ClassNotFoundException {
        return x0.doUnicastDiscovery(x1, x2, x3);
    }

    private static class AnnouncementInfo {
        private long tStamp;
        private long seqNum;

        private AnnouncementInfo(long tStamp, long seqNum) {
            this.tStamp = tStamp;
            this.seqNum = seqNum;
        }
    }

    private class UnicastDiscoveryTask
    implements TaskManager.Task {
        private Object req;
        private WakeupManager.Ticket ticket = null;
        private boolean delayRun = false;

        UnicastDiscoveryTask(Object req) {
            this(req, false);
        }

        UnicastDiscoveryTask(Object req, boolean delayRun) {
            this.req = req;
            this.delayRun = delayRun;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            block35: {
                logger.finest("LookupDiscovery - UnicastDiscoveryTask started");
                try {
                    block34: {
                        try {
                            UnicastDiscoveryTask unicastDiscoveryTask = this;
                            // MONITORENTER : unicastDiscoveryTask
                            while (this.delayRun) {
                                this.wait();
                            }
                            Set set = LookupDiscovery.this.pendingDiscoveries;
                            // MONITORENTER : set
                            if (this.ticket != null) {
                                LookupDiscovery.this.tickets.remove(this.ticket);
                            }
                            // MONITOREXIT : set
                            // MONITOREXIT : unicastDiscoveryTask
                            Socket sock = null;
                            MulticastAnnouncement announcement = null;
                            UnicastResponse response = null;
                            if (this.req instanceof Socket) {
                                UnicastResponse resp;
                                DiscoveryConstraints unicastDiscoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)LookupDiscovery.this.rawUnicastDiscoveryConstraints);
                                sock = (Socket)this.req;
                                try {
                                    LookupDiscovery.prepareSocket(sock, unicastDiscoveryConstraints);
                                    resp = LookupDiscovery.this.doUnicastDiscovery(sock, unicastDiscoveryConstraints);
                                }
                                finally {
                                    try {
                                        sock.close();
                                    }
                                    catch (IOException e) {}
                                }
                                LookupDiscovery.this.maybeAddNewRegistrar(resp);
                                break block34;
                            }
                            if (this.req instanceof LookupLocator) {
                                LookupLocator loc = (LookupLocator)this.req;
                                UnicastResponse resp = new MultiIPDiscovery(this){
                                    private final /* synthetic */ UnicastDiscoveryTask this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    protected UnicastResponse performDiscovery(Discovery disco, DiscoveryConstraints dc, Socket s) throws IOException, ClassNotFoundException {
                                        return LookupDiscovery.access$4200(UnicastDiscoveryTask.access$4100(this.this$1), s, dc, disco);
                                    }

                                    protected void singleResponseException(Exception e, InetAddress addr, int port) {
                                        LookupDiscovery.access$000().log(Levels.HANDLED, "Exception occured during unicast discovery " + addr + ":" + port, e);
                                    }
                                }.getResponse(loc.getHost(), loc.getPort(), LookupDiscovery.this.rawUnicastDiscoveryConstraints);
                                LookupDiscovery.this.maybeAddNewRegistrar(resp);
                                break block34;
                            }
                            if (this.req instanceof CheckGroupsMarker) {
                                announcement = ((CheckGroupsMarker)this.req).announcement;
                                ServiceID srvcID = announcement.getServiceID();
                                UnicastResponse resp = null;
                                Map map = LookupDiscovery.this.registrars;
                                // MONITORENTER : map
                                resp = (UnicastResponse)LookupDiscovery.this.registrars.get(srvcID);
                                // MONITOREXIT : map
                                if (resp != null) {
                                    LookupDiscovery.this.maybeSendEvent(resp, announcement.getGroups());
                                }
                                break block34;
                            }
                            if (!(this.req instanceof CheckReachabilityMarker)) break block34;
                            response = ((CheckReachabilityMarker)this.req).response;
                            LookupDiscovery.this.maybeSendEvent(response, null);
                        }
                        catch (InterruptedIOException e) {
                            logger.log(Levels.HANDLED, "exception occurred during unicast discovery", e);
                            Object var11_21 = null;
                            Set set = LookupDiscovery.this.pendingDiscoveries;
                            // MONITORENTER : set
                            LookupDiscovery.this.pendingDiscoveries.remove(this.req);
                            // MONITOREXIT : set
                            break block35;
                        }
                        catch (Throwable e) {
                            if ((this.req instanceof Socket || this.req instanceof LookupLocator) && logger.isLoggable(Level.INFO)) {
                                String logmsg = "exception occurred during unicast discovery to {0}:{1,number,#} with constraints {2}";
                                String methodName = "run";
                                if (this.req instanceof Socket) {
                                    Socket sock = (Socket)this.req;
                                    LogUtil.logThrow(logger, Level.INFO, this.getClass(), methodName, logmsg, new Object[]{sock.getInetAddress().getHostName(), new Integer(sock.getPort()), LookupDiscovery.this.rawUnicastDiscoveryConstraints}, e);
                                } else {
                                    LookupLocator loc = (LookupLocator)this.req;
                                    LogUtil.logThrow(logger, Level.INFO, this.getClass(), methodName, logmsg, new Object[]{loc.getHost(), new Integer(loc.getPort()), LookupDiscovery.this.rawUnicastDiscoveryConstraints}, e);
                                }
                            } else {
                                logger.log(Level.INFO, "exception occurred during unicast discovery", e);
                            }
                            Object var11_22 = null;
                            Set set = LookupDiscovery.this.pendingDiscoveries;
                            // MONITORENTER : set
                            LookupDiscovery.this.pendingDiscoveries.remove(this.req);
                            // MONITOREXIT : set
                        }
                    }
                    Object var11_20 = null;
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    // MONITORENTER : set
                    LookupDiscovery.this.pendingDiscoveries.remove(this.req);
                    // MONITOREXIT : set
                }
                catch (Throwable throwable) {
                    Object var11_23 = null;
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    // MONITORENTER : set
                    LookupDiscovery.this.pendingDiscoveries.remove(this.req);
                    // MONITOREXIT : set
                    throw throwable;
                }
            }
            logger.finest("LookupDiscovery - UnicastDiscoveryTask completed");
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        static /* synthetic */ LookupDiscovery access$4100(UnicastDiscoveryTask x0) {
            return x0.LookupDiscovery.this;
        }
    }

    private class DecodeAnnouncementTask
    implements TaskManager.Task {
        private final DatagramPacket datagram;

        public DecodeAnnouncementTask(DatagramPacket datagram) {
            this.datagram = datagram;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MulticastAnnouncement ann;
            try {
                ann = LookupDiscovery.this.decodeMulticastAnnouncement(this.datagram);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedIOException)) {
                    logger.log(Levels.HANDLED, "exception decoding multicast announcement", e);
                }
                return;
            }
            Object pending = null;
            ServiceID srvcID = ann.getServiceID();
            Map map = LookupDiscovery.this.registrars;
            synchronized (map) {
                UnicastResponse resp = (UnicastResponse)LookupDiscovery.this.registrars.get(srvcID);
                if (resp != null) {
                    AnnouncementInfo aInfo = (AnnouncementInfo)LookupDiscovery.this.regInfo.get(srvcID);
                    aInfo.tStamp = System.currentTimeMillis();
                    long currNum = ann.getSequenceNumber();
                    if (this.newSeqNum(currNum, aInfo.seqNum) && !LookupDiscovery.groupSetsEqual(resp.getGroups(), ann.getGroups())) {
                        pending = new CheckGroupsMarker(ann);
                    }
                } else if (LookupDiscovery.this.groupsOverlap(ann.getGroups())) {
                    pending = new LookupLocator(ann.getHost(), ann.getPort());
                }
            }
            if (pending != null) {
                boolean added;
                Object aInfo;
                try {
                    ann.checkConstraints();
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedIOException)) {
                        logger.log(Levels.HANDLED, "exception decoding multicast announcement", e);
                    }
                    return;
                }
                if (pending instanceof CheckGroupsMarker) {
                    Map e = LookupDiscovery.this.registrars;
                    synchronized (e) {
                        aInfo = (AnnouncementInfo)LookupDiscovery.this.regInfo.get(srvcID);
                        ((AnnouncementInfo)aInfo).seqNum = ann.getSequenceNumber();
                    }
                }
                aInfo = LookupDiscovery.this.pendingDiscoveries;
                synchronized (aInfo) {
                    added = LookupDiscovery.this.pendingDiscoveries.add(pending);
                }
                if (added) {
                    if (LookupDiscovery.this.unicastDelayRange <= 0L) {
                        new UnicastDiscoveryTask(pending).run();
                    } else {
                        UnicastDiscoveryTask ud = new UnicastDiscoveryTask(pending, true);
                        WakeupManager.Ticket t = LookupDiscovery.this.discoveryWakeupMgr.schedule(System.currentTimeMillis() + (long)(Math.random() * (double)LookupDiscovery.this.unicastDelayRange), new Runnable(this, ud){
                            private final /* synthetic */ UnicastDiscoveryTask val$ud;
                            private final /* synthetic */ DecodeAnnouncementTask this$1;
                            {
                                this.this$1 = this$1;
                                this.val$ud = val$ud;
                            }

                            public void run() {
                                LookupDiscovery.access$1000(DecodeAnnouncementTask.access$3200(this.this$1)).add(this.val$ud);
                            }
                        });
                        UnicastDiscoveryTask unicastDiscoveryTask = ud;
                        synchronized (unicastDiscoveryTask) {
                            ud.ticket = t;
                            ud.delayRun = false;
                            Set set = LookupDiscovery.this.pendingDiscoveries;
                            synchronized (set) {
                                LookupDiscovery.this.tickets.add(t);
                            }
                            ud.notifyAll();
                        }
                    }
                }
            }
        }

        private boolean newSeqNum(long currentNum, long oldNum) {
            if (oldNum == -1L) {
                return true;
            }
            return currentNum > oldNum;
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        static /* synthetic */ LookupDiscovery access$3200(DecodeAnnouncementTask x0) {
            return x0.LookupDiscovery.this;
        }
    }

    private static class CheckReachabilityMarker {
        final UnicastResponse response;

        CheckReachabilityMarker(UnicastResponse response) {
            this.response = response;
        }

        public int hashCode() {
            return this.response.getRegistrar().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CheckReachabilityMarker && this.response.getRegistrar().equals(((CheckReachabilityMarker)obj).response.getRegistrar());
        }
    }

    private static class CheckGroupsMarker {
        final MulticastAnnouncement announcement;

        CheckGroupsMarker(MulticastAnnouncement announcement) {
            this.announcement = announcement;
        }

        public int hashCode() {
            return this.announcement.getServiceID().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CheckGroupsMarker && this.announcement.getServiceID().equals((Object)((CheckGroupsMarker)obj).announcement.getServiceID());
        }
    }

    private class AnnouncementTimerThread
    extends Thread {
        private static final long N_INTERVALS = 3L;

        public AnnouncementTimerThread() {
            super("multicast announcement timer");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void run() {
            long timeThreshold = 3L * LookupDiscovery.this.multicastAnnouncementInterval;
            try {
                while (!this.isInterrupted()) {
                    this.wait(LookupDiscovery.this.multicastAnnouncementInterval);
                    long curTime = System.currentTimeMillis();
                    Map map = LookupDiscovery.this.registrars;
                    synchronized (map) {
                        HashMap regInfoClone = (HashMap)LookupDiscovery.this.regInfo.clone();
                        Set eSet = regInfoClone.entrySet();
                        Iterator itr = eSet.iterator();
                        while (itr.hasNext()) {
                            Map.Entry pair = itr.next();
                            ServiceID srvcID = (ServiceID)pair.getKey();
                            long tStamp = ((AnnouncementInfo)pair.getValue()).tStamp;
                            long deltaT = curTime - tStamp;
                            if (deltaT <= timeThreshold) continue;
                            UnicastResponse resp = (UnicastResponse)LookupDiscovery.this.registrars.get(srvcID);
                            CheckReachabilityMarker req = new CheckReachabilityMarker(resp);
                            Set set = LookupDiscovery.this.pendingDiscoveries;
                            synchronized (set) {
                                if (LookupDiscovery.this.pendingDiscoveries.add(req)) {
                                    LookupDiscovery.this.taskManager.add(new UnicastDiscoveryTask(req));
                                }
                            }
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class Requestor
    extends Thread {
        private MulticastSocket sock;
        private int responsePort;
        private String[] groups;
        private boolean delayFlag;

        public Requestor(String[] groups, int port, boolean delayFlag) throws IOException {
            super("multicast discovery request");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            this.sock.setTimeToLive(LookupDiscovery.this.multicastRequestConstraints.getMulticastTimeToLive(15));
            this.responsePort = port;
            this.groups = groups == null ? new String[]{} : groups;
            this.delayFlag = delayFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            logger.finest("LookupDiscovery - Requestor thread started");
            try {
                try {
                    if (this.delayFlag && LookupDiscovery.this.initialMulticastRequestDelayRange > 0L && LookupDiscovery.this.multicastRequestMax >= 0) {
                        Thread.sleep((long)(Math.random() * (double)LookupDiscovery.this.initialMulticastRequestDelayRange));
                    }
                    int count = LookupDiscovery.this.multicastRequestMax;
                    while (--count >= 0 && !this.isInterrupted()) {
                        DatagramPacket[] reqs = LookupDiscovery.this.encodeMulticastRequest(new MulticastRequest(LookupDiscovery.this.multicastRequestHost, this.responsePort, this.groups, LookupDiscovery.this.getServiceIDs()));
                        LookupDiscovery.this.sendPacketByNIC(this.sock, reqs);
                        Thread.sleep(count > 0 ? LookupDiscovery.this.multicastRequestInterval : LookupDiscovery.this.finalMulticastRequestInterval);
                    }
                    Object var4_6 = null;
                }
                catch (InterruptedException e) {
                    Object var4_7 = null;
                    Collection collection2 = LookupDiscovery.this.requestors;
                    synchronized (collection2) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
                catch (InterruptedIOException e) {
                    Object var4_8 = null;
                    Collection collection3 = LookupDiscovery.this.requestors;
                    synchronized (collection3) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "exception while marshalling outgoing multicast request", e);
                    Object var4_9 = null;
                    Collection collection4 = LookupDiscovery.this.requestors;
                    synchronized (collection4) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    LookupDiscovery.this.requestors.remove(Thread.currentThread());
                    if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                        LookupDiscovery.this.respondeeThread = null;
                    }
                }
                this.sock.close();
                logger.finest("LookupDiscovery - Requestor thread completed");
                throw throwable;
            }
            Collection collection = LookupDiscovery.this.requestors;
            synchronized (collection) {
                LookupDiscovery.this.requestors.remove(Thread.currentThread());
                if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                    LookupDiscovery.this.respondeeThread.interrupt();
                    LookupDiscovery.this.respondeeThread = null;
                }
            }
            this.sock.close();
            logger.finest("LookupDiscovery - Requestor thread completed");
        }
    }

    private class ResponseListener
    extends Thread {
        public ServerSocket serv;
        private volatile boolean interrupted;

        public ResponseListener() throws IOException {
            super("multicast discovery response listener");
            this.interrupted = false;
            this.setDaemon(true);
            this.serv = new ServerSocket(0);
        }

        public void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.getPort()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupDiscovery - ResponseListener thread started");
            while (!this.isInterrupted()) {
                try {
                    Socket sock = this.serv.accept();
                    if (this.isInterrupted()) {
                        try {
                            sock.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (set) {
                        LookupDiscovery.this.pendingDiscoveries.add(sock);
                        LookupDiscovery.this.taskManager.add(new UnicastDiscoveryTask(sock));
                    }
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "exception while listening for multicast response", e);
                }
            }
            try {
                this.serv.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "IOException while attempting a socket close", e);
            }
            logger.finest("LookupDiscovery - ResponseListener thread completed");
        }

        public int getPort() {
            return this.serv.getLocalPort();
        }
    }

    private class AnnouncementListener
    extends Thread {
        private MulticastSocket sock;
        private ArrayList retryNics;
        private volatile boolean interrupted;

        public AnnouncementListener() throws IOException {
            super("multicast discovery announcement listener");
            this.retryNics = null;
            this.interrupted = false;
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            switch (LookupDiscovery.this.nicsToUse) {
                case 0: {
                    for (int i = 0; i < LookupDiscovery.this.nics.length; ++i) {
                        try {
                            this.sock.setNetworkInterface(LookupDiscovery.this.nics[i]);
                            this.sock.joinGroup(Constants.getAnnouncementAddress());
                            continue;
                        }
                        catch (IOException e) {
                            if (this.retryNics == null) {
                                this.retryNics = new ArrayList(LookupDiscovery.this.nics.length);
                            }
                            this.retryNics.add(LookupDiscovery.this.nics[i]);
                            if (!logger.isLoggable(Levels.HANDLED)) continue;
                            LogRecord logRec = new LogRecord(Levels.HANDLED, "network interface is bad or not configured for multicast: {0}");
                            logRec.setParameters(new Object[]{LookupDiscovery.this.nics[i]});
                            logRec.setThrown(e);
                            logger.log(logRec);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < LookupDiscovery.this.nics.length; ++i) {
                        try {
                            this.sock.setNetworkInterface(LookupDiscovery.this.nics[i]);
                            this.sock.joinGroup(Constants.getAnnouncementAddress());
                            continue;
                        }
                        catch (IOException e) {
                            if (this.retryNics == null) {
                                this.retryNics = new ArrayList(LookupDiscovery.this.nics.length);
                            }
                            this.retryNics.add(LookupDiscovery.this.nics[i]);
                            if (!logger.isLoggable(Level.SEVERE)) continue;
                            LogRecord logRec = new LogRecord(Level.SEVERE, "network interface is bad or not configured for multicast: {0}");
                            logRec.setParameters(new Object[]{LookupDiscovery.this.nics[i]});
                            logRec.setThrown(e);
                            logger.log(logRec);
                        }
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sock.joinGroup(Constants.getAnnouncementAddress());
                    }
                    catch (IOException e) {
                        this.retryNics = new ArrayList(0);
                        if (!logger.isLoggable(Level.SEVERE)) break;
                        logger.log(Level.SEVERE, "system default network interface is bad or not configured for multicast", e);
                    }
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("nicsToUse flag out of range (0-3): " + LookupDiscovery.this.nicsToUse));
                }
            }
        }

        public void interrupt() {
            this.interrupted = true;
            this.sock.close();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        private void retryBadNics() {
            if (this.retryNics == null) {
                return;
            }
            if (!this.retryNics.isEmpty()) {
                String recoveredStr = "network interface has recovered from previous failure: {0}";
                ArrayList tmpList = (ArrayList)this.retryNics.clone();
                this.retryNics.clear();
                for (int i = 0; i < tmpList.size(); ++i) {
                    NetworkInterface nic = (NetworkInterface)tmpList.get(i);
                    try {
                        this.sock.setNetworkInterface(nic);
                        this.sock.joinGroup(Constants.getAnnouncementAddress());
                        if (LookupDiscovery.this.nicsToUse == 2) {
                            logger.log(Level.INFO, recoveredStr, nic);
                            continue;
                        }
                        logger.log(Level.FINE, recoveredStr, nic);
                        continue;
                    }
                    catch (IOException e1) {
                        this.retryNics.add(nic);
                    }
                }
                if (this.retryNics.isEmpty()) {
                    this.retryNics = null;
                }
            } else {
                try {
                    this.sock.joinGroup(Constants.getAnnouncementAddress());
                    this.retryNics = null;
                    logger.log(Level.INFO, "system default network interface has recovered from previous failure");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            logger.finest("LookupDiscovery - AnnouncementListener thread started");
            byte[] buf = new byte[LookupDiscovery.this.multicastAnnouncementConstraints.getMulticastMaxPacketSize(512)];
            DatagramPacket pkt = new DatagramPacket(buf, buf.length);
            long endTime = System.currentTimeMillis() + (long)LookupDiscovery.this.nicRetryInterval;
            while (!this.isInterrupted()) {
                try {
                    int delta_t = 0;
                    if (this.retryNics != null && (delta_t = (int)(endTime - System.currentTimeMillis())) <= 0) {
                        this.retryBadNics();
                        if (this.retryNics != null) {
                            delta_t = LookupDiscovery.this.nicRetryInterval;
                            endTime = System.currentTimeMillis() + (long)delta_t;
                        } else {
                            delta_t = 0;
                        }
                    }
                    this.sock.setSoTimeout(delta_t);
                    pkt.setLength(buf.length);
                    try {
                        this.sock.receive(pkt);
                    }
                    catch (NullPointerException e) {
                        break;
                    }
                    LookupDiscovery.this.taskManager.add(new DecodeAnnouncementTask(pkt));
                    buf = new byte[buf.length];
                    pkt = new DatagramPacket(buf, buf.length);
                }
                catch (SocketTimeoutException e) {
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    if (this.isInterrupted()) break;
                    logger.log(Level.INFO, "exception while listening for multicast announcements", e);
                }
            }
            this.sock.close();
            this.sock = null;
            logger.finest("LookupDiscovery - AnnouncementListener thread completed");
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event listener notification");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupDiscovery - Notifier thread started");
            while (true) {
                NotifyTask task;
                LinkedList linkedList = LookupDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupDiscovery.this.notifierThread = null;
                        return;
                    }
                    task = (NotifyTask)LookupDiscovery.this.pendingNotifies.removeFirst();
                }
                AccessController.doPrivileged(LookupDiscovery.this.securityContext.wrap(new PrivilegedAction(){

                    public Object run() {
                        boolean firstListener = true;
                        Iterator iter = task.listeners.iterator();
                        while (iter.hasNext()) {
                            DiscoveryListener l = (DiscoveryListener)iter.next();
                            if (task.eventType == 2 && !(l instanceof DiscoveryChangeListener)) continue;
                            DiscoveryEvent e = new DiscoveryEvent((Object)LookupDiscovery.this, LookupDiscovery.this.deepCopy((HashMap)task.groupsMap));
                            if (firstListener && logger.isLoggable(Level.FINEST)) {
                                String eType = (new String[]{"discovered", "discarded", "changed"})[task.eventType];
                                ServiceRegistrar[] regs = e.getRegistrars();
                                logger.finest(eType + " event  -- " + regs.length + " lookup(s)");
                                Map groupsMap = e.getGroups();
                                for (int i = 0; i < regs.length; ++i) {
                                    LookupLocator loc = null;
                                    try {
                                        loc = regs[i].getLocator();
                                    }
                                    catch (Throwable ex) {
                                        // empty catch block
                                    }
                                    String[] groups = (String[])groupsMap.get(regs[i]);
                                    logger.finest("    " + eType + " locator  = " + loc);
                                    if (groups.length == 0) {
                                        logger.finest("    " + eType + " group    " + "= NO_GROUPS");
                                        continue;
                                    }
                                    for (int j = 0; j < groups.length; ++j) {
                                        logger.finest("    " + eType + " group[" + j + "] = " + groups[j]);
                                    }
                                }
                            }
                            switch (task.eventType) {
                                case 0: {
                                    l.discovered(e);
                                    break;
                                }
                                case 1: {
                                    l.discarded(e);
                                    break;
                                }
                                case 2: {
                                    ((DiscoveryChangeListener)l).changed(e);
                                }
                            }
                            firstListener = false;
                        }
                        return null;
                    }
                }), LookupDiscovery.this.securityContext.getAccessControlContext());
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final int eventType;

        public NotifyTask(ArrayList listeners, Map groupsMap, int eventType) {
            this.listeners = listeners;
            this.groupsMap = groupsMap;
            this.eventType = eventType;
        }
    }
}

