/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.collection.SoftCache;
import com.sun.jini.jeri.internal.http.ServerInfo;
import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;

public class HttpClientManager {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private final SoftCache rolodex = new SoftCache();
    private final TimedMap unsentAcks;

    public HttpClientManager(long ackTimeout) {
        this.unsentAcks = new TimedMap(systemThreadPool, ackTimeout);
    }

    public void clearServerInfo() {
        this.rolodex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnsentAcks(String host, int port, String[] cookies) {
        if (cookies == null) {
            throw new NullPointerException();
        }
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            ServerKey key = new ServerKey(host, port);
            HashSet<String> set = (HashSet<String>)this.unsentAcks.get(key);
            if (set == null) {
                set = new HashSet<String>();
                this.unsentAcks.put(key, set);
            }
            for (int i = 0; i < cookies.length; ++i) {
                set.add(cookies[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnsentAcks(String host, int port, String[] cookies) {
        if (cookies == null) {
            throw new NullPointerException();
        }
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            ServerKey key = new ServerKey(host, port);
            Set set = (Set)this.unsentAcks.get(key);
            if (set == null) {
                return;
            }
            for (int i = 0; i < cookies.length; ++i) {
                set.remove(cookies[i]);
            }
            if (set.isEmpty()) {
                this.unsentAcks.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getUnsentAcks(String host, int port) {
        TimedMap timedMap = this.unsentAcks;
        synchronized (timedMap) {
            Set set = (Set)this.unsentAcks.get(new ServerKey(host, port));
            return set != null ? set.toArray(new String[set.size()]) : new String[]{};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo getServerInfo(String host, int port) {
        ServerKey key = new ServerKey(host, port);
        SoftCache softCache = this.rolodex;
        synchronized (softCache) {
            ServerInfo info = (ServerInfo)this.rolodex.get(key);
            return info != null ? (ServerInfo)info.clone() : new ServerInfo(host, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheServerInfo(ServerInfo info) {
        if (info.timestamp == -1L) {
            return;
        }
        ServerKey key = new ServerKey(info.host, info.port);
        SoftCache softCache = this.rolodex;
        synchronized (softCache) {
            ServerInfo oldInfo = (ServerInfo)this.rolodex.get(key);
            if (oldInfo == null || info.timestamp > oldInfo.timestamp) {
                this.rolodex.put(key, info.clone());
            }
        }
    }

    private static class ServerKey {
        private final String host;
        private final int port;
        private final int hash;

        ServerKey(String host, int port) {
            this.host = host;
            this.port = port;
            this.hash = host.hashCode() << 10 | port & 0x3FF;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServerKey) {
                ServerKey key = (ServerKey)obj;
                return this.host.equals(key.host) && this.port == key.port;
            }
            return false;
        }
    }
}

