/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.precompiler;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.compiler.BaseCompiledTemplate;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateMapKey;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.DelegatingTemplateLoader;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecompiledTemplateLoader
implements DelegatingTemplateLoader {
    private final TemplateLoader nextLoader;
    private final Map<Object, BaseCompiledTemplate> templateMap;
    private final AutoEscapeOptions autoEscapeOptions;

    public PrecompiledTemplateLoader(TemplateLoader nextLoader, Map<Object, String> templateToClassNameMap, FunctionExecutor globalFunctionExecutor, AutoEscapeOptions autoEscapeOptions) {
        this.nextLoader = nextLoader;
        this.autoEscapeOptions = autoEscapeOptions;
        this.templateMap = this.makeTemplateMap(templateToClassNameMap, globalFunctionExecutor);
    }

    private Map<Object, BaseCompiledTemplate> makeTemplateMap(Map<Object, String> templateToClassNameMap, FunctionExecutor globalFunctionExecutor) {
        HashMap<Object, BaseCompiledTemplate> templateMap = new HashMap<Object, BaseCompiledTemplate>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (Map.Entry<Object, String> entry : templateToClassNameMap.entrySet()) {
            String className = entry.getValue();
            BaseCompiledTemplate compiledTemplate = this.loadTemplateObject(className, classLoader);
            compiledTemplate.setFunctionExecutor(globalFunctionExecutor);
            compiledTemplate.setTemplateName(entry.getKey().toString());
            compiledTemplate.setTemplateLoader(this);
            if (entry.getKey() instanceof PrecompiledTemplateMapKey) {
                PrecompiledTemplateMapKey mapKey = (PrecompiledTemplateMapKey)entry.getKey();
                compiledTemplate.setEscapeMode(mapKey.getEscapeMode());
            } else {
                compiledTemplate.setEscapeMode(EscapeMode.ESCAPE_NONE);
            }
            compiledTemplate.setAutoEscapeOptions(this.autoEscapeOptions);
            templateMap.put(entry.getKey(), compiledTemplate);
        }
        return ImmutableMap.copyOf(templateMap);
    }

    @VisibleForTesting
    protected BaseCompiledTemplate loadTemplateObject(String className, ClassLoader classLoader) {
        try {
            Class<?> templateClass = classLoader.loadClass(className);
            return (BaseCompiledTemplate)templateClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setTemplateLoaderDelegate(TemplateLoader templateLoaderDelegate) {
        for (BaseCompiledTemplate template : this.templateMap.values()) {
            template.setTemplateLoader(templateLoaderDelegate);
        }
    }

    @Override
    public Template load(String templateName, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        Object key = resourceLoader.getKey(templateName);
        PrecompiledTemplateMapKey mapKey = new PrecompiledTemplateMapKey(key, escapeMode);
        Template template = this.templateMap.get(mapKey);
        if (template != null) {
            return template;
        }
        return this.nextLoader.load(templateName, resourceLoader, escapeMode);
    }

    @Override
    public Template createTemp(String name, String content, EscapeMode escapeMode) {
        return this.nextLoader.createTemp(name, content, escapeMode);
    }
}

