/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Englober;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class Englobers {
    private final List<Englober> englobers = new ArrayList<Englober>();

    public Englobers(TileArguments tileArguments) {
        Englober pending = null;
        for (Participant p : tileArguments.getLivingSpaces().participants()) {
            ParticipantEnglober englober = tileArguments.getLivingSpaces().get(p).getEnglober();
            if (englober == null) {
                pending = null;
                continue;
            }
            assert (englober != null);
            if (pending != null && englober == pending.getParticipantEnglober()) {
                pending.add(p);
                continue;
            }
            pending = Englober.createTeoz(englober, p, tileArguments, tileArguments.getSkinParam().getCurrentStyleBuilder());
            this.englobers.add(pending);
        }
    }

    public int size() {
        return this.englobers.size();
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double result = 0.0;
        for (Englober englober : this.englobers) {
            double height = englober.getPreferredHeight();
            if (!(height > result)) continue;
            result = height;
        }
        return result;
    }

    public void addConstraints(StringBounder stringBounder) {
        Englober last = null;
        for (Englober current : this.englobers) {
            current.addInternalConstraints();
            if (last != null) {
                last.addConstraintAfter(current);
            }
            last = current;
        }
    }

    public void drawEnglobers(UGraphic ug, double height, Context2D context) {
        for (Englober englober : this.englobers) {
            englober.drawEnglober(ug, height, context);
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> all = new ArrayList<Real>();
        for (Englober englober : this.englobers) {
            all.add(englober.getMinX(stringBounder));
        }
        return RealUtils.min(all);
    }

    public Real getMaxX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> all = new ArrayList<Real>();
        for (Englober englober : this.englobers) {
            all.add(englober.getMaxX(stringBounder));
        }
        return RealUtils.max(all);
    }
}

