/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.RotationZoom;

public class MyPoint2D
extends Point2D {
    public static final double NO_CURVE = 0.0;
    private final double x;
    private final double y;
    private final double curvation;

    public MyPoint2D(StringTokenizer st) {
        this.x = Double.parseDouble(st.nextToken());
        this.y = Double.parseDouble(st.nextToken());
        this.curvation = st.hasMoreTokens() ? Double.parseDouble(st.nextToken()) : 0.0;
    }

    @Override
    public boolean equals(Object arg0) {
        MyPoint2D other = (MyPoint2D)arg0;
        return this.x == other.x && this.y == other.y && this.curvation == other.curvation;
    }

    public static MyPoint2D from(double x, double y) {
        return new MyPoint2D(x, y, 0.0);
    }

    public MyPoint2D withCurvation(double curvation) {
        if (curvation == 0.0) {
            return this;
        }
        return new MyPoint2D(this.x, this.y, curvation);
    }

    private MyPoint2D(Point2D p, double curvation) {
        this.x = p.getX();
        this.y = p.getY();
        this.curvation = curvation;
    }

    private MyPoint2D(double x, double y, double curvation) {
        this.x = x;
        this.y = y;
        this.curvation = curvation;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public double getCurvation(double def) {
        if (this.curvation == 0.0) {
            return def;
        }
        return this.curvation;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setLocation(double arg0, double arg1) {
        throw new UnsupportedOperationException();
    }

    public MyPoint2D rotateZoom(RotationZoom rotationZoom) {
        Point2D.Double p = rotationZoom.getPoint(this.x, this.y);
        double curvation = this.curvation == 0.0 ? 0.0 : rotationZoom.applyZoom(this.curvation);
        return new MyPoint2D(p, curvation);
    }

    public boolean hasCurvation() {
        return this.curvation != 0.0;
    }
}

