/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandGrouping
extends SingleLineCommand2<SequenceDiagram> {
    public CommandGrouping() {
        super(CommandGrouping.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGrouping.class.getName(), RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("TYPE", "(opt|alt|loop|par|par2|break|critical|else|end|also|group)"), new RegexLeaf("COLORS", "((?<!else)(?<!also)(?<!end)#\\w+)?(?:[%s]+(#\\w+))?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("COMMENT", "(.*?)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        boolean parallel;
        boolean result;
        String type = StringUtils.goLowerCase(arg.get("TYPE", 0));
        HtmlColor backColorElement = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLORS", 0));
        HtmlColor backColorGeneral = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLORS", 1), true);
        String comment = arg.get("COMMENT", 0);
        GroupingType groupingType = GroupingType.getType(type);
        if ("group".equals(type)) {
            if (StringUtils.isEmpty(comment)) {
                comment = "group";
            } else {
                Pattern p = Pattern.compile("^(.*?)\\[(.*)\\]$");
                Matcher m = p.matcher(comment);
                if (m.find()) {
                    type = m.group(1);
                    comment = m.group(2);
                }
            }
        }
        if (!(result = diagram.grouping(type, comment, groupingType, backColorGeneral, backColorElement, parallel = arg.get("PARALLEL", 0) != null))) {
            return CommandExecutionResult.error("Cannot create group");
        }
        return CommandExecutionResult.ok();
    }
}

