/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final UStroke stroke;
    private final double minWidth;
    private final boolean collections;
    private final double padding;

    public ComponentRoseParticipant(Style style, Style stereo, SymbolContext biColor, FontConfiguration font, Display stringsToDisplay, ISkinSimple spriteContainer, double roundCorner, UFont fontForStereotype, HtmlColor htmlColorForStereotype, double minWidth, boolean collections, double padding) {
        super(style, stereo, LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 7, 7, 7, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
        if (SkinParam.USE_STYLES()) {
            this.roundCorner = style.value(PName.RoundCorner).asInt();
            biColor = style.getSymbolContext(this.getIHtmlColorSet());
            this.stroke = style.getStroke();
        } else {
            this.roundCorner = roundCorner;
            this.stroke = biColor.getStroke();
        }
        this.padding = padding;
        this.minWidth = minWidth;
        this.collections = collections;
        this.back = biColor.getBackColor();
        this.deltaShadow = biColor.getDeltaShadow();
        this.foregroundColor = biColor.getForeColor();
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate(this.padding, 0.0));
        ug = ug.apply(new UChangeBackColor(this.back)).apply(new UChangeColor(this.foregroundColor));
        ug = ug.apply(this.stroke);
        URectangle rect = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.roundCorner, this.roundCorner);
        rect.setDeltaShadow(this.deltaShadow);
        if (this.collections) {
            ug.apply(new UTranslate(this.getDeltaCollection(), 0.0)).draw(rect);
            ug = ug.apply(new UTranslate(0.0, this.getDeltaCollection()));
        }
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(ug.apply(new UTranslate((double)this.getMarginX1() + this.suppWidth(stringBounder) / 2.0, this.getMarginY())));
    }

    private double getDeltaCollection() {
        if (this.collections) {
            return 4.0;
        }
        return 0.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0 + this.getDeltaCollection();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow + this.getDeltaCollection() + 2.0 * this.padding;
    }

    @Override
    protected double getPureTextWidth(StringBounder stringBounder) {
        return Math.max(super.getPureTextWidth(stringBounder), this.minWidth);
    }

    private final double suppWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) - super.getPureTextWidth(stringBounder);
    }
}

