/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class PostIt {
    private final String id;
    private final Display text;
    private Dimension2D minimumDimension;

    public PostIt(String id, Display text) {
        this.id = id;
        this.text = text;
    }

    public String getId() {
        return this.id;
    }

    public Display getText() {
        return this.text;
    }

    public Dimension2D getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimumDimension(Dimension2D minimumDimension) {
        this.minimumDimension = minimumDimension;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        double width = this.getComponent().getPreferredWidth(stringBounder);
        double height = this.getComponent().getPreferredHeight(stringBounder);
        if (this.minimumDimension != null && width < this.minimumDimension.getWidth()) {
            width = this.minimumDimension.getWidth();
        }
        if (this.minimumDimension != null && height < this.minimumDimension.getHeight()) {
            height = this.minimumDimension.getHeight();
        }
        return new Dimension2DDouble(width, height);
    }

    public void drawU(UGraphic ug) {
        Component note = this.getComponent();
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimensionToUse = this.getDimension(stringBounder);
        note.drawU(ug, new Area(dimensionToUse), new SimpleContext2D(false));
    }

    private Component getComponent() {
        HtmlColor noteBackgroundColor = new HtmlColorSetSimple().getColorIfValid("#FBFB77");
        HtmlColor borderColor = HtmlColorUtils.MY_RED;
        SkinParam param = SkinParam.noShadowing(null);
        UFont fontNote = param.getFont(null, false, FontParam.NOTE);
        FontConfiguration font2 = fontNote.toFont2(HtmlColorUtils.BLACK, true, HtmlColorUtils.BLUE, 8);
        ComponentRoseNote note = new ComponentRoseNote(null, new SymbolContext(noteBackgroundColor, borderColor).withStroke(new UStroke()), font2, this.text, 0.0, 0.0, new SpriteContainerEmpty(), 0.0, HorizontalAlignment.LEFT);
        return note;
    }
}

