/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.util.Locale;
import net.sourceforge.plantuml.openiconic.SvgCommand;

public class SvgCommandNumber
implements SvgCommand {
    private final String number;

    public SvgCommandNumber(String number) {
        if (!number.matches("[-.0-9]+")) {
            throw new IllegalArgumentException();
        }
        this.number = number;
    }

    public String toString() {
        return super.toString() + " " + this.number;
    }

    public SvgCommandNumber(double number) {
        this.number = String.format(Locale.US, "%1.4f", number);
    }

    public SvgCommandNumber add(SvgCommandNumber other) {
        return new SvgCommandNumber(this.getDouble() + other.getDouble());
    }

    @Override
    public String toSvg() {
        return this.number;
    }

    public double getDouble() {
        return Double.parseDouble(this.number);
    }
}

