/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CodeImpl;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;

public class Ident
implements Code {
    private final List<String> parts;

    private Ident(List<String> parts) {
        this.parts = parts;
    }

    public String toString() {
        return this.parts.toString();
    }

    public boolean startsWith(Ident other) {
        if (other.parts.size() > this.parts.size()) {
            return false;
        }
        for (int i = 0; i < other.parts.size(); ++i) {
            if (other.parts.get(i).equals(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    public String forXmi() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.parts) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public Ident add(Ident added) {
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        copy.addAll(added.parts);
        return new Ident(copy);
    }

    public static Ident empty() {
        return new Ident(Collections.<String>emptyList());
    }

    public String getLast() {
        if (this.parts.size() == 0) {
            return "";
        }
        return this.parts.get(this.parts.size() - 1);
    }

    public Code toCode(CucaDiagram diagram) {
        if (diagram.V1972()) {
            return this;
        }
        return CodeImpl.of(this.getLast());
    }

    @Override
    public Ident eventuallyRemoveStartingAndEndingDoubleQuote(String format) {
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        int pos = copy.size() - 1;
        copy.set(pos, StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote((String)copy.get(pos), format));
        return new Ident(copy);
    }

    public Ident removeStartingParenthesis() {
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        int pos = copy.size() - 1;
        String last = (String)copy.get(pos);
        if (!last.startsWith("()")) {
            throw new IllegalStateException();
        }
        copy.set(pos, StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(last.substring(2).trim()));
        return new Ident(copy);
    }

    public Ident addSuffix(String suffix) {
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        int pos = copy.size() - 1;
        copy.set(pos, (String)copy.get(pos) + suffix);
        return new Ident(copy);
    }

    public Ident removeMemberPart() {
        String last = this.getLast();
        int x = last.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        ArrayList<String> copy = new ArrayList<String>(this.parts);
        int pos = copy.size() - 1;
        copy.set(pos, last.substring(0, x));
        return new Ident(copy);
    }

    public String getPortMember() {
        String last = this.getLast();
        int x = last.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        return last.substring(x + 2);
    }

    private static Ident from(String full, String separator) {
        Ident result = new Ident(new ArrayList<String>());
        if (separator == null || full.contains(separator + separator)) {
            result.parts.add(full);
            return result;
        }
        while (true) {
            int idx;
            if ((idx = full.indexOf(separator)) == -1) {
                result.parts.add(full);
                result.checkResult(separator);
                return result;
            }
            if (idx > 0) {
                result.parts.add(full.substring(0, idx));
            }
            full = full.substring(idx + separator.length());
        }
    }

    private void checkResult(String separator) {
        for (String s : this.parts) {
            if (s.length() == 0) {
                throw new IllegalStateException(this.toString());
            }
            if (separator == null || !s.contains(separator) || s.contains(separator + separator)) continue;
            throw new IllegalStateException(this.toString());
        }
    }

    public Ident add(String sup, String separator) {
        this.checkResult(separator);
        Ident added = Ident.from(sup, separator);
        ArrayList<String> list = new ArrayList<String>(this.parts.size() + added.parts.size());
        list.addAll(this.parts);
        list.addAll(added.parts);
        Ident result = new Ident(list);
        result.checkResult(separator);
        return result;
    }

    public Ident parent() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException();
        }
        return new Ident(this.parts.subList(0, this.parts.size() - 1));
    }

    public boolean equals(Object obj) {
        Ident other = (Ident)obj;
        return this.parts.equals(other.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public String toString(String sep) {
        if (sep == null) {
            sep = ".";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.parts) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void checkSameAs(Code code, String separator, CucaDiagram diagram) {
        if (diagram.V1972()) {
            return;
        }
        String last = this.parts.get(this.parts.size() - 1);
        if (separator == null) {
            if (!code.getName().equals(last) && !code.getName().equals(this.toString(separator))) {
                System.err.println("code1=" + code);
                System.err.println("this1=" + this);
                EntityFactory.bigError();
            }
        } else if (!this.getLastPart(code.getName(), separator).equals(last) && !code.getName().equals(this.toString(separator))) {
            System.err.println("code2=" + code);
            System.err.println("this2=" + this);
            EntityFactory.bigError();
        }
    }

    private String getLastPart(String fullName, String separator) {
        if (separator == null) {
            return fullName;
        }
        int x = fullName.lastIndexOf(separator);
        if (x == -1) {
            return fullName;
        }
        return fullName.substring(x + separator.length());
    }

    @Override
    public String getName() {
        return this.getLast();
    }

    public boolean isRoot() {
        return this.parts.size() == 0;
    }

    public Ident move(Ident from, Ident to) {
        if (!this.startsWith(from)) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> result = new ArrayList<String>(to.parts);
        for (int i = from.parts.size(); i < this.parts.size(); ++i) {
            result.add(this.parts.get(i));
        }
        return new Ident(result);
    }

    public int size() {
        return this.parts.size();
    }
}

