/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.Member;

class Election {
    private final Map<String, Member> all = new HashMap<String, Member>();

    Election() {
    }

    public void addCandidate(String display, Member candidate) {
        this.all.put(display, candidate);
    }

    private Member getCandidate(String shortName) {
        List<Member> list = this.getAllCandidateContains(shortName);
        if (list.size() == 1) {
            return list.get(0);
        }
        list = this.getAllCandidateContainsStrict(shortName);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private List<Member> getAllCandidateContains(String shortName) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Map.Entry<String, Member> ent : this.all.entrySet()) {
            if (!ent.getKey().contains(shortName)) continue;
            result.add(ent.getValue());
        }
        return result;
    }

    private List<Member> getAllCandidateContainsStrict(String shortName) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Map.Entry<String, Member> ent : this.all.entrySet()) {
            String key = ent.getKey();
            if (!key.matches(".*\\b" + shortName + "\\b.*")) continue;
            result.add(ent.getValue());
        }
        return result;
    }

    public Map<Member, String> getAllElected(Collection<String> shortNames) {
        HashMap<Member, String> memberWithPort = new HashMap<Member, String>();
        for (String shortName : new HashSet<String>(shortNames)) {
            Member m = this.getCandidate(shortName);
            if (m == null) continue;
            memberWithPort.put(m, shortName);
            shortNames.remove(shortName);
        }
        return Collections.unmodifiableMap(memberWithPort);
    }
}

