/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementDate;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class VerbTaskStartsAbsolute
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementDate());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("starts[%s]*(the[%s]*|on[%s]*|at[%s]*)*");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Task task = (Task)subject;
                DayAsDate start = (DayAsDate)complement;
                DayAsDate startingDate = project.getStartingDate();
                if (startingDate == null) {
                    return CommandExecutionResult.error("No starting date for the project");
                }
                task.setStart(start.asInstantDay(startingDate));
                return CommandExecutionResult.ok();
            }
        };
    }
}

